"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevkitMigration = void 0;
const migration_1 = require("../update-tool/migration");
class DevkitMigration extends migration_1.Migration {
    /** Prints an informative message with context on the current target. */
    printInfo(text) {
        const targetName = this.context.isTestTarget ? 'test' : 'build';
        this.logger.info(`- ${this.context.projectName}@${targetName}: ${text}`);
    }
}
exports.DevkitMigration = DevkitMigration;
//# sourceMappingURL=data:application/json;base64,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