/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Shallow-extends a stylesheet object with another stylesheet object.
 * @docs-private
 */
export function extendStyles(dest, source) {
    for (let key in source) {
        if (source.hasOwnProperty(key)) {
            dest[key] = source[key];
        }
    }
    return dest;
}
/**
 * Toggles whether the native drag interactions should be enabled for an element.
 * @param element Element on which to toggle the drag interactions.
 * @param enable Whether the drag interactions should be enabled.
 * @docs-private
 */
export function toggleNativeDragInteractions(element, enable) {
    const userSelect = enable ? '' : 'none';
    extendStyles(element.style, {
        touchAction: enable ? '' : 'none',
        webkitUserDrag: enable ? '' : 'none',
        webkitTapHighlightColor: enable ? '' : 'transparent',
        userSelect: userSelect,
        msUserSelect: userSelect,
        webkitUserSelect: userSelect,
        MozUserSelect: userSelect
    });
}
/**
 * Toggles whether an element is visible while preserving its dimensions.
 * @param element Element whose visibility to toggle
 * @param enable Whether the element should be visible.
 * @docs-private
 */
export function toggleVisibility(element, enable) {
    const styles = element.style;
    styles.position = enable ? '' : 'fixed';
    styles.top = styles.opacity = enable ? '' : '0';
    styles.left = enable ? '' : '-999em';
}
//# sourceMappingURL=data:application/json;base64,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