"use strict";var assert=require("assert"),Mux=require("../lib/mux").Mux,PassThrough=require("stream").PassThrough||require("readable-stream/passthrough"),latch=require("./util").latch,schedule=require("./util").schedule;function stream(){return new PassThrough({objectMode:!0})}function readAllObjects(n,e){var t=[];function r(){for(var e=n.read();null!==e;)t.push(e),e=n.read()}n.on("end",function(){e(t)}),n.on("readable",r),r()}test("single input",function(n){var e=stream(),t=stream();e.on("end",function(){t.end()}),new Mux(t).pipeFrom(e);var r=[1,2,3,4,5,6,7,8,9];r.forEach(e.write.bind(e)),readAllObjects(t,function(e){assert.deepEqual(r,e),n()}),e.end()}),test("single input, resuming stream",function(n){var t=stream(),e=stream();t.on("end",function(){e.end()}),new Mux(e).pipeFrom(t);var r=t.read;t.read=function(e){e=r.call(t,e);return"skip"===e?(t.emit("readable"),null):e},[1,2,3,4,"skip",6,7,8,9].forEach(t.write.bind(t)),readAllObjects(e,function(e){assert.deepEqual([1,2,3,4,6,7,8,9],e),n()}),t.end()}),test("two sequential inputs",function(n){var t=stream(),r=stream(),e=stream(),a=new Mux(e);a.pipeFrom(t),a.pipeFrom(r);var i=[1,2,3,4,5,6,7,8,9];i.forEach(function(e){t.write(e)}),t.on("end",function(){i.forEach(function(e){r.write(e)}),r.end()}),r.on("end",function(){e.end()}),t.end(),readAllObjects(e,function(e){assert.equal(2*i.length,e.length),n()})}),test("two interleaved inputs",function(n){var t=stream(),r=stream(),e=stream(),a=new Mux(e);a.pipeFrom(t),a.pipeFrom(r);a=latch(2,function(){e.end()});t.on("end",a),r.on("end",a);var i=[1,2,3,4,5,6,7,8,9];i.forEach(function(e){t.write(e)}),t.end(),i.forEach(function(e){r.write(e)}),r.end(),readAllObjects(e,function(e){assert.equal(2*i.length,e.length),n()})}),test("unpipe",function(n){var e=stream(),t=stream(),r=new Mux(t),a=[1,2,3,4,5],i=[6,7,8,9];r.pipeFrom(e),schedule(function(){a.forEach(e.write.bind(e)),schedule(function(){r.unpipeFrom(e),schedule(function(){i.forEach(e.write.bind(e)),e.end(),schedule(function(){for(;e.read(););})})})}),e.on("end",function(){t.end()}),readAllObjects(t,function(e){try{assert.deepEqual(a,e),n()}catch(e){n(e)}})}),test("roundrobin",function(n){var t=stream(),r=stream(),e=stream(),a=new Mux(e);a.pipeFrom(t),a.pipeFrom(r);a=latch(2,function(){e.end()});t.on("end",a),r.on("end",a);[1,1,1,1,1].forEach(function(e){t.write(e)}),t.end();[2,2,2,2,2].forEach(function(e){r.write(e)}),r.end(),readAllObjects(e,function(e){assert.deepEqual([1,2,1,2,1,2,1,2,1,2],e),n()})});