"use strict";var assert=require("assert"),succeed=require("./util").succeed,fail=require("./util").fail,Buffer=require("safe-buffer").Buffer,connection=require("../lib/connection"),Frames=connection.Connection,HEARTBEAT=require("../lib/frame").HEARTBEAT,Stream=require("stream"),PassThrough=Stream.PassThrough||require("readable-stream/passthrough"),defs=require("../lib/defs");function inputs(){return new PassThrough({objectMode:!0})}var HB=Buffer.from([defs.constants.FRAME_HEARTBEAT,0,0,0,0,0,0,defs.constants.FRAME_END]);suite("Explicit parsing",function(){function e(e,a){test(e,function(t){var e=inputs(),r=new Frames(e);r.frameMax=5,e.write(Buffer.from(a)),r.step(function(e,r){null!=e?t():t(new Error("Was a bogus frame!"))})})}test("Parse heartbeat",function(){var e=inputs(),r=new Frames(e);e.write(HB),assert(r.recvFrame()===HEARTBEAT),assert(!r.recvFrame())}),test("Parse partitioned",function(){var e=inputs(),r=new Frames(e);e.write(HB.slice(0,3)),assert(!r.recvFrame()),e.write(HB.slice(3)),assert(r.recvFrame()===HEARTBEAT),assert(!r.recvFrame())}),e("Wrong sized frame",[defs.constants.FRAME_BODY,0,0,0,0,0,0,65,defs.constants.FRAME_END]),e("Unknown method frame",[defs.constants.FRAME_METHOD,0,0,0,0,0,4,0,0,0,0,defs.constants.FRAME_END]),e("> max frame",[defs.constants.FRAME_BODY,0,0,0,0,0,6,65,66,67,68,69,70,defs.constants.FRAME_END])});var amqp=require("./data"),claire=require("claire"),choice=claire.choice,forAll=claire.forAll,repeat=claire.repeat,label=claire.label,sequence=claire.sequence,transform=claire.transform,sized=claire.sized,assertEqualModuloDefaults=require("./codec").assertEqualModuloDefaults,Trace=label("frame trace",repeat(choice.apply(choice,amqp.methods)));suite("Parsing",function(){function e(i){return forAll(Trace).satisfy(function(r){var t,a=[],e=inputs(),s=new Frames(e),n=0;if(s.accept=function(e){try{assertEqualModuloDefaults(r[n],e.fields)}catch(e){t=e}n++},r.forEach(function(e){e.channel=0,a.push(defs.encodeMethod(e.id,0,e.fields))}),i(a).forEach(e.write.bind(e)),s.acceptLoop(),t)throw t;return n===r.length}).asTest({times:20})}test("Parse trace of methods",e(function(e){return e})),test("Parse concat'd methods",e(function(e){return[Buffer.concat(e)]})),test("Parse partitioned methods",e(function(e){var r=Buffer.concat(e),t=Math.floor(r.length/3),e=2*t;return[r.slice(0,t),r.slice(t,e),r.slice(e)]}))});var FRAME_MAX_MAX=16384,FRAME_MAX_MIN=4096,FrameMax=amqp.rangeInt("frame max",FRAME_MAX_MIN,FRAME_MAX_MAX),Body=sized(function(e){return Math.floor(Math.random()*FRAME_MAX_MAX)},repeat(amqp.Octet)),Content=transform(function(e){return{method:e[0].fields,header:e[1].fields,body:Buffer.from(e[2])}},sequence(amqp.methods.BasicDeliver,amqp.properties.BasicProperties,Body));suite("Content framing",function(){test("Adhere to frame max",forAll(Content,FrameMax).satisfy(function(e,r){var t=inputs(),a=new Frames(t);a.frameMax=r,a.sendMessage(0,defs.BasicDeliver,e.method,defs.BasicProperties,e.header,e.body);for(var s,n=0;s=t.read();)if(s.length>n&&(n=s.length),s.length>r)return!1;return!0}).asTest())});