"use strict";var assert=require("assert"),defs=require("../lib/defs"),Buffer=require("safe-buffer").Buffer,Connection=require("../lib/connection").Connection,HEARTBEAT=require("../lib/frame").HEARTBEAT,HB_BUF=require("../lib/frame").HEARTBEAT_BUF,util=require("./util"),succeed=util.succeed,fail=util.fail,latch=util.latch,completes=util.completes,kCallback=util.kCallback,LOG_ERRORS=process.env.LOG_ERRORS,OPEN_OPTS={clientProperties:{},mechanism:"PLAIN",response:Buffer.from(["","guest","guest"].join(String.fromCharCode(0))),locale:"en_US",channelMax:0,frameMax:0,heartbeat:0,virtualHost:"/",capabilities:"",insist:0};function happy_open(n,e){return n(defs.ConnectionStart,{versionMajor:0,versionMinor:9,serverProperties:{},mechanisms:Buffer.from("PLAIN"),locales:Buffer.from("en_US")}),e(defs.ConnectionStartOk)().then(function(e){n(defs.ConnectionTune,{channelMax:0,heartbeat:0,frameMax:0})}).then(e(defs.ConnectionTuneOk)).then(e(defs.ConnectionOpen)).then(function(e){n(defs.ConnectionOpenOk,{knownHosts:""})})}function connectionTest(n,c){return function(e){var o=latch(2,e),t=util.socketPair(),e=new Connection(t.client);LOG_ERRORS&&e.on("error",console.warn),n(e,o);e=t.server.read(8);assert.deepEqual(Buffer.from("AMQP"+String.fromCharCode(0,0,9,1)),e);util.runServer(t.server,function(e,n){c(e,n,o,t.server)})}}module.exports.OPEN_OPTS=OPEN_OPTS,module.exports.connection_handshake=happy_open,suite("Connection errors",function(){test("socket close during open",function(e){var n=util.socketPair(),o=new Connection(n.client);n.server.on("readable",function(){n.server.end()}),o.open({},kCallback(fail(e),succeed(e)))}),test("bad frame during open",function(e){var n=util.socketPair(),o=new(require("../lib/connection").Connection)(n.client);n.server.on("readable",function(){n.server.write(Buffer.from([0,0,0,0,0,0,0,0,0,0]))}),o.open({},kCallback(fail(e),succeed(e)))})}),suite("Connection open",function(){test("happy",connectionTest(function(e,n){e.open(OPEN_OPTS,kCallback(succeed(n),fail(n)))},function(e,n,o){happy_open(e,n).then(succeed(o),fail(o))})),test("wrong first frame",connectionTest(function(e,n){e.open(OPEN_OPTS,kCallback(fail(n),succeed(n)))},function(e,n,o){completes(function(){e(defs.ConnectionTune,{channelMax:0,heartbeat:0,frameMax:0})},o)})),test("unexpected socket close",connectionTest(function(e,n){e.open(OPEN_OPTS,kCallback(fail(n),succeed(n)))},function(e,n,o,t){return e(defs.ConnectionStart,{versionMajor:0,versionMinor:9,serverProperties:{},mechanisms:Buffer.from("PLAIN"),locales:Buffer.from("en_US")}),n(defs.ConnectionStartOk)().then(function(){t.end()}).then(succeed(o),fail(o))}))}),suite("Connection running",function(){test("wrong frame on channel 0",connectionTest(function(e,n){e.on("error",succeed(n)),e.open(OPEN_OPTS)},function(n,e,o){happy_open(n,e).then(function(){n(defs.ChannelOpenOk,{channelId:Buffer.from("")},0)}).then(e(defs.ConnectionClose)).then(function(e){n(defs.ConnectionCloseOk,{},0)}).then(succeed(o),fail(o))})),test("unopened channel",connectionTest(function(e,n){e.on("error",succeed(n)),e.open(OPEN_OPTS)},function(n,e,o){happy_open(n,e).then(function(){n(defs.ChannelOpenOk,{channelId:Buffer.from("")},3)}).then(e(defs.ConnectionClose)).then(function(e){n(defs.ConnectionCloseOk,{},0)}).then(succeed(o),fail(o))})),test("unexpected socket close",connectionTest(function(e,n){n=latch(2,n);e.on("error",succeed(n)),e.on("close",succeed(n)),e.open(OPEN_OPTS,kCallback(function(){e.sendHeartbeat()},fail(n)))},function(e,n,o,t){happy_open(e,n).then(n()).then(function(){t.end()}).then(succeed(o))})),test("connection.blocked",connectionTest(function(e,n){e.on("blocked",succeed(n)),e.open(OPEN_OPTS)},function(e,n,o,t){happy_open(e,n).then(function(){e(defs.ConnectionBlocked,{reason:"felt like it"},0)}).then(succeed(o))})),test("connection.unblocked",connectionTest(function(e,n){e.on("unblocked",succeed(n)),e.open(OPEN_OPTS)},function(e,n,o,t){happy_open(e,n).then(function(){e(defs.ConnectionUnblocked,{},0)}).then(succeed(o))}))}),suite("Connection close",function(){test("happy",connectionTest(function(n,e){var o=latch(2,e);n.on("close",o),n.open(OPEN_OPTS,kCallback(function(e){n.close(kCallback(succeed(o),fail(o)))},function(){}))},function(n,e,o){happy_open(n,e).then(e(defs.ConnectionClose)).then(function(e){n(defs.ConnectionCloseOk,{})}).then(succeed(o),fail(o))})),test("interleaved close frames",connectionTest(function(n,e){var o=latch(2,e);n.on("close",o),n.open(OPEN_OPTS,kCallback(function(e){n.close(kCallback(succeed(o),fail(o)))},o))},function(n,e,o){happy_open(n,e).then(e(defs.ConnectionClose)).then(function(e){n(defs.ConnectionClose,{replyText:"Ha!",replyCode:defs.constants.REPLY_SUCCESS,methodId:0,classId:0})}).then(e(defs.ConnectionCloseOk)).then(function(e){n(defs.ConnectionCloseOk,{})}).then(succeed(o),fail(o))})),test("server error close",connectionTest(function(e,n){n=latch(2,n);e.on("close",succeed(n)),e.on("error",succeed(n)),e.open(OPEN_OPTS)},function(n,e,o){happy_open(n,e).then(function(e){n(defs.ConnectionClose,{replyText:"Begone",replyCode:defs.constants.INTERNAL_ERROR,methodId:0,classId:0})}).then(e(defs.ConnectionCloseOk)).then(succeed(o),fail(o))})),test("operator-intiated close",connectionTest(function(e,n){e.on("close",succeed(n)),e.on("error",fail(n)),e.open(OPEN_OPTS)},function(n,e,o){happy_open(n,e).then(function(e){n(defs.ConnectionClose,{replyText:"Begone",replyCode:defs.constants.CONNECTION_FORCED,methodId:0,classId:0})}).then(e(defs.ConnectionCloseOk)).then(succeed(o),fail(o))})),test("double close",connectionTest(function(e,n){e.open(OPEN_OPTS,kCallback(function(){e.close(),assert.throws(function(){e.close()}),n()},n))},function(e,n,o){happy_open(e,n).then(n(defs.ConnectionClose)).then(function(){e(defs.ConnectionCloseOk,{})}).then(succeed(o),fail(o))}))}),suite("heartbeats",function(){var i=require("../lib/heartbeat");setup(function(){i.UNITS_TO_MS=20}),teardown(function(){i.UNITS_TO_MS=1e3}),test("send heartbeat after open",connectionTest(function(n,e){completes(function(){var e=Object.create(OPEN_OPTS);e.heartbeat=1,n.on("error",function(){}),n.open(e)},e)},function(e,n,o,t){var c;happy_open(e,n).then(function(){c=setInterval(function(){t.write(HB_BUF)},i.UNITS_TO_MS)}).then(n()).then(function(e){e===HEARTBEAT?o():o("Next frame after silence not a heartbeat"),clearInterval(c)})})),test("detect lack of heartbeats",connectionTest(function(e,n){var o=Object.create(OPEN_OPTS);o.heartbeat=1,e.on("error",succeed(n)),e.open(o)},function(e,n,o,t){happy_open(e,n).then(succeed(o),fail(o))}))});