"use strict";var connect=require("../lib/connect").connect,Buffer=require("safe-buffer").Buffer,credentialsFromUrl=require("../lib/connect").credentialsFromUrl,assert=require("assert"),util=require("./util"),net=require("net"),fail=util.fail,succeed=util.succeed,kCallback=util.kCallback,succeedIfAttributeEquals=util.succeedIfAttributeEquals,format=require("util").format,URL=process.env.URL||"amqp://localhost",urlparse=require("url-parse");suite("Credentials",function(){function r(e,t,r,s){return"PLAIN"!=e.mechanism?s("expected mechanism PLAIN"):e.username!=t||e.password!=r?s(format("expected '%s', '%s'; got '%s', '%s'",t,r,e.username,e.password)):void s()}test("no creds",function(e){var t=urlparse("amqp://localhost");r(credentialsFromUrl(t),"guest","guest",e)}),test("usual user:pass",function(e){var t=urlparse("amqp://user:pass@localhost");r(credentialsFromUrl(t),"user","pass",e)}),test("missing user",function(e){var t=urlparse("amqps://:password@localhost");r(credentialsFromUrl(t),"","password",e)}),test("missing password",function(e){var t=urlparse("amqps://username:@localhost");r(credentialsFromUrl(t),"username","",e)}),test("escaped colons",function(e){var t=urlparse("amqp://user%3Aname:pass%3Aword@localhost");r(credentialsFromUrl(t),"user:name","pass:word",e)})}),suite("Connect API",function(){test("Connection refused",function(e){connect("amqp://localhost:23450",{},kCallback(fail(e),succeed(e)))}),test("bad URL",function(){assert.throws(function(){connect("blurble")})}),test("wrongly typed open option",function(e){var t=require("url"),r=t.parse(URL,!0),s=r.query||{};s.frameMax="NOT A NUMBER",r.query=s;r=t.format(r);connect(r,{},kCallback(fail(e),succeed(e)))}),test("serverProperties",function(r){var e=require("url").parse(URL,!0).query||{};connect(e,{},function(e,t){return e?r(e):(assert.equal(t.serverProperties.product,"RabbitMQ"),void r())})}),test("using custom heartbeat option",function(e){var t=require("url").parse(URL,!0).query||{};t.heartbeat=20,connect(t,{},kCallback(succeedIfAttributeEquals("heartbeat",20,e),fail(e)))}),test("wrongly typed heartbeat option",function(e){var t=require("url").parse(URL,!0).query||{};t.heartbeat="NOT A NUMBER",connect(t,{},kCallback(fail(e),succeed(e)))}),test("using plain credentials",function(e){var t=require("url").parse(URL,!0),r="guest",s="guest";t.auth&&(r=(t=t.auth.split(":"))[0],s=t[1]),connect(URL,{credentials:require("../lib/credentials").plain(r,s)},kCallback(succeed(e),fail(e)))}),test("using amqplain credentials",function(e){var t=require("url").parse(URL,!0),r="guest",s="guest";t.auth&&(r=(t=t.auth.split(":"))[0],s=t[1]),connect(URL,{credentials:require("../lib/credentials").amqplain(r,s)},kCallback(succeed(e),fail(e)))}),test("using unsupported mechanism",function(e){connect(URL,{credentials:{mechanism:"UNSUPPORTED",response:function(){return Buffer.from("")}}},kCallback(fail(e),succeed(e)))}),test("with a given connection timeout",function(r){var s=net.createServer(function(){}).listen(31991);connect("amqp://localhost:31991",{timeout:50},function(e,t){s.close(),t?r(new Error("Expected connection timeout, did not")):r()})})});