"use strict";var codec=require("../lib/codec"),defs=require("../lib/defs"),assert=require("assert"),ints=require("buffer-more-ints"),Buffer=require("safe-buffer").Buffer,C=require("claire"),forAll=C.forAll,testCases=[["byte",{byte:112},[4,98,121,116,101,98,112]],["byte max value",{byte:127},[4,98,121,116,101,98,127]],["byte min value",{byte:-128},[4,98,121,116,101,98,128]],["< -128 promoted to signed short",{short:-129},[5,115,104,111,114,116,115,255,127]],["> 127 promoted to short",{short:128},[5,115,104,111,114,116,115,0,128]],["< 2^15 still a short",{short:32767},[5,115,104,111,114,116,115,127,255]],["-2^15 still a short",{short:-32768},[5,115,104,111,114,116,115,128,0]],[">= 2^15 promoted to int",{int:32768},[3,105,110,116,73,0,0,128,0]],["< -2^15 promoted to int",{int:-32769},[3,105,110,116,73,255,255,127,255]],["< 2^31 still an int",{int:2147483647},[3,105,110,116,73,127,255,255,255]],[">= -2^31 still an int",{int:-2147483648},[3,105,110,116,73,128,0,0,0]],[">= 2^31 promoted to long",{long:2147483648},[4,108,111,110,103,108,0,0,0,0,128,0,0,0]],["< -2^31 promoted to long",{long:-2147483649},[4,108,111,110,103,108,255,255,255,255,127,255,255,255]],["float value",{double:.5},[6,100,111,117,98,108,101,100,63,224,0,0,0,0,0,0]],["negative float value",{double:-.5},[6,100,111,117,98,108,101,100,191,224,0,0,0,0,0,0]],["string",{string:"boop"},[6,115,116,114,105,110,103,83,0,0,0,4,98,111,111,112]],["byte array from buffer",{bytes:Buffer.from([1,2,3,4])},[5,98,121,116,101,115,120,0,0,0,4,1,2,3,4]],["true",{bool:!0},[4,98,111,111,108,116,1]],["false",{bool:!1},[4,98,111,111,108,116,0]],["null",{void:null},[4,118,111,105,100,86]],["array",{array:[6,!0,"foo"]},[5,97,114,114,97,121,65,0,0,0,12,98,6,116,1,83,0,0,0,3,102,111,111]],["object",{object:{foo:"bar",baz:12}},[6,111,98,106,101,99,116,70,0,0,0,18,3,102,111,111,83,0,0,0,3,98,97,114,3,98,97,122,98,12]],["timestamp",{timestamp:{"!":"timestamp",value:1357212277527}},[9,116,105,109,101,115,116,97,109,112,84,0,0,1,60,0,39,219,23]],["decimal",{decimal:{"!":"decimal",value:{digits:2345,places:2}}},[7,100,101,99,105,109,97,108,68,2,0,0,9,41]],["float",{float:{"!":"float",value:.1}},[5,102,108,111,97,116,102,61,204,204,205]]];function bufferToArray(e){return Array.prototype.slice.call(e)}suite("Implicit encodings",function(){testCases.forEach(function(e){var t=e[0],r=e[1],o=e[2];test(t,function(){var e=Buffer.alloc(1e3),t=codec.encodeTable(e,r,0),t=e.slice(4,t);assert.deepEqual(o,bufferToArray(t))})})});var amqp=require("./data");function roundtrip_table(e){var t=Buffer.alloc(4096),r=codec.encodeTable(t,e,0),r=codec.decodeFields(t.slice(4,r));try{assert.deepEqual(removeExplicitTypes(e),r)}catch(e){return!1}return!0}function roundtrips(e){return forAll(e).satisfy(function(e){return roundtrip_table({value:e})})}function removeExplicitTypes(e){if("object"==typeof e){if(null==e)return null;if(Array.isArray(e)){for(var t=[],r=0;r<e.length;r++)t[r]=removeExplicitTypes(e[r]);return t}if(Buffer.isBuffer(e))return e;switch(e["!"]){case"timestamp":case"decimal":case"float":return e;case void 0:var o,a={};for(o in e)a[o]=removeExplicitTypes(e[o]);return a;default:return e.value}}return e}function assertEqualModuloDefaults(t,e){for(var r=defs.info(t.id).args,o=0;o<r.length;o++){var a=r[o],i=t.fields[a.name],s=e[a.name];try{void 0===i?assert.deepEqual("longstr"===a.type?Buffer.from(a.default):a.default,s):assert.deepEqual(removeExplicitTypes(i),s)}catch(e){s=defs.info(t.id).name;throw e.message+=" (frame "+s+" field "+a.name+")",e}}return!0}function roundtripMethod(e){return forAll(e).satisfy(function(e){var t=defs.encodeMethod(e.id,0,e.fields);return assertEqualModuloDefaults(e,defs.decode(e.id,t.slice(11,t.length))),!0})}function roundtripProperties(e){return forAll(e).satisfy(function(e){var t=defs.encodeProperties(e.id,0,e.size,e.fields),r=defs.decode(e.id,t.slice(19,t.length));return assert.equal(e.size,ints.readUInt64BE(t,11)),assertEqualModuloDefaults(e,r),!0})}suite("Roundtrip values",function(){[amqp.Octet,amqp.ShortStr,amqp.LongStr,amqp.UShort,amqp.ULong,amqp.ULongLong,amqp.UShort,amqp.Short,amqp.Long,amqp.Bit,amqp.Decimal,amqp.Timestamp,amqp.Double,amqp.Float,amqp.FieldArray,amqp.FieldTable].forEach(function(e){test(e.toString()+" roundtrip",roundtrips(e).asTest())})}),module.exports.assertEqualModuloDefaults=assertEqualModuloDefaults,suite("Roundtrip methods",function(){amqp.methods.forEach(function(e){test(e.toString()+" roundtrip",roundtripMethod(e).asTest())})}),suite("Roundtrip properties",function(){amqp.properties.forEach(function(e){test(e.toString()+" roundtrip",roundtripProperties(e).asTest())})});