"use strict";var assert=require("assert"),api=require("../channel_api"),util=require("./util"),succeed=util.succeed,fail=util.fail,schedule=util.schedule,randomString=util.randomString,Promise=require("bluebird"),Buffer=require("safe-buffer").Buffer,URL=process.env.URL||"amqp://localhost";function connect(){return api.connect(URL)}function expectFail(t){return new Promise(function(e,n){return t.then(n).catch(e)})}function ignore(){}function ignoreErrors(e){return e.on("error",ignore),e}function logErrors(e){return e.on("error",console.warn),e}function channel_test(t,e,r){test(e,function(n){connect(URL).then(logErrors).then(function(e){e[t]().then(ignoreErrors).then(r).then(succeed(n),fail(n)).finally(function(){e.close()})})})}var chtest=channel_test.bind(null,"createChannel");suite("connect",function(){test("at all",function(e){connect(URL).then(function(e){return e.close()}).then(succeed(e),fail(e))}),chtest("create channel",ignore)});var QUEUE_OPTS={durable:!1},EX_OPTS={durable:!1};function waitForQueue(u,o){return connect(URL).then(function(r){return r.createChannel().then(function(t){return t.checkQueue(u).then(function(e){return function n(){return t.checkQueue(u).then(function(e){return o(e)?(r.close(),e):void schedule(n)})}()})})})}function waitForMessages(e,n){var t=void 0===n?1:n;return waitForQueue(e,function(e){return e.messageCount>=t})}suite("assert, check, delete",function(){chtest("assert and check queue",function(n){return n.assertQueue("test.check-queue",QUEUE_OPTS).then(function(e){return n.checkQueue("test.check-queue")})}),chtest("assert and check exchange",function(n){return n.assertExchange("test.check-exchange","direct",EX_OPTS).then(function(e){return assert.equal("test.check-exchange",e.exchange),n.checkExchange("test.check-exchange")})}),chtest("fail on reasserting queue with different options",function(e){var n="test.reassert-queue";return e.assertQueue(n,{durable:!1,autoDelete:!0}).then(function(){return expectFail(e.assertQueue(n,{durable:!1,autoDelete:!1}))})}),chtest("fail on checking a queue that's not there",function(e){return expectFail(e.checkQueue("test.random-"+randomString()))}),chtest("fail on checking an exchange that's not there",function(e){return expectFail(e.checkExchange("test.random-"+randomString()))}),chtest("fail on reasserting exchange with different type",function(e){var n="test.reassert-ex";return e.assertExchange(n,"fanout",EX_OPTS).then(function(){return expectFail(e.assertExchange(n,"direct",EX_OPTS))})}),chtest("channel break on publishing to non-exchange",function(n){return new Promise(function(e){n.on("error",e),n.publish(randomString(),"",Buffer.from("foobar"))})}),chtest("delete queue",function(e){var n="test.delete-queue";return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.checkQueue(n)).then(function(){return e.deleteQueue(n)}).then(function(){return expectFail(e.checkQueue(n))})}),chtest("delete exchange",function(e){var n="test.delete-exchange";return Promise.join(e.assertExchange(n,"fanout",EX_OPTS),e.checkExchange(n)).then(function(){return e.deleteExchange(n)}).then(function(){return expectFail(e.checkExchange(n))})})}),suite("sendMessage",function(){chtest("send to queue and get from queue",function(e){var n="test.send-to-q",t=randomString();return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,Buffer.from(t)),waitForMessages(n)}).then(function(){return e.get(n,{noAck:!0})}).then(function(e){assert(e),assert.equal(t,e.content.toString())})}),chtest("send (and get) zero content to queue",function(e){var n="test.send-to-q",t=Buffer.alloc(0);return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,t),waitForMessages(n)}).then(function(){return e.get(n,{noAck:!0})}).then(function(e){assert(e),assert.deepEqual(t,e.content)})})}),suite("binding, consuming",function(){chtest("route message",function(e){var n="test.route-message",t="test.route-message-q",r=randomString();return Promise.join(e.assertExchange(n,"fanout",EX_OPTS),e.assertQueue(t,QUEUE_OPTS),e.purgeQueue(t),e.bindQueue(t,n,"",{})).then(function(){return e.publish(n,"",Buffer.from(r)),waitForMessages(t)}).then(function(){return e.get(t,{noAck:!0})}).then(function(e){assert(e),assert.equal(r,e.content.toString())})}),chtest("purge queue",function(e){var n="test.purge-queue";return e.assertQueue(n,{durable:!1}).then(function(){return e.sendToQueue(n,Buffer.from("foobar")),waitForMessages(n)}).then(function(){return e.purgeQueue(n),e.get(n,{noAck:!0})}).then(function(e){assert(!e)})}),chtest("unbind queue",function(e){var n="test.unbind-queue-ex",t="test.unbind-queue",r=randomString(),u=randomString();return Promise.join(e.assertExchange(n,"fanout",EX_OPTS),e.assertQueue(t,QUEUE_OPTS),e.purgeQueue(t),e.bindQueue(t,n,"",{})).then(function(){return e.publish(n,"",Buffer.from("foobar")),waitForMessages(t)}).then(function(){return e.get(t,{noAck:!0}).then(function(e){assert(e)})}).then(function(){return e.unbindQueue(t,n,"",{})}).then(function(){return e.publish(n,"",Buffer.from(r)),e.sendToQueue(t,Buffer.from(u)),waitForMessages(t)}).then(function(){return e.get(t)}).then(function(e){assert.equal(u,e.content.toString())})}),chtest("consume via exchange-exchange binding",function(e){var r="test.ex-ex-binding1",n="test.ex-ex-binding2",u="test.ex-ex-binding-q",o="test.routing.key",s=randomString();return Promise.join(e.assertExchange(r,"direct",EX_OPTS),e.assertExchange(n,"fanout",{durable:!1,internal:!0}),e.assertQueue(u,QUEUE_OPTS),e.purgeQueue(u),e.bindExchange(n,r,o,{}),e.bindQueue(u,n,"",{})).then(function(){return new Promise(function(n,t){e.consume(u,function(e){e.content.toString()===s?n():t(new Error("Wrong message"))},{noAck:!0}).then(function(){e.publish(r,o,Buffer.from(s))})})})}),chtest("unbind exchange",function(e){var n="test.unbind-ex-source",t="test.unbind-ex-dest",r="test.unbind-ex-queue",u=randomString(),o=randomString();return Promise.join(e.assertExchange(n,"fanout",EX_OPTS),e.assertExchange(t,"fanout",EX_OPTS),e.assertQueue(r,QUEUE_OPTS),e.purgeQueue(r),e.bindExchange(t,n,"",{}),e.bindQueue(r,t,"",{})).then(function(){return e.publish(n,"",Buffer.from("foobar")),waitForMessages(r)}).then(function(){return e.get(r,{noAck:!0}).then(function(e){assert(e)})}).then(function(){return e.unbindExchange(t,n,"",{})}).then(function(){return e.publish(n,"",Buffer.from(u)),e.sendToQueue(r,Buffer.from(o)),waitForMessages(r)}).then(function(){return e.get(r)}).then(function(e){assert.equal(o,e.content.toString())})}),chtest("cancel consumer",function(t){var r,u="test.consumer-cancel";return new Promise(function(e,n){Promise.join(t.assertQueue(u,QUEUE_OPTS),t.purgeQueue(u),t.consume(u,e,{noAck:!0}).then(function(e){r=e.consumerTag,t.sendToQueue(u,Buffer.from("foo"))}))}).then(function(){return expectFail(Promise.join(t.cancel(r).then(function(){return t.sendToQueue(u,Buffer.from("bar"))}),waitForMessages(u)).then(function(){return t.get(u,{noAck:!0})}).then(function(e){if("bar"===e.content.toString())throw new Error}))})}),chtest("cancelled consumer",function(e){var r="test.cancelled-consumer";return new Promise(function(n,t){return Promise.join(e.assertQueue(r),e.purgeQueue(r),e.consume(r,function(e){null===e?n():t(new Error("Message not expected"))})).then(function(){return e.deleteQueue(r)})})}),chtest("ack",function(n){var t="test.ack",r=randomString(),u=randomString();return Promise.join(n.assertQueue(t,QUEUE_OPTS),n.purgeQueue(t)).then(function(){return n.sendToQueue(t,Buffer.from(r)),n.sendToQueue(t,Buffer.from(u)),waitForMessages(t,2)}).then(function(){return n.get(t,{noAck:!1})}).then(function(e){return assert.equal(r,e.content.toString()),n.ack(e),n.get(t)}).then(function(e){assert(e),assert.equal(u,e.content.toString())})}),chtest("nack",function(n){var t="test.nack",r=randomString();return Promise.join(n.assertQueue(t,QUEUE_OPTS),n.purgeQueue(t)).then(function(){return n.sendToQueue(t,Buffer.from(r)),waitForMessages(t)}).then(function(){return n.get(t,{noAck:!1})}).then(function(e){return assert.equal(r,e.content.toString()),n.nack(e),waitForMessages(t)}).then(function(){return n.get(t)}).then(function(e){assert(e),assert.equal(r,e.content.toString())})}),chtest("reject",function(n){var t="test.reject",r=randomString();return Promise.join(n.assertQueue(t,QUEUE_OPTS),n.purgeQueue(t)).then(function(){return n.sendToQueue(t,Buffer.from(r)),waitForMessages(t)}).then(function(){return n.get(t,{noAck:!1})}).then(function(e){return assert.equal(r,e.content.toString()),n.reject(e),waitForMessages(t)}).then(function(){return n.get(t)}).then(function(e){assert(e),assert.equal(r,e.content.toString())})}),chtest("prefetch",function(r){var e="test.prefetch";return Promise.join(r.assertQueue(e,QUEUE_OPTS),r.purgeQueue(e),r.prefetch(1)).then(function(){return r.sendToQueue(e,Buffer.from("foobar")),r.sendToQueue(e,Buffer.from("foobar")),waitForMessages(e,2)}).then(function(){return new Promise(function(n){var t=0;return r.consume(e,function(e){r.ack(e),1<++t&&n(t)},{noAck:!1})})}).then(function(e){return assert.equal(2,e)})}),chtest("close",function(e){return e.close()})});var confirmtest=channel_test.bind(null,"createConfirmChannel");suite("confirms",function(){confirmtest("message is confirmed",function(e){var n="test.confirm-message";return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,Buffer.from("bleep"))})}),confirmtest("multiple confirms",function(s){var c="test.multiple-confirms";return Promise.join(s.assertQueue(c,QUEUE_OPTS),s.purgeQueue(c)).then(function(){var o=!1;return s.on("ack",function(e){e.multiple&&(o=!0)}),function e(n){var t=[];for(var r,u=0;u<n;u++)r=void 0,r=Promise.fromCallback(function(e){return s.sendToQueue(c,Buffer.from("bleep"),{},e)}),t.push(r);return Promise.all(t).then(function(){if(o)return!0;if(500<n)throw new Error("Couldn't provoke the server into multi-acking with "+n+" messages; giving up");return e(2*n)})}(5)})}),confirmtest("wait for confirms",function(e){for(var n=0;n<1e3;n++)e.publish("","",Buffer.from("foobar"),{});return e.waitForConfirms()}),confirmtest("works when channel is closed",function(e){for(var n=0;n<1e3;n++)e.publish("","",Buffer.from("foobar"),{});return e.close().then(function(){return e.waitForConfirms()}).then(function(){assert.strictEqual(!0,!1,"Wait should have failed.")},function(e){assert.strictEqual(e.message,"channel closed")})})});