"use strict";var assert=require("assert"),Promise=require("bluebird"),Channel=require("../lib/channel").Channel,Connection=require("../lib/connection").Connection,util=require("./util"),succeed=util.succeed,fail=util.fail,latch=util.latch,completes=util.completes,defs=require("../lib/defs"),conn_handshake=require("./connection").connection_handshake,OPEN_OPTS=require("./connection").OPEN_OPTS,Buffer=require("safe-buffer").Buffer,LOG_ERRORS=process.env.LOG_ERRORS;function baseChannelTest(c,o){return function(e){var t=latch(2,e),e=util.socketPair(),s=new Connection(e.client);LOG_ERRORS&&s.on("error",console.warn),s.open(OPEN_OPTS,function(e,n){null===e?c(s,t):fail(t)}),e.server.read(8);util.runServer(e.server,function(e,n){conn_handshake(e,n).then(function(){o(e,n,t)},fail(t))})}}function channelTest(s,c){return baseChannelTest(function(e,n){var t=new Channel(e);LOG_ERRORS&&t.on("error",console.warn),s(t,n,e)},function(n,t,s){channel_handshake(n,t).then(function(e){return c(n,t,s,e)}).then(null,fail(s))})}function channel_handshake(n,e){return e(defs.ChannelOpen)().then(function(e){return assert.notEqual(0,e.channel),n(defs.ChannelOpenOk,{channelId:Buffer.from("")},e.channel),e.channel})}var DELIVER_FIELDS={consumerTag:"fake",deliveryTag:1,redelivered:!1,exchange:"foo",routingKey:"bar",replyCode:defs.constants.NO_ROUTE,replyText:"derp"};function open(n){return Promise.try(function(){return n.allocate(),Promise.fromCallback(function(e){n._rpc(defs.ChannelOpen,{outOfBand:""},defs.ChannelOpenOk,e)})})}suite("channel open and close",function(){test("open",channelTest(function(e,n){open(e).then(succeed(n),fail(n))},function(e,n,t){t()})),test("bad server",baseChannelTest(function(e,n){open(new Channel(e)).then(fail(n),succeed(n))},function(n,e,t){return e(defs.ChannelOpen)().then(function(e){n(defs.ChannelCloseOk,{},e.channel)}).then(succeed(t),fail(t))})),test("open, close",channelTest(function(n,e){open(n).then(function(){return new Promise(function(e){n.closeBecause("Bye",defs.constants.REPLY_SUCCESS,e)})}).then(succeed(e),fail(e))},function(n,e,t,s){return e(defs.ChannelClose)().then(function(e){n(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("server close",channelTest(function(e,n){e.on("error",function(e){assert.strictEqual(504,e.code),assert.strictEqual(0,e.classId),assert.strictEqual(0,e.methodId),succeed(n)()}),open(e)},function(e,n,t,s){e(defs.ChannelClose,{replyText:"Forced close",replyCode:defs.constants.CHANNEL_ERROR,classId:0,methodId:0},s),n(defs.ChannelCloseOk)().then(succeed(t),fail(t))})),test("overlapping channel/server close",channelTest(function(e,n,t){n=latch(2,n);t.on("error",succeed(n)),e.on("close",succeed(n)),open(e).then(function(){e.closeBecause("Bye",defs.constants.REPLY_SUCCESS)},fail(n))},function(e,n,t,s){n(defs.ChannelClose)().then(function(){e(defs.ConnectionClose,{replyText:"Got there first",replyCode:defs.constants.INTERNAL_ERROR,classId:0,methodId:0},0)}).then(n(defs.ConnectionCloseOk)).then(succeed(t),fail(t))})),test("double close",channelTest(function(e,n){open(e).then(function(){e.closeBecause("First close",defs.constants.REPLY_SUCCESS),assert.throws(function(){e.closeBecause("Second close",defs.constants.REPLY_SUCCESS)})}).then(succeed(n),fail(n))},function(e,n,t,s){n(defs.ChannelClose)().then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))}))}),suite("channel machinery",function(){function e(t,c){return test("confirm "+t,channelTest(function(e,n){e.on(t,function(e){completes(function(){assert.equal(1,e.deliveryTag)},n)}),open(e)},function(e,n,t,s){completes(function(){e(c,{deliveryTag:1,multiple:!1},s)},t)}))}test("RPC",channelTest(function(t,e){var s=latch(3,e);open(t).then(function(){function e(e,n){null!==e?s(e):s()}var n={prefetchCount:10,prefetchSize:0,global:!1};t._rpc(defs.BasicQos,n,defs.BasicQosOk,e),t._rpc(defs.BasicQos,n,defs.BasicQosOk,e),t._rpc(defs.BasicQos,n,defs.BasicQosOk,e)}).then(null,fail(s))},function(n,e,t,s){function c(e){n(defs.BasicQosOk,{},s)}return e(defs.BasicQos)().then(c).then(e(defs.BasicQos)).then(c).then(e(defs.BasicQos)).then(c).then(succeed(t),fail(t))})),test("Bad RPC",channelTest(function(e,n){var t=latch(2,n);e.on("error",function(e){assert.strictEqual(505,e.code),assert.strictEqual(60,e.classId),assert.strictEqual(72,e.methodId),succeed(t)()}),open(e).then(function(){e._rpc(defs.BasicRecover,{requeue:!0},defs.BasicRecoverOk,function(e){null!==e?t():t(new Error("Expected RPC failure"))})},fail(t))},function(e,n,t,s){return n()().then(function(){e(defs.BasicGetEmpty,{clusterId:""},s)}).then(n(defs.ChannelClose)).then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("RPC on closed channel",channelTest(function(t,e){open(t);var n=new Promise(function(n){t.on("error",function(e){assert.strictEqual(504,e.code),assert.strictEqual(0,e.classId),assert.strictEqual(0,e.methodId),n()})});function s(n,t){return function(e){(null!==e?n:t)()}}var c=new Promise(function(e,n){return t._rpc(defs.BasicRecover,{requeue:!0},defs.BasicRecoverOk,s(e,n))}),o=new Promise(function(e,n){return t._rpc(defs.BasicRecover,{requeue:!0},defs.BasicRecoverOk,s(e,n))});Promise.join(n,c,o).then(succeed(e)).catch(fail(e))},function(e,n,t,s){n(defs.BasicRecover)().then(function(){return e(defs.ChannelClose,{replyText:"Nuh-uh!",replyCode:defs.constants.CHANNEL_ERROR,methodId:0,classId:0},s),n(defs.ChannelCloseOk)}).then(succeed(t)).catch(fail(t))})),test("publish all < single chunk threshold",channelTest(function(e,n){open(e).then(function(){e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{},Buffer.from("foobar"))}).then(succeed(n),fail(n))},function(e,n,t,s){n(defs.BasicPublish)().then(n(defs.BasicProperties)).then(n(void 0)).then(function(e){assert.equal("foobar",e.content.toString())}).then(succeed(t),fail(t))})),test("publish content > single chunk threshold",channelTest(function(e,n){open(e),completes(function(){e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{},Buffer.alloc(3e3))},n)},function(e,n,t,s){n(defs.BasicPublish)().then(n(defs.BasicProperties)).then(n(void 0)).then(function(e){assert.equal(3e3,e.content.length)}).then(succeed(t),fail(t))})),test("publish method & headers > threshold",channelTest(function(e,n){open(e),completes(function(){e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{headers:{foo:Buffer.alloc(3e3)}},Buffer.from("foobar"))},n)},function(e,n,t,s){n(defs.BasicPublish)().then(n(defs.BasicProperties)).then(n(void 0)).then(function(e){assert.equal("foobar",e.content.toString())}).then(succeed(t),fail(t))})),test("publish zero-length message",channelTest(function(e,n){open(e),completes(function(){e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{},Buffer.alloc(0)),e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{},Buffer.alloc(0))},n)},function(e,n,t,s){n(defs.BasicPublish)().then(n(defs.BasicProperties)).then(n(defs.BasicPublish)).then(succeed(t),fail(t))})),test("delivery",channelTest(function(e,n){open(e),e.on("delivery",function(e){completes(function(){assert.equal("barfoo",e.content.toString())},n)})},function(e,n,t,s){completes(function(){e(defs.BasicDeliver,DELIVER_FIELDS,s,Buffer.from("barfoo"))},t)})),test("zero byte msg",channelTest(function(e,n){open(e),e.on("delivery",function(e){completes(function(){assert.deepEqual(Buffer.alloc(0),e.content)},n)})},function(e,n,t,s){completes(function(){e(defs.BasicDeliver,DELIVER_FIELDS,s,Buffer.from(""))},t)})),test("bad delivery",channelTest(function(e,n){var t=latch(2,n);e.on("error",function(e){assert.strictEqual(505,e.code),assert.strictEqual(60,e.classId),assert.strictEqual(60,e.methodId),succeed(t)()}),e.on("close",succeed(t)),open(e)},function(e,n,t,s){return e(defs.BasicDeliver,DELIVER_FIELDS,s),e(defs.BasicDeliver,DELIVER_FIELDS,s),n(defs.ChannelClose)().then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("bad content send",channelTest(function(e,n){completes(function(){open(e),assert.throws(function(){e.sendMessage({routingKey:"foo",exchange:"amq.direct"},{},null)})},n)},function(e,n,t,s){t()})),test("bad properties send",channelTest(function(e,n){completes(function(){open(e),assert.throws(function(){e.sendMessage({routingKey:"foo",exchange:"amq.direct"},{contentEncoding:7},Buffer.from("foobar"))})},n)},function(e,n,t,s){t()})),test("bad consumer",channelTest(function(e,n){var t=latch(2,n);e.on("delivery",function(){throw new Error("I am a bad consumer")}),e.on("error",function(e){assert.strictEqual(541,e.code),assert.strictEqual(void 0,e.classId),assert.strictEqual(void 0,e.methodId),succeed(t)()}),e.on("close",succeed(t)),open(e)},function(e,n,t,s){return e(defs.BasicDeliver,DELIVER_FIELDS,s,Buffer.from("barfoo")),n(defs.ChannelClose)().then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("bad send in consumer",channelTest(function(e,n){var t=latch(2,n);e.on("close",succeed(t)),e.on("error",function(e){assert.strictEqual(541,e.code),assert.strictEqual(void 0,e.classId),assert.strictEqual(void 0,e.methodId),succeed(t)()}),e.on("delivery",function(){e.sendMessage({routingKey:"foo",exchange:"amq.direct"},{},null)}),open(e)},function(e,n,t,s){return completes(function(){e(defs.BasicDeliver,DELIVER_FIELDS,s,Buffer.from("barfoo"))},t),n(defs.ChannelClose)().then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("return",channelTest(function(e,n){e.on("return",function(e){completes(function(){assert.equal("barfoo",e.content.toString())},n)}),open(e)},function(e,n,t,s){completes(function(){e(defs.BasicReturn,DELIVER_FIELDS,s,Buffer.from("barfoo"))},t)})),test("cancel",channelTest(function(e,n){e.on("cancel",function(e){completes(function(){assert.equal("product of society",e.consumerTag)},n)}),open(e)},function(e,n,t,s){completes(function(){e(defs.BasicCancel,{consumerTag:"product of society",nowait:!1},s)},t)})),e("ack",defs.BasicAck),e("nack",defs.BasicNack),test("out-of-order acks",channelTest(function(e,n){var t=latch(3,function(){completes(function(){assert.equal(0,e.unconfirmed.length),assert.equal(4,e.lwm)},n)});e.pushConfirmCallback(t),e.pushConfirmCallback(t),e.pushConfirmCallback(t),open(e)},function(e,n,t,s){completes(function(){e(defs.BasicAck,{deliveryTag:2,multiple:!1},s),e(defs.BasicAck,{deliveryTag:3,multiple:!1},s),e(defs.BasicAck,{deliveryTag:1,multiple:!1},s)},t)})),test("not all out-of-order acks",channelTest(function(e,n){var t=latch(2,function(){completes(function(){assert.equal(1,e.unconfirmed.length),assert.equal(3,e.lwm)},n)});e.pushConfirmCallback(t),e.pushConfirmCallback(t),e.pushConfirmCallback(function(){n(new Error("Confirm callback should not be called"))}),open(e)},function(e,n,t,s){completes(function(){e(defs.BasicAck,{deliveryTag:2,multiple:!1},s),e(defs.BasicAck,{deliveryTag:1,multiple:!1},s)},t)}))});