"use strict";var assert=require("assert"),crypto=require("crypto"),api=require("../callback_api"),util=require("./util"),schedule=util.schedule,randomString=util.randomString,kCallback=util.kCallback,domain=require("domain"),Buffer=require("safe-buffer").Buffer,URL=process.env.URL||"amqp://localhost";function connect(e){api.connect(URL,{},e)}function doneCallback(t){return function(e,n){null==e?t():t(e)}}function ignore(){}function twice(n){var t=function(e){null==e?c=n:(c=ignore,n(e))},c=function(e){null==e?t=n:(t=ignore,n(e))};return{first:function(e){t(e)},second:function(e){c(e)}}}function failCallback(t){return function(e,n){null==e?t(new Error("Expected failure, got "+val)):t()}}function waitForMessages(t,c,o){t.checkQueue(c,function(e,n){return null!=e?o(e):0<n.messageCount?o(null,n):void schedule(waitForMessages.bind(null,t,c,o))})}function channel_test_fn(c){return function(e,t){test(e,function(n){connect(kCallback(function(e){e[c](kCallback(function(e){t(e,n)},n))},n))})}}suite("connect",function(){test("at all",function(e){connect(doneCallback(e))})});var channel_test=channel_test_fn("createChannel"),confirm_channel_test=channel_test_fn("createConfirmChannel");suite("channel open",function(){channel_test("at all",function(e,n){n()}),channel_test("open and close",function(e,n){e.close(doneCallback(n))})}),suite("assert, check, delete",function(){channel_test("assert, check, delete queue",function(n,t){n.assertQueue("test.cb.queue",{},kCallback(function(e){n.checkQueue("test.cb.queue",kCallback(function(e){n.deleteQueue("test.cb.queue",{},doneCallback(t))},t))},t))}),channel_test("assert, check, delete exchange",function(n,t){n.assertExchange("test.cb.exchange","topic",{},kCallback(function(e){n.checkExchange("test.cb.exchange",kCallback(function(e){n.deleteExchange("test.cb.exchange",{},doneCallback(t))},t))},t))}),channel_test("fail on check non-queue",function(e,n){n=twice(n);e.on("error",failCallback(n.first)),e.checkQueue("test.cb.nothere",failCallback(n.second))}),channel_test("fail on check non-exchange",function(e,n){n=twice(n);e.on("error",failCallback(n.first)),e.checkExchange("test.cb.nothere",failCallback(n.second))})}),suite("bindings",function(){channel_test("bind queue",function(t,c){t.assertQueue("test.cb.bindq",{},kCallback(function(n){t.assertExchange("test.cb.bindex","fanout",{},kCallback(function(e){t.bindQueue(n.queue,e.exchange,"",{},doneCallback(c))},c))},c))}),channel_test("bind exchange",function(t,c){t.assertExchange("test.cb.bindex1","fanout",{},kCallback(function(n){t.assertExchange("test.cb.bindex2","fanout",{},kCallback(function(e){t.bindExchange(n.exchange,e.exchange,"",{},doneCallback(c))},c))},c))})}),suite("sending messages",function(){channel_test("send to queue and consume noAck",function(t,c){var o=randomString();t.assertQueue("",{exclusive:!0},function(e,n){return null!==e?c(e):(t.consume(n.queue,function(e){e.content.toString()==o?c():c(new Error("message content doesn't match:"+o+" =/= "+e.content.toString()))},{noAck:!0,exclusive:!0}),void t.sendToQueue(n.queue,Buffer.from(o)))})}),channel_test("send to queue and consume ack",function(t,c){var o=randomString();t.assertQueue("",{exclusive:!0},function(e,n){return null!==e?c(e):(t.consume(n.queue,function(e){e.content.toString()==o?(t.ack(e),c()):c(new Error("message content doesn't match:"+o+" =/= "+e.content.toString()))},{noAck:!1,exclusive:!0}),void t.sendToQueue(n.queue,Buffer.from(o)))})}),channel_test("send to and get from queue",function(o,r){o.assertQueue("",{exclusive:!0},function(e,t){if(null!=e)return r(e);var c=randomString();o.sendToQueue(t.queue,Buffer.from(c)),waitForMessages(o,t.queue,function(e,n){return null!=e?r(e):void o.get(t.queue,{noAck:!0},function(e,n){return null!=e?r(e):n?n.content.toString()==c?r():r(new Error("Messages do not match: "+c+" =/= "+n.content.toString())):r(new Error("Empty (false) not expected"))})})})})}),suite("ConfirmChannel",function(){confirm_channel_test("Receive confirmation",function(e,n){e.publish("","",Buffer.from("foo"),{},n)}),confirm_channel_test("Wait for confirms",function(e,n){for(var t=0;t<1e3;t++)e.publish("","",Buffer.from("foo"),{});e.waitForConfirms(n)})}),suite("Error handling",function(){function e(e,c){test(e,function(n){var t=domain.createDomain();t.run(function(){connect(kCallback(function(e){t.add(e),e.createChannel(kCallback(function(e){c(e,n,t)},n))},n))})})}util.versionGreaterThan(process.versions.node,"0.8")&&test("Throw error in connection open callback",function(e){var n=domain.createDomain();n.on("error",failCallback(e)),connect(n.bind(function(e,n){throw new Error("Spurious connection open callback error")}))}),e("Channel open callback throws an error",function(e,n,t){throw t.on("error",failCallback(n)),new Error("Error in open callback")}),e("RPC callback throws error",function(e,n,t){t.on("error",failCallback(n)),e.prefetch(0,!1,function(e,n){throw new Error("Spurious callback error")})}),e("Get callback throws error",function(t,e,n){n.on("error",failCallback(e)),t.assertQueue("test.cb.get-with-error",{},function(e,n){t.get("test.cb.get-with-error",{noAck:!0},function(){throw new Error("Spurious callback error")})})}),e("Consume callback throws error",function(t,e,n){n.on("error",failCallback(e)),t.assertQueue("test.cb.consume-with-error",{},function(e,n){t.consume("test.cb.consume-with-error",ignore,{noAck:!0},function(){throw new Error("Spurious callback error")})})}),e("Get from non-queue invokes error k",function(e,n,t){n=twice(failCallback(n));t.on("error",n.first),e.get("",{},n.second)}),e("Consume from non-queue invokes error k",function(e,n,t){n=twice(failCallback(n));t.on("error",n.first),e.consume("",n.second)})});