"use strict";var defs=require("./defs"),constants=defs.constants,frame=require("./frame"),HEARTBEAT=frame.HEARTBEAT,Mux=require("./mux").Mux,Buffer=require("safe-buffer").Buffer,Duplex=require("stream").Duplex||require("readable-stream/duplex"),EventEmitter=require("events").EventEmitter,Heart=require("./heartbeat").Heart,methodName=require("./format").methodName,closeMsg=require("./format").closeMessage,inspect=require("./format").inspect,BitSet=require("./bitset").BitSet,inherits=require("util").inherits,fmt=require("util").format,PassThrough=require("stream").PassThrough||require("readable-stream/passthrough"),IllegalOperationError=require("./error").IllegalOperationError,stackCapture=require("./error").stackCapture,DEFAULT_WRITE_HWM=1024,SINGLE_CHUNK_THRESHOLD=2048;function Connection(e){EventEmitter.call(this);var t=this.stream=wrapStream(e);this.muxer=new Mux(t),this.rest=Buffer.alloc(0),this.frameMax=constants.FRAME_MIN_SIZE,this.sentSinceLastCheck=!1,this.recvSinceLastCheck=!1,this.expectSocketClose=!1,this.freeChannels=new BitSet,this.channels=[{channel:{accept:channel0(this)},buffer:e}]}inherits(Connection,EventEmitter);var C=Connection.prototype;function mainAccept(e){var t=this.channels[e.channel];if(t)return t.channel.accept(e);this.closeWithError(fmt("Frame on unknown channel %d",e.channel),constants.CHANNEL_ERROR,new Error(fmt("Frame on unknown channel: %s",inspect(e,!1))))}function channel0(r){return function(e){var t,n;e===HEARTBEAT||(e.id===defs.ConnectionClose?(r.sendMethod(0,defs.ConnectionCloseOk,{}),n=fmt("Connection closed: %s",closeMsg(e)),t=stackCapture(n),(n=new Error(n)).code=e.fields.replyCode,isFatalError(n)&&r.emit("error",n),r.toClosed(t,n)):e.id===defs.ConnectionBlocked?r.emit("blocked",e.fields.reason):e.id===defs.ConnectionUnblocked?r.emit("unblocked"):r.closeWithError(fmt("Unexpected frame on channel 0"),constants.UNEXPECTED_FRAME,new Error(fmt("Unexpected frame on channel 0: %s",inspect(e,!1)))))}}function invalidOp(e,t){return function(){throw new IllegalOperationError(e,t)}}function invalidateSend(e,t,n){e.sendMethod=e.sendContent=e.sendMessage=invalidOp(t,n)}C.sendProtocolHeader=function(){this.sendBytes(frame.PROTOCOL_HEADER)},C.open=function(n,e){var t=this,r=e||function(){},s=Object.create(n);function o(n){t.step(function(e,t){null!==e?i(e):0!==t.channel?i(new Error(fmt("Frame on channel != 0 during handshake: %s",inspect(t,!1)))):n(t)})}function a(t,n){o(function(e){e.id===t?n(e):i(new Error(fmt("Expected %s; got %s",methodName(t),inspect(e,!1))))})}function i(e){r(e)}function c(e){try{t.sendMethod(0,e,s)}catch(e){i(e)}}function h(e,t){return 0===e||0===t?Math.max(e,t):Math.min(e,t)}function l(e){switch(e.id){case defs.ConnectionSecure:i(new Error("Wasn't expecting to have to go through secure"));break;case defs.ConnectionClose:i(new Error(fmt("Handshake terminated by server: %s",closeMsg(e))));break;case defs.ConnectionTune:var t=e.fields;s.frameMax=h(t.frameMax,n.frameMax),s.channelMax=h(t.channelMax,n.channelMax),s.heartbeat=h(t.heartbeat,n.heartbeat),c(defs.ConnectionTuneOk),c(defs.ConnectionOpen),a(defs.ConnectionOpenOk,f);break;default:i(new Error(fmt("Expected connection.secure, connection.close, or connection.tune during handshake; got %s",inspect(e,!1))))}}function f(e){t.channelMax=s.channelMax||65535,t.frameMax=s.frameMax||4294967295,t.heartbeat=s.heartbeat,t.heartbeater=t.startHeartbeater(),t.accept=mainAccept,e=e,t.stream.removeListener("end",u),t.stream.removeListener("error",u),t.stream.on("error",t.onSocketError.bind(t)),t.stream.on("end",t.onSocketError.bind(t,new Error("Unexpected close"))),t.on("frameError",t.onSocketError.bind(t)),t.acceptLoop(),r(null,e)}function u(e){i(e||new Error("Socket closed abruptly during opening handshake"))}this.stream.on("end",u),this.stream.on("error",u),this.sendProtocolHeader(),a(defs.ConnectionStart,function(e){e.fields.mechanisms.toString().split(" ").indexOf(n.mechanism)<0?i(new Error(fmt("SASL mechanism %s is not provided by the server",n.mechanism))):(t.serverProperties=e.fields.serverProperties,c(defs.ConnectionStartOk),o(l))})},C.close=function(e){this.closeBecause("Cheers, thanks",constants.REPLY_SUCCESS,e&&function(){e(null)})},C.closeBecause=function(e,t,n){this.sendMethod(0,defs.ConnectionClose,{replyText:e,replyCode:t,methodId:0,classId:0});e=stackCapture("closeBecause called: "+e);this.toClosing(e,n)},C.closeWithError=function(e,t,n){this.emit("error",n),this.closeBecause(e,t)},C.onSocketError=function(e){var t;this.expectSocketClose||(this.expectSocketClose=!0,this.emit("error",e),t=stackCapture("Socket error"),this.toClosed(t,e))},C.toClosing=function(e,n){var r=this.sendMethod.bind(this);this.accept=function(e){var t;e.id===defs.ConnectionCloseOk?(n&&n(),t=stackCapture("ConnectionCloseOk received"),this.toClosed(t,void 0)):e.id===defs.ConnectionClose&&r(0,defs.ConnectionCloseOk,{})},invalidateSend(this,"Connection closing",e)},C._closeChannels=function(e){for(var t=1;t<this.channels.length;t++){var n=this.channels[t];null!==n&&n.channel.toClosed(e)}},C.toClosed=function(t,e){this._closeChannels(t);var n=fmt("Connection closed (%s)",e?e.toString():"by client");invalidateSend(this,n,t),this.accept=invalidOp(n,t),this.close=function(e){e&&e(new IllegalOperationError(n,t))},this.heartbeater&&this.heartbeater.clear(),this.expectSocketClose=!0,this.stream.end(),this.emit("close",e)},C.startHeartbeater=function(){if(0===this.heartbeat)return null;var n=this,e=new Heart(this.heartbeat,this.checkSend.bind(this),this.checkRecv.bind(this));return e.on("timeout",function(){var e=new Error("Heartbeat timeout");n.emit("error",e);var t=stackCapture("Heartbeat timeout");n.toClosed(t,e)}),e.on("beat",function(){n.sendHeartbeat()}),e},C.freshChannel=function(e,t){var n=this.freeChannels.nextClearBit(1);if(n<0||n>this.channelMax)throw new Error("No channels left to allocate");this.freeChannels.set(n);t=t&&t.highWaterMark||DEFAULT_WRITE_HWM,t=new PassThrough({objectMode:!0,highWaterMark:t});return this.channels[n]={channel:e,buffer:t},t.on("drain",function(){e.onBufferDrain()}),this.muxer.pipeFrom(t),n},C.releaseChannel=function(e){this.freeChannels.clear(e),this.channels[e].buffer.end(),this.channels[e]=null},C.acceptLoop=function(){var t=this;function e(){try{for(var e;e=t.recvFrame();)t.accept(e)}catch(e){t.emit("frameError",e)}}t.stream.on("readable",e),e()},C.step=function(n){var r=this;!function e(){var t;try{t=r.recvFrame()}catch(e){return void n(e,null)}t?n(null,t):r.stream.once("readable",e)}()},C.checkSend=function(){var e=this.sentSinceLastCheck;return this.sentSinceLastCheck=!1,e},C.checkRecv=function(){var e=this.recvSinceLastCheck;return this.recvSinceLastCheck=!1,e},C.sendBytes=function(e){this.sentSinceLastCheck=!0,this.stream.write(e)},C.sendHeartbeat=function(){return this.sendBytes(frame.HEARTBEAT_BUF)};var encodeMethod=defs.encodeMethod,encodeProperties=defs.encodeProperties;C.sendMethod=function(e,t,n){n=encodeMethod(t,e,n);return this.sentSinceLastCheck=!0,this.channels[e].buffer.write(n)},C.sendMessage=function(e,t,n,r,s,o){if(!Buffer.isBuffer(o))throw new TypeError("content is not a buffer");var a=encodeMethod(t,e,n),i=encodeProperties(r,e,o.length,s),t=this.channels[e].buffer;this.sentSinceLastCheck=!0;n=a.length+i.length,r=0<o.length?o.length+FRAME_OVERHEAD:0,s=n+r;if(s<SINGLE_CHUNK_THRESHOLD){var s=Buffer.alloc(s),c=a.copy(s,0);return c+=i.copy(s,c),0<r&&makeBodyFrame(e,o).copy(s,c),t.write(s)}return n<SINGLE_CHUNK_THRESHOLD?(n=Buffer.alloc(n),c=a.copy(n,0),i.copy(n,c),t.write(n)):(t.write(a),t.write(i)),this.sendContent(e,o)};var FRAME_OVERHEAD=defs.FRAME_OVERHEAD,makeBodyFrame=frame.makeBodyFrame;C.sendContent=function(e,t){if(!Buffer.isBuffer(t))throw new TypeError(fmt("Expected buffer; got %s",t));for(var n=!0,r=this.channels[e].buffer,s=this.frameMax-FRAME_OVERHEAD,o=0;o<t.length;o+=s)var a=o+s,a=a>t.length?t.slice(o):t.slice(o,a),a=makeBodyFrame(e,a),n=r.write(a);return this.sentSinceLastCheck=!0,n};var parseFrame=frame.parseFrame,decodeFrame=frame.decodeFrame;function wrapStream(r){if(r instanceof Duplex)return r;var e=new Duplex;return e.wrap(r),e._write=function(e,t,n){return r.write(e,t,n)},e}function isFatalError(e){switch(e&&e.code){case defs.constants.CONNECTION_FORCED:case defs.constants.REPLY_SUCCESS:return!1;default:return!0}}C.recvFrame=function(){var e=parseFrame(this.rest,this.frameMax);if(e)return this.rest=e.rest,decodeFrame(e);e=this.stream.read();return null!==e&&(this.recvSinceLastCheck=!0,this.rest=Buffer.concat([this.rest,e]),this.recvFrame())},module.exports.Connection=Connection,module.exports.isFatalError=isFatalError;