"use strict";var defs=require("./defs"),Promise=require("bluebird"),inherits=require("util").inherits,EventEmitter=require("events").EventEmitter,BaseChannel=require("./channel").BaseChannel,acceptMessage=require("./channel").acceptMessage,Args=require("./api_args");function ChannelModel(n){if(!(this instanceof ChannelModel))return new ChannelModel(n);EventEmitter.call(this),this.connection=n;var r=this;["error","close","blocked","unblocked"].forEach(function(e){n.on(e,r.emit.bind(r,e))})}inherits(ChannelModel,EventEmitter);var CM=(module.exports.ChannelModel=ChannelModel).prototype;function Channel(e){BaseChannel.call(this,e),this.on("delivery",this.handleDelivery.bind(this)),this.on("cancel",this.handleCancel.bind(this))}CM.close=function(){return Promise.fromCallback(this.connection.close.bind(this.connection))},inherits(Channel,BaseChannel),module.exports.Channel=Channel,CM.createChannel=function(){var n=new Channel(this.connection);return n.open().then(function(e){return n})};var C=Channel.prototype;function ConfirmChannel(e){Channel.call(this,e)}C.rpc=function(n,r,t){var i=this;return Promise.fromCallback(function(e){return i._rpc(n,r,t,e)}).then(function(e){return e.fields})},C.open=function(){return Promise.try(this.allocate.bind(this)).then(function(e){return e.rpc(defs.ChannelOpen,{outOfBand:""},defs.ChannelOpenOk)})},C.close=function(){var n=this;return Promise.fromCallback(function(e){return n.closeBecause("Goodbye",defs.constants.REPLY_SUCCESS,e)})},C.assertQueue=function(e,n){return this.rpc(defs.QueueDeclare,Args.assertQueue(e,n),defs.QueueDeclareOk)},C.checkQueue=function(e){return this.rpc(defs.QueueDeclare,Args.checkQueue(e),defs.QueueDeclareOk)},C.deleteQueue=function(e,n){return this.rpc(defs.QueueDelete,Args.deleteQueue(e,n),defs.QueueDeleteOk)},C.purgeQueue=function(e){return this.rpc(defs.QueuePurge,Args.purgeQueue(e),defs.QueuePurgeOk)},C.bindQueue=function(e,n,r,t){return this.rpc(defs.QueueBind,Args.bindQueue(e,n,r,t),defs.QueueBindOk)},C.unbindQueue=function(e,n,r,t){return this.rpc(defs.QueueUnbind,Args.unbindQueue(e,n,r,t),defs.QueueUnbindOk)},C.assertExchange=function(n,e,r){return this.rpc(defs.ExchangeDeclare,Args.assertExchange(n,e,r),defs.ExchangeDeclareOk).then(function(e){return{exchange:n}})},C.checkExchange=function(e){return this.rpc(defs.ExchangeDeclare,Args.checkExchange(e),defs.ExchangeDeclareOk)},C.deleteExchange=function(e,n){return this.rpc(defs.ExchangeDelete,Args.deleteExchange(e,n),defs.ExchangeDeleteOk)},C.bindExchange=function(e,n,r,t){return this.rpc(defs.ExchangeBind,Args.bindExchange(e,n,r,t),defs.ExchangeBindOk)},C.unbindExchange=function(e,n,r,t){return this.rpc(defs.ExchangeUnbind,Args.unbindExchange(e,n,r,t),defs.ExchangeUnbindOk)},C.publish=function(e,n,r,t){t=Args.publish(e,n,t);return this.sendMessage(t,t,r)},C.sendToQueue=function(e,n,r){return this.publish("",e,n,r)},C.consume=function(e,n,r){var t=this,i=Args.consume(e,r);return Promise.fromCallback(function(e){t._rpc(defs.BasicConsume,i,defs.BasicConsumeOk,e)}).then(function(e){return t.registerConsumer(e.fields.consumerTag,n),e.fields})},C.cancel=function(n){var r=this;return Promise.fromCallback(function(e){r._rpc(defs.BasicCancel,Args.cancel(n),defs.BasicCancelOk,e)}).then(function(e){return r.unregisterConsumer(n),e.fields})},C.get=function(e,n){var t=this,r=Args.get(e,n);return Promise.fromCallback(function(e){return t.sendOrEnqueue(defs.BasicGet,r,e)}).then(function(e){if(e.id===defs.BasicGetEmpty)return!1;if(e.id!==defs.BasicGetOk)throw new Error("Unexpected response to BasicGet: "+inspect(e));var r=e.fields;return new Promise(function(n){t.handleMessage=acceptMessage(function(e){e.fields=r,n(e)})})})},C.ack=function(e,n){this.sendImmediately(defs.BasicAck,Args.ack(e.fields.deliveryTag,n))},C.ackAll=function(){this.sendImmediately(defs.BasicAck,Args.ack(0,!0))},C.nack=function(e,n,r){this.sendImmediately(defs.BasicNack,Args.nack(e.fields.deliveryTag,n,r))},C.nackAll=function(e){this.sendImmediately(defs.BasicNack,Args.nack(0,!0,e))},C.reject=function(e,n){this.sendImmediately(defs.BasicReject,Args.reject(e.fields.deliveryTag,n))},C.prefetch=C.qos=function(e,n){return this.rpc(defs.BasicQos,Args.prefetch(e,n),defs.BasicQosOk)},C.recover=function(){return this.rpc(defs.BasicRecover,Args.recover(),defs.BasicRecoverOk)},inherits(ConfirmChannel,Channel),module.exports.ConfirmChannel=ConfirmChannel,CM.createConfirmChannel=function(){var n=new ConfirmChannel(this.connection);return n.open().then(function(e){return n.rpc(defs.ConfirmSelect,{nowait:!1},defs.ConfirmSelectOk)}).then(function(){return n})};var CC=ConfirmChannel.prototype;CC.publish=function(e,n,r,t,i){return this.pushConfirmCallback(i),C.publish.call(this,e,n,r,t)},CC.sendToQueue=function(e,n,r,t){return this.publish("",e,n,r,t)},CC.waitForConfirms=function(){var r=[],i=this.unconfirmed;return i.forEach(function(t,e){var n;null===t||(n=new Promise(function(n,r){i[e]=function(e){t&&t(e),null===e?n():r(e)}}),r.push(n))}),Promise.all(r)};