"use strict";var defs=require("./defs"),closeMsg=require("./format").closeMessage,inspect=require("./format").inspect,methodName=require("./format").methodName,assert=require("assert"),inherits=require("util").inherits,EventEmitter=require("events").EventEmitter,fmt=require("util").format,IllegalOperationError=require("./error").IllegalOperationError,stackCapture=require("./error").stackCapture,Buffer=require("safe-buffer").Buffer;function Channel(e){EventEmitter.call(this),this.connection=e,this.reply=null,this.pending=[],this.lwm=1,this.unconfirmed=[],this.on("ack",this.handleConfirm.bind(this,function(e){e&&e(null)})),this.on("nack",this.handleConfirm.bind(this,function(e){e&&e(new Error("message nacked"))})),this.on("close",function(){for(var e;e=this.unconfirmed.shift();)e&&e(new Error("channel closed"))}),this.handleMessage=acceptDeliveryOrReturn}inherits(Channel,EventEmitter),module.exports.Channel=Channel,module.exports.acceptMessage=acceptMessage;var C=Channel.prototype;function invalidOp(e,n){return function(){throw new IllegalOperationError(e,n)}}function invalidateSend(e,n,t){e.sendImmediately=e.sendOrEnqueue=e.sendMessage=invalidOp(n,t)}function acceptDeliveryOrReturn(e){var n;if(e.id===defs.BasicDeliver)n="delivery";else{if(e.id!==defs.BasicReturn)throw fmt("Expected BasicDeliver or BasicReturn; got %s",inspect(e));n="return"}var t=this,s=e.fields;return acceptMessage(function(e){e.fields=s,t.emit(n,e)})}function acceptMessage(t){var s=0,i=0,r=null,o={fields:null,properties:null,content:null};return function(e){{if(e.id===defs.BasicProperties)return o.properties=e.fields,0===(s=i=e.size)?(o.content=Buffer.alloc(0),t(o),acceptDeliveryOrReturn):l;throw"Expected headers frame after delivery"}};function l(e){if(e.content){var n=e.content.length;if(0===(i-=n))return null!==r?(r.push(e.content),o.content=Buffer.concat(r)):o.content=e.content,t(o),acceptDeliveryOrReturn;if(i<0)throw fmt("Too much content sent! Expected %d bytes",s);return null!==r?r.push(e.content):r=[e.content],l}throw"Expected content frame after headers"}}function BaseChannel(e){Channel.call(this,e),this.consumers={}}C.allocate=function(){return this.ch=this.connection.freshChannel(this),this},C.sendImmediately=function(e,n){return this.connection.sendMethod(this.ch,e,n)},C.sendOrEnqueue=function(e,n,t){this.reply?this.pending.push({method:e,fields:n,reply:t}):(assert(0===this.pending.length),this.reply=t,this.sendImmediately(e,n))},C.sendMessage=function(e,n,t){return this.connection.sendMessage(this.ch,defs.BasicPublish,e,defs.BasicProperties,n,t)},C._rpc=function(s,e,i,r){var o=this;this.sendOrEnqueue(s,e,function(e,n){if(null!==e)return e instanceof Error?r(e):(n=(e.fields.classId<<16)+e.fields.methodId,t=s===n?fmt("Operation failed: %s; %s",methodName(s),closeMsg(e)):fmt("Channel closed by server: %s",closeMsg(e)),(t=new Error(t)).code=e.fields.replyCode,t.classId=e.fields.classId,t.methodId=e.fields.methodId,r(t));if(n.id===i)return r(null,n);var e=methodName(i),t=new Error(fmt("Expected %s; got %s",e,inspect(n,!1)));return o.closeWithError(n.id,fmt("Expected %s; got %s",e,methodName(n.id)),defs.constants.UNEXPECTED_FRAME,t),r(t)})},C.toClosed=function(e){this._rejectPending(),invalidateSend(this,"Channel closed",e),this.accept=invalidOp("Channel closed",e),this.connection.releaseChannel(this.ch),this.emit("close")},C.toClosing=function(e,t){var s=this.sendImmediately.bind(this);invalidateSend(this,"Channel closing",e),this.accept=function(e){var n;e.id===defs.ChannelCloseOk?(t&&t(),n=stackCapture("ChannelCloseOk frame received"),this.toClosed(n)):e.id===defs.ChannelClose&&s(defs.ChannelCloseOk,{})}},C._rejectPending=function(){function e(e){e(new Error("Channel ended, no reply will be forthcoming"))}var n;for(null!==this.reply&&e(this.reply),this.reply=null;n=this.pending.shift();)e(n.reply);this.pending=null},C.closeBecause=function(e,n,t){this.sendImmediately(defs.ChannelClose,{replyText:e,replyCode:n,methodId:0,classId:0});e=stackCapture("closeBecause called: "+e);this.toClosing(e,t)},C.closeWithError=function(e,n,t,s){var i=this;this.closeBecause(n,t,function(){s.code=t,e&&(s.classId=defs.info(e).classId,s.methodId=defs.info(e).methodId),i.emit("error",s)})},C.acceptMessageFrame=function(n){try{this.handleMessage=this.handleMessage(n)}catch(e){"string"==typeof e?this.closeWithError(n.id,e,defs.constants.UNEXPECTED_FRAME,new Error(e)):e instanceof Error?this.closeWithError(n.id,"Error while processing message",defs.constants.INTERNAL_ERROR,e):this.closeWithError(n.id,"Internal error while processing message",defs.constants.INTERNAL_ERROR,new Error(e.toString()))}},C.handleConfirm=function(e,n){var t,s=n.deliveryTag;if(n.multiple){n=this.unconfirmed.splice(0,s-this.lwm+1);this.lwm=s+1,n.forEach(e)}else{if(s===this.lwm)for(t=this.unconfirmed.shift(),this.lwm++;null===this.unconfirmed[0];)this.unconfirmed.shift(),this.lwm++;else t=this.unconfirmed[s-this.lwm],this.unconfirmed[s-this.lwm]=null;e(t)}},C.pushConfirmCallback=function(e){this.unconfirmed.push(e||!1)},C.accept=function(e){switch(e.id){case void 0:case defs.BasicDeliver:case defs.BasicReturn:case defs.BasicProperties:return this.acceptMessageFrame(e);case defs.BasicAck:return this.emit("ack",e.fields);case defs.BasicNack:return this.emit("nack",e.fields);case defs.BasicCancel:return this.emit("cancel",e.fields);case defs.ChannelClose:this.reply&&(s=this.reply,this.reply=null,s(e));var n="Channel closed by server: "+closeMsg(e);this.sendImmediately(defs.ChannelCloseOk,{});var t=new Error(n);t.code=e.fields.replyCode,t.classId=e.fields.classId,t.methodId=e.fields.methodId,this.emit("error",t);n=stackCapture(n);return void this.toClosed(n);case defs.BasicFlow:return this.closeWithError(e.id,"Flow not implemented",defs.constants.NOT_IMPLEMENTED,new Error("Flow not implemented"));default:var s=this.reply;return this.reply=null,0<this.pending.length&&(n=this.pending.shift(),this.reply=n.reply,this.sendImmediately(n.method,n.fields)),s(null,e)}},C.onBufferDrain=function(){this.emit("drain")},inherits(BaseChannel,Channel),(module.exports.BaseChannel=BaseChannel).prototype.registerConsumer=function(e,n){this.consumers[e]=n},BaseChannel.prototype.unregisterConsumer=function(e){delete this.consumers[e]},BaseChannel.prototype.dispatchMessage=function(e,n){var t=e.consumerTag,e=this.consumers[t];if(e)return e(n);throw new Error("Unknown consumer: "+t)},BaseChannel.prototype.handleDelivery=function(e){return this.dispatchMessage(e.fields,e)},BaseChannel.prototype.handleCancel=function(e){return this.dispatchMessage(e,null)};