"use strict";var defs=require("./defs"),Promise=require("bluebird"),inherits=require("util").inherits,EventEmitter=require("events").EventEmitter,BaseChannel=require("./channel").BaseChannel,acceptMessage=require("./channel").acceptMessage,Args=require("./api_args");function CallbackModel(n){if(!(this instanceof CallbackModel))return new CallbackModel(n);EventEmitter.call(this),this.connection=n;var t=this;["error","close","blocked","unblocked"].forEach(function(e){n.on(e,t.emit.bind(t,e))})}function Channel(e){BaseChannel.call(this,e),this.on("delivery",this.handleDelivery.bind(this)),this.on("cancel",this.handleCancel.bind(this))}function callbackWrapper(e,t){return t?function(e,n){null===e?t(null,n):t(e)}:function(){}}function ConfirmChannel(e){Channel.call(this,e)}inherits(CallbackModel,EventEmitter),(module.exports.CallbackModel=CallbackModel).prototype.close=function(e){this.connection.close(e)},inherits(Channel,BaseChannel),module.exports.Channel=Channel,CallbackModel.prototype.createChannel=function(t){var r=new Channel(this.connection);return r.open(function(e,n){null===e?t&&t(null,r):t&&t(e)}),r},Channel.prototype.rpc=function(e,n,t,r){var i=callbackWrapper(this,r);return this._rpc(e,n,t,function(e,n){i(e,n&&n.fields)}),this},Channel.prototype.open=function(n){try{this.allocate()}catch(e){return n(e)}return this.rpc(defs.ChannelOpen,{outOfBand:""},defs.ChannelOpenOk,n)},Channel.prototype.close=function(e){return this.closeBecause("Goodbye",defs.constants.REPLY_SUCCESS,function(){e&&e(null)})},Channel.prototype.assertQueue=function(e,n,t){return this.rpc(defs.QueueDeclare,Args.assertQueue(e,n),defs.QueueDeclareOk,t)},Channel.prototype.checkQueue=function(e,n){return this.rpc(defs.QueueDeclare,Args.checkQueue(e),defs.QueueDeclareOk,n)},Channel.prototype.deleteQueue=function(e,n,t){return this.rpc(defs.QueueDelete,Args.deleteQueue(e,n),defs.QueueDeleteOk,t)},Channel.prototype.purgeQueue=function(e,n){return this.rpc(defs.QueuePurge,Args.purgeQueue(e),defs.QueuePurgeOk,n)},Channel.prototype.bindQueue=function(e,n,t,r,i){return this.rpc(defs.QueueBind,Args.bindQueue(e,n,t,r),defs.QueueBindOk,i)},Channel.prototype.unbindQueue=function(e,n,t,r,i){return this.rpc(defs.QueueUnbind,Args.unbindQueue(e,n,t,r),defs.QueueUnbindOk,i)},Channel.prototype.assertExchange=function(t,e,n,r){var i=callbackWrapper(this,r);return this._rpc(defs.ExchangeDeclare,Args.assertExchange(t,e,n),defs.ExchangeDeclareOk,function(e,n){i(e,{exchange:t})}),this},Channel.prototype.checkExchange=function(e,n){return this.rpc(defs.ExchangeDeclare,Args.checkExchange(e),defs.ExchangeDeclareOk,n)},Channel.prototype.deleteExchange=function(e,n,t){return this.rpc(defs.ExchangeDelete,Args.deleteExchange(e,n),defs.ExchangeDeleteOk,t)},Channel.prototype.bindExchange=function(e,n,t,r,i){return this.rpc(defs.ExchangeBind,Args.bindExchange(e,n,t,r),defs.ExchangeBindOk,i)},Channel.prototype.unbindExchange=function(e,n,t,r,i){return this.rpc(defs.ExchangeUnbind,Args.unbindExchange(e,n,t,r),defs.ExchangeUnbindOk,i)},Channel.prototype.publish=function(e,n,t,r){r=Args.publish(e,n,r);return this.sendMessage(r,r,t)},Channel.prototype.sendToQueue=function(e,n,t){return this.publish("",e,n,t)},Channel.prototype.consume=function(e,t,n,r){var i=callbackWrapper(this,r),n=Args.consume(e,n),s=this;return this._rpc(defs.BasicConsume,n,defs.BasicConsumeOk,function(e,n){null===e?(s.registerConsumer(n.fields.consumerTag,t),i(null,n.fields)):i(e)}),this},Channel.prototype.cancel=function(t,e){var r=callbackWrapper(this,e),i=this;return this._rpc(defs.BasicCancel,Args.cancel(t),defs.BasicCancelOk,function(e,n){null===e?(i.unregisterConsumer(t),r(null,n.fields)):r(e)}),this},Channel.prototype.get=function(e,n,t){var r=this,n=Args.get(e,n),i=callbackWrapper(this,t);return this.sendOrEnqueue(defs.BasicGet,n,function(e,n){null===e&&(n.id===defs.BasicGetEmpty?i(null,!1):n.id===defs.BasicGetOk?r.handleMessage=acceptMessage(function(e){e.fields=n.fields,i(null,e)}):i(new Error("Unexpected response to BasicGet: "+inspect(n))))}),this},Channel.prototype.ack=function(e,n){return this.sendImmediately(defs.BasicAck,Args.ack(e.fields.deliveryTag,n)),this},Channel.prototype.ackAll=function(){return this.sendImmediately(defs.BasicAck,Args.ack(0,!0)),this},Channel.prototype.nack=function(e,n,t){return this.sendImmediately(defs.BasicNack,Args.nack(e.fields.deliveryTag,n,t)),this},Channel.prototype.nackAll=function(e){return this.sendImmediately(defs.BasicNack,Args.nack(0,!0,e)),this},Channel.prototype.reject=function(e,n){return this.sendImmediately(defs.BasicReject,Args.reject(e.fields.deliveryTag,n)),this},Channel.prototype.prefetch=function(e,n,t){return this.rpc(defs.BasicQos,Args.prefetch(e,n),defs.BasicQosOk,t)},Channel.prototype.recover=function(e){return this.rpc(defs.BasicRecover,Args.recover(),defs.BasicRecoverOk,e)},inherits(ConfirmChannel,Channel),module.exports.ConfirmChannel=ConfirmChannel,CallbackModel.prototype.createConfirmChannel=function(t){var r=new ConfirmChannel(this.connection);return r.open(function(e){return null!==e?t&&t(e):void r.rpc(defs.ConfirmSelect,{nowait:!1},defs.ConfirmSelectOk,function(e,n){return null!==e?t&&t(e):void(t&&t(null,r))})}),r},ConfirmChannel.prototype.publish=function(e,n,t,r,i){return this.pushConfirmCallback(i),Channel.prototype.publish.call(this,e,n,t,r)},ConfirmChannel.prototype.sendToQueue=function(e,n,t,r){return this.publish("",e,n,t,r)},ConfirmChannel.prototype.waitForConfirms=function(n){var t=[],i=this.unconfirmed;return i.forEach(function(r,e){var n;null===r||(n=new Promise(function(n,t){i[e]=function(e){r&&r(e),null===e?n():t(e)}}),t.push(n))}),Promise.all(t).then(function(){n()},function(e){n(e)})};