Install with:
`npm install @cambium/cns-webhook`

## Usage Example

```js
var webhooks = require('@cambium/cns-webhook'),
  cnsLogger = require('@cambium/cns-logger');

webhooks.initLogger(cnsLogger);

new webhooks(config);
```

Config is optional. If not provided fallback to default.
Default config. If provided config should have the same format as shown. Config is validated and will throw an error if incorrect config format passed.

```json
{
  "message": {
    "channels": [
      {
        "exchanges": {
          "cns.notify": {
            "type": "topic",
            "queues": {
              "cns.notify.webhook": {
                "binding": "cns.notify.webhook",
                "arguments": {
                  "x-message-ttl": 600000
                }
              }
            }
          }
        },
        "prefetch": 1
      }
    ],
    "consumers": [
      {
        "exchange": "cns.notify",
        "queue": "cns.notify.webhook",
        "noAck": false
      }
    ]
  },
  "connection": {
    "redis": {
      "host": "localhost",
      "port": 6379,
      "db": {
        "common": 1,
        "customer": 4
      }
    },
    "amqp": {
      "protocol": "amqp",
      "hostname": "localhost",
      "port": 5672,
      "username": "guest",
      "password": "guest",
      "locale": "en_US"
    }
  },
  "locale": {},
  "devicesSKU": {}
}
```
