"use strict";var net=require("net"),tls=require("tls"),util=require("util"),utils=require("./lib/utils"),Command=require("./lib/command"),Queue=require("denque"),errorClasses=require("./lib/customErrors"),EventEmitter=require("events"),Parser=require("redis-parser"),RedisErrors=require("redis-errors"),commands=require("redis-commands"),debug=require("./lib/debug"),unifyOptions=require("./lib/createClient"),SUBSCRIBE_COMMANDS={subscribe:!0,unsubscribe:!0,psubscribe:!0,punsubscribe:!0};function noop(){}function handle_detect_buffers_reply(e,t,r){return!1!==r&&!this.message_buffers||(e=utils.reply_to_strings(e)),e="hgetall"===t?utils.reply_to_object(e):e}function RedisClient(e,t){e=utils.clone(e),EventEmitter.call(this);var r,i,s={};for(r in e.tls)s[r]=e.tls[r],"port"!==r&&"host"!==r&&"path"!==r&&"family"!==r||(e[r]=e.tls[r]);for(i in t?(e.stream=t,this.address='"Private stream"'):e.path?(s.path=e.path,this.address=e.path):(s.port=+e.port||6379,s.host=e.host||"127.0.0.1",s.family=!e.family&&net.isIP(s.host)||("IPv6"===e.family?6:4),this.address=s.host+":"+s.port),this.connection_options=s,this.connection_id=RedisClient.connection_id++,this.connected=!1,this.ready=!1,void 0===e.socket_keepalive&&(e.socket_keepalive=!0),void 0===e.socket_initial_delay&&(e.socket_initial_delay=0),e.rename_commands)e.rename_commands[i.toLowerCase()]=e.rename_commands[i];e.return_buffers=!!e.return_buffers,e.detect_buffers=!!e.detect_buffers,e.return_buffers&&e.detect_buffers&&(this.warn("WARNING: You activated return_buffers and detect_buffers at the same time. The return value is always going to be a buffer."),e.detect_buffers=!1),e.detect_buffers&&(this.handle_reply=handle_detect_buffers_reply),this.should_buffer=!1,this.command_queue=new Queue,this.offline_queue=new Queue,this.pipeline_queue=new Queue,this.connect_timeout=+e.connect_timeout||36e5,this.enable_offline_queue=!1!==e.enable_offline_queue,this.initialize_retry_vars(),this.pub_sub_mode=0,this.subscription_set={},this.monitoring=!1,this.message_buffers=!1,this.closing=!1,this.server_info={},this.auth_pass=e.auth_pass||e.password,this.auth_user=e.auth_user||e.user,this.selected_db=e.db,this.fire_strings=!0,this.pipeline=!1,this.sub_commands_left=0,this.times_connected=0,this.buffers=e.return_buffers||e.detect_buffers,this.options=e,this.reply="ON",this.create_stream(),this.on("newListener",function(e){"message_buffer"!==e&&"pmessage_buffer"!==e&&"messageBuffer"!==e&&"pmessageBuffer"!==e||this.buffers||this.message_buffers||(this.reply_parser.optionReturnBuffers=!0,this.message_buffers=!0,this.handle_reply=handle_detect_buffers_reply)})}function create_parser(t){return new Parser({returnReply:function(e){t.return_reply(e)},returnError:function(e){t.return_error(e)},returnFatalError:function(e){e.message+=". Please report this.",t.ready=!1,t.flush_and_error({message:"Fatal error encountered. Command aborted.",code:"NR_FATAL"},{error:e,queues:["command_queue"]}),t.emit("error",e),t.create_stream()},returnBuffers:t.buffers||t.message_buffers,stringNumbers:t.options.string_numbers||!1})}exports.debug_mode=/\bredis\b/i.test(process.env.NODE_DEBUG),util.inherits(RedisClient,EventEmitter),RedisClient.connection_id=0,RedisClient.prototype.create_stream=function(){var t=this;if(this.reply_parser=create_parser(this),this.options.stream){if(this.stream)return;this.stream=this.options.stream}else this.stream&&(this.stream.removeAllListeners(),this.stream.destroy()),this.options.tls?this.stream=tls.connect(this.connection_options):this.stream=net.createConnection(this.connection_options);this.options.connect_timeout&&this.stream.setTimeout(this.connect_timeout,function(){t.retry_totaltime=t.connect_timeout,t.connection_gone("timeout")});var e=this.options.tls?"secureConnect":"connect";this.stream.once(e,function(){this.removeAllListeners("timeout"),t.times_connected++,t.on_connect()}),this.stream.on("data",function(e){debug("Net read "+t.address+" id "+t.connection_id),t.reply_parser.execute(e)}),this.stream.on("error",function(e){t.on_error(e)}),this.stream.once("close",function(e){t.connection_gone("close")}),this.stream.once("end",function(){t.connection_gone("end")}),this.stream.on("drain",function(){t.drain()}),this.stream.setNoDelay(),void 0!==this.auth_pass&&(this.ready=!0,this.auth(this.auth_pass,this.auth_user,function(e){e&&"UNCERTAIN_STATE"!==e.code&&t.emit("error",e)}),this.ready=!1)},RedisClient.prototype.handle_reply=function(e,t){return e="hgetall"===t?utils.reply_to_object(e):e},RedisClient.prototype.cork=noop,RedisClient.prototype.uncork=noop,RedisClient.prototype.initialize_retry_vars=function(){this.retry_timer=null,this.retry_totaltime=0,this.retry_delay=200,this.retry_backoff=1.7,this.attempts=1},RedisClient.prototype.warn=function(e){var t=this;process.nextTick(function(){0!==t.listeners("warning").length?t.emit("warning",e):console.warn("node_redis:",e)})},RedisClient.prototype.flush_and_error=function(e,t){for(var r,i=[],s=(t=t||{}).queues||["command_queue","offline_queue"],n=0;n<s.length;n++){"command_queue"===s[n]?e.message+=" It might have been processed.":e.message=e.message.replace(" It might have been processed.","");for(var o=this[s[n]].shift();o;o=this[s[n]].shift()){var a=new errorClasses.AbortError(e);o.error&&(a.stack=a.stack+o.error.stack.replace(/^Error.*?\n/,"\n")),a.command=o.command.toUpperCase(),o.args&&o.args.length&&(a.args=o.args),t.error&&(a.origin=t.error),"function"==typeof o.callback?o.callback(a):i.push(a)}}exports.debug_mode&&i.length&&(1===i.length?r=i[0]:(e.message=e.message.replace("It","They").replace(/command/i,"$&s"),(r=new errorClasses.AggregateError(e)).errors=i),this.emit("error",r))},RedisClient.prototype.on_error=function(e){this.closing||(e.message="Redis connection to "+this.address+" failed - "+e.message,debug(e.message),this.connected=!1,this.ready=!1,this.options.retry_strategy||this.emit("error",e),this.connection_gone("error",e))},RedisClient.prototype.on_connect=function(){debug("Stream connected "+this.address+" id "+this.connection_id),this.connected=!0,this.ready=!1,this.emitted_end=!1,this.stream.setKeepAlive(this.options.socket_keepalive,this.options.socket_initial_delay),this.stream.setTimeout(0),this.emit("connect"),this.initialize_retry_vars(),this.options.no_ready_check?this.on_ready():this.ready_check()},RedisClient.prototype.on_ready=function(){var e=this;debug("on_ready called "+this.address+" id "+this.connection_id),this.ready=!0,this.cork=function(){e.pipeline=!0,e.stream.cork&&e.stream.cork()},this.uncork=function(){e.fire_strings?e.write_strings():e.write_buffers(),e.pipeline=!1,e.fire_strings=!0,e.stream.uncork&&e.stream.uncork()},void 0!==this.selected_db&&this.internal_send_command(new Command("select",[this.selected_db])),this.monitoring&&this.internal_send_command(new Command("monitor",[]));var t=Object.keys(this.subscription_set).length;if(this.options.disable_resubscribing||!t)this.send_offline_queue(),this.emit("ready");else{var r,i=function(){0===--t&&e.emit("ready")};for(r in debug("Sending pub/sub on_ready commands"),this.subscription_set){var s=r.slice(0,r.indexOf("_")),n=this.subscription_set[r];this[s]([n],i)}this.send_offline_queue()}},RedisClient.prototype.on_info_cmd=function(e,t){if(e)return"ERR unknown command 'info'"===e.message?void this.on_ready():(e.message="Ready check failed: "+e.message,void this.emit("error",e));if(!t)return debug("The info command returned without any data."),void this.on_ready();if(!this.server_info.loading||"0"===this.server_info.loading){if(!this.server_info.master_link_status||"up"===this.server_info.master_link_status)return debug("Redis server ready."),void this.on_ready();this.server_info.loading_eta_seconds=.05}t=1e3*+this.server_info.loading_eta_seconds;debug("Redis server still loading, trying again in "+(t=1e3<t?1e3:t)),setTimeout(function(e){e.ready_check()},t,this)},RedisClient.prototype.ready_check=function(){var r=this;debug("Checking server ready state..."),this.ready=!0,this.info(function(e,t){r.on_info_cmd(e,t)}),this.ready=!1},RedisClient.prototype.send_offline_queue=function(){for(var e=this.offline_queue.shift();e;e=this.offline_queue.shift())debug("Sending offline command: "+e.command),this.internal_send_command(e);this.drain()};var retry_connection=function(e,t){debug("Retrying connection...");t={delay:e.retry_delay,attempt:e.attempts,error:t};e.options.camel_case?(t.totalRetryTime=e.retry_totaltime,t.timesConnected=e.times_connected):(t.total_retry_time=e.retry_totaltime,t.times_connected=e.times_connected),e.emit("reconnecting",t),e.retry_totaltime+=e.retry_delay,e.attempts+=1,e.retry_delay=Math.round(e.retry_delay*e.retry_backoff),e.create_stream(),e.retry_timer=null};function normal_reply(e,t){var r=e.command_queue.shift();"function"==typeof r.callback?("exec"!==r.command&&(t=e.handle_reply(t,r.command,r.buffer_args)),r.callback(null,t)):debug("No callback for reply")}function subscribe_unsubscribe(e,t,r){var i=e.command_queue.get(0),s=e.options.return_buffers||e.options.detect_buffers&&i.buffer_args||null===t[1]?t[1]:t[1].toString(),t=+t[2];if(debug(r,s),null!==s&&(e.emit(r,s,t),"subscribe"===r||"psubscribe"===r?e.subscription_set[r+"_"+s]=s:delete e.subscription_set[(r="unsubscribe"===r?"subscribe":"psubscribe")+"_"+s]),1===i.args.length||1===e.sub_commands_left||0===i.args.length&&(0==t||null===s)){if(0==t){var n,o=1;for(e.pub_sub_mode=0;n=e.command_queue.get(o);){if(SUBSCRIBE_COMMANDS[n.command]){e.pub_sub_mode=o;break}o++}}e.command_queue.shift(),"function"==typeof i.callback&&i.callback(null,s),e.sub_commands_left=0}else 0!==e.sub_commands_left?e.sub_commands_left--:e.sub_commands_left=i.args.length?i.args.length-1:t}function return_pub_sub(e,t){var r=t[0].toString();"message"===r?!e.options.return_buffers||e.message_buffers?(e.emit("message",t[1].toString(),t[2].toString()),e.emit("message_buffer",t[1],t[2]),e.emit("messageBuffer",t[1],t[2])):e.emit("message",t[1],t[2]):"pmessage"===r?!e.options.return_buffers||e.message_buffers?(e.emit("pmessage",t[1].toString(),t[2].toString(),t[3].toString()),e.emit("pmessage_buffer",t[1],t[2],t[3]),e.emit("pmessageBuffer",t[1],t[2],t[3])):e.emit("pmessage",t[1],t[2],t[3]):subscribe_unsubscribe(e,t,r)}function handle_offline_command(e,t){var r,i=t.command;e.closing||!e.enable_offline_queue?(i=i.toUpperCase(),r=e.closing?"The connection is already closed.":e.stream.writable?"The connection is not yet established and the offline queue is deactivated.":"Stream not writeable.",r=new errorClasses.AbortError({message:i+" can't be processed. "+r,code:"NR_CLOSED",command:i}),t.args.length&&(r.args=t.args),utils.reply_in_order(e,t.callback,r)):(debug("Queueing "+i+" for next server connection."),e.offline_queue.push(t)),e.should_buffer=!0}RedisClient.prototype.connection_gone=function(e,t){if(!this.retry_timer){if(t=t||null,debug("Redis connection is gone from "+e+" event."),this.connected=!1,this.ready=!1,this.cork=noop,this.uncork=noop,this.pipeline=!1,this.pub_sub_mode=0,this.emitted_end||(this.emit("end"),this.emitted_end=!0),this.closing)return debug("Connection ended by quit / end command, not retrying."),void this.flush_and_error({message:"Stream connection ended and command aborted.",code:"NR_CLOSED"},{error:t});if("function"==typeof this.options.retry_strategy){e={attempt:this.attempts,error:t};if(this.options.camel_case?(e.totalRetryTime=this.retry_totaltime,e.timesConnected=this.times_connected):(e.total_retry_time=this.retry_totaltime,e.times_connected=this.times_connected),this.retry_delay=this.options.retry_strategy(e),"number"!=typeof this.retry_delay){this.retry_delay instanceof Error&&(t=this.retry_delay);var r="Redis connection in broken state: retry aborted.";this.flush_and_error({message:r,code:"CONNECTION_BROKEN"},{error:t});r=new Error(r);return r.code="CONNECTION_BROKEN",t&&(r.origin=t),this.end(!1),void this.emit("error",r)}}if(this.retry_totaltime>=this.connect_timeout){r="Redis connection in broken state: connection timeout exceeded.";this.flush_and_error({message:r,code:"CONNECTION_BROKEN"},{error:t});r=new Error(r);return r.code="CONNECTION_BROKEN",t&&(r.origin=t),this.end(!1),void this.emit("error",r)}this.options.retry_unfulfilled_commands?(this.offline_queue.unshift.apply(this.offline_queue,this.command_queue.toArray()),this.command_queue.clear()):0!==this.command_queue.length&&this.flush_and_error({message:"Redis connection lost and command aborted.",code:"UNCERTAIN_STATE"},{error:t,queues:["command_queue"]}),this.retry_totaltime+this.retry_delay>this.connect_timeout&&(this.retry_delay=this.connect_timeout-this.retry_totaltime),debug("Retry connection in "+this.retry_delay+" ms"),this.retry_timer=setTimeout(retry_connection,this.retry_delay,this,t)}},RedisClient.prototype.return_error=function(e){var t=this.command_queue.shift();t.error&&(e.stack=t.error.stack.replace(/^Error.*?\n/,"ReplyError: "+e.message+"\n")),e.command=t.command.toUpperCase(),t.args&&t.args.length&&(e.args=t.args),1<this.pub_sub_mode&&this.pub_sub_mode--;var r=e.message.match(utils.err_code);r&&(e.code=r[1]),utils.callback_or_emit(this,t.callback,e)},RedisClient.prototype.drain=function(){this.should_buffer=!1},RedisClient.prototype.return_reply=function(e){if(this.monitoring){var t=this.buffers&&Buffer.isBuffer(e)?e.toString():e;if("string"==typeof t&&utils.monitor_regex.test(t)){var r=t.slice(0,t.indexOf(" ")),i=t.slice(t.indexOf('"')+1,-1).split('" "').map(function(e){return e.replace(/\\"/g,'"')});return void this.emit("monitor",r,i,t)}}0===this.pub_sub_mode?normal_reply(this,e):1!==this.pub_sub_mode?(this.pub_sub_mode--,normal_reply(this,e)):(!(e instanceof Array)||e.length<=2?normal_reply:return_pub_sub)(this,e)},RedisClient.prototype.internal_send_command=function(e){var t,r,i=0,s="",n=e.args,o=e.command,a=n.length,u=!1,c=new Array(a);if(process.domain&&e.callback&&(e.callback=process.domain.bind(e.callback)),!1===this.ready||!1===this.stream.writable)return handle_offline_command(this,e),!1;for(i=0;i<a;i+=1)if("string"==typeof n[i])3e4<n[i].length?(u=!0,c[i]=Buffer.from(n[i],"utf8")):c[i]=n[i];else if("object"==typeof n[i])if(n[i]instanceof Date)c[i]=n[i].toString();else{if(!Buffer.isBuffer(n[i])){var d=new Error("node_redis: The "+o.toUpperCase()+" command contains a invalid argument type.\nOnly strings, dates and buffers are accepted. Please update your code to use valid argument types.");if(d.command=e.command.toUpperCase(),e.args&&e.args.length&&(d.args=e.args),e.callback)return e.callback(d),!1;throw d}c[i]=n[i],u=e.buffer_args=!0}else{if(void 0===n[i]){d=new Error("node_redis: The "+o.toUpperCase()+' command contains a invalid argument type of "undefined".\nOnly strings, dates and buffers are accepted. Please update your code to use valid argument types.');return d.command=e.command.toUpperCase(),e.args&&e.args.length&&(d.args=e.args),e.callback(d),!1}c[i]=""+n[i]}if(this.options.prefix)for(i=(r=commands.getKeyIndexes(o,c)).pop();void 0!==i;i=r.pop())c[i]=this.options.prefix+c[i];if(s="*"+(a+1)+"\r\n$"+(o=this.options.rename_commands&&this.options.rename_commands[o]?this.options.rename_commands[o]:o).length+"\r\n"+o+"\r\n",!1===u){for(i=0;i<a;i+=1)t=c[i],s+="$"+Buffer.byteLength(t)+"\r\n"+t+"\r\n";debug("Send "+this.address+" id "+this.connection_id+": "+s),this.write(s)}else for(debug("Send command ("+s+") has Buffer arguments"),this.fire_strings=!1,this.write(s),i=0;i<a;i+=1)"string"==typeof(t=c[i])?this.write("$"+Buffer.byteLength(t)+"\r\n"+t+"\r\n"):(this.write("$"+t.length+"\r\n"),this.write(t),this.write("\r\n")),debug("send_command: buffer send "+t.length+" bytes");return e.call_on_write&&e.call_on_write(),"ON"===this.reply?this.command_queue.push(e):(e.callback&&utils.reply_in_order(this,e.callback,null,void 0,this.command_queue),"SKIP"===this.reply?this.reply="SKIP_ONE_MORE":"SKIP_ONE_MORE"===this.reply&&(this.reply="ON")),!this.should_buffer},RedisClient.prototype.write_strings=function(){for(var e="",t=this.pipeline_queue.shift();t;t=this.pipeline_queue.shift())4194304<e.length+t.length&&(this.should_buffer=!this.stream.write(e),e=""),e+=t;""!==e&&(this.should_buffer=!this.stream.write(e))},RedisClient.prototype.write_buffers=function(){for(var e=this.pipeline_queue.shift();e;e=this.pipeline_queue.shift())this.should_buffer=!this.stream.write(e)},RedisClient.prototype.write=function(e){!1!==this.pipeline?this.pipeline_queue.push(e):this.should_buffer=!this.stream.write(e)},Object.defineProperty(exports,"debugMode",{get:function(){return this.debug_mode},set:function(e){this.debug_mode=e}}),Object.defineProperty(RedisClient.prototype,"command_queue_length",{get:function(){return this.command_queue.length}}),Object.defineProperty(RedisClient.prototype,"offline_queue_length",{get:function(){return this.offline_queue.length}}),Object.defineProperty(RedisClient.prototype,"retryDelay",{get:function(){return this.retry_delay}}),Object.defineProperty(RedisClient.prototype,"retryBackoff",{get:function(){return this.retry_backoff}}),Object.defineProperty(RedisClient.prototype,"commandQueueLength",{get:function(){return this.command_queue.length}}),Object.defineProperty(RedisClient.prototype,"offlineQueueLength",{get:function(){return this.offline_queue.length}}),Object.defineProperty(RedisClient.prototype,"shouldBuffer",{get:function(){return this.should_buffer}}),Object.defineProperty(RedisClient.prototype,"connectionId",{get:function(){return this.connection_id}}),Object.defineProperty(RedisClient.prototype,"serverInfo",{get:function(){return this.server_info}}),exports.createClient=function(){return new RedisClient(unifyOptions.apply(null,arguments))},exports.RedisClient=RedisClient,exports.print=utils.print,exports.Multi=require("./lib/multi"),exports.AbortError=errorClasses.AbortError,exports.RedisError=RedisErrors.RedisError,exports.ParserError=RedisErrors.ParserError,exports.ReplyError=RedisErrors.ReplyError,exports.AggregateError=errorClasses.AggregateError,require("./lib/individualCommands"),require("./lib/extendedApi"),exports.addCommand=exports.add_command=require("./lib/commands");