"use strict";const Buffer=require("buffer").Buffer,StringDecoder=require("string_decoder").StringDecoder,decoder=new StringDecoder,errors=require("redis-errors"),ReplyError=errors.ReplyError,ParserError=errors.ParserError;var bufferPool=Buffer.allocUnsafe(32768),bufferOffset=0,interval=null,counter=0,notDecreased=0;function parseSimpleNumbers(r){var e=r.buffer.length-1,t=r.offset,f=0,n=1;for(45===r.buffer[t]&&(n=-1,t++);t<e;){var s=r.buffer[t++];if(13===s)return r.offset=t+1,n*f;f=10*f+(s-48)}}function parseStringNumbers(r){var e=r.buffer.length-1,t=r.offset,f=0,n="";for(45===r.buffer[t]&&(n+="-",t++);t<e;){var s=r.buffer[t++];if(13===s)return r.offset=t+1,0!==f&&(n+=f),n;429496728<f?(n+=10*f+(s-48),f=0):48===s&&0===f?n+=0:f=10*f+(s-48)}}function parseSimpleString(r){for(var e=r.offset,t=r.buffer,f=t.length-1,n=e;n<f;)if(13===t[n++])return r.offset=n+1,!0===r.optionReturnBuffers?r.buffer.slice(e,n-1):r.buffer.toString("utf8",e,n-1)}function parseLength(r){for(var e=r.buffer.length-1,t=r.offset,f=0;t<e;){var n=r.buffer[t++];if(13===n)return r.offset=t+1,f;f=10*f+(n-48)}}function parseInteger(r){return(!0===r.optionStringNumbers?parseStringNumbers:parseSimpleNumbers)(r)}function parseBulkString(r){var e=parseLength(r);if(void 0!==e){if(e<0)return null;var t=r.offset+e;if(t+2>r.buffer.length)return r.bigStrSize=t+2,r.totalChunkSize=r.buffer.length,void r.bufferCache.push(r.buffer);e=r.offset;return r.offset=t+2,!0===r.optionReturnBuffers?r.buffer.slice(e,t):r.buffer.toString("utf8",e,t)}}function parseError(r){var e=parseSimpleString(r);if(void 0!==e)return!0===r.optionReturnBuffers&&(e=e.toString()),new ReplyError(e)}function handleError(r,e){e=new ParserError("Protocol error, got "+JSON.stringify(String.fromCharCode(e))+" as reply type byte",JSON.stringify(r.buffer),r.offset);r.buffer=null,r.returnFatalError(e)}function parseArray(r){var e=parseLength(r);if(void 0!==e)return e<0?null:parseArrayElements(r,new Array(e),0)}function pushArrayCache(r,e,t){r.arrayCache.push(e),r.arrayPos.push(t)}function parseArrayChunks(r){const e=r.arrayCache.pop();var t=r.arrayPos.pop();if(r.arrayCache.length){var f=parseArrayChunks(r);if(void 0===f)return void pushArrayCache(r,e,t);e[t++]=f}return parseArrayElements(r,e,t)}function parseArrayElements(r,e,t){for(var f=r.buffer.length;t<e.length;){var n=r.offset;if(r.offset>=f)return void pushArrayCache(r,e,t);var s=parseType(r,r.buffer[r.offset++]);if(void 0===s)return r.arrayCache.length||r.bufferCache.length||(r.offset=n),void pushArrayCache(r,e,t);e[t]=s,t++}return e}function parseType(r,e){switch(e){case 36:return parseBulkString(r);case 43:return parseSimpleString(r);case 42:return parseArray(r);case 58:return parseInteger(r);case 45:return parseError(r);default:return handleError(r,e)}}function decreaseBufferPool(){var r;51200<bufferPool.length?1===counter||2*counter<notDecreased?(r=(r=Math.floor(bufferPool.length/10))<bufferOffset?bufferOffset:r,bufferOffset=0,bufferPool=bufferPool.slice(r,bufferPool.length)):(notDecreased++,counter--):(clearInterval(interval),notDecreased=counter=0,interval=null)}function resizeBuffer(r){var e;bufferPool.length<r+bufferOffset&&(e=78643200<r?2:3,116391936<bufferOffset&&(bufferOffset=52428800),bufferPool=Buffer.allocUnsafe(r*e+bufferOffset),bufferOffset=0,counter++,null===interval&&(interval=setInterval(decreaseBufferPool,50)))}function concatBulkString(r){const e=r.bufferCache;var t=r.offset,f=e.length,n=r.bigStrSize-r.totalChunkSize;if((r.offset=n)<=2){if(2===f)return e[0].toString("utf8",t,e[0].length+n-2);f--,n=e[e.length-2].length+n}for(var s=decoder.write(e[0].slice(t)),o=1;o<f-1;o++)s+=decoder.write(e[o]);return s+=decoder.end(e[o].slice(0,n-2))}function concatBulkBuffer(r){const e=r.bufferCache;var t=r.offset,f=r.bigStrSize-t-2,n=e.length,s=r.bigStrSize-r.totalChunkSize;if((r.offset=s)<=2){if(2===n)return e[0].slice(t,e[0].length+s-2);n--,s=e[e.length-2].length+s}resizeBuffer(f);f=bufferOffset;e[0].copy(bufferPool,f,t,e[0].length),bufferOffset+=e[0].length-t;for(var o=1;o<n-1;o++)e[o].copy(bufferPool,bufferOffset),bufferOffset+=e[o].length;return e[o].copy(bufferPool,bufferOffset,0,s-2),bufferOffset+=s-2,bufferPool.slice(f,bufferOffset)}class JavascriptRedisParser{constructor(r){if(!r)throw new TypeError("Options are mandatory.");if("function"!=typeof r.returnError||"function"!=typeof r.returnReply)throw new TypeError("The returnReply and returnError options have to be functions.");this.setReturnBuffers(!!r.returnBuffers),this.setStringNumbers(!!r.stringNumbers),this.returnError=r.returnError,this.returnFatalError=r.returnFatalError||r.returnError,this.returnReply=r.returnReply,this.reset()}reset(){this.offset=0,this.buffer=null,this.bigStrSize=0,this.totalChunkSize=0,this.bufferCache=[],this.arrayCache=[],this.arrayPos=[]}setReturnBuffers(r){if("boolean"!=typeof r)throw new TypeError("The returnBuffers argument has to be a boolean");this.optionReturnBuffers=r}setStringNumbers(r){if("boolean"!=typeof r)throw new TypeError("The stringNumbers argument has to be a boolean");this.optionStringNumbers=r}execute(r){if(null===this.buffer)this.buffer=r,this.offset=0;else if(0===this.bigStrSize){var e=this.buffer.length,t=e-this.offset,f=Buffer.allocUnsafe(t+r.length);if(this.buffer.copy(f,0,this.offset,e),r.copy(f,t,0,r.length),this.buffer=f,this.offset=0,this.arrayCache.length){var n=parseArrayChunks(this);if(void 0===n)return;this.returnReply(n)}}else{if(!(this.totalChunkSize+r.length>=this.bigStrSize))return this.bufferCache.push(r),void(this.totalChunkSize+=r.length);this.bufferCache.push(r);n=(this.optionReturnBuffers?concatBulkBuffer:concatBulkString)(this);if(this.bigStrSize=0,this.bufferCache=[],this.buffer=r,this.arrayCache.length&&(this.arrayCache[0][this.arrayPos[0]++]=n,void 0===(n=parseArrayChunks(this))))return;this.returnReply(n)}for(;this.offset<this.buffer.length;){var s=this.offset,o=this.buffer[this.offset++],u=parseType(this,o);if(void 0===u)return void(this.arrayCache.length||this.bufferCache.length||(this.offset=s));45===o?this.returnError(u):this.returnReply(u)}this.buffer=null}}module.exports=JavascriptRedisParser;