Install with:
`npm install @cambium/cns-redis`

# Note

Please make sure config, CONST is defined on top of the file before calling `require('@cambium/cns-redis')` method.

# Usage Example

```javascript
const RedisModule = require('@cambium/cns-redis');

class WrapperClass {
  constructor(options) {
    options.db = (options && options.db) || 'common';
    this.redisConn = RedisModule.getInstance(options);
  }

  /* you custom functions logic */

  setWithExpire(key, val, expire, cb) {
    db = this.redisConn.getDB();
    if (!db) {
      cb(null, null);
      return;
    }
    db.setnx(key, expireInSec, value, cb);
  }
}

const commonCache = new WrapperClass({ db: 'common', redis: config.redis });

commonCache.get(key, () => {});
```

# Redis Connection options

```JSON

options : {
    "db": "common",
    "redis": {
        "host": "redis" ,
        "port": 6379,
        "db": {
            "common": 4,
            "api": 5,
            "metrics": 6,
            "inventory": 7,
            "notify": 8,
            "urls": 5,
            "device": 9,
            "subscription": 10,
            "mon8zn": 11
        }
    }
}

```
