// Generated by dts-bundle-generator v5.6.0

/// <reference types="node" />

declare enum ScriptResponse {
	REJECT = 0,
	ALLOW = 1,
	NODATA = -1
}
/**
 * @description defines Rate as count per every unit
 */
export interface IRate {
	second: number;
	count: number;
}
export interface IRateLimitScriptResponse {
	result: ScriptResponse;
	limit: number;
	remaining: number;
	reset: number;
}
export interface IMaxWeight {
	[key: string]: number;
}
export interface IRateLimiterConfig {
	enabled: boolean;
	weightSystemEnabled: boolean;
	totalWeight?: number;
	fixedShareInPercent?: number;
	sharedWeightEnabled: boolean;
	sharedRateLimiterIds?: Array<string>;
	sharingPriority: number;
	shareInPercent: number;
	getWeight?: number;
	postWeight?: number;
	deleteWeight?: number;
	putWeight?: number;
	patchWeight?: number;
	limitReachedHttpCode?: number;
	limitReachedResData?: any;
	serviceFailureHttpResCode?: number;
	serviceFailureResData?: any;
	weightReachedHttpResCode?: number;
	weightReachedHttpResData?: any;
	retryAfterHeaderValueInSec?: number;
	logger?: any;
}
export interface IRateLimitConditions {
	rate?: any;
	defaultRate?: any;
	http_headers?: Array<string>;
	http_method?: boolean;
	weight?: number;
}
export interface IRulesOptions {
	rateEnabled?: boolean;
	weightEnabled?: boolean;
}
/**
 * @description A Component with rlId has "shareInPercent" percent share with "priority"
 * on total value stored on maxSharedWtHKey under maxSharedWtKey. demandKey is used to create
 * a priority list used at runtime
 */
export interface ISharedCounterParam {
	maxSharedWtKey: string;
	maxSharedWtHKey: string;
	shareInPercent: number;
	demandKey: string;
	priority: number;
	rlId?: string;
}
declare class Rules {
	private rl;
	private keyFn;
	private conditions;
	private calculatedRates?;
	private calculateRate?;
	private defaultRate?;
	private opts;
	static RATE_LIMIT_SCRIPT: string;
	constructor(rateLimiter: RateLimiter, keyFn: Function, opts: IRulesOptions);
	/**
	 * @description Update one or more conditions in rules
	 * @param {IRateLimitConditions} conditions
	 */
	updateConditions(conditions: IRateLimitConditions): void;
	_reloadRates(): void;
	apply(conditions?: IRateLimitConditions): (req: any, res: any, next: Function) => any;
	private get logger();
	_sendWeightLimitHttpResponse(response: ScriptResponse, res: any, next: Function): Promise<void>;
	_sendRateLimitHttpResponse(scriptResponse: IRateLimitScriptResponse, res: any, next: Function): Promise<void>;
	_validateRate(key: string, maxHit: number, expiry: number): Promise<IRateLimitScriptResponse>;
	_randomJitterInSec(from?: number, to?: number): number;
	_generateRateLimitKey(req: any, rulesKey: string): string;
	_generateWeightKey(rulesKey: string): string;
	_applyWeight(weightKey: string, rulesKey: string, req: any, res: any): Promise<ScriptResponse>;
}
declare const EventEmitter: any;
export declare class RateLimiter extends EventEmitter {
	db: any;
	id: string;
	private _config;
	private _weightCounter;
	/**
	 * @description Create a new instance of RateLimiter
	 * @param {String} id define unique id or a rate limit group id
	 * @param {any} db Redis Client
	 * @param {IRateLimiterConfig} config
	 */
	constructor(id: string, db: any, config: IRateLimiterConfig);
	get enabled(): boolean;
	get limitReachedHttpResCode(): number;
	get limitReachedResData(): object;
	get serviceFailureHttpResCode(): number;
	get serviceFailureResData(): object;
	get weightReachedHttpResCode(): number;
	get weightReachedHttpResData(): object;
	get retryAfterHeaderValueInSec(): number;
	get isWeightSystemEnabled(): boolean;
	rateOn(keyFn?: Function): Rules;
	weightOn(keyFn: Function): Rules;
	rateAndWeightOn(keyFn: Function): Rules;
	/**
	 * @description You can define key based Max weight
	 * @param maxWeights
	 * @example defineKeyBasedMaxWeight({ cid1: 3, cid2:5, totalWeight: 8});
	 * @public
	 */
	defineKeyBasedMaxWeight(maxWeights: IMaxWeight): Promise<void>;
	/**
	 * @description You can define key based shared max weight per key
	 * @param maxWeights
	 * @example defineKeyBasedMaxWeight({ cid1: 3, cid2:5, totalWeight: 8}); where max=> Max shared available
	 * @public
	 */
	defineKeyBasedMaxSharedWeight(maxWeights: IMaxWeight): Promise<void>;
	/**
	 * @description Update the rateLimiter config at realtime
	 * @param maxWeights
	 * @public
	 */
	updateConfig(config: IRateLimiterConfig): Promise<void>;
	/**
	 * @description Get key of key wise custom max weight value
	 * @param key key of a rules as return value of keyFn() in Rules class
	 * @internal
	 */
	get maxWeightHKey(): string;
	/**
	 * @description
	 * @param value
	 * @internal
	 */
	_addWeight(value: number, weightKey: string, rulesKey: string): Promise<ScriptResponse>;
	/**
	 * @description
	 * @param value
	 * @internal
	 */
	_removeWeight(value: number, weightKey: string, rulesKey: string): Promise<ScriptResponse>;
	/**
	 *
	 * @param method
	 * @internal
	 */
	_getHttpMethodWeight(method: string): number;
	get logger(): any;
	static parseRate(rate: string): IRate;
}
export declare class BasicRateLimiter extends RateLimiter {
	private _rate;
	private _defaultRate;
	private _rlFn;
	/**
	 * @description Create a new instance of BasicRateLimiter
	 * @param {String} id define unique id or a rate limit group id
	 * @param {any} db Redis Client
	 * @param {any} logger
	 * @param {any} rate // 1/3m ==> 1 per 2 minutes OR {"customerId1":"10/m","customerId2":"10/m"}
	 * @param {any} defaultRate // defaultRate is used when there is a cache-miss in rate as dictionary
	 * @param {IRateLimiterConfig} config
	 */
	constructor(id: any, db: any, logger: any, rate: any, defaultRate: any);
	/**
	 * @name getRate
	 * @returns rate
	 */
	getRate(): any;
	/**
	 * @name setRate
	 * @description creates a new rl instance with the updated rate value
	 *
	 * @param {String} _rate new rate value
	 */
	setRate(_rate: any): void;
	/**
	 * @name isAllowed
	 * @description applies rate limit and returns true/false indicating the rate is achieved or not
	 *
	 * @param {String} key - key string to apply the rate limit
	 *
	 * @returns {Promise<Boolean>}
	 */
	isAllowed(key: any): Promise<unknown>;
}
export declare class Counter {
	static SCRIPT_ADD: string;
	static SCRIPT_SUBTRACT: string;
	db: any;
	maxValueKey: string;
	currentValueKey: string;
	/**
	 * @description Redis Counter
	 * @param db Redis Client
	 * @param maxValueKey Max value of the counter
	 * @param currentValueKey
	 */
	constructor(db: any, maxValueKey: string, currentValueKey: string);
	/**
	 * @description set max value of the counter
	 * @param value Max value of the counter
	 */
	setMaxValue(value: number, maxValueKey?: string): Promise<unknown>;
	/**
	 * @description Add value to Counter
	 * @param value value to add to counter
	 * @param currentValueKey custom currentValueKey
	 * @param maxValueKey custom maxValueKey
	 * @param maxValueHKey custom maxValueHKey
	 * @param fixedShareInPercent parentage in fixed value in case of sharing else 100%
	 * @param sharedCounterParam
	 * @returns Promise<ScriptResponse> returns ScriptResponse.ALLOW if successful to do
	 * increment and final result is less than equal to max else returns ScriptResponse.REJECT
	 */
	add(value: number, currentValueKey?: string, maxValueKey?: string, maxValueHKey?: string, fixedShareInPercent?: number, sharedCounterParam?: ISharedCounterParam): Promise<ScriptResponse>;
	/**
	 * @description Subtract value from Counter. Counter is always reset to 0 if value goes negative
	 * @param value value to subtract from counter
	 * @param currentValueKey custom currentValueKey
	 * @param maxValueKey custom maxValueKey
	 * @param maxValueHKey custom maxValueHKey
	 * @param fixedShareInPercent parentage in fixed value in case of sharing else 100%
	 * @param sharedCounterParam
	 * @returns Promise<ScriptResponse> returns ScriptResponse.ALLOW if max value is set else return ScriptResponse.REJECT
	 */
	subtract(value: number, currentValueKey?: string, maxValueKey?: string, maxValueHKey?: string, fixedShareInPercent?: number, sharedCounterParam?: ISharedCounterParam): Promise<ScriptResponse>;
	/**
	 * @description invalidate the instance
	 */
	invalidate(): void;
}

export {};
