/******************************************************************************
 **<copyright file='rules.ts'>
 ** Copyright (C) 2016 Cambium Networks, LTD. All rights reserved.
 ** </copyright>
 ** <summary>
 ** Rule is construct of some conditions to be applied on a resource detected using custom key
 ** </summary>
 *******************************************************************************/
import { RateLimiter } from './rateLimiter';
import { IRateLimitScriptResponse, IRateLimitConditions, IRulesOptions } from '../common/interfaces';
import { ScriptResponse } from '../common/enums';
/**
 * @description Rule is construct of some conditions to be applied on a resource detected using custom key
 */
export default class Rules {
    private rl;
    private keyFn;
    private conditions;
    private calculatedRates?;
    private calculateRate?;
    private defaultRate?;
    private opts;
    static RATE_LIMIT_SCRIPT: string;
    constructor(rateLimiter: RateLimiter, keyFn: Function, opts: IRulesOptions);
    /**
     * @description Update one or more conditions in rules
     * @param {IRateLimitConditions} conditions
     */
    updateConditions(conditions: IRateLimitConditions): void;
    _reloadRates(): void;
    apply(conditions?: IRateLimitConditions): (req: any, res: any, next: Function) => any;
    private get logger();
    _sendWeightLimitHttpResponse(response: ScriptResponse, res: any, next: Function): Promise<void>;
    _sendRateLimitHttpResponse(scriptResponse: IRateLimitScriptResponse, res: any, next: Function): Promise<void>;
    _validateRate(key: string, maxHit: number, expiry: number): Promise<IRateLimitScriptResponse>;
    _randomJitterInSec(from?: number, to?: number): number;
    _generateRateLimitKey(req: any, rulesKey: string): string;
    _generateWeightKey(rulesKey: string): string;
    _applyWeight(weightKey: string, rulesKey: string, req: any, res: any): Promise<ScriptResponse>;
}
