/******************************************************************************
 **<copyright file='rateLimiter.ts'>
 ** Copyright (C) 2016 Cambium Networks, LTD. All rights reserved.
 ** </copyright>
 ** <summary>
 ** RateLimiter class can limit the incoming or outgoing traffic based on the rules applied.
 ** Follow readme.md to know more about the available apis
 ** </summary>
 *******************************************************************************/
declare const EventEmitter: any;
import Rules from './rules';
import { ScriptResponse } from '../common/enums';
import { IMaxWeight, IRate, IRateLimiterConfig } from '../common/interfaces';
export declare class RateLimiter extends EventEmitter {
    db: any;
    id: string;
    private _config;
    private _weightCounter;
    /**
     * @description Create a new instance of RateLimiter
     * @param {String} id define unique id or a rate limit group id
     * @param {any} db Redis Client
     * @param {IRateLimiterConfig} config
     */
    constructor(id: string, db: any, config: IRateLimiterConfig);
    get enabled(): boolean;
    get limitReachedHttpResCode(): number;
    get limitReachedResData(): object;
    get serviceFailureHttpResCode(): number;
    get serviceFailureResData(): object;
    get weightReachedHttpResCode(): number;
    get weightReachedHttpResData(): object;
    get retryAfterHeaderValueInSec(): number;
    get isWeightSystemEnabled(): boolean;
    rateOn(keyFn?: Function): Rules;
    weightOn(keyFn: Function): Rules;
    rateAndWeightOn(keyFn: Function): Rules;
    /**
     * @description You can define key based Max weight
     * @param maxWeights
     * @example defineKeyBasedMaxWeight({ cid1: 3, cid2:5, totalWeight: 8});
     * @public
     */
    defineKeyBasedMaxWeight(maxWeights: IMaxWeight): Promise<void>;
    /**
     * @description You can define key based shared max weight per key
     * @param maxWeights
     * @example defineKeyBasedMaxWeight({ cid1: 3, cid2:5, totalWeight: 8}); where max=> Max shared available
     * @public
     */
    defineKeyBasedMaxSharedWeight(maxWeights: IMaxWeight): Promise<void>;
    /**
     * @description Update the rateLimiter config at realtime
     * @param maxWeights
     * @public
     */
    updateConfig(config: IRateLimiterConfig): Promise<void>;
    /**
     * @description Get key of key wise custom max weight value
     * @param key key of a rules as return value of keyFn() in Rules class
     * @internal
     */
    get maxWeightHKey(): string;
    /**
     * @description
     * @param value
     * @internal
     */
    _addWeight(value: number, weightKey: string, rulesKey: string): Promise<ScriptResponse>;
    /**
     * @description
     * @param value
     * @internal
     */
    _removeWeight(value: number, weightKey: string, rulesKey: string): Promise<ScriptResponse>;
    /**
     *
     * @param method
     * @internal
     */
    _getHttpMethodWeight(method: string): number;
    get logger(): any;
    static parseRate(rate: string): IRate;
}
export {};
