/******************************************************************************
 **<copyright file='counter.ts'>
 ** Copyright (C) 2016 Cambium Networks, LTD. All rights reserved.
 ** </copyright>
 ** <summary>
 ** Basic Counter implements add and subtract method
 ** </summary>
 *******************************************************************************/
import { ScriptResponse } from '../common/enums';
import { ISharedCounterParam } from '../common/interfaces';
export declare class Counter {
    static SCRIPT_ADD: string;
    static SCRIPT_SUBTRACT: string;
    db: any;
    maxValueKey: string;
    currentValueKey: string;
    /**
     * @description Redis Counter
     * @param db Redis Client
     * @param maxValueKey Max value of the counter
     * @param currentValueKey
     */
    constructor(db: any, maxValueKey: string, currentValueKey: string);
    /**
     * @description set max value of the counter
     * @param value Max value of the counter
     */
    setMaxValue(value: number, maxValueKey?: string): Promise<unknown>;
    /**
     * @description Add value to Counter
     * @param value value to add to counter
     * @param currentValueKey custom currentValueKey
     * @param maxValueKey custom maxValueKey
     * @param maxValueHKey custom maxValueHKey
     * @param fixedShareInPercent parentage in fixed value in case of sharing else 100%
     * @param sharedCounterParam
     * @returns Promise<ScriptResponse> returns ScriptResponse.ALLOW if successful to do
     * increment and final result is less than equal to max else returns ScriptResponse.REJECT
     */
    add(value: number, currentValueKey?: string, maxValueKey?: string, maxValueHKey?: string, fixedShareInPercent?: number, sharedCounterParam?: ISharedCounterParam): Promise<ScriptResponse>;
    /**
     * @description Subtract value from Counter. Counter is always reset to 0 if value goes negative
     * @param value value to subtract from counter
     * @param currentValueKey custom currentValueKey
     * @param maxValueKey custom maxValueKey
     * @param maxValueHKey custom maxValueHKey
     * @param fixedShareInPercent parentage in fixed value in case of sharing else 100%
     * @param sharedCounterParam
     * @returns Promise<ScriptResponse> returns ScriptResponse.ALLOW if max value is set else return ScriptResponse.REJECT
     */
    subtract(value: number, currentValueKey?: string, maxValueKey?: string, maxValueHKey?: string, fixedShareInPercent?: number, sharedCounterParam?: ISharedCounterParam): Promise<ScriptResponse>;
    /**
     * @description invalidate the instance
     */
    invalidate(): void;
}
