/******************************************************************************
 **<copyright file='basicRateLimiter.ts'>
 ** Copyright (C) 2021 Cambium Networks, LTD. All rights reserved.
 ** </copyright>
 ** <summary>
 ** BasicRateLimiter class is a wrapper of RateLimiter to support a simple rate based (ex: 1/3m) version
 ** This version doesn't have the complexity involved in weight based rate limit and percent based.
 ** It just exposes a single method isAllowed() method which can be used to know whether the rate limit is reached or not.
 ** Even though all the member functions of RateLimiter is still available, it is advised to not use them directly
 ** </summary>
 *******************************************************************************/
import { RateLimiter } from "./rateLimiter";
export declare class BasicRateLimiter extends RateLimiter {
    private _rate;
    private _defaultRate;
    private _rlFn;
    /**
     * @description Create a new instance of BasicRateLimiter
     * @param {String} id define unique id or a rate limit group id
     * @param {any} db Redis Client
     * @param {any} logger
     * @param {any} rate // 1/3m ==> 1 per 2 minutes OR {"customerId1":"10/m","customerId2":"10/m"}
     * @param {any} defaultRate // defaultRate is used when there is a cache-miss in rate as dictionary
     * @param {IRateLimiterConfig} config
     */
    constructor(id: any, db: any, logger: any, rate: any, defaultRate: any);
    /**
     * @name getRate
     * @returns rate
     */
    getRate(): any;
    /**
     * @name setRate
     * @description creates a new rl instance with the updated rate value
     *
     * @param {String} _rate new rate value
     */
    setRate(_rate: any): void;
    /**
     * @name isAllowed
     * @description applies rate limit and returns true/false indicating the rate is achieved or not
     *
     * @param {String} key - key string to apply the rate limit
     *
     * @returns {Promise<Boolean>}
     */
    isAllowed(key: any): Promise<unknown>;
}
