/******************************************************************************
 **<copyright file='interfaces.ts'>
 ** Copyright (C) 2016 Cambium Networks, LTD. All rights reserved.
 ** </copyright>
 ** <summary>
 ** Defines all the interfaces
 ** </summary>
 *******************************************************************************/
import { ScriptResponse } from './enums';
/**
 * @description defines Rate as count per every unit
 */
export interface IRate {
    second: number;
    count: number;
}
export interface IRateLimitScriptResponse {
    result: ScriptResponse;
    limit: number;
    remaining: number;
    reset: number;
}
export interface IMaxWeight {
    [key: string]: number;
}
export interface IRateLimiterConfig {
    enabled: boolean;
    weightSystemEnabled: boolean;
    totalWeight?: number;
    fixedShareInPercent?: number;
    sharedWeightEnabled: boolean;
    sharedRateLimiterIds?: Array<string>;
    sharingPriority: number;
    shareInPercent: number;
    getWeight?: number;
    postWeight?: number;
    deleteWeight?: number;
    putWeight?: number;
    patchWeight?: number;
    limitReachedHttpCode?: number;
    limitReachedResData?: any;
    serviceFailureHttpResCode?: number;
    serviceFailureResData?: any;
    weightReachedHttpResCode?: number;
    weightReachedHttpResData?: any;
    retryAfterHeaderValueInSec?: number;
    logger?: any;
}
export interface IRateLimitConditions {
    rate?: any;
    defaultRate?: any;
    http_headers?: Array<string>;
    http_method?: boolean;
    weight?: number;
}
export interface IRulesOptions {
    rateEnabled?: boolean;
    weightEnabled?: boolean;
}
/**
 * @description A Component with rlId has "shareInPercent" percent share with "priority"
 * on total value stored on maxSharedWtHKey under maxSharedWtKey. demandKey is used to create
 * a priority list used at runtime
 */
export interface ISharedCounterParam {
    maxSharedWtKey: string;
    maxSharedWtHKey: string;
    shareInPercent: number;
    demandKey: string;
    priority: number;
    rlId?: string;
}
