"use strict";const ReadPreference=require("./core").ReadPreference,parser=require("url"),f=require("util").format,Logger=require("./core").Logger,dns=require("dns"),ReadConcern=require("./read_concern"),qs=require("querystring"),MongoParseError=require("./core/error").MongoParseError;function matchesParentDomain(e,r){var n=/^.*?\./;let t=`.${e.replace(n,"")}`;n=`.${r.replace(n,"")}`;return!!t.endsWith(n)}function parseHandler(e,r,n){let t,o;try{t=parseConnectionString(e,r)}catch(e){o=e}return o?n(o,null):n(null,t)}function parseConnectionString(r,e){let n="",t="",o="",s="admin",a=parser.parse(r,!0);if((null==a.hostname||""===a.hostname)&&-1===r.indexOf(".sock"))throw new Error("No hostname or hostnames provided in connection string");if("0"===a.port)throw new Error("Invalid port (zero) with hostname");if(!isNaN(parseInt(a.port,10))&&65535<parseInt(a.port,10))throw new Error("Invalid port (larger than 65535) with hostname");if(a.path&&0<a.path.length&&"/"!==a.path[0]&&-1===r.indexOf(".sock"))throw new Error("Missing delimiting slash between hosts and options");if(a.query)for(var i in a.query){if(-1!==i.indexOf("::"))throw new Error("Double colon in host identifier");if(""===a.query[i])throw new Error("Query parameter "+i+" is an incomplete value pair")}if(a.auth){var c=a.auth.split(":");if(-1!==r.indexOf(a.auth)&&2<c.length)throw new Error("Username with password containing an unescaped colon");if(-1!==r.indexOf(a.auth)&&-1!==a.auth.indexOf("@"))throw new Error("Username containing an unescaped at-sign")}let l=r.split("?").shift();var p=l.split(",");let d=[];for(let r=0;r<p.length;r++){let e=p[r];-1!==e.indexOf("mongodb")?-1!==e.indexOf("@")?d.push(e.split("@").pop()):d.push(e.substr("mongodb://".length)):-1!==e.indexOf("/")?d.push(e.split("/").shift()):-1===e.indexOf("/")&&d.push(e.trim())}for(let r=0;r<d.length;r++){let e=parser.parse(f("mongodb://%s",d[r].trim()));if((!e.path||-1===e.path.indexOf(".sock"))&&(e.path&&-1!==e.path.indexOf(":")))throw 1<e.path.split("/").length&&-1===e.path.indexOf("::")?new Error("Slash in host identifier"):new Error("Double colon in host identifier")}if(n=-1!==r.indexOf("?")?(o=r.substr(r.indexOf("?")+1),r.substring("mongodb://".length,r.indexOf("?"))):r.substring("mongodb://".length),-1!==n.indexOf("@")&&(t=n.split("@")[0],n=n.split("@")[1]),2<n.split("/").length)throw new Error("Unsupported host '"+n.split("?")[0]+"', hosts must be URL encoded and contain at most one unencoded slash");if(-1!==n.indexOf(".sock")){if(-1!==n.indexOf(".sock/")){if(s=n.split(".sock/")[1],-1!==s.indexOf("/")){if(2===s.split("/").length&&0===s.split("/")[1].length)throw new Error("Illegal trailing backslash after database name");throw new Error("More than 1 database name in URL")}n=n.split("/",n.indexOf(".sock")+".sock".length)}}else if(-1!==n.indexOf("/")){if(2<n.split("/").length){if(0===n.split("/")[2].length)throw new Error("Illegal trailing backslash after database name");throw new Error("More than 1 database name in URL")}s=n.split("/")[1],n=n.split("/")[0]}n=decodeURIComponent(n);let u={},h=t||"",m=h.split(":",2);c=decodeURIComponent(m[0]);if(m[0]!==encodeURIComponent(c))throw new Error("Username contains an illegal unescaped character");if(m[0]=c,m[1]){c=decodeURIComponent(m[1]);if(m[1]!==encodeURIComponent(c))throw new Error("Password contains an illegal unescaped character");m[1]=c}2===m.length&&(u.auth={user:m[0],password:m[1]}),e&&null!=e.auth&&(u.auth=e.auth);let g,b,w,k,O={socketOptions:{}},E={read_preference_tags:[]},S={socketOptions:{}},I={socketOptions:{}};if(u.server_options=O,u.db_options=E,u.rs_options=S,u.mongos_options=I,r.match(/\.sock/)){let e=r.substring(r.indexOf("mongodb://")+"mongodb://".length,r.lastIndexOf(".sock")+".sock".length);-1!==e.indexOf("@")&&(e=e.split("@")[1]),e=decodeURIComponent(e),w=[{domain_socket:e}]}else{g=n;let o={};w=g.split(",").map(function(e){let r,n,t;return(t=/\[([^\]]+)\](?::(.+))?/.exec(e))?(r=t[1],n=parseInt(t[2],10)||27017):(e=e.split(":",2),r=e[0]||"localhost",n=null!=e[1]?parseInt(e[1],10):27017,-1!==r.indexOf("?")&&(r=r.split(/\?/)[0])),o[r+"_"+n]?null:(o[r+"_"+n]=1,{host:r,port:n})}).filter(function(e){return null!=e})}if(u.dbName=s||"admin",b=(o||"").split(/[&;]/),b.some(e=>"loadbalanced"===e.toLowerCase()))throw new MongoParseError("Load balancer mode requires driver version 4+");if(b.forEach(function(e){if(e){var e=e.split("="),r=e[0],t=e[1];switch(r){case"slaveOk":case"slave_ok":O.slave_ok="true"===t,E.slaveOk="true"===t;break;case"maxPoolSize":case"poolSize":O.poolSize=parseInt(t,10),S.poolSize=parseInt(t,10);break;case"appname":u.appname=decodeURIComponent(t);break;case"autoReconnect":case"auto_reconnect":O.auto_reconnect="true"===t;break;case"ssl":if("prefer"===t){O.ssl=t,S.ssl=t,I.ssl=t;break}O.ssl="true"===t,S.ssl="true"===t,I.ssl="true"===t;break;case"sslValidate":O.sslValidate="true"===t,S.sslValidate="true"===t,I.sslValidate="true"===t;break;case"replicaSet":case"rs_name":S.rs_name=t;break;case"reconnectWait":S.reconnectWait=parseInt(t,10);break;case"retries":S.retries=parseInt(t,10);break;case"readSecondary":case"read_secondary":S.read_secondary="true"===t;break;case"fsync":E.fsync="true"===t;break;case"journal":E.j="true"===t;break;case"safe":E.safe="true"===t;break;case"nativeParser":case"native_parser":E.native_parser="true"===t;break;case"readConcernLevel":E.readConcern=new ReadConcern(t);break;case"connectTimeoutMS":O.socketOptions.connectTimeoutMS=parseInt(t,10),S.socketOptions.connectTimeoutMS=parseInt(t,10),I.socketOptions.connectTimeoutMS=parseInt(t,10);break;case"socketTimeoutMS":O.socketOptions.socketTimeoutMS=parseInt(t,10),S.socketOptions.socketTimeoutMS=parseInt(t,10),I.socketOptions.socketTimeoutMS=parseInt(t,10);break;case"w":E.w=parseInt(t,10),isNaN(E.w)&&(E.w=t);break;case"authSource":E.authSource=t;break;case"gssapiServiceName":E.gssapiServiceName=t;break;case"authMechanism":if("GSSAPI"===t)if(null==u.auth){let e=decodeURIComponent(h);if(-1===e.indexOf("@"))throw new Error("GSSAPI requires a provided principal");u.auth={user:e,password:null}}else u.auth.user=decodeURIComponent(u.auth.user);else"MONGODB-X509"===t&&(u.auth={user:decodeURIComponent(h)});if("GSSAPI"!==t&&"MONGODB-X509"!==t&&"MONGODB-CR"!==t&&"DEFAULT"!==t&&"SCRAM-SHA-1"!==t&&"SCRAM-SHA-256"!==t&&"PLAIN"!==t)throw new Error("Only DEFAULT, GSSAPI, PLAIN, MONGODB-X509, or SCRAM-SHA-1 is supported by authMechanism");E.authMechanism=t;break;case"authMechanismProperties":{let e=t.split(","),r={};e.forEach(function(e){e=e.split(":");r[e[0]]=e[1]}),E.authMechanismProperties=r,"string"==typeof r.SERVICE_NAME&&(E.gssapiServiceName=r.SERVICE_NAME),"string"==typeof r.SERVICE_REALM&&(E.gssapiServiceRealm=r.SERVICE_REALM),"string"==typeof r.CANONICALIZE_HOST_NAME&&(E.gssapiCanonicalizeHostName="true"===r.CANONICALIZE_HOST_NAME)}break;case"wtimeoutMS":E.wtimeout=parseInt(t,10);break;case"readPreference":if(!ReadPreference.isValid(t))throw new Error("readPreference must be either primary/primaryPreferred/secondary/secondaryPreferred/nearest");E.readPreference=t;break;case"maxStalenessSeconds":E.maxStalenessSeconds=parseInt(t,10);break;case"readPreferenceTags":{let r={};if(null==(t=decodeURIComponent(t))||""===t){E.read_preference_tags.push(r);break}let n=t.split(/,/);for(let e=0;e<n.length;e++){var o=n[e].trim().split(/:/);r[o[0]]=o[1]}E.read_preference_tags.push(r)}break;case"compressors":{k=O.compression||{};let e=t.split(",");if(!e.every(function(e){return"snappy"===e||"zlib"===e}))throw new Error("Compressors must be at least one of snappy or zlib");k.compressors=e,O.compression=k}break;case"zlibCompressionLevel":k=O.compression||{};var n=parseInt(t,10);if(n<-1||9<n)throw new Error("zlibCompressionLevel must be an integer between -1 and 9");k.zlibCompressionLevel=n,O.compression=k;break;case"retryWrites":E.retryWrites="true"===t;break;case"minSize":E.minSize=parseInt(t,10);break;default:{let e=Logger("URL Parser");e.warn(`${r} is not supported as a connection string option`)}}}}),0===E.read_preference_tags.length&&(E.read_preference_tags=null),!(-1!==E.w&&0!==E.w||!0!==E.journal&&!0!==E.fsync&&!0!==E.safe))throw new Error("w set to -1 or 0 cannot be combined with safe/w/journal/fsync");return E.readPreference||(E.readPreference="primary"),E=Object.assign(E,e),u.servers=w,u}module.exports=function(e,a,i){"function"==typeof a&&(i=a,a={}),a=a||{};let c;try{c=parser.parse(e,!0)}catch(e){return i(new Error("URL malformed, cannot be parsed"))}if("mongodb:"!==c.protocol&&"mongodb+srv:"!==c.protocol)return i(new Error("Invalid schema, expected `mongodb` or `mongodb+srv`"));if("mongodb:"===c.protocol)return parseHandler(e,a,i);if(c.hostname.split(".").length<3)return i(new Error("URI does not have hostname, domain name and tld"));c.domainLength=c.hostname.split(".").length;const r=e.substring("mongodb+srv://".length).split("/")[0];if(r.match(","))return i(new Error("Invalid URI, cannot contain multiple hostnames"));if(c.port)return i(new Error("Ports not accepted with `mongodb+srv` URIs"));e=`_mongodb._tcp.${c.host}`;dns.resolveSrv(e,function(e,r){if(e)return i(e);if(0===r.length)return i(new Error("No addresses found at host"));for(let e=0;e<r.length;e++)if(!matchesParentDomain(r[e].name,c.hostname,c.domainLength))return i(new Error("Server record does not share hostname with parent URI"));let n=c.auth?`mongodb://${c.auth}@`:"mongodb://",t=r.map(function(e,r){return 0===r?`${n}${e.name}:${e.port}`:`${e.name}:${e.port}`}),o=t.join(",")+"/",s=[];if(c.path){let e=c.path.slice(1);-1!==e.indexOf("?")&&(e=e.slice(0,e.indexOf("?"))),o+=e}(a.ssl||c.search)&&(a.ssl||!c.search||c.search.match("ssl"))||s.push("ssl=true"),c.search&&s.push(c.search.replace("?","")),dns.resolveTxt(c.host,function(e,r){if(e&&"ENODATA"!==e.code&&"ENOTFOUND"!==e.code)return i(e);if(r=e&&"ENODATA"===e.code?null:r){if(1<r.length)return i(new MongoParseError("Multiple text records not allowed"));r=r[0].join("");e=qs.parse(r);const n=Object.keys(e);if(Object.keys(n).some(e=>"loadbalanced"===e.toLowerCase()))return i(new MongoParseError("Load balancer mode requires driver version 4+"));if(n.some(e=>"authSource"!==e&&"replicaSet"!==e))return i(new MongoParseError("Text record must only set `authSource` or `replicaSet`"));0<n.length&&s.push(r)}s.length&&(o+=`?${s.join("&")}`),parseHandler(o,a,i)})})};