"use strict";const CServer=require("../core").Server,Cursor=require("../cursor"),TopologyBase=require("./topology_base").TopologyBase,Store=require("./topology_base").Store,MongoError=require("../core").MongoError,MAX_JS_INT=require("../utils").MAX_JS_INT,translateOptions=require("../utils").translateOptions,filterOptions=require("../utils").filterOptions,mergeOptions=require("../utils").mergeOptions;var legalOptionNames=["ha","haInterval","acceptableLatencyMS","poolSize","ssl","checkServerIdentity","sslValidate","sslCA","sslCRL","sslCert","ciphers","ecdhCurve","sslKey","sslPass","socketOptions","bufferMaxEntries","store","auto_reconnect","autoReconnect","emitError","keepAlive","keepAliveInitialDelay","noDelay","connectTimeoutMS","socketTimeoutMS","family","loggerLevel","logger","reconnectTries","reconnectInterval","monitoring","appname","domainsEnabled","servername","promoteLongs","promoteValues","promoteBuffers","bsonRegExp","compression","promiseLibrary","monitorCommands"];class Server extends TopologyBase{constructor(e,o,r){super();var t=(r=filterOptions(r,legalOptionNames)).promiseLibrary,n={force:!1,bufferMaxEntries:"number"==typeof r.bufferMaxEntries?r.bufferMaxEntries:MAX_JS_INT},s=r.store||new Store(this,n);if(-1!==e.indexOf("/"))null!=o&&"object"==typeof o&&(r=o,o=null);else if(null==o)throw MongoError.create({message:"port must be specified",driver:!0});var c="boolean"!=typeof r.auto_reconnect||r.auto_reconnect,c="boolean"==typeof r.autoReconnect?r.autoReconnect:c,i=mergeOptions({},{host:e,port:o,disconnectHandler:s,cursorFactory:Cursor,reconnect:c,emitError:"boolean"!=typeof r.emitError||r.emitError,size:"number"==typeof r.poolSize?r.poolSize:5,monitorCommands:"boolean"==typeof r.monitorCommands&&r.monitorCommands}),i=translateOptions(i,r),c=r.socketOptions&&0<Object.keys(r.socketOptions).length?r.socketOptions:r;i=translateOptions(i,c),this.s={coreTopology:new CServer(i),sCapabilities:null,clonedOptions:i,reconnect:i.reconnect,emitError:i.emitError,poolSize:i.size,storeOptions:n,store:s,host:e,port:o,options:r,sessionPool:null,sessions:new Set,promiseLibrary:t||Promise}}connect(e,o){var t=this;"function"==typeof e&&(o=e,e={}),null==e&&(e=this.s.clonedOptions),"function"!=typeof o&&(o=null),e=Object.assign({},this.s.clonedOptions,e),t.s.options=e,t.s.storeOptions.bufferMaxEntries="number"==typeof e.bufferMaxEntries?e.bufferMaxEntries:-1;function r(r){return function(e,o){t.emit(r,e,o)}}var n=function(){return function(e){["timeout","error","close"].forEach(function(e){t.s.coreTopology.removeListener(e,i[e])}),t.s.coreTopology.removeListener("connect",n);try{o(e)}catch(e){process.nextTick(function(){throw e})}}},s=function(o){return function(e){"error"!==o&&t.emit(o,e)}},c=function(){t.s.store.flush()},i={timeout:n("timeout"),error:n("error"),close:n("close")};["timeout","error","close","serverOpening","serverDescriptionChanged","serverHeartbeatStarted","serverHeartbeatSucceeded","serverHeartbeatFailed","serverClosed","topologyOpening","topologyClosed","topologyDescriptionChanged","commandStarted","commandSucceeded","commandFailed"].forEach(function(e){t.s.coreTopology.removeAllListeners(e)}),t.s.coreTopology.once("timeout",i.timeout),t.s.coreTopology.once("error",i.error),t.s.coreTopology.once("close",i.close),t.s.coreTopology.once("connect",function(){["timeout","error","close","destroy"].forEach(function(e){t.s.coreTopology.removeAllListeners(e)}),t.s.coreTopology.on("timeout",s("timeout")),t.s.coreTopology.once("error",s("error")),t.s.coreTopology.on("close",s("close")),t.s.coreTopology.on("destroy",c),t.emit("open",null,t);try{o(null,t)}catch(e){process.nextTick(function(){throw e})}}),t.s.coreTopology.on("reconnect",function(){t.emit("reconnect",t),t.s.store.execute()}),t.s.coreTopology.on("reconnectFailed",function(e){t.emit("reconnectFailed",e),t.s.store.flush(e)}),t.s.coreTopology.on("serverDescriptionChanged",r("serverDescriptionChanged")),t.s.coreTopology.on("serverHeartbeatStarted",r("serverHeartbeatStarted")),t.s.coreTopology.on("serverHeartbeatSucceeded",r("serverHeartbeatSucceeded")),t.s.coreTopology.on("serverHeartbeatFailed",r("serverHeartbeatFailed")),t.s.coreTopology.on("serverOpening",r("serverOpening")),t.s.coreTopology.on("serverClosed",r("serverClosed")),t.s.coreTopology.on("topologyOpening",r("topologyOpening")),t.s.coreTopology.on("topologyClosed",r("topologyClosed")),t.s.coreTopology.on("topologyDescriptionChanged",r("topologyDescriptionChanged")),t.s.coreTopology.on("commandStarted",r("commandStarted")),t.s.coreTopology.on("commandSucceeded",r("commandSucceeded")),t.s.coreTopology.on("commandFailed",r("commandFailed")),t.s.coreTopology.on("attemptReconnect",r("attemptReconnect")),t.s.coreTopology.on("monitoring",r("monitoring")),t.s.coreTopology.connect(e)}}Object.defineProperty(Server.prototype,"poolSize",{enumerable:!0,get:function(){return this.s.coreTopology.connections().length}}),Object.defineProperty(Server.prototype,"autoReconnect",{enumerable:!0,get:function(){return this.s.reconnect}}),Object.defineProperty(Server.prototype,"host",{enumerable:!0,get:function(){return this.s.host}}),Object.defineProperty(Server.prototype,"port",{enumerable:!0,get:function(){return this.s.port}}),module.exports=Server;