"use strict";const maybePromise=require("../utils").maybePromise,MongoError=require("../core/error").MongoError,Aspect=require("./operation").Aspect,OperationBase=require("./operation").OperationBase,ReadPreference=require("../core/topologies/read_preference"),isRetryableError=require("../core/error").isRetryableError,maxWireVersion=require("../core/utils").maxWireVersion,isUnifiedTopology=require("../core/utils").isUnifiedTopology;function executeOperation(r,i,e){if(null==r)throw new TypeError("This method requires a valid topology instance");if(!(i instanceof OperationBase))throw new TypeError("This method requires a valid operation instance");return maybePromise(r,e,o=>{if(isUnifiedTopology(r)&&r.shouldCheckForSessionSupport())return selectServerForSessionSupport(r,i,o);let s,n;if(r.hasSessionSupport()){if(null==i.session)n=Symbol(),s=r.startSession({owner:n}),i.session=s;else if(i.session.hasEnded)return o(new MongoError("Use of expired sessions is not permitted"))}else if(i.session)return o(new MongoError("Current topology does not support sessions"));function e(e,r){s&&s.owner===n&&(s.endSession(),i.session===s&&i.clearSession()),o(e,r)}try{i.hasAspect(Aspect.EXECUTE_WITH_SELECTION)?executeWithServerSelection(r,i,e):i.execute(e)}catch(e){s&&s.owner===n&&(s.endSession(),i.session===s&&i.clearSession()),o(e)}})}function supportsRetryableReads(e){return 6<=maxWireVersion(e)}function executeWithServerSelection(o,s,n){const e=s.readPreference||ReadPreference.primary,i=s.session&&s.session.inTransaction();if(!i||e.equals(ReadPreference.primary)){const a={readPreference:e,session:s.session};function t(e,r){return null==e?n(null,r):isRetryableError(e)?void o.selectServer(a,(e,r)=>{!e&&supportsRetryableReads(r)?s.execute(r,n):n(e,null)}):n(e)}o.selectServer(a,(e,r)=>{e?n(e,null):(e=!1!==o.s.options.retryReads&&s.session&&!i&&supportsRetryableReads(r)&&s.canRetryRead,s.hasAspect(Aspect.RETRYABLE)&&e?s.execute(r,t):s.execute(r,n))})}else n(new MongoError(`Read preference in a transaction must be primary, not: ${e.mode}`))}function selectServerForSessionSupport(r,o,s){r.selectServer(ReadPreference.primaryPreferred,e=>e?s(e):void executeOperation(r,o,s))}module.exports=executeOperation;