"use strict";const MONGODB_ERROR_CODES=require("../error_codes").MONGODB_ERROR_CODES,applyWriteConcern=require("../utils").applyWriteConcern,Code=require("../core").BSON.Code,debugOptions=require("../utils").debugOptions,handleCallback=require("../utils").handleCallback,MongoError=require("../core").MongoError,parseIndexOptions=require("../utils").parseIndexOptions,ReadPreference=require("../core").ReadPreference,toError=require("../utils").toError,extractCommand=require("../command_utils").extractCommand,CONSTANTS=require("../constants"),MongoDBNamespace=require("../utils").MongoDBNamespace,debugFields=["authSource","w","wtimeout","j","native_parser","forceServerObjectId","serializeFunctions","raw","promoteLongs","promoteValues","promoteBuffers","bsonRegExp","bufferMaxEntries","numberOfRetries","retryMiliSeconds","readPreference","pkFactory","parentDb","promiseLibrary","noListener"];function createIndex(o,a,t,l,i){let s=Object.assign({},{readPreference:ReadPreference.PRIMARY},l);if(s=applyWriteConcern(s,{db:o},l),s.writeConcern&&"function"!=typeof i)throw MongoError.create({message:"Cannot use a writeConcern without a provided callback",driver:!0});if(o.serverConfig&&o.serverConfig.isDestroyed())return i(new MongoError("topology was destroyed"));createIndexUsingCreateIndexes(o,a,t,s,(e,r)=>{if(null==e)return handleCallback(i,e,r);if(e.code===MONGODB_ERROR_CODES.CannotCreateIndex||e.code===MONGODB_ERROR_CODES.DuplicateKey||e.code===MONGODB_ERROR_CODES.IndexOptionsConflict||e.code===MONGODB_ERROR_CODES.IndexKeySpecsConflict||e.code===MONGODB_ERROR_CODES.InterruptedAtShutdown||e.code===MONGODB_ERROR_CODES.InvalidIndexSpecificationOption)return handleCallback(i,e,r);const n=createCreateIndexCommand(o,a,t,l);s.checkKeys=!1,o.s.topology.insert(o.s.namespace.withCollection(CONSTANTS.SYSTEM_INDEX_COLLECTION),n,s,(e,r)=>{if(null!=i)return e?handleCallback(i,e):null==r?handleCallback(i,null,null):r.result.writeErrors?handleCallback(i,MongoError.create(r.result.writeErrors[0]),null):void handleCallback(i,null,n.name)})})}function createListener(n,o,e){return function(r){if(0<e.listeners(o).length){e.emit(o,r,n);for(let e=0;e<n.s.children.length;e++)n.s.children[e].emit(o,r,n.s.children[e])}}}function ensureIndex(n,o,a,t,l){const e=applyWriteConcern({},{db:n},t);const i=createCreateIndexCommand(n,o,a,t).name;if(n.serverConfig&&n.serverConfig.isDestroyed())return l(new MongoError("topology was destroyed"));e.readPreference=ReadPreference.PRIMARY,indexInformation(n,o,e,(e,r)=>{if(null!=e&&e.code!==MONGODB_ERROR_CODES.NamespaceNotFound)return handleCallback(l,e,null);if(null!=r&&r[i]){if("function"==typeof l)return handleCallback(l,null,i)}else createIndex(n,o,a,t,l)})}function evaluate(e,r,n,o,a){let t=r,l=[];if(e.serverConfig&&e.serverConfig.isDestroyed())return a(new MongoError("topology was destroyed"));t&&"Code"===t._bsontype||(t=new Code(t)),null==n||Array.isArray(n)||"function"==typeof n?null!=n&&Array.isArray(n)&&"function"!=typeof n&&(l=n):l=[n];let i={$eval:t,args:l};o.nolock&&(i.nolock=o.nolock),o.readPreference=new ReadPreference(ReadPreference.PRIMARY),executeCommand(e,i,o,(e,r)=>e?handleCallback(a,e,null):r&&1===r.ok?handleCallback(a,null,r.retval):r?handleCallback(a,MongoError.create({message:`eval failed: ${r.errmsg}`,driver:!0}),null):void handleCallback(a,e,r))}function executeCommand(e,r,n,o){if(e.serverConfig&&e.serverConfig.isDestroyed())return o(new MongoError("topology was destroyed"));var a,t=n.dbName||n.authdb||e.databaseName;n.readPreference=ReadPreference.resolve(e,n),e.s.logger.isDebug()&&(a=extractCommand(r),e.s.logger.debug(`executing command ${JSON.stringify(a.shouldRedact?`${a.name} details REDACTED`:r)} against ${t}.$cmd with options [${JSON.stringify(debugOptions(debugFields,n))}]`)),e.s.topology.command(e.s.namespace.withCollection("$cmd"),r,n,(e,r)=>e?handleCallback(o,e):n.full?handleCallback(o,null,r):void handleCallback(o,null,r.result))}function executeDbAdminCommand(n,e,r,o){var a=new MongoDBNamespace("admin","$cmd");n.s.topology.command(a,e,r,(e,r)=>n.serverConfig&&n.serverConfig.isDestroyed()?o(new MongoError("topology was destroyed")):e?handleCallback(o,e):void handleCallback(o,null,r.result))}function indexInformation(e,r,n,o){const a=null!=n.full&&n.full;if(e.serverConfig&&e.serverConfig.isDestroyed())return o(new MongoError("topology was destroyed"));e.collection(r).listIndexes(n).toArray((e,r)=>e?o(toError(e)):Array.isArray(r)?a?handleCallback(o,null,r):void handleCallback(o,null,function(r){let n={};for(let e=0;e<r.length;e++){var o,a=r[e];for(o in n[a.name]=[],a.key)n[a.name].push([o,a.key[o]])}return n}(r)):handleCallback(o,null,[]))}function profilingInfo(e,r,n){try{e.collection("system.profile").find({},r).toArray(n)}catch(e){return n(e,null)}}function validateDatabaseName(r){if("string"!=typeof r)throw MongoError.create({message:"database name must be a string",driver:!0});if(0===r.length)throw MongoError.create({message:"database name cannot be the empty string",driver:!0});if("$external"!==r){var n=[" ",".","$","/","\\"];for(let e=0;e<n.length;e++)if(-1!==r.indexOf(n[e]))throw MongoError.create({message:"database names cannot contain the character '"+n[e]+"'",driver:!0})}}function createCreateIndexCommand(e,r,n,o){var a=parseIndexOptions(n),n=a.fieldHash,a=("string"==typeof o.name?o:a).name;const t={ns:e.s.namespace.withCollection(r).toString(),key:n,name:a};var l,a=null!=o&&"object"!=typeof o&&o;o=null==o||"boolean"==typeof o?{}:o;const i=Object.keys(t);for(l in o)-1===i.indexOf(l)&&(t[l]=o[l]);null==t.unique&&(t.unique=a);var s=["w","wtimeout","j","fsync","readPreference","session"];for(let e=0;e<s.length;e++)delete t[s[e]];return t}function createIndexUsingCreateIndexes(e,r,n,o,a){var t,n=parseIndexOptions(n);const l=("string"==typeof o.name?o:n).name,i=[{name:l,key:n.fieldHash}],s=Object.keys(i[0]).concat(["writeConcern","w","wtimeout","j","fsync","readPreference","session"]);for(t in o)-1===s.indexOf(t)&&(i[0][t]=o[t]);n=e.s.topology.capabilities();if(i[0].collation&&n&&!n.commandsTakeCollation){const c=new MongoError("server/primary/mongos does not support collation");return c.code=67,a(c)}r=applyWriteConcern({createIndexes:r,indexes:i},{db:e},o);o.readPreference=ReadPreference.PRIMARY,executeCommand(e,r,o,(e,r)=>e?handleCallback(a,e,null):0===r.ok?handleCallback(a,toError(r),null):void handleCallback(a,null,l))}module.exports={createListener:createListener,createIndex:createIndex,ensureIndex:ensureIndex,evaluate:evaluate,executeCommand:executeCommand,executeDbAdminCommand:executeDbAdminCommand,indexInformation:indexInformation,profilingInfo:profilingInfo,validateDatabaseName:validateDatabaseName};