"use strict";const deprecate=require("util").deprecate,Logger=require("../core").Logger,MongoCredentials=require("../core").MongoCredentials,MongoError=require("../core").MongoError,Mongos=require("../topologies/mongos"),NativeTopology=require("../topologies/native_topology"),parse=require("../core").parseConnectionString,ReadConcern=require("../read_concern"),ReadPreference=require("../core").ReadPreference,ReplSet=require("../topologies/replset"),Server=require("../topologies/server"),ServerSessionPool=require("../core").Sessions.ServerSessionPool,emitDeprecationWarning=require("../utils").emitDeprecationWarning,emitWarningOnce=require("../utils").emitWarningOnce,fs=require("fs"),WriteConcern=require("../write_concern"),CMAP_EVENT_NAMES=require("../cmap/events").CMAP_EVENT_NAMES;let client;function loadClient(){return client=client||require("../mongo_client"),client}const legacyParse=deprecate(require("../url_parser"),"current URL string parser is deprecated, and will be removed in a future version. To use the new parser, pass option { useNewUrlParser: true } to MongoClient.connect."),AUTH_MECHANISM_INTERNAL_MAP={DEFAULT:"default",PLAIN:"plain",GSSAPI:"gssapi","MONGODB-CR":"mongocr","MONGODB-X509":"x509","MONGODB-AWS":"mongodb-aws","SCRAM-SHA-1":"scram-sha-1","SCRAM-SHA-256":"scram-sha-256"},monitoringEvents=["timeout","close","serverOpening","serverDescriptionChanged","serverHeartbeatStarted","serverHeartbeatSucceeded","serverHeartbeatFailed","serverClosed","topologyOpening","topologyClosed","topologyDescriptionChanged","commandStarted","commandSucceeded","commandFailed","joined","left","ping","ha","all","fullsetup","open"],VALID_AUTH_MECHANISMS=new Set(["DEFAULT","PLAIN","GSSAPI","MONGODB-CR","MONGODB-X509","MONGODB-AWS","SCRAM-SHA-1","SCRAM-SHA-256"]),validOptionNames=["poolSize","ssl","sslValidate","sslCA","sslCert","sslKey","sslPass","sslCRL","autoReconnect","noDelay","keepAlive","keepAliveInitialDelay","connectTimeoutMS","family","socketTimeoutMS","reconnectTries","reconnectInterval","ha","haInterval","replicaSet","secondaryAcceptableLatencyMS","acceptableLatencyMS","connectWithNoPrimary","authSource","w","wtimeout","j","writeConcern","forceServerObjectId","serializeFunctions","ignoreUndefined","raw","bufferMaxEntries","readPreference","pkFactory","promiseLibrary","readConcern","maxStalenessSeconds","loggerLevel","logger","promoteValues","promoteBuffers","promoteLongs","bsonRegExp","domainsEnabled","checkServerIdentity","validateOptions","appname","auth","user","password","authMechanism","compression","fsync","readPreferenceTags","numberOfRetries","auto_reconnect","minSize","monitorCommands","serverApi","retryWrites","retryReads","useNewUrlParser","useUnifiedTopology","serverSelectionTimeoutMS","useRecoveryToken","autoEncryption","driverInfo","tls","tlsInsecure","tlsinsecure","tlsAllowInvalidCertificates","tlsAllowInvalidHostnames","tlsCAFile","tlsCertificateFile","tlsCertificateKeyFile","tlsCertificateKeyFilePassword","minHeartbeatFrequencyMS","heartbeatFrequencyMS","directConnection","appName","maxPoolSize","minPoolSize","maxIdleTimeMS","waitQueueTimeoutMS"],ignoreOptionNames=["native_parser"],legacyOptionNames=["server","replset","replSet","mongos","db"];function validOptions(e){const r=validOptionNames.concat(legacyOptionNames);for(const n in e)if(-1===ignoreOptionNames.indexOf(n)){if(-1===r.indexOf(n)){if(e.validateOptions)return new MongoError(`option ${n} is not supported`);emitWarningOnce(`the options [${n}] is not supported`)}-1!==legacyOptionNames.indexOf(n)&&emitWarningOnce("the server/replset/mongos/db options are deprecated, "+`all their options are supported at the top level of the options object [${validOptionNames}]`)}}const LEGACY_OPTIONS_MAP=validOptionNames.reduce((e,r)=>(e[r.toLowerCase()]=r,e),{});function addListeners(e,r){r.on("authenticated",createListener(e,"authenticated")),r.on("error",createListener(e,"error")),r.on("timeout",createListener(e,"timeout")),r.on("close",createListener(e,"close")),r.on("parseError",createListener(e,"parseError")),r.once("open",createListener(e,"open")),r.once("fullsetup",createListener(e,"fullsetup")),r.once("all",createListener(e,"all")),r.on("reconnect",createListener(e,"reconnect"))}function assignTopology(e,r){(e.topology=r)instanceof NativeTopology||(r.s.sessionPool=new ServerSessionPool(r.s.coreTopology))}function clearAllEvents(r){monitoringEvents.forEach(e=>r.removeAllListeners(e))}function collectEvents(t,e){var r=loadClient();const o=[];return t instanceof r&&monitoringEvents.forEach(n=>{e.on(n,(e,r)=>{"open"===n?o.push({event:n,object1:t}):o.push({event:n,object1:e,object2:r})})}),o}function resolveTLSOptions(r){null!=r.tls&&["sslCA","sslKey","sslCert"].forEach(e=>{r[e]&&(r[e]=fs.readFileSync(r[e]))})}function connect(t,e,o,s){if(o=Object.assign({},o),null==s)throw new Error("no callback function provided");let i=!1;const a=Logger("MongoClient",o);if(e instanceof Server||e instanceof ReplSet||e instanceof Mongos)return connectWithUrl(t,e,o,l);var r=!1!==o.useNewUrlParser;const n=r?parse:legacyParse,c=r?transformUrlOptions:legacyTransformUrlOptions;function l(e,r){var n="seed list contains no mongos proxies, replicaset connections requires the parameter replicaSet to be supplied in the URI or options object, mongodb://server:port/db?replicaSet=name";if(e&&"no mongos proxies found in seed list"===e.message)return a.isWarn()&&a.warn(n),s(new MongoError(n));i&&t.emit("authenticated",null,!0),s(e,r)}n(e,o,(e,r)=>{if(e)return s(e);r=c(r);const n=createUnifiedOptions(r,o);if(null==n.socketTimeoutMS&&(n.socketTimeoutMS=0),null==n.connectTimeoutMS&&(n.connectTimeoutMS=1e4),null==n.retryWrites&&(n.retryWrites=!0),null==n.useRecoveryToken&&(n.useRecoveryToken=!0),null==n.readPreference&&(n.readPreference="primary"),n.db_options&&n.db_options.auth&&delete n.db_options.auth,resolveTLSOptions(n),t.s.options=n,t.s.readPreference=ReadPreference.fromOptions(n),t.s.writeConcern=WriteConcern.fromOptions(n),0===r.servers.length)return s(new Error("connection string must contain at least one seed host"));if(n.auth&&!n.credentials)try{i=!0,n.credentials=generateCredentials(t,n.auth.user,n.auth.password,n)}catch(e){return s(e)}return n.useUnifiedTopology?createTopology(t,"unified",n,l):(emitWarningOnce("Current Server Discovery and Monitoring engine is deprecated, and will be removed in a future version. To use the new Server Discover and Monitoring engine, pass option { useUnifiedTopology: true } to the MongoClient constructor."),n.replicaSet||n.rs_name?createTopology(t,"replicaset",n,l):1<r.servers.length?createTopology(t,"mongos",n,l):createServer(t,n,l))})}function connectWithUrl(e,r,n,t){assignTopology(e,r),addListeners(e,r),relayEvents(e,r);let o=Object.assign({},n);if("string"!=typeof n.readPreference&&"string"!=typeof n.read_preference||(o.readPreference=new ReadPreference(n.readPreference||n.read_preference)),(o.user||o.password||o.authMechanism)&&!o.credentials)try{o.credentials=generateCredentials(e,o.user,o.password,o)}catch(e){return t(e,r)}return r.connect(o,t)}function createListener(n,t){const o=new Set(["all","fullsetup","open","reconnect"]);return(e,r)=>{if(o.has(t))return n.emit(t,n);n.emit(t,e,r)}}function createServer(t,o,s){o.promiseLibrary=t.s.promiseLibrary;const i=translateOptions(o)[0],a=collectEvents(t,i);i.connect(o,(e,r)=>{if(e)return i.close(!0),s(e);clearAllEvents(i),relayEvents(t,i),addListeners(t,i);var n=r.lastIsMaster();if(assignTopology(t,r),n&&"isdbgrid"===n.msg)return r.close(),createTopology(t,"mongos",o,s);replayEvents(t,a),s(e,r)})}const DEPRECATED_UNIFIED_EVENTS=new Set(["reconnect","reconnectFailed","attemptReconnect","joined","left","ping","ha","all","fullsetup","open"]);function registerDeprecatedEventNotifiers(e){e.on("newListener",e=>{DEPRECATED_UNIFIED_EVENTS.has(e)&&emitDeprecationWarning(`The \`${e}\` event is no longer supported by the unified topology, please read more by visiting http://bit.ly/2D8WfT6`,"DeprecationWarning")})}function createTopology(e,r,n,t){n.promiseLibrary=e.s.promiseLibrary;const o={};"unified"===r&&(o.createServers=!1);var s=translateOptions(n,o);if(null!=n.autoEncryption){const a=require("../encrypter").Encrypter;n.encrypter=new a(e,n),n.autoEncrypter=n.encrypter.autoEncrypter}let i;"mongos"===r?i=new Mongos(s,n):"replicaset"===r?i=new ReplSet(s,n):"unified"===r&&(i=new NativeTopology(n.servers,n),registerDeprecatedEventNotifiers(e)),addListeners(e,i),relayEvents(e,i),assignTopology(e,i),n.autoEncrypter?n.autoEncrypter.init(e=>{e?t(e):i.connect(n,e=>e?(i.close(!0),void t(e)):void n.encrypter.connectInternalClient(e=>e?t(e):void t(void 0,i)))}):i.connect(n,e=>e?(i.close(!0),t(e)):void t(void 0,i))}function createUnifiedOptions(e,r){const n=["mongos","server","db","replset","db_options","server_options","rs_options","mongos_options"],t=["readconcern","compression","autoencryption"],o=["w","wtimeout","j","journal","fsync","writeconcern"];for(const i in r)-1===o.indexOf(i.toLowerCase())&&(-1!==t.indexOf(i.toLowerCase())?e[i]=r[i]:-1!==n.indexOf(i.toLowerCase())?e=mergeOptions(e,r[i],!1):!r[i]||"object"!=typeof r[i]||Buffer.isBuffer(r[i])||Array.isArray(r[i])?e[i]=r[i]:e=mergeOptions(e,r[i],!0));var s=WriteConcern.fromOptions(r);return s&&(e.writeConcern=Object.assign({},e.writeConcern,s)),e}function generateCredentials(e,r,n,t){var o=(t=Object.assign({},t)).authSource||t.authdb||t.dbName;const s=t.authMechanism||"DEFAULT";var i=s.toUpperCase(),t=t.authMechanismProperties;if(!VALID_AUTH_MECHANISMS.has(i))throw MongoError.create({message:`authentication mechanism ${s} not supported', options.authMechanism`,driver:!0});return new MongoCredentials({mechanism:AUTH_MECHANISM_INTERNAL_MAP[i],mechanismProperties:t,source:o,username:r,password:n})}function legacyTransformUrlOptions(e){return mergeOptions(createUnifiedOptions({},e),e,!1)}function mergeOptions(e,r,n){for(const t in r)r[t]&&"object"==typeof r[t]&&n?e=mergeOptions(e,r[t],n):e[t]=r[t];return e}function relayEvents(t,e){const r=["commandStarted","commandSucceeded","commandFailed","serverOpening","serverClosed","serverDescriptionChanged","serverHeartbeatStarted","serverHeartbeatSucceeded","serverHeartbeatFailed","topologyOpening","topologyClosed","topologyDescriptionChanged","joined","left","ping","ha"].concat(CMAP_EVENT_NAMES);r.forEach(n=>{e.on(n,(e,r)=>{t.emit(n,e,r)})})}function replayEvents(r,n){for(let e=0;e<n.length;e++)r.emit(n[e].event,n[e].object1,n[e].object2)}function transformUrlOptions(e){let r=Object.assign({servers:e.hosts},e.options);for(var n in r){var t=LEGACY_OPTIONS_MAP[n];t&&(r[t]=r[n])}var o=e.auth&&e.auth.username,s=e.options&&e.options.authMechanism;(o||s)&&(r.auth=Object.assign({},e.auth),r.auth.db&&(r.authSource=r.authSource||r.auth.db),r.auth.username&&(r.auth.user=r.auth.username)),e.defaultDatabase&&(r.dbName=e.defaultDatabase),r.maxPoolSize&&(r.poolSize=r.maxPoolSize),r.readConcernLevel&&(r.readConcern=new ReadConcern(r.readConcernLevel)),r.wTimeoutMS&&(r.wtimeout=r.wTimeoutMS,r.wTimeoutMS=void 0),e.srvHost&&(r.srvHost=e.srvHost);for(const i of["w","wtimeout","j","journal","fsync"])void 0!==r[i]&&(void 0===r.writeConcern&&(r.writeConcern={}),r.writeConcern[i]=r[i],r[i]=void 0);return r}function translateOptions(r,e){if(e=Object.assign({},{createServers:!0},e),"string"!=typeof r.readPreference&&"string"!=typeof r.read_preference||(r.readPreference=new ReadPreference(r.readPreference||r.read_preference)),r.readPreference&&(r.readPreferenceTags||r.read_preference_tags)&&(r.readPreference.tags=r.readPreferenceTags||r.read_preference_tags),r.maxStalenessSeconds&&(r.readPreference.maxStalenessSeconds=r.maxStalenessSeconds),null==r.socketTimeoutMS&&(r.socketTimeoutMS=0),null==r.connectTimeoutMS&&(r.connectTimeoutMS=1e4),e.createServers)return r.servers.map(e=>e.domain_socket?new Server(e.domain_socket,27017,r):new Server(e.host,e.port,r))}module.exports={validOptions:validOptions,connect:connect};