"use strict";const ChangeStream=require("./change_stream"),Db=require("./db"),EventEmitter=require("events").EventEmitter,inherits=require("util").inherits,MongoError=require("./core").MongoError,ValidServerApiVersions=require("./core").ValidServerApiVersions,deprecate=require("util").deprecate,WriteConcern=require("./write_concern"),MongoDBNamespace=require("./utils").MongoDBNamespace,ReadPreference=require("./core/topologies/read_preference"),maybePromise=require("./utils").maybePromise,NativeTopology=require("./topologies/native_topology"),connect=require("./operations/connect").connect,validOptions=require("./operations/connect").validOptions;function MongoClient(e,o){if(o=o||{},!(this instanceof MongoClient))return new MongoClient(e,o);if(EventEmitter.call(this),o.autoEncryption&&require("./encrypter"),o.serverApi){var t="string"==typeof o.serverApi?{version:o.serverApi}:o.serverApi;const n=t&&t.version;if(!n)throw new MongoError(`Invalid \`serverApi\` property; must specify a version from the following enum: ["${ValidServerApiVersions.join('", "')}"]`);if(!ValidServerApiVersions.some(e=>e===n))throw new MongoError(`Invalid server API version=${n}; must be in the following enum: ["${ValidServerApiVersions.join('", "')}"]`);o.serverApi=t}this.s={url:e,options:o,promiseLibrary:o&&o.promiseLibrary||Promise,dbCache:new Map,sessions:new Set,writeConcern:WriteConcern.fromOptions(o),readPreference:ReadPreference.fromOptions(o)||ReadPreference.primary,namespace:new MongoDBNamespace("admin")}}inherits(MongoClient,EventEmitter),Object.defineProperty(MongoClient.prototype,"writeConcern",{enumerable:!0,get:function(){return this.s.writeConcern}}),Object.defineProperty(MongoClient.prototype,"readPreference",{enumerable:!0,get:function(){return this.s.readPreference}}),MongoClient.prototype.connect=function(e){if("string"==typeof e)throw new TypeError("`connect` only accepts a callback");const t=this;return maybePromise(this,e,o=>{var e=validOptions(t.s.options);if(e)return o(e);connect(t,t.s.url,t.s.options,e=>e?o(e):void o(null,t))})},MongoClient.prototype.logout=deprecate(function(e,o){"function"==typeof e&&(o=e,e={}),"function"==typeof o&&o(null,!0)},"Multiple authentication is prohibited on a connected client, please only authenticate once per MongoClient"),MongoClient.prototype.close=function(r,e){"function"==typeof r&&(e=r,r=!1);const i=this;return maybePromise(this,e,t=>{const n=e=>{if(i.emit("close",i),!(i.topology instanceof NativeTopology))for(const o of i.s.dbCache)o[1].emit("close",i);i.removeAllListeners("close"),t(e)};null!=i.topology?i.topology.close(r,o=>{const e=i.topology.s.options.encrypter;if(e)return e.close(i,r,e=>{n(o||e)});n(o)}):n()})},MongoClient.prototype.db=function(e,o){o=o||{},e=e||this.s.options.dbName;const t=Object.assign({},this.s.options,o);if(this.s.dbCache.has(e)&&!0!==t.returnNonCachedInstance)return this.s.dbCache.get(e);if(t.promiseLibrary=this.s.promiseLibrary,!this.topology)throw new MongoError("MongoClient must be connected before calling MongoClient.prototype.db");o=new Db(e,this.topology,t);return this.s.dbCache.set(e,o),o},MongoClient.prototype.isConnected=deprecate(function(e){return e=e||{},!!this.topology&&this.topology.isConnected(e)},"isConnected is deprecated and will be removed in the next major version"),MongoClient.connect=function(e,o,t){const n=Array.prototype.slice.call(arguments,1);t="function"==typeof n[n.length-1]?n.pop():void 0;const r=new MongoClient(e,(n.length?n.shift():null)||{});return r.connect(t)},MongoClient.prototype.startSession=function(e){if(e=Object.assign({explicit:!0},e),!this.topology)throw new MongoError("Must connect to a server before calling this method");return this.topology.startSession(e,this.s.options)},MongoClient.prototype.withSession=function(e,o){"function"==typeof e&&(o=e,e=void 0);const n=this.startSession(e);let r=(e,o,t)=>{if(r=()=>{throw new ReferenceError("cleanupHandler was called too many times")},t=Object.assign({throw:!0},t),n.endSession(),e){if(t.throw)throw e;return Promise.reject(e)}};try{var t=o(n);return Promise.resolve(t).then(e=>r(null,e)).catch(e=>r(e,null,{throw:!0}))}catch(e){return r(e,null,{throw:!1})}},MongoClient.prototype.watch=function(e,o){return e=e||[],o=o||{},Array.isArray(e)||(o=e,e=[]),new ChangeStream(this,e,o)},MongoClient.prototype.getLogger=function(){return this.s.options.logger},module.exports=MongoClient;