"use strict";const Chunk=require("./chunk"),ObjectID=require("../core").BSON.ObjectID,ReadPreference=require("../core").ReadPreference,Buffer=require("safe-buffer").Buffer,fs=require("fs"),f=require("util").format,util=require("util"),MongoError=require("../core").MongoError,inherits=util.inherits,Duplex=require("stream").Duplex,shallowClone=require("../utils").shallowClone,executeLegacyOperation=require("../utils").executeLegacyOperation,deprecate=require("util").deprecate;var REFERENCE_BY_FILENAME=0,REFERENCE_BY_ID=1;const deprecationFn=deprecate(()=>{},"GridStore is deprecated, and will be removed in a future version. Please use GridFSBucket instead");var GridStore=function e(n,t,o,i,r){if(deprecationFn(),!(this instanceof e))return new e(n,t,o,i,r);this.db=n,void 0===r&&(r={}),void 0===i?(i=o,o=void 0):"object"==typeof i&&(r=i,i=o,o=void 0),(!t||"ObjectID"!==t._bsontype)&&void 0===o?(this.referenceBy=REFERENCE_BY_FILENAME,this.filename=t,null!=i.indexOf("w")&&(this.fileId=new ObjectID)):(this.referenceBy=REFERENCE_BY_ID,this.fileId=t,this.filename=o),this.mode=null==i?"r":i,this.options=r||{},this.isOpen=!1,this.root=null==this.options.root?e.DEFAULT_ROOT_COLLECTION:this.options.root,this.position=0,this.readPreference=this.options.readPreference||n.options.readPreference||ReadPreference.primary,this.writeConcern=_getWriteConcern(n,this.options),this.internalChunkSize=null==this.options.chunkSize?Chunk.DEFAULT_CHUNK_SIZE:this.options.chunkSize;n=this.options.promiseLibrary||Promise;this.promiseLibrary=n,Object.defineProperty(this,"chunkSize",{enumerable:!0,get:function(){return this.internalChunkSize},set:function(e){"w"!==this.mode[0]||0!==this.position||null!=this.uploadDate?this.internalChunkSize=this.internalChunkSize:this.internalChunkSize=e}}),Object.defineProperty(this,"md5",{enumerable:!0,get:function(){return this.internalMd5}}),Object.defineProperty(this,"chunkNumber",{enumerable:!0,get:function(){return this.currentChunk&&this.currentChunk.chunkNumber?this.currentChunk.chunkNumber:null}})};GridStore.prototype.open=function(e,n){if("function"==typeof e&&(n=e,e={}),e=e||{},"w"!==this.mode&&"w+"!==this.mode&&"r"!==this.mode)throw MongoError.create({message:"Illegal mode "+this.mode,driver:!0});return executeLegacyOperation(this.db.s.topology,open,[this,e,n],{skipSessions:!0})};var open=function(t,e,o){var i=_getWriteConcern(t.db,t.options);"w"===t.mode||"w+"===t.mode?t.collection().ensureIndex([["filename",1]],i,function(){var e=t.chunkCollection(),n=shallowClone(i);n.unique=!0,e.ensureIndex([["files_id",1],["n",1]],n,function(){_open(t,i,function(e,n){return e?o(e):(t.isOpen=!0,void o(e,n))})})}):_open(t,i,function(e,n){return e?o(e):(t.isOpen=!0,void o(e,n))})};GridStore.prototype.eof=function(){return this.position===this.length},GridStore.prototype.getc=function(e,n){return"function"==typeof e&&(n=e,e={}),e=e||{},executeLegacyOperation(this.db.s.topology,getc,[this,e,n],{skipSessions:!0})};var getc=function(t,e,o){t.eof()?o(null,null):t.currentChunk.eof()?nthChunk(t,t.currentChunk.chunkNumber+1,function(e,n){t.currentChunk=n,t.position=t.position+1,o(e,t.currentChunk.getc())}):(t.position=t.position+1,o(null,t.currentChunk.getc()))};GridStore.prototype.puts=function(e,n,t){"function"==typeof n&&(t=n,n={}),n=n||{};e=null==e.match(/\n$/)?e+"\n":e;return executeLegacyOperation(this.db.s.topology,this.write.bind(this),[e,n,t],{skipSessions:!0})},GridStore.prototype.stream=function(){return new GridStoreStream(this)},GridStore.prototype.write=function(e,n,t,o){return"function"==typeof t&&(o=t,t={}),t=t||{},executeLegacyOperation(this.db.s.topology,_writeNormal,[this,e,n,t,o],{skipSessions:!0})},GridStore.prototype.destroy=function(){this.writable&&(this.readable=!1,this.writable&&(this.writable=!1,this._q.length=0,this.emit("close")))},GridStore.prototype.writeFile=function(e,n,t){return"function"==typeof n&&(t=n,n={}),n=n||{},executeLegacyOperation(this.db.s.topology,writeFile,[this,e,n,t],{skipSessions:!0})};var writeFile=function(t,s,e,c){"string"!=typeof s?t.open(function(e,l){return e?c(e,l):void fs.fstat(s,function(e,o){if(e)return c(e,l);var i=0,r=0,u=function(){var e=Buffer.alloc(l.chunkSize);fs.read(s,e,0,e.length,i,function(e,t,n){return e?c(e,l):(i+=t,void new Chunk(l,{n:r++},l.writeConcern).write(n.slice(0,t),function(e,n){return e?c(e,l):void n.save({},function(e){return e?c(e,l):(l.position=l.position+t,l.currentChunk=n,i>=o.size?void fs.close(s,function(e){return e?c(e):void l.close(function(e){return c(e||null,l)})}):process.nextTick(u))})}))})};process.nextTick(u)})}):fs.open(s,"r",function(e,n){return e?c(e):void t.writeFile(n,c)})};GridStore.prototype.close=function(e,n){return"function"==typeof e&&(n=e,e={}),e=e||{},executeLegacyOperation(this.db.s.topology,close,[this,e,n],{skipSessions:!0})};var close=function(n,o,i){"w"===n.mode[0]?(o=Object.assign({},n.writeConcern,o),null!=n.currentChunk&&0<n.currentChunk.position?n.currentChunk.save({},function(e){return e&&"function"==typeof i?i(e):void n.collection(function(e,t){return e&&"function"==typeof i?i(e):void(null!=n.uploadDate?buildMongoObject(n,function(e,n){if(e){if("function"==typeof i)return i(e);throw e}t.save(n,o,function(e){"function"==typeof i&&i(e,n)})}):(n.uploadDate=new Date,buildMongoObject(n,function(e,n){if(e){if("function"==typeof i)return i(e);throw e}t.save(n,o,function(e){"function"==typeof i&&i(e,n)})})))})}):n.collection(function(e,t){return e&&"function"==typeof i?i(e):(n.uploadDate=new Date,void buildMongoObject(n,function(e,n){if(e){if("function"==typeof i)return i(e);throw e}t.save(n,o,function(e){"function"==typeof i&&i(e,n)})}))})):"r"===n.mode[0]?"function"==typeof i&&i(null,null):"function"==typeof i&&i(MongoError.create({message:f("Illegal mode %s",n.mode),driver:!0}))};GridStore.prototype.chunkCollection=function(e){return"function"==typeof e?this.db.collection(this.root+".chunks",e):this.db.collection(this.root+".chunks")},GridStore.prototype.unlink=function(e,n){return"function"==typeof e&&(n=e,e={}),e=e||{},executeLegacyOperation(this.db.s.topology,unlink,[this,e,n],{skipSessions:!0})};var unlink=function(t,e,o){deleteChunks(t,function(e){return null!==e?(e.message="at deleteChunks: "+e.message,o(e)):void t.collection(function(e,n){return null!==e?(e.message="at collection: "+e.message,o(e)):void n.remove({_id:t.fileId},t.writeConcern,function(e){o(e,t)})})})};GridStore.prototype.collection=function(e){return"function"==typeof e&&this.db.collection(this.root+".files",e),this.db.collection(this.root+".files")},GridStore.prototype.readlines=function(e,n,t){var o=Array.prototype.slice.call(arguments,0);return t="function"==typeof o[o.length-1]?o.pop():void 0,e=(o.length?o.shift():"\n")||"\n",n=o.length?o.shift():{},executeLegacyOperation(this.db.s.topology,readlines,[this,e,n,t],{skipSessions:!0})};var readlines=function(e,i,n,r){e.read(function(e,n){if(e)return r(e);for(var t=0<(t=n.toString().split(i)).length?t.splice(0,t.length-1):[],o=0;o<t.length;o++)t[o]=t[o]+i;r(null,t)})};GridStore.prototype.rewind=function(e,n){return"function"==typeof e&&(n=e,e={}),e=e||{},executeLegacyOperation(this.db.s.topology,rewind,[this,e,n],{skipSessions:!0})};var rewind=function(t,e,o){0!==t.currentChunk.chunkNumber?"w"===t.mode[0]?deleteChunks(t,function(e){return e?o(e):(t.currentChunk=new Chunk(t,{n:0},t.writeConcern),t.position=0,void o(null,t))}):t.currentChunk(0,function(e,n){return e?o(e):(t.currentChunk=n,t.currentChunk.rewind(),t.position=0,void o(null,t))}):(t.currentChunk.rewind(),t.position=0,o(null,t))};GridStore.prototype.read=function(e,n,t,o){var i=Array.prototype.slice.call(arguments,0);return o="function"==typeof i[i.length-1]?i.pop():void 0,e=i.length?i.shift():null,n=i.length?i.shift():null,t=i.length?i.shift():{},executeLegacyOperation(this.db.s.topology,read,[this,e,n,t,o],{skipSessions:!0})};var read=function(t,o,e,n,i){var r=null==o?t.length-t.position:o,u=null==e?Buffer.alloc(r):e;if(u._index=null!=e&&null!=e._index?e._index:0,t.currentChunk.length()-t.currentChunk.position+u._index>=r){var l=t.currentChunk.readSlice(r-u._index);return l.copy(u,u._index),t.position=t.position+u.length,0===r&&0===u.length?i(MongoError.create({message:"File does not exist",driver:!0}),null):i(null,u)}(l=t.currentChunk.readSlice(t.currentChunk.length()-t.currentChunk.position)).copy(u,u._index),u._index+=l.length,nthChunk(t,t.currentChunk.chunkNumber+1,function(e,n){return e?i(e):void(0<n.length()?(t.currentChunk=n,t.read(o,u,i)):0<u._index?i(null,u):i(MongoError.create({message:"no chunks found for file, possibly corrupt",driver:!0}),null))})};GridStore.prototype.tell=function(e){var n=this;return"function"==typeof e?e(null,this.position):new n.promiseLibrary(function(e){e(n.position)})},GridStore.prototype.seek=function(e,n,t,o){var i=Array.prototype.slice.call(arguments,1);return o="function"==typeof i[i.length-1]?i.pop():void 0,n=i.length?i.shift():null,t=i.length?i.shift():{},executeLegacyOperation(this.db.s.topology,seek,[this,e,n,t,o],{skipSessions:!0})};var seek=function(t,e,n,o,i){if("r"!==t.mode)return i(MongoError.create({message:"seek is only supported for mode r",driver:!0}));var n=null==n?GridStore.IO_SEEK_SET:n,r=0,r=n===GridStore.IO_SEEK_CUR?t.position+e:n===GridStore.IO_SEEK_END?t.length+e:e,u=Math.floor(r/t.chunkSize);nthChunk(t,u,function(e,n){return e?i(e,null):null==n?i(new Error("no chunk found")):(t.currentChunk=n,t.position=r,t.currentChunk.position=t.position%t.chunkSize,void i(e,t))})},_open=function(t,o,i){var e=t.collection(),n=t.referenceBy===REFERENCE_BY_ID?{_id:t.fileId}:{filename:t.filename};function r(e){r.err||i(r.err=e)}n=null==t.fileId&&null==t.filename?null:n,o.readPreference=t.readPreference,null!=n?e.findOne(n,o,function(e,n){if(e)return r(e);if(null!=n)t.fileId=n._id,t.filename=("r"===t.mode||void 0===t.filename?n:t).filename,t.contentType=n.contentType,t.internalChunkSize=n.chunkSize,t.uploadDate=n.uploadDate,t.aliases=n.aliases,t.length=n.length,t.metadata=n.metadata,t.internalMd5=n.md5;else{if("r"===t.mode){t.length=0;e="ObjectID"===t.fileId._bsontype?t.fileId.toHexString():t.fileId;return r(MongoError.create({message:f("file with id %s not opened for writing",t.referenceBy===REFERENCE_BY_ID?e:t.filename),driver:!0}))}t.fileId=null==t.fileId?new ObjectID:t.fileId,t.contentType=GridStore.DEFAULT_CONTENT_TYPE,t.internalChunkSize=null==t.internalChunkSize?Chunk.DEFAULT_CHUNK_SIZE:t.internalChunkSize,t.length=0}"r"===t.mode?nthChunk(t,0,o,function(e,n){return e?r(e):(t.currentChunk=n,t.position=0,void i(null,t))}):"w"===t.mode&&n?deleteChunks(t,o,function(e){return e?r(e):(t.currentChunk=new Chunk(t,{n:0},t.writeConcern),t.contentType=null==t.options.content_type?t.contentType:t.options.content_type,t.internalChunkSize=null==t.options.chunk_size?t.internalChunkSize:t.options.chunk_size,t.metadata=(null==t.options.metadata?t:t.options).metadata,t.aliases=(null==t.options.aliases?t:t.options).aliases,t.position=0,void i(null,t))}):"w"===t.mode?(t.currentChunk=new Chunk(t,{n:0},t.writeConcern),t.contentType=null==t.options.content_type?t.contentType:t.options.content_type,t.internalChunkSize=null==t.options.chunk_size?t.internalChunkSize:t.options.chunk_size,t.metadata=(null==t.options.metadata?t:t.options).metadata,t.aliases=(null==t.options.aliases?t:t.options).aliases,t.position=0,i(null,t)):"w+"===t.mode&&nthChunk(t,lastChunkNumber(t),o,function(e,n){return e?r(e):(t.currentChunk=null==n?new Chunk(t,{n:0},t.writeConcern):n,t.currentChunk.position=t.currentChunk.data.length(),t.metadata=(null==t.options.metadata?t:t.options).metadata,t.aliases=(null==t.options.aliases?t:t.options).aliases,t.position=t.length,void i(null,t))})}):(t.fileId=null==t.fileId?new ObjectID:t.fileId,t.contentType=GridStore.DEFAULT_CONTENT_TYPE,t.internalChunkSize=null==t.internalChunkSize?Chunk.DEFAULT_CHUNK_SIZE:t.internalChunkSize,t.length=0,"w"===t.mode?deleteChunks(t,o,function(e){return e?r(e):(t.currentChunk=new Chunk(t,{n:0},t.writeConcern),t.contentType=null==t.options.content_type?t.contentType:t.options.content_type,t.internalChunkSize=null==t.options.chunk_size?t.internalChunkSize:t.options.chunk_size,t.metadata=(null==t.options.metadata?t:t.options).metadata,t.aliases=(null==t.options.aliases?t:t.options).aliases,t.position=0,void i(null,t))}):"w+"===t.mode&&nthChunk(t,lastChunkNumber(t),o,function(e,n){return e?r(e):(t.currentChunk=null==n?new Chunk(t,{n:0},t.writeConcern):n,t.currentChunk.position=t.currentChunk.data.length(),t.metadata=(null==t.options.metadata?t:t.options).metadata,t.aliases=(null==t.options.aliases?t:t.options).aliases,t.position=t.length,void i(null,t))}))},writeBuffer=function(n,e,t,o){"function"==typeof t&&(o=t,t=null);var i="boolean"==typeof t&&t;if("w"!==n.mode)o(MongoError.create({message:f("file with id %s not opened for writing",n.referenceBy===REFERENCE_BY_ID?n.referenceBy:n.filename),driver:!0}),null);else{if(!(n.currentChunk.position+e.length>=n.chunkSize))return n.position=n.position+e.length,n.currentChunk.write(e),i?n.close(function(e){o(e,n)}):o(null,n);for(var r=n.currentChunk.chunkNumber,t=n.chunkSize-n.currentChunk.position,u=e.slice(0,t),l=e.slice(t),s=[n.currentChunk.write(u)];l.length>=n.chunkSize;){var c=new Chunk(n,{n:r+1},n.writeConcern),u=l.slice(0,n.chunkSize),l=l.slice(n.chunkSize);r+=1,c.write(u),s.push(c)}n.currentChunk=new Chunk(n,{n:r+1},n.writeConcern),0<l.length&&n.currentChunk.write(l),n.position=n.position+e.length;for(var a=s.length,p=0;p<s.length;p++)s[p].save({},function(e){return e?o(e):(a-=1)<=0?i?n.close(function(e){o(e,n)}):o(null,n):void 0})}},buildMongoObject=function(e,t){var o={_id:e.fileId,filename:e.filename,contentType:e.contentType,length:e.position||0,chunkSize:e.chunkSize,uploadDate:e.uploadDate,aliases:e.aliases,metadata:e.metadata},n={filemd5:e.fileId,root:e.root};e.db.command(n,function(e,n){return e?t(e):(o.md5=n.md5,void t(null,o))})},nthChunk=function(t,e,n,o){"function"==typeof n&&(o=n,n={}),(n=n||t.writeConcern).readPreference=t.readPreference,t.chunkCollection().findOne({files_id:t.fileId,n:e},n,function(e,n){if(e)return o(e);n=null==n?{}:n;o(null,new Chunk(t,n,t.writeConcern))})},lastChunkNumber=function(e){return Math.floor((e.length?e.length-1:0)/e.chunkSize)},deleteChunks=function(e,n,t){"function"==typeof n&&(t=n,n={}),n=n||e.writeConcern,null!=e.fileId?e.chunkCollection().remove({files_id:e.fileId},n,function(e){return e?t(e,!1):void t(null,!0)}):t(null,!0)};GridStore.DEFAULT_ROOT_COLLECTION="fs",GridStore.DEFAULT_CONTENT_TYPE="binary/octet-stream",GridStore.IO_SEEK_SET=0,GridStore.IO_SEEK_CUR=1,GridStore.IO_SEEK_END=2,GridStore.exist=function(e,n,t,o,i){var r=Array.prototype.slice.call(arguments,2);return i="function"==typeof r[r.length-1]?r.pop():void 0,t=r.length?r.shift():null,o=(r.length?r.shift():{})||{},executeLegacyOperation(e.s.topology,exists,[e,n,t,o,i],{skipSessions:!0})};var exists=function(e,t,n,o,i){var r=o.readPreference||ReadPreference.PRIMARY,n=null!=n?n:GridStore.DEFAULT_ROOT_COLLECTION;e.collection(n+".files",function(e,n){if(e)return i(e);e="string"==typeof t||"[object RegExp]"===Object.prototype.toString.call(t)?{filename:t}:{_id:t};null!=t&&"object"==typeof t&&"[object RegExp]"!==Object.prototype.toString.call(t)&&(e=t),n.findOne(e,{readPreference:r},function(e,n){return e?i(e):void i(null,null!=n)})})};GridStore.list=function(e,n,t,o){var i=Array.prototype.slice.call(arguments,1);return o="function"==typeof i[i.length-1]?i.pop():void 0,n=i.length?i.shift():null,t=(i.length?i.shift():{})||{},executeLegacyOperation(e.s.topology,list,[e,n,t,o],{skipSessions:!0})};var list=function(e,n,t,o){null!=n&&"object"==typeof n&&(t=n,n=null);var i=t.readPreference||ReadPreference.primary,r=null!=t.id&&t.id,n=null!=n?n:GridStore.DEFAULT_ROOT_COLLECTION,u=[];e.collection(n+".files",function(e,n){return e?o(e):void n.find({},{readPreference:i},function(e,n){return e?o(e):void n.each(function(e,n){null!=n?u.push(r?n._id:n.filename):o(e,u)})})})};GridStore.read=function(e,n,t,o,i,r){var u=Array.prototype.slice.call(arguments,2);return r="function"==typeof u[u.length-1]?u.pop():void 0,t=u.length?u.shift():null,o=u.length?u.shift():null,i=(u.length?u.shift():null)||{},executeLegacyOperation(e.s.topology,readStatic,[e,n,t,o,i,r],{skipSessions:!0})};var readStatic=function(e,n,t,o,i,r){new GridStore(e,n,"r",i).open(function(e,n){return e?r(e):o&&o>=n.length?r("offset larger than size of file",null):t&&t>n.length?r("length is larger than the size of the file",null):o&&t&&o+t>n.length?r("offset and length is larger than the size of the file",null):void(null!=o?n.seek(o,function(e,n){return e?r(e):void n.read(t,r)}):n.read(t,r))})};GridStore.readlines=function(e,n,t,o,i){var r=Array.prototype.slice.call(arguments,2);return i="function"==typeof r[r.length-1]?r.pop():void 0,t=r.length?r.shift():null,o=(r.length?r.shift():null)||{},executeLegacyOperation(e.s.topology,readlinesStatic,[e,n,t,o,i],{skipSessions:!0})};var readlinesStatic=function(e,n,t,o,i){var r=null==t?"\n":t;new GridStore(e,n,"r",o).open(function(e,n){return e?i(e):void n.readlines(r,i)})};GridStore.unlink=function(e,n,t,o){var i=Array.prototype.slice.call(arguments,2);return o="function"==typeof i[i.length-1]?i.pop():void 0,t=(i.length?i.shift():{})||{},executeLegacyOperation(e.s.topology,unlinkStatic,[this,e,n,t,o],{skipSessions:!0})};var unlinkStatic=function(o,e,n,t,i){var r=_getWriteConcern(e,t);if(n.constructor===Array)for(var u=0,l=0;l<n.length;l++)++u,GridStore.unlink(e,n[l],t,function(){0==--u&&i(null,o)});else new GridStore(e,n,"w",t).open(function(e,t){return e?i(e):void deleteChunks(t,function(e){return e?i(e):void t.collection(function(e,n){return e?i(e):void n.remove({_id:t.fileId},r,function(e){i(e,o)})})})})},_writeNormal=function(e,n,t,o,i){return Buffer.isBuffer(n)?writeBuffer(e,n,t,i):writeBuffer(e,Buffer.from(n,"binary"),t,i)},_setWriteConcernHash=function(e){var n=Object.assign(e,e.writeConcern),e={};return null!=n.w&&(e.w=n.w),!0===n.journal&&(e.j=n.journal),!0===n.j&&(e.j=n.j),!0===n.fsync&&(e.fsync=n.fsync),null!=n.wtimeout&&(e.wtimeout=n.wtimeout),e},_getWriteConcern=function(e,n){var t={w:1};if(null!=(n=n||{}).writeConcern||null!=n.w||"boolean"==typeof n.j||"boolean"==typeof n.journal||"boolean"==typeof n.fsync?t=_setWriteConcernHash(n):null!=n.safe&&"object"==typeof n.safe?t=_setWriteConcernHash(n.safe):"boolean"==typeof n.safe?t={w:n.safe?1:0}:null!=e.options.writeConcern||null!=e.options.w||"boolean"==typeof e.options.j||"boolean"==typeof e.options.journal||"boolean"==typeof e.options.fsync?t=_setWriteConcernHash(e.options):!e.safe||null==e.safe.w&&"boolean"!=typeof e.safe.j&&"boolean"!=typeof e.safe.journal&&"boolean"!=typeof e.safe.fsync?"boolean"==typeof e.safe&&(t={w:e.safe?1:0}):t=_setWriteConcernHash(e.safe),t.w<1&&(!0===t.journal||!0===t.j||!0===t.fsync))throw MongoError.create({message:"No acknowledgement using w < 1 cannot be combined with journal:true or fsync:true",driver:!0});return t},GridStoreStream=function(e){Duplex.call(this),this.gs=e,this.endCalled=!1,this.totalBytesToRead=this.gs.length-this.gs.position,this.seekPosition=this.gs.position};inherits(GridStoreStream,Duplex),GridStoreStream.prototype._pipe=GridStoreStream.prototype.pipe,GridStoreStream.prototype.pipe=function(n){var t=this;return t.gs.isOpen?(t.totalBytesToRead=t.gs.length-t.gs.position,t._pipe.apply(t,[n])):t.gs.open(function(e){return e?t.emit("error",e):(t.totalBytesToRead=t.gs.length-t.gs.position,void t._pipe.apply(t,[n]))}),n},GridStoreStream.prototype._read=function(){function n(){t.gs.read(e,function(e,n){return e&&!t.endCalled?t.emit("error",e):t.endCalled||null==n?t.push(null):(n.length<=t.totalBytesToRead?(t.totalBytesToRead=t.totalBytesToRead-n.length,t.push(n)):n.length>t.totalBytesToRead&&(t.totalBytesToRead=t.totalBytesToRead-n._index,t.push(n.slice(0,n._index))),void(t.totalBytesToRead<=0&&(t.endCalled=!0)))})}var t=this,e=t.gs.length<t.gs.chunkSize?t.gs.length-t.seekPosition:t.gs.chunkSize;t.gs.isOpen?n():t.gs.open(function(e){return t.totalBytesToRead=t.gs.length-t.gs.position,e?t.emit("error",e):void n()})},GridStoreStream.prototype.destroy=function(){this.pause(),this.endCalled=!0,this.gs.close(),this.emit("end")},GridStoreStream.prototype.write=function(e){var n=this;return n.endCalled?n.emit("error",MongoError.create({message:"attempting to write to stream after end called",driver:!0})):n.gs.isOpen?(n.gs.write(e,function(){n.emit("drain")}),!0):(n.gs.open(function(){n.gs.isOpen=!0,n.gs.write(e,function(){process.nextTick(function(){n.emit("drain")})})}),!1)},GridStoreStream.prototype.end=function(e,n,t){var o=this,i=Array.prototype.slice.call(arguments,0);t="function"==typeof i[i.length-1]?i.pop():void 0,e=i.length?i.shift():null,i.length&&i.shift(),o.endCalled=!0,e&&o.gs.write(e,function(){o.gs.close(function(){"function"==typeof t&&t(),o.emit("end")})}),o.gs.close(function(){"function"==typeof t&&t(),o.emit("end")})},module.exports=GridStore;