"use strict";var Emitter=require("events").EventEmitter,GridFSBucketReadStream=require("./download"),GridFSBucketWriteStream=require("./upload"),shallowClone=require("../utils").shallowClone,toError=require("../utils").toError,util=require("util"),executeLegacyOperation=require("../utils").executeLegacyOperation;const deprecateOptions=require("../utils").deprecateOptions;var DEFAULT_GRIDFS_BUCKET_OPTIONS={bucketName:"fs",chunkSizeBytes:261120};function GridFSBucket(e,t){if(Emitter.apply(this),this.setMaxListeners(0),t&&"object"==typeof t){t=shallowClone(t);for(var i=Object.keys(DEFAULT_GRIDFS_BUCKET_OPTIONS),o=0;o<i.length;++o)t[i[o]]||(t[i[o]]=DEFAULT_GRIDFS_BUCKET_OPTIONS[i[o]])}else t=DEFAULT_GRIDFS_BUCKET_OPTIONS;this.s={db:e,options:t,_chunksCollection:e.collection(t.bucketName+".chunks"),_filesCollection:e.collection(t.bucketName+".files"),checkedIndexes:!1,calledOpenUploadStream:!1,promiseLibrary:e.s.promiseLibrary||Promise}}function _delete(i,o,r){i.s._filesCollection.deleteOne({_id:o},function(e,t){return e?r(e):void i.s._chunksCollection.deleteMany({files_id:o},function(e){return e?r(e):t.result.n?void r():r(new Error("FileNotFound: no file with id "+o+" found"))})})}function _rename(e,i,t,o){e.s._filesCollection.updateOne({_id:i},{$set:{filename:t}},function(e,t){return e?o(e):t.result.n?void o():o(toError("File with id "+i+" not found"))})}function _drop(t,i){t.s._filesCollection.drop(function(e){return e?i(e):void t.s._chunksCollection.drop(function(e){return e?i(e):i()})})}module.exports=GridFSBucket,util.inherits(GridFSBucket,Emitter),GridFSBucket.prototype.openUploadStream=deprecateOptions({name:"GridFSBucket.openUploadStream",deprecatedOptions:["disableMD5"],optionsIndex:1},function(e,t){return(t=t?shallowClone(t):{}).chunkSizeBytes||(t.chunkSizeBytes=this.s.options.chunkSizeBytes),new GridFSBucketWriteStream(this,e,t)}),GridFSBucket.prototype.openUploadStreamWithId=deprecateOptions({name:"GridFSBucket.openUploadStreamWithId",deprecatedOptions:["disableMD5"],optionsIndex:2},function(e,t,i){return(i=i?shallowClone(i):{}).chunkSizeBytes||(i.chunkSizeBytes=this.s.options.chunkSizeBytes),i.id=e,new GridFSBucketWriteStream(this,t,i)}),GridFSBucket.prototype.openDownloadStream=function(e,t){return t={start:t&&t.start,end:t&&t.end},new GridFSBucketReadStream(this.s._chunksCollection,this.s._filesCollection,this.s.options.readPreference,{_id:e},t)},GridFSBucket.prototype.delete=function(e,t){return executeLegacyOperation(this.s.db.s.topology,_delete,[this,e,t],{skipSessions:!0})},GridFSBucket.prototype.find=function(e,t){t=t||{};e=this.s._filesCollection.find(e=e||{});return null!=t.batchSize&&e.batchSize(t.batchSize),null!=t.limit&&e.limit(t.limit),null!=t.maxTimeMS&&e.maxTimeMS(t.maxTimeMS),null!=t.noCursorTimeout&&e.addCursorFlag("noCursorTimeout",t.noCursorTimeout),null!=t.skip&&e.skip(t.skip),null!=t.sort&&e.sort(t.sort),e},GridFSBucket.prototype.openDownloadStreamByName=function(e,t){var i={uploadDate:-1},o=null;return t&&null!=t.revision&&(o=0<=t.revision?(i={uploadDate:1},t.revision):-t.revision-1),t={sort:i,skip:o,start:t&&t.start,end:t&&t.end},new GridFSBucketReadStream(this.s._chunksCollection,this.s._filesCollection,this.s.options.readPreference,{filename:e},t)},GridFSBucket.prototype.rename=function(e,t,i){return executeLegacyOperation(this.s.db.s.topology,_rename,[this,e,t,i],{skipSessions:!0})},GridFSBucket.prototype.drop=function(e){return executeLegacyOperation(this.s.db.s.topology,_drop,[this,e],{skipSessions:!0})},GridFSBucket.prototype.getLogger=function(){return this.s.db.s.logger};