"use strict";const EventEmitter=require("events").EventEmitter,inherits=require("util").inherits,getSingleProperty=require("./utils").getSingleProperty,CommandCursor=require("./command_cursor"),handleCallback=require("./utils").handleCallback,filterOptions=require("./utils").filterOptions,toError=require("./utils").toError,ReadPreference=require("./core").ReadPreference,MongoError=require("./core").MongoError,ObjectID=require("./core").ObjectID,Logger=require("./core").Logger,Collection=require("./collection"),conditionallyMergeWriteConcern=require("./utils").conditionallyMergeWriteConcern,executeLegacyOperation=require("./utils").executeLegacyOperation,ChangeStream=require("./change_stream"),deprecate=require("util").deprecate,deprecateOptions=require("./utils").deprecateOptions,MongoDBNamespace=require("./utils").MongoDBNamespace,CONSTANTS=require("./constants"),WriteConcern=require("./write_concern"),ReadConcern=require("./read_concern"),AggregationCursor=require("./aggregation_cursor"),createListener=require("./operations/db_ops").createListener,ensureIndex=require("./operations/db_ops").ensureIndex,evaluate=require("./operations/db_ops").evaluate,profilingInfo=require("./operations/db_ops").profilingInfo,validateDatabaseName=require("./operations/db_ops").validateDatabaseName,AggregateOperation=require("./operations/aggregate"),AddUserOperation=require("./operations/add_user"),CollectionsOperation=require("./operations/collections"),CommandOperation=require("./operations/command"),RunCommandOperation=require("./operations/run_command"),CreateCollectionOperation=require("./operations/create_collection"),CreateIndexesOperation=require("./operations/create_indexes"),DropCollectionOperation=require("./operations/drop").DropCollectionOperation,DropDatabaseOperation=require("./operations/drop").DropDatabaseOperation,ExecuteDbAdminCommandOperation=require("./operations/execute_db_admin_command"),IndexInformationOperation=require("./operations/index_information"),ListCollectionsOperation=require("./operations/list_collections"),ProfilingLevelOperation=require("./operations/profiling_level"),RemoveUserOperation=require("./operations/remove_user"),RenameOperation=require("./operations/rename"),SetProfilingLevelOperation=require("./operations/set_profiling_level"),executeOperation=require("./operations/execute_operation"),legalOptionNames=["w","wtimeout","fsync","j","writeConcern","readPreference","readPreferenceTags","native_parser","forceServerObjectId","pkFactory","serializeFunctions","raw","bufferMaxEntries","authSource","ignoreUndefined","promiseLibrary","readConcern","retryMiliSeconds","numberOfRetries","parentDb","noListener","loggerLevel","logger","promoteBuffers","promoteLongs","promoteValues","bsonRegExp","compression","retryWrites"];function Db(e,t,r){if(r=r||{},!(this instanceof Db))return new Db(e,t,r);EventEmitter.call(this);var o=r.promiseLibrary||Promise;(r=filterOptions(r,legalOptionNames)).promiseLibrary=o,this.s={dbCache:{},children:[],topology:t,options:r,logger:Logger("Db",r),bson:t?t.bson:null,readPreference:ReadPreference.fromOptions(r),bufferMaxEntries:"number"==typeof r.bufferMaxEntries?r.bufferMaxEntries:-1,parentDb:r.parentDb||null,pkFactory:r.pkFactory||ObjectID,nativeParser:r.nativeParser||r.native_parser,promiseLibrary:o,noListener:"boolean"==typeof r.noListener&&r.noListener,readConcern:ReadConcern.fromOptions(r),writeConcern:WriteConcern.fromOptions(r),namespace:new MongoDBNamespace(e)},validateDatabaseName(e),getSingleProperty(this,"serverConfig",this.s.topology),getSingleProperty(this,"bufferMaxEntries",this.s.bufferMaxEntries),getSingleProperty(this,"databaseName",this.s.namespace.db),r.parentDb||this.s.noListener||(t.on("error",createListener(this,"error",this)),t.on("timeout",createListener(this,"timeout",this)),t.on("close",createListener(this,"close",this)),t.on("parseError",createListener(this,"parseError",this)),t.once("open",createListener(this,"open",this)),t.once("fullsetup",createListener(this,"fullsetup",this)),t.once("all",createListener(this,"all",this)),t.on("reconnect",createListener(this,"reconnect",this)))}inherits(Db,EventEmitter),Db.prototype.on=deprecate(function(){return Db.super_.prototype.on.apply(this,arguments)},"Listening to events on the Db class has been deprecated and will be removed in the next major version."),Db.prototype.once=deprecate(function(){return Db.super_.prototype.once.apply(this,arguments)},"Listening to events on the Db class has been deprecated and will be removed in the next major version."),Object.defineProperty(Db.prototype,"topology",{enumerable:!0,get:function(){return this.s.topology}}),Object.defineProperty(Db.prototype,"options",{enumerable:!0,get:function(){return this.s.options}}),Object.defineProperty(Db.prototype,"slaveOk",{enumerable:!0,get:function(){return null!=this.s.options.readPreference&&("primary"!==this.s.options.readPreference||"primary"!==this.s.options.readPreference.mode)}}),Object.defineProperty(Db.prototype,"readConcern",{enumerable:!0,get:function(){return this.s.readConcern}}),Object.defineProperty(Db.prototype,"readPreference",{enumerable:!0,get:function(){return null==this.s.readPreference?ReadPreference.primary:this.s.readPreference}}),Object.defineProperty(Db.prototype,"writeConcern",{enumerable:!0,get:function(){return this.s.writeConcern}}),Object.defineProperty(Db.prototype,"namespace",{enumerable:!0,get:function(){return this.s.namespace.toString()}}),Db.prototype.command=function(e,t,r){"function"==typeof t&&(r=t,t={}),t=Object.assign({},t);t=new RunCommandOperation(this,e,t);return executeOperation(this.s.topology,t,r)},Db.prototype.aggregate=function(e,t,r){"function"==typeof t&&(r=t,t={}),null==t&&null==r&&(t={});t=new AggregationCursor(this.s.topology,new AggregateOperation(this,e,t),t);if("function"!=typeof r)return t;r(null,t)},Db.prototype.admin=function(){const e=require("./admin");return new e(this,this.s.topology,this.s.promiseLibrary)};const COLLECTION_OPTION_KEYS=["pkFactory","readPreference","serializeFunctions","strict","readConcern","ignoreUndefined","promoteValues","promoteBuffers","promoteLongs","bsonRegExp"];Db.prototype.collection=deprecateOptions({name:"Db.collection",deprecatedOptions:["strict"],optionsIndex:1},function(r,o,n){"function"==typeof o&&(n=o,o={}),o=o||{},(o=Object.assign({},o)).promiseLibrary=this.s.promiseLibrary,o.readConcern=o.readConcern?new ReadConcern(o.readConcern.level):this.readConcern,this.s.options.ignoreUndefined&&(o.ignoreUndefined=this.s.options.ignoreUndefined);for(const t of COLLECTION_OPTION_KEYS)t in o||void 0===this.s.options[t]||(o[t]=this.s.options[t]);if(null==(o=conditionallyMergeWriteConcern(o,this.s.options))||!o.strict)try{var e=new Collection(this,this.s.topology,this.databaseName,r,this.s.pkFactory,o);return n&&n(null,e),e}catch(e){if(e instanceof MongoError&&n)return n(e);throw e}if("function"!=typeof n)throw toError(`A callback is required in strict mode. While getting collection ${r}`);if(this.serverConfig&&this.serverConfig.isDestroyed())return n(new MongoError("topology was destroyed"));e=Object.assign({},o,{nameOnly:!0});this.listCollections({name:r},e).toArray((e,t)=>{if(null!=e)return handleCallback(n,e,null);if(0===t.length)return handleCallback(n,toError(`Collection ${r} does not exist. Currently in strict mode.`),null);try{return handleCallback(n,null,new Collection(this,this.s.topology,this.databaseName,r,this.s.pkFactory,o))}catch(e){return handleCallback(n,e,null)}})}),Db.prototype.createCollection=deprecateOptions({name:"Db.createCollection",deprecatedOptions:["autoIndexId","strict","w","wtimeout","j"],optionsIndex:1},function(e,t,r){"function"==typeof t&&(r=t,t={}),(t=t||{}).promiseLibrary=t.promiseLibrary||this.s.promiseLibrary,t.readConcern=t.readConcern?new ReadConcern(t.readConcern.level):this.readConcern;t=new CreateCollectionOperation(this,e,t);return executeOperation(this.s.topology,t,r)}),Db.prototype.stats=function(e,t){"function"==typeof e&&(t=e,e={});const r={dbStats:!0};null!=(e=e||{}).scale&&(r.scale=e.scale),null==e.readPreference&&this.s.readPreference&&(e.readPreference=this.s.readPreference);e=new CommandOperation(this,e,null,r);return executeOperation(this.s.topology,e,t)},Db.prototype.listCollections=function(e,t){return e=e||{},t=t||{},new CommandCursor(this.s.topology,new ListCollectionsOperation(this,e,t),t)},Db.prototype.eval=deprecate(function(e,t,r,o){const n=Array.prototype.slice.call(arguments,1);return o="function"==typeof n[n.length-1]?n.pop():void 0,t=n.length?n.shift():t,r=n.length&&n.shift()||{},executeLegacyOperation(this.s.topology,evaluate,[this,e,t,r,o])},"Db.eval is deprecated as of MongoDB version 3.2"),Db.prototype.renameCollection=function(e,t,r,o){"function"==typeof r&&(o=r,r={}),(r=Object.assign({},r,{readPreference:ReadPreference.PRIMARY})).new_collection=!0;r=new RenameOperation(this.collection(e),t,r);return executeOperation(this.s.topology,r,o)},Db.prototype.dropCollection=function(e,t,r){"function"==typeof t&&(r=t,t={}),t=t||{};t=new DropCollectionOperation(this,e,t);return executeOperation(this.s.topology,t,r)},Db.prototype.dropDatabase=function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new DropDatabaseOperation(this,e);return executeOperation(this.s.topology,e,t)},Db.prototype.collections=function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new CollectionsOperation(this,e);return executeOperation(this.s.topology,e,t)},Db.prototype.executeDbAdminCommand=function(e,t,r){"function"==typeof t&&(r=t,t={}),(t=t||{}).readPreference=ReadPreference.resolve(this,t);t=new ExecuteDbAdminCommandOperation(this,e,t);return executeOperation(this.s.topology,t,r)},Db.prototype.createIndex=function(e,t,r,o){"function"==typeof r&&(o=r,r={}),r=r?Object.assign({},r):{};r=new CreateIndexesOperation(this,e,t,r);return executeOperation(this.s.topology,r,o)},Db.prototype.ensureIndex=deprecate(function(e,t,r,o){return"function"==typeof r&&(o=r,r={}),r=r||{},executeLegacyOperation(this.s.topology,ensureIndex,[this,e,t,r,o])},"Db.ensureIndex is deprecated as of MongoDB version 3.0 / driver version 2.0"),Db.prototype.addChild=function(e){if(this.s.parentDb)return this.s.parentDb.addChild(e);this.s.children.push(e)},Db.prototype.addUser=function(e,t,r,o){"function"==typeof r&&(o=r,r={}),r=r||{},"string"==typeof e&&null!=t&&"object"==typeof t&&(r=t,t=null);r=new AddUserOperation(this,e,t,r);return executeOperation(this.s.topology,r,o)},Db.prototype.removeUser=function(e,t,r){"function"==typeof t&&(r=t,t={}),t=t||{};t=new RemoveUserOperation(this,e,t);return executeOperation(this.s.topology,t,r)},Db.prototype.setProfilingLevel=function(e,t,r){"function"==typeof t&&(r=t,t={}),t=t||{};t=new SetProfilingLevelOperation(this,e,t);return executeOperation(this.s.topology,t,r)},Db.prototype.profilingInfo=deprecate(function(e,t){return"function"==typeof e&&(t=e,e={}),e=e||{},executeLegacyOperation(this.s.topology,profilingInfo,[this,e,t])},"Db.profilingInfo is deprecated. Query the system.profile collection directly."),Db.prototype.profilingLevel=function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new ProfilingLevelOperation(this,e);return executeOperation(this.s.topology,e,t)},Db.prototype.indexInformation=function(e,t,r){"function"==typeof t&&(r=t,t={}),t=t||{};t=new IndexInformationOperation(this,e,t);return executeOperation(this.s.topology,t,r)},Db.prototype.unref=function(){this.s.topology.unref()},Db.prototype.watch=function(e,t){return e=e||[],t=t||{},Array.isArray(e)||(t=e,e=[]),new ChangeStream(this,e,t)},Db.prototype.getLogger=function(){return this.s.logger},Db.SYSTEM_NAMESPACE_COLLECTION=CONSTANTS.SYSTEM_NAMESPACE_COLLECTION,Db.SYSTEM_INDEX_COLLECTION=CONSTANTS.SYSTEM_INDEX_COLLECTION,Db.SYSTEM_PROFILE_COLLECTION=CONSTANTS.SYSTEM_PROFILE_COLLECTION,Db.SYSTEM_USER_COLLECTION=CONSTANTS.SYSTEM_USER_COLLECTION,Db.SYSTEM_COMMAND_COLLECTION=CONSTANTS.SYSTEM_COMMAND_COLLECTION,Db.SYSTEM_JS_COLLECTION=CONSTANTS.SYSTEM_JS_COLLECTION,module.exports=Db;