"use strict";const Transform=require("stream").Transform,PassThrough=require("stream").PassThrough,deprecate=require("util").deprecate,handleCallback=require("./utils").handleCallback,ReadPreference=require("./core").ReadPreference,MongoError=require("./core").MongoError,CoreCursor=require("./core/cursor").CoreCursor,CursorState=require("./core/cursor").CursorState,Map=require("./core").BSON.Map,maybePromise=require("./utils").maybePromise,executeOperation=require("./operations/execute_operation"),formattedOrderClause=require("./utils").formattedOrderClause,Explain=require("./explain").Explain,Aspect=require("./operations/operation").Aspect,each=require("./operations/cursor_ops").each,CountOperation=require("./operations/count"),flags=["tailable","oplogReplay","noCursorTimeout","awaitData","exhaust","partial"],fields=["numberOfRetries","tailableRetryInterval"];class Cursor extends CoreCursor{constructor(r,e,t,s){super(r,e,t,s);r=(s=this.operation?this.operation.options:s).numberOfRetries||5,e=s.tailableRetryInterval||500,t=s.promiseLibrary||Promise;this.s={numberOfRetries:r,tailableRetryInterval:e,currentNumberOfRetries:r,state:CursorState.INIT,promiseLibrary:t,explicitlyIgnoreSession:!!s.explicitlyIgnoreSession},!s.explicitlyIgnoreSession&&s.session&&(this.cursorState.session=s.session),!0===this.options.noCursorTimeout&&this.addCursorFlag("noCursorTimeout",!0);let o=1e3;this.cmd.cursor&&this.cmd.cursor.batchSize?o=this.cmd.cursor.batchSize:s.cursor&&s.cursor.batchSize?o=s.cursor.batchSize:"number"==typeof s.batchSize&&(o=s.batchSize),this.setCursorBatchSize(o)}get readPreference(){return(this.operation||this.options).readPreference}get sortValue(){return this.cmd.sort}set session(r){this.cursorState.session=r}_initializeCursor(r){this.operation&&null!=this.operation.session?this.cursorState.session=this.operation.session:this.s.explicitlyIgnoreSession||this.cursorState.session||!this.topology.hasSessionSupport()||(this.cursorState.session=this.topology.startSession({owner:this}),this.operation&&(this.operation.session=this.cursorState.session)),super._initializeCursor(r)}hasNext(r){if(this.s.state===CursorState.CLOSED||this.isDead&&this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return maybePromise(this,r,t=>{const s=this;if(s.isNotified())return t(null,!1);s._next((r,e)=>r?t(r):null==e||s.s.state===Cursor.CLOSED||s.isDead()?t(null,!1):(s.s.state=CursorState.OPEN,s.cursorState.cursorIndex--,0<s.cursorState.limit&&s.cursorState.currentLimit--,void t(null,!0)))})}next(r){return maybePromise(this,r,t=>{const s=this;if(s.s.state===CursorState.CLOSED||s.isDead&&s.isDead())t(MongoError.create({message:"Cursor is closed",driver:!0}));else{if(s.s.state===CursorState.INIT&&s.cmd.sort)try{s.cmd.sort=formattedOrderClause(s.cmd.sort)}catch(r){return t(r)}s._next((r,e)=>r?t(r):(s.s.state=CursorState.OPEN,void t(null,e)))}})}filter(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.query=r,this}maxScan(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.maxScan=r,this}hint(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.hint=r,this}min(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.min=r,this}max(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.max=r,this}returnKey(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.returnKey=r,this}showRecordId(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.showDiskLoc=r,this}snapshot(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.snapshot=r,this}setCursorOption(r,e){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});if(-1===fields.indexOf(r))throw MongoError.create({message:`option ${r} is not a supported option ${fields}`,driver:!0});return this.s[r]=e,"numberOfRetries"===r&&(this.s.currentNumberOfRetries=e),this}addCursorFlag(r,e){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});if(-1===flags.indexOf(r))throw MongoError.create({message:`flag ${r} is not a supported flag ${flags}`,driver:!0});if("boolean"!=typeof e)throw MongoError.create({message:`flag ${r} must be a boolean value`,driver:!0});return this.cmd[r]=e,this}addQueryModifier(r,e){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});if("$"!==r[0])throw MongoError.create({message:`${r} is not a valid query modifier`,driver:!0});r=r.substr(1);return this.cmd[r]=e,"orderby"===r&&(this.cmd.sort=this.cmd[r]),this}comment(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.comment=r,this}maxAwaitTimeMS(r){if("number"!=typeof r)throw MongoError.create({message:"maxAwaitTimeMS must be a number",driver:!0});if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.maxAwaitTimeMS=r,this}maxTimeMS(r){if("number"!=typeof r)throw MongoError.create({message:"maxTimeMS must be a number",driver:!0});if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.maxTimeMS=r,this}project(r){if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});return this.cmd.fields=r,this}sort(r,e){if(this.options.tailable)throw MongoError.create({message:"Tailable cursor doesn't support sorting",driver:!0});if(this.s.state===CursorState.CLOSED||this.s.state===CursorState.OPEN||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});let t=r;return Array.isArray(t)&&Array.isArray(t[0])&&(t=new Map(t.map(r=>{const e=[r[0],null];if("asc"===r[1])e[1]=1;else if("desc"===r[1])e[1]=-1;else{if(1!==r[1]&&-1!==r[1]&&!r[1].$meta)throw new MongoError("Illegal sort clause, must be of the form [['field1', '(ascending|descending)'], ['field2', '(ascending|descending)']]");e[1]=r[1]}return e}))),null!=e&&(t=[[r,e]]),this.cmd.sort=t,this}batchSize(r){if(this.options.tailable)throw MongoError.create({message:"Tailable cursor doesn't support batchSize",driver:!0});if(this.s.state===CursorState.CLOSED||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});if("number"!=typeof r)throw MongoError.create({message:"batchSize requires an integer",driver:!0});return this.cmd.batchSize=r,this.setCursorBatchSize(r),this}collation(r){return this.cmd.collation=r,this}limit(r){if(this.options.tailable)throw MongoError.create({message:"Tailable cursor doesn't support limit",driver:!0});if(this.s.state===CursorState.OPEN||this.s.state===CursorState.CLOSED||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});if("number"!=typeof r)throw MongoError.create({message:"limit requires an integer",driver:!0});return this.cmd.limit=r,this.setCursorLimit(r),this}skip(r){if(this.options.tailable)throw MongoError.create({message:"Tailable cursor doesn't support skip",driver:!0});if(this.s.state===CursorState.OPEN||this.s.state===CursorState.CLOSED||this.isDead())throw MongoError.create({message:"Cursor is closed",driver:!0});if("number"!=typeof r)throw MongoError.create({message:"skip requires an integer",driver:!0});return this.cmd.skip=r,this.setCursorSkip(r),this}each(r){this.rewind(),this.s.state=CursorState.INIT,each(this,r)}forEach(o,s){if(this.rewind(),this.s.state=CursorState.INIT,"function"!=typeof s)return new this.s.promiseLibrary((t,s)=>{each(this,(r,e)=>{if(r)return s(r),!1;if(null==e)return t(null),!1;try{o(e)}catch(r){return s(r),!1}return!0})});each(this,(r,e)=>{if(r)return s(r),!1;if(null!=e){try{o(e)}catch(r){return s(r),!1}return!0}if(null==e&&s){const t=s;return s=null,t(null),!1}})}setReadPreference(r){if(this.s.state!==CursorState.INIT)throw MongoError.create({message:"cannot change cursor readPreference after cursor has been accessed",driver:!0});if(r instanceof ReadPreference)this.options.readPreference=r;else{if("string"!=typeof r)throw new TypeError("Invalid read preference: "+r);this.options.readPreference=new ReadPreference(r)}return this}toArray(r){if(this.options.tailable)throw MongoError.create({message:"Tailable cursor cannot be converted to array",driver:!0});return maybePromise(this,r,t=>{const s=this,o=[];s.rewind(),s.s.state=CursorState.INIT;const i=()=>{s._next((r,e)=>{return r?handleCallback(t,r):null==e?s.close({skipKillCursors:!0},()=>handleCallback(t,null,o)):(o.push(e),0<s.bufferedCount()&&(e=s.readBufferedDocuments(s.bufferedCount()),Array.prototype.push.apply(o,e)),void i())})};i()})}count(r,e,t){if(null==this.cmd.query)throw MongoError.create({message:"count can only be used with find command",driver:!0});"function"==typeof e&&(t=e,e={}),e=e||{},"function"==typeof r&&(t=r,r=!0),this.cursorState.session&&(e=Object.assign({},e,{session:this.cursorState.session}));e=new CountOperation(this,r,e);return executeOperation(this.topology,e,t)}close(e,r){return"function"==typeof e&&(r=e,e={}),e=Object.assign({},{skipKillCursors:!1},e),maybePromise(this,r,r=>{this.s.state=CursorState.CLOSED,e.skipKillCursors||this.kill(),this._endSession(()=>{this.emit("close"),r(null,this)})})}map(e){if(this.cursorState.transforms&&this.cursorState.transforms.doc){const t=this.cursorState.transforms.doc;this.cursorState.transforms.doc=r=>e(t(r))}else this.cursorState.transforms={doc:e};return this}isClosed(){return this.isDead()}destroy(r){r&&this.emit("error",r),this.pause(),this.close()}stream(r){return this.cursorState.streamOptions=r||{},this}transformStream(r){const s=r||{};if("function"!=typeof s.transform)return this.pipe(new PassThrough({objectMode:!0}));r=new Transform({objectMode:!0,transform:function(r,e,t){this.push(s.transform(r)),t()}});return this.pipe(r)}explain(r,e){if("function"==typeof r&&(e=r,r=!0),void 0===r&&(r=!0),!this.operation||!this.operation.hasAspect(Aspect.EXPLAINABLE))throw new MongoError("This command cannot be explained");return this.operation.explain=new Explain(r),maybePromise(this,e,r=>{CoreCursor.prototype._next.apply(this,[r])})}getLogger(){return this.logger}}Cursor.prototype.maxTimeMs=Cursor.prototype.maxTimeMS,deprecate(Cursor.prototype.each,"Cursor.each is deprecated. Use Cursor.forEach instead."),deprecate(Cursor.prototype.maxScan,"Cursor.maxScan is deprecated, and will be removed in a later version"),deprecate(Cursor.prototype.snapshot,"Cursor Snapshot is deprecated, and will be removed in a later version"),module.exports=Cursor;