"use strict";const URL=require("url"),qs=require("querystring"),dns=require("dns"),MongoParseError=require("./error").MongoParseError,ReadPreference=require("./topologies/read_preference"),emitWarningOnce=require("../utils").emitWarningOnce,HOSTS_RX=/(mongodb(?:\+srv|)):\/\/(?: (?:[^:]*) (?: : ([^@]*) )? @ )?([^/?]*)(?:\/|)(.*)/,FILE_PATH_OPTIONS=new Set(["sslCA","sslCert","sslKey","tlsCAFile","tlsCertificateKeyFile"].map(e=>e.toLowerCase()));function matchesParentDomain(e,r){var t=/^.*?\./;const n=`.${e.replace(t,"")}`;t=`.${r.replace(t,"")}`;return n.endsWith(t)}function parseSrvConnectionString(e,t,n){const s=URL.parse(e,!0);if(t.directConnection||t.directconnection)return n(new MongoParseError("directConnection not supported with SRV URI"));if(s.hostname.split(".").length<3)return n(new MongoParseError("URI does not have hostname, domain name and tld"));s.domainLength=s.hostname.split(".").length;const r=e.substring("mongodb+srv://".length).split("/")[0];if(r.match(","))return n(new MongoParseError("Invalid URI, cannot contain multiple hostnames"));if(s.port)return n(new MongoParseError(`Ports not accepted with '${PROTOCOL_MONGODB_SRV}' URIs`));const o=s.host;dns.resolveSrv(`_mongodb._tcp.${o}`,(e,r)=>{if(e)return n(e);if(0===r.length)return n(new MongoParseError("No addresses found at host"));for(let e=0;e<r.length;e++)if(!matchesParentDomain(r[e].name,s.hostname,s.domainLength))return n(new MongoParseError("Server record does not share hostname with parent URI"));s.protocol="mongodb",s.host=r.map(e=>`${e.name}:${e.port}`).join(","),"ssl"in t||s.search&&"ssl"in s.query&&null!==s.query.ssl||(s.query.ssl=!0),dns.resolveTxt(o,(e,r)=>{if(e){if("ENODATA"!==e.code&&"ENOTFOUND"!==e.code)return n(e);r=null}if(r){if(1<r.length)return n(new MongoParseError("Multiple text records not allowed"));if(r=qs.parse(r[0].join("")),Object.keys(r).some(e=>"loadbalanced"===e.toLowerCase()))return n(new MongoParseError("Load balancer mode requires driver version 4+"));if(Object.keys(r).some(e=>"authSource"!==e&&"replicaSet"!==e))return n(new MongoParseError("Text record must only set `authSource` or `replicaSet`"));s.query=Object.assign({},r,s.query)}s.search=qs.stringify(s.query),parseConnectionString(URL.format(s),t,(e,r)=>{e?n(e):n(null,Object.assign({},r,{srvHost:o}))})})})}function parseQueryStringItemValue(t,n){var e;return Array.isArray(n)?1===(n=n.filter((e,r)=>n.indexOf(e)===r)).length&&(n=n[0]):0<n.indexOf(":")?n=n.split(",").reduce((e,r)=>{r=r.split(":");return e[r[0]]=parseQueryStringItemValue(t,r[1]),e},{}):0<n.indexOf(",")?n=n.split(",").map(e=>parseQueryStringItemValue(t,e)):"true"===n.toLowerCase()||"false"===n.toLowerCase()?n="true"===n.toLowerCase():Number.isNaN(n)||STRING_OPTIONS.has(t)||(e=parseFloat(n),Number.isNaN(e)||(n=parseFloat(n))),n}const BOOLEAN_OPTIONS=new Set(["slaveok","slave_ok","sslvalidate","fsync","safe","retrywrites","j"]),STRING_OPTIONS=new Set(["authsource","replicaset"]),AUTH_MECHANISMS=new Set(["GSSAPI","MONGODB-AWS","MONGODB-X509","MONGODB-CR","DEFAULT","SCRAM-SHA-1","SCRAM-SHA-256","PLAIN"]),CASE_TRANSLATION={replicaset:"replicaSet",connecttimeoutms:"connectTimeoutMS",sockettimeoutms:"socketTimeoutMS",maxpoolsize:"maxPoolSize",minpoolsize:"minPoolSize",maxidletimems:"maxIdleTimeMS",waitqueuemultiple:"waitQueueMultiple",waitqueuetimeoutms:"waitQueueTimeoutMS",wtimeoutms:"wtimeoutMS",readconcern:"readConcern",readconcernlevel:"readConcernLevel",readpreference:"readPreference",maxstalenessseconds:"maxStalenessSeconds",readpreferencetags:"readPreferenceTags",authsource:"authSource",authmechanism:"authMechanism",authmechanismproperties:"authMechanismProperties",gssapiservicename:"gssapiServiceName",localthresholdms:"localThresholdMS",serverselectiontimeoutms:"serverSelectionTimeoutMS",serverselectiontryonce:"serverSelectionTryOnce",heartbeatfrequencyms:"heartbeatFrequencyMS",retrywrites:"retryWrites",uuidrepresentation:"uuidRepresentation",zlibcompressionlevel:"zlibCompressionLevel",tlsallowinvalidcertificates:"tlsAllowInvalidCertificates",tlsallowinvalidhostnames:"tlsAllowInvalidHostnames",tlsinsecure:"tlsInsecure",tlscafile:"tlsCAFile",tlscertificatekeyfile:"tlsCertificateKeyFile",tlscertificatekeyfilepassword:"tlsCertificateKeyFilePassword",wtimeout:"wTimeoutMS",j:"journal",directconnection:"directConnection"};function applyConnectionStringOption(e,r,t,n){if("journal"===r?r="j":"wtimeoutms"===r&&(r="wtimeout"),BOOLEAN_OPTIONS.has(r)?t="true"===t||!0===t:"appname"===r?t=decodeURIComponent(t):"readconcernlevel"===r&&(r="readconcern",t={level:e.readConcernLevel=t}),"compressors"===r&&!(t=Array.isArray(t)?t:[t]).every(e=>"snappy"===e||"zlib"===e))throw new MongoParseError("Value for `compressors` must be at least one of: `snappy`, `zlib`");if("authmechanism"===r&&!AUTH_MECHANISMS.has(t))throw new MongoParseError(`Value for authMechanism must be one of: ${Array.from(AUTH_MECHANISMS).join(", ")}, found: ${t}`);if("readpreference"===r&&!ReadPreference.isValid(t))throw new MongoParseError("Value for `readPreference` must be one of: `primary`, `primaryPreferred`, `secondary`, `secondaryPreferred`, `nearest`");if("zlibcompressionlevel"===r&&(t<-1||9<t))throw new MongoParseError("zlibCompressionLevel must be an integer between -1 and 9");"compressors"!==r&&"zlibcompressionlevel"!==r||(e.compression=e.compression||{},e=e.compression),"authmechanismproperties"===r&&("string"==typeof t.SERVICE_NAME&&(e.gssapiServiceName=t.SERVICE_NAME),"string"==typeof t.SERVICE_REALM&&(e.gssapiServiceRealm=t.SERVICE_REALM),void 0!==t.CANONICALIZE_HOST_NAME&&(e.gssapiCanonicalizeHostName=t.CANONICALIZE_HOST_NAME)),"readpreferencetags"===r&&(t=Array.isArray(t)?splitArrayOfMultipleReadPreferenceTags(t):[t]),n.caseTranslate&&CASE_TRANSLATION[r]?e[CASE_TRANSLATION[r]]=t:e[r]=t}const USERNAME_REQUIRED_MECHANISMS=new Set(["GSSAPI","MONGODB-CR","PLAIN","SCRAM-SHA-1","SCRAM-SHA-256"]);function splitArrayOfMultipleReadPreferenceTags(e){const t=[];for(let r=0;r<e.length;r++)t[r]={},e[r].split(",").forEach(e=>{e=e.split(":");t[r][e[0]]=e[1]});return t}function applyAuthExpectations(e){if(null!=e.options){var r=e.options,t=r.authsource||r.authSource;null!=t&&(e.auth=Object.assign({},e.auth,{db:t}));r=r.authmechanism||r.authMechanism;if(null!=r){if(USERNAME_REQUIRED_MECHANISMS.has(r)&&(!e.auth||null==e.auth.username))throw new MongoParseError(`Username required for mechanism \`${r}\``);if("GSSAPI"===r){if(null!=t&&"$external"!==t)throw new MongoParseError(`Invalid source \`${t}\` for mechanism \`${r}\` specified.`);e.auth=Object.assign({},e.auth,{db:"$external"})}if("MONGODB-AWS"===r){if(null!=t&&"$external"!==t)throw new MongoParseError(`Invalid source \`${t}\` for mechanism \`${r}\` specified.`);e.auth=Object.assign({},e.auth,{db:"$external"})}if("MONGODB-X509"===r){if(e.auth&&null!=e.auth.password)throw new MongoParseError(`Password not allowed for mechanism \`${r}\``);if(null!=t&&"$external"!==t)throw new MongoParseError(`Invalid source \`${t}\` for mechanism \`${r}\` specified.`);e.auth=Object.assign({},e.auth,{db:"$external"})}"PLAIN"===r&&e.auth&&null==e.auth.db&&(e.auth=Object.assign({},e.auth,{db:"$external"}))}return e.auth&&null==e.auth.db&&(e.auth=Object.assign({},e.auth,{db:"admin"})),e}}function parseQueryString(e,r){const t={};var n=qs.parse(e);checkTLSOptions(n);for(const a in n){var s=n[a];if(""===s||null==s)throw new MongoParseError("Incomplete key value pair for option");var o=a.toLowerCase();if("serverapi"===o)throw new MongoParseError("URI cannot contain `serverApi`, it can only be passed to the client");s=FILE_PATH_OPTIONS.has(o)?s:parseQueryStringItemValue(o,s);applyConnectionStringOption(t,o,s,r)}return t.wtimeout&&t.wtimeoutms&&(delete t.wtimeout,emitWarningOnce("Unsupported option `wtimeout` specified")),Object.keys(t).length?t:null}function translateTLSOptions(e){return e.tls&&(e.ssl=e.tls),e.tlsInsecure?(e.checkServerIdentity=!1,e.sslValidate=!1):Object.assign(e,{checkServerIdentity:!e.tlsAllowInvalidHostnames,sslValidate:!e.tlsAllowInvalidCertificates}),e.tlsCAFile&&(e.ssl=!0,e.sslCA=e.tlsCAFile),e.tlsCertificateKeyFile&&(e.ssl=!0,e.tlsCertificateFile?(e.sslCert=e.tlsCertificateFile,e.sslKey=e.tlsCertificateKeyFile):(e.sslKey=e.tlsCertificateKeyFile,e.sslCert=e.tlsCertificateKeyFile)),e.tlsCertificateKeyFilePassword&&(e.ssl=!0,e.sslPass=e.tlsCertificateKeyFilePassword),e}function checkTLSOptions(e){const r=Object.keys(e);if(-1!==r.indexOf("tlsInsecure")&&(-1!==r.indexOf("tlsAllowInvalidCertificates")||-1!==r.indexOf("tlsAllowInvalidHostnames")))throw new MongoParseError("The `tlsInsecure` option cannot be used with `tlsAllowInvalidCertificates` or `tlsAllowInvalidHostnames`.");var t=assertTlsOptionsAreEqual("tls",e,r),e=assertTlsOptionsAreEqual("ssl",e,r);if(null!=t&&null!=e&&t!==e)throw new MongoParseError("All values of `tls` and `ssl` must be the same.")}function assertTlsOptionsAreEqual(r,e,t){t=-1!==t.indexOf(r);let n;if(n=Array.isArray(e[r])?e[r][0]:e[r],t&&Array.isArray(e[r])){const s=e[r][0];e[r].forEach(e=>{if(e!==s)throw new MongoParseError(`All values of ${r} must be the same.`)})}return n}const PROTOCOL_MONGODB="mongodb",PROTOCOL_MONGODB_SRV="mongodb+srv",SUPPORTED_PROTOCOLS=[PROTOCOL_MONGODB,PROTOCOL_MONGODB_SRV];function parseConnectionString(e,r,t){"function"==typeof r&&(t=r,r={}),r=Object.assign({},{caseTranslate:!0},r);try{URL.parse(e)}catch(e){return t(new MongoParseError("URI malformed, cannot be parsed"))}const n=e.match(HOSTS_RX);if(!n)return t(new MongoParseError("Invalid connection string"));var s=n[1];if(-1===SUPPORTED_PROTOCOLS.indexOf(s))return t(new MongoParseError("Invalid protocol provided"));var o=n[4].split("?"),a=0<o.length?o[0]:null,o=1<o.length?o[1]:null;let i;try{i=parseQueryString(o,r)}catch(e){return t(e)}if(i=Object.assign({},i,r),Object.keys(i).some(e=>"loadbalanced"===e.toLowerCase()))return t(new MongoParseError("Load balancer mode requires driver version 4+"));if(s===PROTOCOL_MONGODB_SRV)return parseSrvConnectionString(e,i,t);const l={username:null,password:null,db:a&&""!==a?qs.unescape(a):null};if(i.auth?(i.auth.username&&(l.username=i.auth.username),i.auth.user&&(l.username=i.auth.user),i.auth.password&&(l.password=i.auth.password)):(i.username&&(l.username=i.username),i.user&&(l.username=i.user),i.password&&(l.password=i.password)),-1!==n[4].split("?")[0].indexOf("@"))return t(new MongoParseError("Unescaped slash in userinfo section"));const u=n[3].split("@");if(2<u.length)return t(new MongoParseError("Unescaped at-sign in authority section"));if(null==u[0]||""===u[0])return t(new MongoParseError("No username provided in authority section"));if(1<u.length){var c=u.shift().split(":");if(2<c.length)return t(new MongoParseError("Unescaped colon in authority section"));if(""===c[0])return t(new MongoParseError("Invalid empty username provided"));l.username||(l.username=qs.unescape(c[0])),l.password||(l.password=c[1]?qs.unescape(c[1]):null)}let p=null;c=u.shift().split(",").map(e=>{let r=URL.parse(`mongodb://${e}`);if("/:"===r.path)return p=new MongoParseError("Double colon in host identifier"),null;if(e.match(/\.sock/)&&(r.hostname=qs.unescape(e),r.port=null),Number.isNaN(r.port))p=new MongoParseError("Invalid port (non-numeric string)");else{e={host:r.hostname,port:r.port?parseInt(r.port):27017};if(0!==e.port)if(65535<e.port)p=new MongoParseError("Invalid port (larger than 65535) with hostname");else{if(!(e.port<0))return e;p=new MongoParseError("Invalid port (negative number)")}else p=new MongoParseError("Invalid port (zero) with hostname")}}).filter(e=>!!e);if(p)return t(p);if(0===c.length||""===c[0].host||null===c[0].host)return t(new MongoParseError("No hostname or hostnames provided in connection string"));if(!!i.directConnection&&1!==c.length)return t(new MongoParseError("directConnection option requires exactly one host"));null==i.directConnection&&1===c.length&&null==i.replicaSet&&(i.directConnection=!0);const d={hosts:c,auth:l.db||l.username?l:null,options:Object.keys(i).length?i:null};d.auth&&d.auth.db?d.defaultDatabase=d.auth.db:d.defaultDatabase="test",d.options=translateTLSOptions(d.options);try{applyAuthExpectations(d)}catch(e){return t(e)}t(null,d)}module.exports=parseConnectionString;