"use strict";const MongoError=require("./error").MongoError,ReadPreference=require("./topologies/read_preference"),ReadConcern=require("../read_concern"),WriteConcern=require("../write_concern");let TxnState,stateMachine;(()=>{var e="NO_TRANSACTION",t="STARTING_TRANSACTION",r="TRANSACTION_IN_PROGRESS",n="TRANSACTION_COMMITTED",T="TRANSACTION_COMMITTED_EMPTY",i="TRANSACTION_ABORTED";TxnState={NO_TRANSACTION:e,STARTING_TRANSACTION:t,TRANSACTION_IN_PROGRESS:r,TRANSACTION_COMMITTED:n,TRANSACTION_COMMITTED_EMPTY:T,TRANSACTION_ABORTED:i},stateMachine={NO_TRANSACTION:[e,t],STARTING_TRANSACTION:[r,n,T,i],TRANSACTION_IN_PROGRESS:[r,n,i],TRANSACTION_COMMITTED:[n,T,t,e],TRANSACTION_ABORTED:[t,e],TRANSACTION_COMMITTED_EMPTY:[T,e]}})();class Transaction{constructor(e){e=e||{},this.state=TxnState.NO_TRANSACTION,this.options={};var t=WriteConcern.fromOptions(e);if(t){if(t.w<=0)throw new MongoError("Transactions do not support unacknowledged write concern");this.options.writeConcern=t}e.readConcern&&(this.options.readConcern=ReadConcern.fromOptions(e)),e.readPreference&&(this.options.readPreference=ReadPreference.fromOptions(e)),e.maxCommitTimeMS&&(this.options.maxTimeMS=e.maxCommitTimeMS),this._pinnedServer=void 0,this._recoveryToken=void 0}get server(){return this._pinnedServer}get recoveryToken(){return this._recoveryToken}get isPinned(){return!!this.server}get isActive(){return-1!==[TxnState.STARTING_TRANSACTION,TxnState.TRANSACTION_IN_PROGRESS].indexOf(this.state)}transition(e){const t=stateMachine[this.state];if(t&&-1!==t.indexOf(e))return this.state=e,void(this.state!==TxnState.NO_TRANSACTION&&this.state!==TxnState.STARTING_TRANSACTION&&this.state!==TxnState.TRANSACTION_ABORTED||this.unpinServer());throw new MongoError(`Attempted illegal state transition from [${this.state}] to [${e}]`)}pinServer(e){this.isActive&&(this._pinnedServer=e)}unpinServer(){this._pinnedServer=void 0}}function isTransactionCommand(e){return!(!e.commitTransaction&&!e.abortTransaction)}module.exports={TxnState:TxnState,Transaction:Transaction,isTransactionCommand:isTransactionCommand};