"use strict";const MONGODB_ERROR_CODES=require("../../error_codes").MONGODB_ERROR_CODES,ReadPreference=require("./read_preference"),TopologyType=require("../sdam/common").TopologyType,MongoError=require("../error").MongoError,isRetryableWriteError=require("../error").isRetryableWriteError,maxWireVersion=require("../utils").maxWireVersion,MongoNetworkError=require("../error").MongoNetworkError,MMAPv1_RETRY_WRITES_ERROR_CODE=MONGODB_ERROR_CODES.IllegalOperation;function emitSDAMEvent(e,r,o){0<e.listeners(r).length&&e.emit(r,o)}function createCompressionInfo(e){return e.compression&&e.compression.compressors?(e.compression.compressors.forEach(function(e){if("snappy"!==e&&"zlib"!==e)throw new Error("compressors must be at least one of snappy or zlib")}),e.compression.compressors):[]}function clone(e){return JSON.parse(JSON.stringify(e))}var getPreviousDescription=function(e){return e.s.serverDescription||(e.s.serverDescription={address:e.name,arbiters:[],hosts:[],passives:[],type:"Unknown"}),e.s.serverDescription},emitServerDescriptionChanged=function(e,r){0<e.listeners("serverDescriptionChanged").length&&(e.emit("serverDescriptionChanged",{topologyId:-1!==e.s.topologyId?e.s.topologyId:e.id,address:e.name,previousDescription:getPreviousDescription(e),newDescription:r}),e.s.serverDescription=r)},getPreviousTopologyDescription=function(e){return e.s.topologyDescription||(e.s.topologyDescription={topologyType:"Unknown",servers:[{address:e.name,arbiters:[],hosts:[],passives:[],type:"Unknown"}]}),e.s.topologyDescription},emitTopologyDescriptionChanged=function(e,r){0<e.listeners("topologyDescriptionChanged").length&&(e.emit("topologyDescriptionChanged",{topologyId:-1!==e.s.topologyId?e.s.topologyId:e.id,address:e.name,previousDescription:getPreviousTopologyDescription(e),newDescription:r}),e.s.serverDescription=r)},changedIsMaster=function(e,r,o){r=getTopologyType(e,r);return getTopologyType(e,o)!==r},getTopologyType=function(e,r){return(r=r||e.ismaster)?r.ismaster&&"isdbgrid"===r.msg?"Mongos":r.ismaster&&!r.hosts?"Standalone":r.ismaster?"RSPrimary":r.secondary?"RSSecondary":r.arbiterOnly?"RSArbiter":"Unknown":"Unknown"},inquireServerState=function(n){return function(s){var t;"destroyed"!==n.s.state&&(t=(new Date).getTime(),emitSDAMEvent(n,"serverHeartbeatStarted",{connectionId:n.name}),n.command("admin.$cmd",{ismaster:!0},{monitoring:!0},function(e,r){var o;return e?emitSDAMEvent(n,"serverHeartbeatFailed",{durationMS:o,failure:e,connectionId:n.name}):(n.emit("ismaster",r,n),o=(new Date).getTime()-t,emitSDAMEvent(n,"serverHeartbeatSucceeded",{durationMS:o,reply:r.result,connectionId:n.name}),changedIsMaster(n,n.s.ismaster,r.result)&&emitServerDescriptionChanged(n,{address:n.name,arbiters:[],hosts:[],passives:[],type:n.s.inTopology?getTopologyType(n):"Standalone"}),n.s.ismaster=r.result,n.s.isMasterLatencyMS=o),"function"==typeof s?s(e,r):void(n.s.inquireServerStateTimeout=setTimeout(inquireServerState(n),n.s.haInterval))}))}},cloneOptions=function(e){var r,o={};for(r in e)o[r]=e[r];return o};function Interval(e,r){var o=!1;this.start=function(){return this.isRunning()||(o=setInterval(e,r)),this},this.stop=function(){return clearInterval(o),o=!1,this},this.isRunning=function(){return!1!==o}}function Timeout(e,r){var o=!1,s=()=>{o&&(clearTimeout(o),o=!1,e())};this.start=function(){return this.isRunning()||(o=setTimeout(s,r)),this},this.stop=function(){return clearTimeout(o),o=!1,this},this.isRunning=function(){return!1!==o}}function diff(e,r){var o={servers:[]};e=e||{servers:[]};for(var s=0;s<e.servers.length;s++){for(var t=!1,n=0;n<r.servers.length;n++)if(r.servers[n].address.toLowerCase()===e.servers[s].address.toLowerCase()){t=!0;break}t||o.servers.push({address:e.servers[s].address,from:e.servers[s].type,to:"Unknown"})}for(n=0;n<r.servers.length;n++){for(t=!1,s=0;s<e.servers.length;s++)if(e.servers[s].address.toLowerCase()===r.servers[n].address.toLowerCase()){t=!0;break}t||o.servers.push({address:r.servers[n].address,from:"Unknown",to:r.servers[n].type})}for(s=0;s<e.servers.length;s++)for(var i=e.servers[s],n=0;n<r.servers.length;n++){var a=r.servers[n];i.address.toLowerCase()===a.address.toLowerCase()&&i.type!==a.type&&o.servers.push({address:i.address,from:i.type,to:a.type})}return o}function resolveClusterTime(e,r){(null==e.clusterTime||r.clusterTime.greaterThan(e.clusterTime.clusterTime))&&(e.clusterTime=r)}const SessionMixins={endSessions:function(e,r){Array.isArray(e)||(e=[e]),this.command("admin.$cmd",{endSessions:e},{readPreference:ReadPreference.primaryPreferred},()=>{"function"==typeof r&&r()})}};function topologyType(e){return e.description?e.description.type:"mongos"===e.type?TopologyType.Sharded:"replset"===e.type?TopologyType.ReplicaSetWithPrimary:TopologyType.Single}const RETRYABLE_WIRE_VERSION=6,isRetryableWritesSupported=function(e){return!(e.lastIsMaster().maxWireVersion<RETRYABLE_WIRE_VERSION)&&(!!e.logicalSessionTimeoutMinutes&&topologyType(e)!==TopologyType.Single)},MMAPv1_RETRY_WRITES_ERROR_MESSAGE="This MongoDB deployment does not support retryable writes. Please add retryWrites=false to your connection string.";function getMMAPError(e){return e.code===MMAPv1_RETRY_WRITES_ERROR_CODE&&e.errmsg.includes("Transaction numbers")?new MongoError({message:MMAPv1_RETRY_WRITES_ERROR_MESSAGE,errmsg:MMAPv1_RETRY_WRITES_ERROR_MESSAGE,originalError:e}):e}function legacyIsRetryableWriteError(e,r){return e instanceof MongoError&&(isRetryableWritesSupported(r)&&(e instanceof MongoNetworkError||maxWireVersion(r)<9&&isRetryableWriteError(e))&&e.addErrorLabel("RetryableWriteError"),e.hasErrorLabel("RetryableWriteError"))}module.exports={SessionMixins:SessionMixins,resolveClusterTime:resolveClusterTime,inquireServerState:inquireServerState,getTopologyType:getTopologyType,emitServerDescriptionChanged:emitServerDescriptionChanged,emitTopologyDescriptionChanged:emitTopologyDescriptionChanged,cloneOptions:cloneOptions,createCompressionInfo:createCompressionInfo,clone:clone,diff:diff,Interval:Interval,Timeout:Timeout,isRetryableWritesSupported:isRetryableWritesSupported,getMMAPError:getMMAPError,topologyType:topologyType,legacyIsRetryableWriteError:legacyIsRetryableWriteError};