"use strict";var inherits=require("util").inherits,f=require("util").format,EventEmitter=require("events").EventEmitter,ReadPreference=require("./read_preference"),Logger=require("../connection/logger"),debugOptions=require("../connection/utils").debugOptions,retrieveBSON=require("../connection/utils").retrieveBSON,Pool=require("../connection/pool"),MongoError=require("../error").MongoError,MongoNetworkError=require("../error").MongoNetworkError,wireProtocol=require("../wireprotocol"),CoreCursor=require("../cursor").CoreCursor,sdam=require("./shared"),createCompressionInfo=require("./shared").createCompressionInfo,resolveClusterTime=require("./shared").resolveClusterTime,SessionMixins=require("./shared").SessionMixins,extractCommand=require("../../command_utils").extractCommand,relayEvents=require("../utils").relayEvents;const collationNotSupported=require("../utils").collationNotSupported,makeClientMetadata=require("../utils").makeClientMetadata;var debugFields=["reconnect","reconnectTries","reconnectInterval","emitError","cursorFactory","host","port","size","keepAlive","keepAliveInitialDelay","noDelay","connectionTimeout","checkServerIdentity","socketTimeout","ssl","ca","crl","cert","key","rejectUnauthorized","promoteLongs","promoteValues","promoteBuffers","bsonRegExp","servername"],id=0,serverAccounting=!1,servers={},BSON=retrieveBSON();function topologyId(e){return(null==e.s.parent?e:e.s.parent).id}var Server=function(e){e=e||{},EventEmitter.call(this),this.id=id++,this.s={options:Object.assign({metadata:makeClientMetadata(e)},e),logger:Logger("Server",e),Cursor:e.cursorFactory||CoreCursor,bson:e.bson||new BSON([BSON.Binary,BSON.Code,BSON.DBRef,BSON.Decimal128,BSON.Double,BSON.Int32,BSON.Long,BSON.Map,BSON.MaxKey,BSON.MinKey,BSON.ObjectId,BSON.BSONRegExp,BSON.Symbol,BSON.Timestamp]),pool:null,disconnectHandler:e.disconnectHandler,monitoring:"boolean"!=typeof e.monitoring||e.monitoring,inTopology:!!e.parent,monitoringInterval:"number"==typeof e.monitoringInterval?e.monitoringInterval:5e3,compression:{compressors:createCompressionInfo(e)},parent:e.parent},this.s.parent||(this.s.clusterTime=null),this.ismaster=null,this.lastIsMasterMS=-1,this.monitoringProcessId=null,this.initialConnect=!0,this._type="server",this.lastUpdateTime=0,this.lastWriteDate=0,this.staleness=0};function disconnectHandler(e,o,r,t,n,s){return e.s.pool.isConnected()||!e.s.options.reconnect||null==e.s.disconnectHandler||n.monitoring?e.s.pool.isConnected()?void 0:(s(new MongoError(f("no connection available to server %s",e.name))),!0):(e.s.disconnectHandler.add(o,r,t,n,s),!0)}function monitoringProcess(t){return function(){var r;t.s.pool.isDestroyed()||(t.emit("monitoring",t),r=(new Date).getTime(),t.command("admin.$cmd",{ismaster:!0},{socketTimeout:"number"!=typeof t.s.options.connectionTimeout?2e3:t.s.options.connectionTimeout,monitoring:!0},(e,o)=>{t.lastIsMasterMS=(new Date).getTime()-r,t.s.pool.isDestroyed()||(o&&(t.ismaster=o.result),t.monitoringProcessId=setTimeout(monitoringProcess(t),t.s.monitoringInterval))}))}}inherits(Server,EventEmitter),Object.assign(Server.prototype,SessionMixins),Object.defineProperty(Server.prototype,"type",{enumerable:!0,get:function(){return this._type}}),Object.defineProperty(Server.prototype,"parserType",{enumerable:!0,get:function(){return BSON.native?"c++":"js"}}),Object.defineProperty(Server.prototype,"logicalSessionTimeoutMinutes",{enumerable:!0,get:function(){return this.ismaster&&this.ismaster.logicalSessionTimeoutMinutes||null}}),Object.defineProperty(Server.prototype,"clientMetadata",{enumerable:!0,get:function(){return this.s.options.metadata}}),Object.defineProperty(Server.prototype,"clusterTime",{enumerable:!0,set:function(e){var o=this.s.parent||this.s;resolveClusterTime(o,e)},get:function(){return(this.s.parent||this.s).clusterTime||null}}),Server.enableServerAccounting=function(){serverAccounting=!0,servers={}},Server.disableServerAccounting=function(){serverAccounting=!1},Server.servers=function(){return servers},Object.defineProperty(Server.prototype,"name",{enumerable:!0,get:function(){return this.s.options.host+":"+this.s.options.port}});var eventHandler=function(t,n){return function(e,o){var r;if(t.s.logger.isInfo()&&(r=e instanceof MongoError?JSON.stringify(e):{},t.s.logger.info(f("server %s fired event %s out with message %s",t.name,n,r))),"connect"===n)t.initialConnect=!1,t.ismaster=o.ismaster,t.lastIsMasterMS=o.lastIsMasterMS,o.agreedCompressor&&(t.s.pool.options.agreedCompressor=o.agreedCompressor),o.zlibCompressionLevel&&(t.s.pool.options.zlibCompressionLevel=o.zlibCompressionLevel),o.ismaster.$clusterTime&&(o=o.ismaster.$clusterTime,t.clusterTime=o),"isdbgrid"===t.ismaster.msg&&(t._type="mongos"),t.s.monitoring&&(t.monitoringProcessId=setTimeout(monitoringProcess(t),t.s.monitoringInterval)),sdam.emitServerDescriptionChanged(t,{address:t.name,arbiters:[],hosts:[],passives:[],type:sdam.getTopologyType(t)}),t.s.inTopology||sdam.emitTopologyDescriptionChanged(t,{topologyType:"Single",servers:[{address:t.name,arbiters:[],hosts:[],passives:[],type:sdam.getTopologyType(t)}]}),t.s.logger.isInfo()&&t.s.logger.info(f("server %s connected with ismaster [%s]",t.name,JSON.stringify(t.ismaster))),t.emit("connect",t);else if("error"===n||"parseError"===n||"close"===n||"timeout"===n||"reconnect"===n||"attemptReconnect"===n||"reconnectFailed"===n)return serverAccounting&&-1!==["close","timeout","error","parseError","reconnectFailed"].indexOf(n)&&(t.s.inTopology||t.emit("topologyOpening",{topologyId:t.id}),delete servers[t.id]),"close"===n&&sdam.emitServerDescriptionChanged(t,{address:t.name,arbiters:[],hosts:[],passives:[],type:"Unknown"}),"reconnectFailed"===n?(t.emit("reconnectFailed",e),void(0<t.listeners("error").length&&t.emit("error",e))):-1!==["disconnected","connecting"].indexOf(t.s.pool.state)&&t.initialConnect&&-1!==["close","timeout","error","parseError"].indexOf(n)?(t.initialConnect=!1,t.emit("error",new MongoNetworkError(f("failed to connect to server [%s] on first connect [%s]",t.name,e)))):"reconnect"===n?(sdam.emitServerDescriptionChanged(t,{address:t.name,arbiters:[],hosts:[],passives:[],type:sdam.getTopologyType(t)}),t.emit(n,t)):void t.emit(n,e)}};function basicWriteValidations(e){return e.s.pool?e.s.pool.isDestroyed()?new MongoError("server instance pool was destroyed"):void 0:new MongoError("server instance is not connected")}function basicReadValidations(e,o){if(basicWriteValidations(e,o),o.readPreference&&!(o.readPreference instanceof ReadPreference))throw new Error("readPreference must be an instance of ReadPreference")}Server.prototype.connect=function(e){var o=this;if(e=e||{},serverAccounting&&(servers[this.id]=this),o.s.pool&&!o.s.pool.isDisconnected()&&!o.s.pool.isDestroyed())throw new MongoError(f("server instance in invalid state %s",o.s.pool.state));o.s.pool=new Pool(this,Object.assign(o.s.options,e,{bson:this.s.bson})),o.s.pool.on("close",eventHandler(o,"close")),o.s.pool.on("error",eventHandler(o,"error")),o.s.pool.on("timeout",eventHandler(o,"timeout")),o.s.pool.on("parseError",eventHandler(o,"parseError")),o.s.pool.on("connect",eventHandler(o,"connect")),o.s.pool.on("reconnect",eventHandler(o,"reconnect")),o.s.pool.on("reconnectFailed",eventHandler(o,"reconnectFailed")),relayEvents(o.s.pool,o,["commandStarted","commandSucceeded","commandFailed"]),o.s.inTopology||this.emit("topologyOpening",{topologyId:topologyId(o)}),o.emit("serverOpening",{topologyId:topologyId(o),address:o.name}),o.s.pool.connect()},Server.prototype.auth=function(e,o){"function"==typeof o&&o(null,null)},Server.prototype.getDescription=function(){var e=this.ismaster||{},o={type:sdam.getTopologyType(this),address:this.name};return e.hosts&&(o.hosts=e.hosts),e.arbiters&&(o.arbiters=e.arbiters),e.passives&&(o.passives=e.passives),e.setName&&(o.setName=e.setName),o},Server.prototype.lastIsMaster=function(){return this.ismaster},Server.prototype.unref=function(){this.s.pool.unref()},Server.prototype.isConnected=function(){return!!this.s.pool&&this.s.pool.isConnected()},Server.prototype.isDestroyed=function(){return!!this.s.pool&&this.s.pool.isDestroyed()},Server.prototype.command=function(e,o,r,t){var n=this;"function"==typeof r&&(t=r,r=(r={})||{});var s=basicReadValidations(n,r);return s?t(s):(r=Object.assign({},r,{wireProtocolCommand:!1}),n.s.logger.isDebug()&&(s=extractCommand(o),n.s.logger.debug(f("executing command [%s] against %s",JSON.stringify({ns:e,cmd:s.shouldRedact?`${s.name} details REDACTED`:o,options:debugOptions(debugFields,r)}),n.name))),disconnectHandler(n,"command",e,o,r,t)?void 0:collationNotSupported(this,o)?t(new MongoError(`server ${this.name} does not support collation`)):void wireProtocol.command(n,e,o,r,t))},Server.prototype.query=function(e,o,r,t,n){wireProtocol.query(this,e,o,r,t,n)},Server.prototype.getMore=function(e,o,r,t,n){wireProtocol.getMore(this,e,o,r,t,n)},Server.prototype.killCursors=function(e,o,r){wireProtocol.killCursors(this,e,o,r)},Server.prototype.insert=function(e,o,r,t){"function"==typeof r&&(t=r,r=(r={})||{});var n=basicWriteValidations(this,r);return n?t(n):disconnectHandler(this,"insert",e,o,r,t)?void 0:(o=Array.isArray(o)?o:[o],wireProtocol.insert(this,e,o,r,t))},Server.prototype.update=function(e,o,r,t){"function"==typeof r&&(t=r,r=(r={})||{});var n=basicWriteValidations(this,r);return n?t(n):disconnectHandler(this,"update",e,o,r,t)?void 0:collationNotSupported(this,r)?t(new MongoError(`server ${this.name} does not support collation`)):(o=Array.isArray(o)?o:[o],wireProtocol.update(this,e,o,r,t))},Server.prototype.remove=function(e,o,r,t){"function"==typeof r&&(t=r,r=(r={})||{});var n=basicWriteValidations(this,r);return n?t(n):disconnectHandler(this,"remove",e,o,r,t)?void 0:collationNotSupported(this,r)?t(new MongoError(`server ${this.name} does not support collation`)):(o=Array.isArray(o)?o:[o],wireProtocol.remove(this,e,o,r,t))},Server.prototype.cursor=function(e,o,r){var t=(r=r||{}).topology||this;return new(r.cursorFactory||this.s.Cursor)(t,e,o,r)},Server.prototype.equals=function(e){return"string"==typeof e?this.name.toLowerCase()===e.toLowerCase():!!e.name&&this.name.toLowerCase()===e.name.toLowerCase()},Server.prototype.connections=function(){return this.s.pool.allConnections()},Server.prototype.selectServer=function(e,o,r){"function"==typeof e&&void 0===r&&(r=e,e=void 0,o={}),"function"==typeof o&&(r=o,o=e,e=void 0),r(null,this)};var listeners=["close","error","timeout","parseError","connect"];Server.prototype.destroy=function(e,o){if(this._destroyed)"function"==typeof o&&o(null,null);else{"function"==typeof e&&(o=e,e={}),e=e||{};var r=this;if(serverAccounting&&delete servers[this.id],this.monitoringProcessId&&clearTimeout(this.monitoringProcessId),!r.s.pool||this._destroyed)return this._destroyed=!0,void("function"==typeof o&&o(null,null));this._destroyed=!0,e.emitClose&&r.emit("close",r),e.emitDestroy&&r.emit("destroy",r),listeners.forEach(function(e){r.s.pool.removeAllListeners(e)}),0<r.listeners("serverClosed").length&&r.emit("serverClosed",{topologyId:topologyId(r),address:r.name}),0<r.listeners("topologyClosed").length&&!r.s.inTopology&&r.emit("topologyClosed",{topologyId:topologyId(r)}),r.s.logger.isDebug()&&r.s.logger.debug(f("destroy called on server %s",r.name)),this.s.pool.destroy(e.force,o)}},module.exports=Server;