"use strict";var inherits=require("util").inherits,f=require("util").format,diff=require("./shared").diff,EventEmitter=require("events").EventEmitter,Logger=require("../connection/logger"),ReadPreference=require("./read_preference"),MongoError=require("../error").MongoError,Buffer=require("safe-buffer").Buffer,TopologyType={Single:"Single",ReplicaSetNoPrimary:"ReplicaSetNoPrimary",ReplicaSetWithPrimary:"ReplicaSetWithPrimary",Sharded:"Sharded",Unknown:"Unknown"},ServerType={Standalone:"Standalone",Mongos:"Mongos",PossiblePrimary:"PossiblePrimary",RSPrimary:"RSPrimary",RSSecondary:"RSSecondary",RSArbiter:"RSArbiter",RSOther:"RSOther",RSGhost:"RSGhost",Unknown:"Unknown"},ReplSetState=function(e){e=e||{},EventEmitter.call(this),this.topologyType=e.setName?TopologyType.ReplicaSetNoPrimary:TopologyType.Unknown,this.setName=e.setName,this.set={},this.id=e.id,this.setName=e.setName,this.logger=e.logger||Logger("ReplSet",e),this.index=0,this.acceptableLatency=e.acceptableLatency||15,this.heartbeatFrequencyMS=e.heartbeatFrequencyMS||1e4,this.primary=null,this.secondaries=[],this.arbiters=[],this.passives=[],this.ghosts=[],this.unknownServers=[],this.set={},this.maxElectionId=null,this.maxSetVersion=0,this.replicasetDescription={topologyType:"Unknown",servers:[]},this.logicalSessionTimeoutMinutes=void 0};inherits(ReplSetState,EventEmitter),ReplSetState.prototype.hasPrimaryAndSecondary=function(){return null!=this.primary&&0<this.secondaries.length},ReplSetState.prototype.hasPrimaryOrSecondary=function(){return this.hasPrimary()||this.hasSecondary()},ReplSetState.prototype.hasPrimary=function(){return null!=this.primary},ReplSetState.prototype.hasSecondary=function(){return 0<this.secondaries.length},ReplSetState.prototype.get=function(e){for(var r=this.allServers(),t=0;t<r.length;t++)if(r[t].name.toLowerCase()===e.toLowerCase())return r[t];return null},ReplSetState.prototype.allServers=function(e){e=e||{};var r=(r=this.primary?[this.primary]:[]).concat(this.secondaries);return r=(r=!e.ignoreArbiters?r.concat(this.arbiters):r).concat(this.passives)},ReplSetState.prototype.destroy=function(r,e){const t=this.secondaries.concat(this.arbiters).concat(this.passives).concat(this.ghosts);this.primary&&t.push(this.primary);let s=t.length;const i=()=>{s--,0<s||(this.secondaries=[],this.arbiters=[],this.passives=[],this.ghosts=[],this.unknownServers=[],this.set={},this.primary=null,emitTopologyDescriptionChanged(this),"function"==typeof e&&e(null,null))};0!==s?t.forEach(e=>e.destroy(r,i)):i()},ReplSetState.prototype.remove=function(e,r){r=r||{};var t=e.name.toLowerCase(),s=this.primary?[this.primary]:[];s=(s=(s=s.concat(this.secondaries)).concat(this.arbiters)).concat(this.passives);for(var i=0;i<s.length;i++)if(!r.force&&s[i].equals(e)&&s[i].isConnected&&s[i].isConnected())return;this.set[t]&&(this.set[t].type=ServerType.Unknown,this.set[t].electionId=null,this.set[t].setName=null,this.set[t].setVersion=null);var a=null;this.primary&&this.primary.equals(e)&&(this.primary=null,this.topologyType=TopologyType.ReplicaSetNoPrimary,a="primary"),a=removeFrom(e,this.secondaries)?"secondary":a,a=removeFrom(e,this.arbiters)?"arbiter":a,a=removeFrom(e,this.passives)?"secondary":a,removeFrom(e,this.ghosts),removeFrom(e,this.unknownServers),this.unknownServers.push(t),a&&this.emit("left",a,e)};const isArbiter=e=>e.arbiterOnly&&e.setName;ReplSetState.prototype.update=function(e){var r=this;const t=e.lastIsMaster();t&&t.isWritablePrimary&&(t.ismaster=t.isWritablePrimary);var s=e.name.toLowerCase();if(t){var i=Array.isArray(t.hosts)?t.hosts:[];i=(i=(i=i.concat(Array.isArray(t.arbiters)?t.arbiters:[])).concat(Array.isArray(t.passives)?t.passives:[])).map(function(e){return e.toLowerCase()});for(var a=0;a<i.length;a++)-1!==this.unknownServers.indexOf(i[a])||this.set[i[a]]&&this.set[i[a]].type!==ServerType.Unknown||this.unknownServers.push(i[a].toLowerCase()),this.set[i[a]]||(this.set[i[a]]={type:ServerType.Unknown,electionId:null,setName:null,setVersion:null})}if(!t&&!inList(t,e,this.unknownServers))return r.set[s]={type:ServerType.Unknown,setVersion:null,electionId:null,setName:null},r.set[s].type=ServerType.Unknown,r.set[s].electionId=t&&t.electionId,r.set[s].setName=t&&t.setName,r.set[s].setVersion=t&&t.setVersion,-1===r.unknownServers.indexOf(e.name)&&r.unknownServers.push(s),!1;if(void 0===t.logicalSessionTimeoutMinutes||isArbiter(t)||(void 0===r.logicalSessionTimeoutMinutes||null===t.logicalSessionTimeoutMinutes?r.logicalSessionTimeoutMinutes=t.logicalSessionTimeoutMinutes:r.logicalSessionTimeoutMinutes=Math.min(r.logicalSessionTimeoutMinutes,t.logicalSessionTimeoutMinutes)),t&&"isdbgrid"===t.msg)return this.primary&&this.primary.name===s&&(this.primary=null,this.topologyType=TopologyType.ReplicaSetNoPrimary),!1;if(t.isreplicaset)return r.set[s]={type:ServerType.RSGhost,setVersion:null,electionId:null,setName:t.setName},this.primary&&this.primary.name===s&&(this.primary=null),this.topologyType=this.primary?TopologyType.ReplicaSetWithPrimary:TopologyType.ReplicaSetNoPrimary,t.setName&&(this.setName=t.setName),!1;if(t.setName&&t.hidden||t.setName&&!t.ismaster&&!t.secondary&&!t.arbiterOnly&&!t.passive)return r.set[s]={type:ServerType.RSOther,setVersion:null,electionId:null,setName:t.setName},this.topologyType=this.primary?TopologyType.ReplicaSetWithPrimary:TopologyType.ReplicaSetNoPrimary,t.setName&&(this.setName=t.setName),!1;if(t&&t.ismaster&&!t.setName)return this.remove(e,{force:!0}),!1;if(t&&!t.ismaster&&!t.secondary&&!t.arbiterOnly)return this.remove(e,{force:!0}),!1;if(t.me&&t.me.toLowerCase()!==s)return this.logger.isWarn()&&this.logger.warn(f("the seedlist server was removed due to its address %s not matching its ismaster.me address %s",e.name,t.me)),delete this.set[s],removeFrom(e,r.unknownServers),e.destroy({force:!0}),this.primary&&!this.primary.equals(e)?this.topologyType=TopologyType.ReplicaSetWithPrimary:this.topologyType=TopologyType.ReplicaSetNoPrimary,!this.primary&&t.primary&&(this.set[t.primary.toLowerCase()]={type:ServerType.PossiblePrimary,setName:null,electionId:null,setVersion:null}),!1;if(!this.primary&&t.ismaster&&t.setName){var o=e.lastIsMaster().electionId;if(this.setName&&this.setName!==t.setName)return this.topologyType=TopologyType.ReplicaSetNoPrimary,new MongoError(f("setName from ismaster does not match provided connection setName [%s] != [%s]",t.setName,this.setName));if(!this.maxElectionId&&o)this.maxElectionId=o;else if(this.maxElectionId&&o){var n=compareObjectIds(this.maxElectionId,o),l=e.lastIsMaster().setVersion;if(1===n)return this.topologyType=TopologyType.ReplicaSetNoPrimary,!1;if(0===n&&l&&l<this.maxSetVersion)return this.topologyType=TopologyType.ReplicaSetNoPrimary,!1;this.maxSetVersion=l,this.maxElectionId=o}return-1!==t.hosts.map(function(e){return e.toLowerCase()}).indexOf(s)?(r.primary=e,r.set[s]={type:ServerType.RSPrimary,setVersion:t.setVersion,electionId:t.electionId,setName:t.setName},this.topologyType=TopologyType.ReplicaSetWithPrimary,t.setName&&(this.setName=t.setName),removeFrom(e,r.unknownServers),removeFrom(e,r.secondaries),removeFrom(e,r.passives),r.emit("joined","primary",e)):this.topologyType=TopologyType.ReplicaSetNoPrimary,emitTopologyDescriptionChanged(r),!0}if(t.ismaster&&t.setName){var p=r.set[r.primary.name.toLowerCase()].electionId,m=r.set[r.primary.name.toLowerCase()].setVersion,y=r.set[r.primary.name.toLowerCase()].setName,o=e.lastIsMaster().electionId,l=e.lastIsMaster().setVersion,c=e.lastIsMaster().setName;if(this.primary.equals(e)&&y===c)return!1;if(y&&y!==c)return this.primary.equals(e)?this.topologyType=TopologyType.ReplicaSetNoPrimary:this.topologyType=TopologyType.ReplicaSetWithPrimary,!1;if(p&&o){if(1===(n=compareObjectIds(p,o)))return!1;if(0===n&&l<m)return!1}else if(!p&&o&&l&&l<this.maxSetVersion)return!1;if(!this.maxElectionId&&o)this.maxElectionId=o;else if(this.maxElectionId&&o){if(1===(n=compareObjectIds(this.maxElectionId,o)))return!1;if(0===n&&m&&l){if(l<this.maxSetVersion)return!1}else if(l<this.maxSetVersion)return!1;this.maxElectionId=o,this.maxSetVersion=l}else this.maxSetVersion=l;return r.set[r.primary.name.toLowerCase()]={type:ServerType.Unknown,setVersion:null,electionId:null,setName:null},r.emit("left","primary",this.primary),r.primary.destroy({force:!0}),r.primary=e,r.set[s]={type:ServerType.RSPrimary,setVersion:t.setVersion,electionId:t.electionId,setName:t.setName},this.topologyType=TopologyType.ReplicaSetWithPrimary,t.setName&&(this.setName=t.setName),removeFrom(e,r.unknownServers),removeFrom(e,r.secondaries),removeFrom(e,r.passives),r.emit("joined","primary",e),emitTopologyDescriptionChanged(r),!0}return!this.primary&&t.primary&&(r.set[t.primary.toLowerCase()]={type:ServerType.PossiblePrimary,setVersion:null,electionId:null,setName:null}),t.secondary&&t.setName&&!inList(t,e,this.secondaries)&&this.setName&&this.setName===t.setName?(addToList(r,ServerType.RSSecondary,t,e,this.secondaries),this.topologyType=this.primary?TopologyType.ReplicaSetWithPrimary:TopologyType.ReplicaSetNoPrimary,t.setName&&(this.setName=t.setName),removeFrom(e,r.unknownServers),this.primary&&this.primary.name.toLowerCase()===s&&(e.destroy({force:!0}),this.primary=null,r.emit("left","primary",e)),r.emit("joined","secondary",e),emitTopologyDescriptionChanged(r),!0):isArbiter(t)&&!inList(t,e,this.arbiters)&&this.setName&&this.setName===t.setName?(addToList(r,ServerType.RSArbiter,t,e,this.arbiters),this.topologyType=this.primary?TopologyType.ReplicaSetWithPrimary:TopologyType.ReplicaSetNoPrimary,t.setName&&(this.setName=t.setName),removeFrom(e,r.unknownServers),r.emit("joined","arbiter",e),emitTopologyDescriptionChanged(r),!0):t.passive&&t.setName&&!inList(t,e,this.passives)&&this.setName&&this.setName===t.setName?(addToList(r,ServerType.RSSecondary,t,e,this.passives),this.topologyType=this.primary?TopologyType.ReplicaSetWithPrimary:TopologyType.ReplicaSetNoPrimary,t.setName&&(this.setName=t.setName),removeFrom(e,r.unknownServers),this.primary&&this.primary.name.toLowerCase()===s&&(e.destroy({force:!0}),this.primary=null,r.emit("left","primary",e)),r.emit("joined","secondary",e),emitTopologyDescriptionChanged(r),!0):(this.set[s]&&this.set[s].type===ServerType.RSPrimary?(r.emit("left","primary",this.primary),this.primary.destroy({force:!0}),this.primary=null,this.topologyType=TopologyType.ReplicaSetNoPrimary):this.topologyType=this.primary?TopologyType.ReplicaSetWithPrimary:TopologyType.ReplicaSetNoPrimary,!1)},ReplSetState.prototype.updateServerMaxStaleness=function(e,r){for(var t=0,s=0;s<this.secondaries.length;s++)t=Math.max(t,this.secondaries[s].lastWriteDate);5<=e.ismaster.maxWireVersion&&e.ismaster.secondary&&this.hasPrimary()?e.staleness=e.lastUpdateTime-e.lastWriteDate-(this.primary.lastUpdateTime-this.primary.lastWriteDate)+r:5<=e.ismaster.maxWireVersion&&e.ismaster.secondary&&(e.staleness=t-e.lastWriteDate+r)},ReplSetState.prototype.updateSecondariesMaxStaleness=function(e){for(var r=0;r<this.secondaries.length;r++)this.updateServerMaxStaleness(this.secondaries[r],e)},ReplSetState.prototype.pickServer=function(e){if("primary"===(e=e||ReadPreference.primary).preference&&null!=e.maxStalenessSeconds)return new MongoError("primary readPreference incompatible with maxStalenessSeconds");var r=(r=this.primary?[this.primary]:[]).concat(this.secondaries);if(null!=e.maxStalenessSeconds)for(var t=0;t<r.length;t++)if(r[t].ismaster.maxWireVersion<5)return new MongoError("maxStalenessSeconds not supported by at least one of the replicaset members");if("nearest"===e.preference&&null==e.maxStalenessSeconds)return pickNearest(this,e);if("nearest"===e.preference&&null!=e.maxStalenessSeconds)return pickNearestMaxStalenessSeconds(this,e);var s=this.secondaries;if(e.equals(ReadPreference.secondary)&&0===s.length)return new MongoError("no secondary server available");if(e.equals(ReadPreference.secondaryPreferred)&&0===s.length&&null==this.primary)return new MongoError("no secondary or primary server available");if(e.equals(ReadPreference.primary)&&null==this.primary)return new MongoError("no primary server available");if(e.equals(ReadPreference.secondaryPreferred)||e.equals(ReadPreference.secondary)){if(0<s.length&&null==e.maxStalenessSeconds){var i=pickNearest(this,e);if(i)return i}else if(0<s.length&&null!=e.maxStalenessSeconds&&(i=pickNearestMaxStalenessSeconds(this,e)))return i;return e.equals(ReadPreference.secondaryPreferred)?this.primary:null}if(e.equals(ReadPreference.primaryPreferred)){if(i=null,this.primary)return this.primary;if(0<s.length&&null==e.maxStalenessSeconds?i=pickNearest(this,e):0<s.length&&null!=e.maxStalenessSeconds&&(i=pickNearestMaxStalenessSeconds(this,e)),i)return i}return this.primary};var filterByTags=function(e,r){if(null==e.tags)return r;for(var t=[],s=Array.isArray(e.tags)?e.tags:[e.tags],i=0;i<s.length;i++)for(var a=s[i],o=0;o<r.length;o++){var n,l=r[o].lastIsMaster().tags||{},p=!0;for(n in a)l[n]!==a[n]&&(p=!1);p&&t.push(r[o])}return t};function pickNearestMaxStalenessSeconds(e,r){var t=[],s=1e3*r.maxStalenessSeconds;if(s<9e4)return new MongoError("maxStalenessSeconds must be set to at least 90 seconds");e.primary&&"secondary"!==r.preference&&"secondaryPreferred"!==r.preference&&t.push(e.primary);for(var i=0;i<e.secondaries.length;i++)t.push(e.secondaries[i]);if(e.primary&&0===t.length&&"secondaryPreferred"!==r.preference&&t.push(e.primary),(t=(t=filterByTags(r,t)).filter(function(e){return e.staleness<=s})).sort(function(e,r){return e.lastIsMasterMS-r.lastIsMasterMS}),0===t.length)return null;e.index=e.index%t.length;r=t[e.index];return e.index=e.index+1,r}function pickNearest(r,e){var t=[];r.primary&&"secondary"!==e.preference&&"secondaryPreferred"!==e.preference&&t.push(r.primary);for(var s=0;s<r.secondaries.length;s++)t.push(r.secondaries[s]);0===t.length&&r.primary&&"secondaryPreferred"!==e.preference&&t.push(r.primary),(t=filterByTags(e,t)).sort(function(e,r){return e.lastIsMasterMS-r.lastIsMasterMS});var i=0<t.length?t[0].lastIsMasterMS:0;if(0===(t=t.filter(function(e){return e.lastIsMasterMS<=i+r.acceptableLatency})).length)return null;r.index=r.index%t.length;e=t[r.index];return r.index=r.index+1,e}function inList(e,r,t){for(var s=0;s<t.length;s++)if(t[s]&&t[s].name&&t[s].name.toLowerCase()===r.name.toLowerCase())return!0;return!1}function addToList(e,r,t,s,i){var a=s.name.toLowerCase();e.set[a].type=r,e.set[a].electionId=t&&t.electionId,e.set[a].setName=t&&t.setName,e.set[a].setVersion=t&&t.setVersion,i.push(s)}function compareObjectIds(e,r){var t=Buffer.from(e.toHexString(),"hex"),s=Buffer.from(r.toHexString(),"hex");if(t===s)return 0;if("function"==typeof Buffer.compare)return Buffer.compare(t,s);for(var e=t.length,r=s.length,i=Math.min(e,r),a=0;a<i&&t[a]===s[a];a++);return a!==i&&(e=t[a],r=s[a]),e<r?-1:r<e?1:0}function removeFrom(e,r){for(var t=0;t<r.length;t++){if(r[t].equals&&r[t].equals(e))return r.splice(t,1),!0;if("string"==typeof r[t]&&r[t].toLowerCase()===e.name.toLowerCase())return r.splice(t,1),!0}return!1}function emitTopologyDescriptionChanged(e){var r,t,s;0<e.listeners("topologyDescriptionChanged").length&&(r="Unknown",t=e.setName,e.hasPrimaryAndSecondary()?r="ReplicaSetWithPrimary":!e.hasPrimary()&&e.hasSecondary()&&(r="ReplicaSetNoPrimary"),t={topologyType:r,setName:t,servers:[]},e.hasPrimary()&&((s=e.primary.getDescription()).type="RSPrimary",t.servers.push(s)),t.servers=t.servers.concat(e.secondaries.map(function(e){e=e.getDescription();return e.type="RSSecondary",e})),t.servers=t.servers.concat(e.arbiters.map(function(e){e=e.getDescription();return e.type="RSArbiter",e})),t.servers=t.servers.concat(e.passives.map(function(e){e=e.getDescription();return e.type="RSSecondary",e})),s=diff(e.replicasetDescription,t),s={topologyId:e.id,previousDescription:e.replicasetDescription,newDescription:t,diff:s},e.emit("topologyDescriptionChanged",s),e.replicasetDescription=t)}module.exports=ReplSetState;