"use strict";const inherits=require("util").inherits,f=require("util").format,EventEmitter=require("events").EventEmitter,ReadPreference=require("./read_preference"),CoreCursor=require("../cursor").CoreCursor,retrieveBSON=require("../connection/utils").retrieveBSON,Logger=require("../connection/logger"),MongoError=require("../error").MongoError,Server=require("./server"),ReplSetState=require("./replset_state"),Timeout=require("./shared").Timeout,Interval=require("./shared").Interval,SessionMixins=require("./shared").SessionMixins,isRetryableWritesSupported=require("./shared").isRetryableWritesSupported,relayEvents=require("../utils").relayEvents,BSON=retrieveBSON(),getMMAPError=require("./shared").getMMAPError,makeClientMetadata=require("../utils").makeClientMetadata,legacyIsRetryableWriteError=require("./shared").legacyIsRetryableWriteError,now=require("../../utils").now,calculateDurationInMs=require("../../utils").calculateDurationInMs;var DISCONNECTED="disconnected",CONNECTING="connecting",CONNECTED="connected",UNREFERENCED="unreferenced",DESTROYED="destroyed";function stateTransition(e,t){var r={disconnected:[CONNECTING,DESTROYED,DISCONNECTED],connecting:[CONNECTING,DESTROYED,CONNECTED,DISCONNECTED],connected:[CONNECTED,DISCONNECTED,DESTROYED,UNREFERENCED],unreferenced:[UNREFERENCED,DESTROYED],destroyed:[DESTROYED]}[e.state];r&&-1!==r.indexOf(t)?e.state=t:e.s.logger.error(f("Pool with id [%s] failed attempted illegal state transition from [%s] to [%s] only following state allowed [%s]",e.id,e.state,t,r))}var id=1,handlers=["connect","close","error","timeout","parseError"],ReplSet=function(e,t){var n=this;if(t=t||{},!Array.isArray(e))throw new MongoError("seedlist must be an array");if(0===e.length)throw new MongoError("seedlist must contain at least one entry");e.forEach(function(e){if("string"!=typeof e.host||"number"!=typeof e.port)throw new MongoError("seedlist entry must contain a host and port")}),EventEmitter.call(this),this.id=id++;var r=t.localThresholdMS||15;t.acceptableLatency&&(r=t.acceptableLatency);var s=Logger("ReplSet",t);this.s={options:Object.assign({metadata:makeClientMetadata(t)},t),bson:t.bson||new BSON([BSON.Binary,BSON.Code,BSON.DBRef,BSON.Decimal128,BSON.Double,BSON.Int32,BSON.Long,BSON.Map,BSON.MaxKey,BSON.MinKey,BSON.ObjectId,BSON.BSONRegExp,BSON.Symbol,BSON.Timestamp]),Cursor:t.cursorFactory||CoreCursor,logger:s,seedlist:e,replicaSetState:new ReplSetState({id:this.id,setName:t.setName,acceptableLatency:r,heartbeatFrequencyMS:t.haInterval||1e4,logger:s}),connectingServers:[],haInterval:t.haInterval||1e4,minHeartbeatFrequencyMS:500,disconnectHandler:t.disconnectHandler,index:0,connectOptions:{},debug:"boolean"==typeof t.debug&&t.debug},this.s.replicaSetState.on("topologyDescriptionChanged",function(e){n.emit("topologyDescriptionChanged",e)}),this.s.logger.isWarn()&&0!==this.s.options.socketTimeout&&this.s.options.socketTimeout<this.s.haInterval&&this.s.logger.warn(f("warning socketTimeout %s is less than haInterval %s. This might cause unnecessary server reconnections due to socket timeouts",this.s.options.socketTimeout,this.s.haInterval));["joined","left"].forEach(function(r){n.s.replicaSetState.on(r,function(e,t){n.emit(r,e,t)})}),this.initialConnectState={connect:!1,fullsetup:!1,all:!1},this.state=DISCONNECTED,this.haTimeoutId=null,this.ismaster=null,this.intervalIds=[],this.clusterTime=null};function rexecuteOperations(e){e.s.replicaSetState.hasPrimaryAndSecondary()&&e.s.disconnectHandler?e.s.disconnectHandler.execute():e.s.replicaSetState.hasPrimary()&&e.s.disconnectHandler?e.s.disconnectHandler.execute({executePrimary:!0}):e.s.replicaSetState.hasSecondary()&&e.s.disconnectHandler&&e.s.disconnectHandler.execute({executeSecondary:!0})}function connectNewServers(n,e,t){if(0===e.length)return t();var r=e.length,s=null;function i(){0===(r-=1)&&t(s)}function o(r,n){return function(e){var t=this;if(r.state===DESTROYED||r.state===UNREFERENCED)return this.destroy({force:!0}),i();if("connect"===n)if(r.s.replicaSetState.update(t)){t.lastIsMaster()&&t.lastIsMaster().ismaster&&(r.ismaster=t.lastIsMaster());for(let e=0;e<handlers.length;e++)t.removeAllListeners(handlers[e]);t.on("error",handleEvent(r,"error")),t.on("close",handleEvent(r,"close")),t.on("timeout",handleEvent(r,"timeout")),t.on("parseError",handleEvent(r,"parseError")),monitorServer(t.lastIsMaster().me,r,{}),rexecuteOperations(r)}else t.destroy({force:!0});else"error"===n&&(s=e);rexecuteOperations(r),i()}}for(var a=0;a<e.length;a++)!function(r,e){setTimeout(function(){if(n.state!==DESTROYED&&n.state!==UNREFERENCED){var e=n.s.connectingServers.findIndex(e=>e.name===r);if(0<=e){const t=n.s.connectingServers[e];return t.destroy({force:!0}),n.s.connectingServers.splice(e,1),i()}e=new Server(Object.assign({},n.s.options,{host:r.split(":")[0],port:parseInt(r.split(":")[1],10),reconnect:!1,monitoring:!1,parent:n}));e.once("connect",o(n,"connect")),e.once("close",o(n,"close")),e.once("timeout",o(n,"timeout")),e.once("error",o(n,"error")),e.once("parseError",o(n,"parseError")),e.on("serverOpening",e=>n.emit("serverOpening",e)),e.on("serverDescriptionChanged",e=>n.emit("serverDescriptionChanged",e)),e.on("serverClosed",e=>n.emit("serverClosed",e)),relayEvents(e,n,["commandStarted","commandSucceeded","commandFailed"]),n.s.connectingServers.push(e),e.connect(n.s.connectOptions)}},e)}(e[a],a)}inherits(ReplSet,EventEmitter),Object.assign(ReplSet.prototype,SessionMixins),Object.defineProperty(ReplSet.prototype,"type",{enumerable:!0,get:function(){return"replset"}}),Object.defineProperty(ReplSet.prototype,"parserType",{enumerable:!0,get:function(){return BSON.native?"c++":"js"}}),Object.defineProperty(ReplSet.prototype,"logicalSessionTimeoutMinutes",{enumerable:!0,get:function(){return this.s.replicaSetState.logicalSessionTimeoutMinutes||null}});var pingServer=function(n,s,i){var o=(new Date).getTime();emitSDAMEvent(n,"serverHeartbeatStarted",{connectionId:s.name}),s.command("admin.$cmd",{ismaster:!0},{monitoring:!0,socketTimeout:n.s.options.connectionTimeout||2e3},function(e,t){if(n.state===DESTROYED||n.state===UNREFERENCED)return s.destroy({force:!0}),i(e,t);var r=(new Date).getTime()-o;s.lastUpdateTime=now(),e?(emitSDAMEvent(n,"serverHeartbeatFailed",{durationMS:r,failure:e,connectionId:s.name}),n.s.replicaSetState.remove(s)):(s.ismaster=t.result,s.ismaster.lastWrite&&s.ismaster.lastWrite.lastWriteDate&&(s.lastWriteDate=s.ismaster.lastWrite.lastWriteDate.getTime()),-1===s.lastIsMasterMS?s.lastIsMasterMS=r:s.lastIsMasterMS&&(s.lastIsMasterMS=.2*r+.8*s.lastIsMasterMS),n.s.replicaSetState.update(s)&&s.lastIsMaster()&&s.lastIsMaster().ismaster&&(n.ismaster=s.lastIsMaster()),emitSDAMEvent(n,"serverHeartbeatSucceeded",{durationMS:r,reply:t.result,connectionId:s.name})),n.s.replicaSetState.updateServerMaxStaleness(s,n.s.haInterval),i(e,t)})},monitorServer=function(t,r,e){if(!e.haInterval)for(var n=0;n<r.intervalIds.length;n++)if(r.intervalIds[n].__host===t)return;var s=e.haInterval?Timeout:Interval,e=e.haInterval||r.s.haInterval,i=new s(function(){if(r.state!==DESTROYED&&r.state!==UNREFERENCED){var e=r.s.replicaSetState.get(t);return e?pingServer(r,e,function(e){e||(r.state!==DESTROYED&&r.state!==UNREFERENCED?(r.intervalIds=r.intervalIds.filter(function(e){return e.isRunning()}),s===Timeout?r.state===CONNECTING&&(r.s.replicaSetState.hasSecondary()&&r.s.options.secondaryOnlyConnectionAllowed||r.s.replicaSetState.hasPrimary())&&(stateTransition(r,CONNECTED),process.nextTick(function(){r.emit("connect",r)}),topologyMonitor(r,{})):r.state===DISCONNECTED&&(r.s.replicaSetState.hasSecondary()&&r.s.options.secondaryOnlyConnectionAllowed||r.s.replicaSetState.hasPrimary())&&(stateTransition(r,CONNECTING),rexecuteOperations(r),process.nextTick(function(){r.emit("reconnect",r)})),r.initialConnectState.connect&&!r.initialConnectState.fullsetup&&r.s.replicaSetState.hasPrimaryAndSecondary()&&(r.initialConnectState.fullsetup=!0,r.initialConnectState.all=!0,process.nextTick(function(){r.emit("fullsetup",r),r.emit("all",r)}))):i.stop())}):void 0}i.stop()},e);i.start(),i.__host=t,r.intervalIds.push(i)};function topologyMonitor(r,n){if(r.state!==DESTROYED&&r.state!==UNREFERENCED){n=n||{};var s=Object.keys(r.s.replicaSetState.set),e=n.haInterval?Timeout:Interval,i=n.haInterval||r.s.haInterval;if(e===Timeout)return connectNewServers(r,r.s.replicaSetState.unknownServers,function(e){if(r.state!==DESTROYED&&r.state!==UNREFERENCED){if(!r.s.replicaSetState.hasPrimary()&&!r.s.options.secondaryOnlyConnectionAllowed)return e?r.emit("error",e):(r.emit("error",new MongoError("no primary found in replicaset or invalid replica set name")),r.destroy({force:!0}));if(!r.s.replicaSetState.hasSecondary()&&r.s.options.secondaryOnlyConnectionAllowed)return e?r.emit("error",e):(r.emit("error",new MongoError("no secondary found in replicaset or invalid replica set name")),r.destroy({force:!0}));for(var t=0;t<s.length;t++)monitorServer(s[t],r,n)}});for(var t=0;t<s.length;t++)monitorServer(s[t],r,n);e=r.s.replicaSetState.hasPrimary()?i:r.s.minHeartbeatFrequencyMS;r.intervalIds.push(new Timeout(function t(r){return function(){r.state!==DESTROYED&&r.state!==UNREFERENCED&&connectNewServers(r,r.s.replicaSetState.unknownServers,function(){var e=r.s.replicaSetState.hasPrimary()?i:r.s.minHeartbeatFrequencyMS;r.intervalIds.push(new Timeout(t(r),e).start())})}}(r),e).start())}}function addServerToList(e,t){for(var r=0;r<e.length;r++)if(e[r].name.toLowerCase()===t.name.toLowerCase())return!0;e.push(t)}function handleEvent(e,t){return function(){e.state!==DESTROYED&&e.state!==UNREFERENCED&&(e.s.logger.isDebug()&&e.s.logger.debug(f("handleEvent %s from server %s in replset with id %s",t,this.name,e.id)),e.s.replicaSetState.remove(this),e.state!==DESTROYED&&e.state!==UNREFERENCED&&((e.s.replicaSetState.hasPrimary()||e.s.replicaSetState.hasSecondary()||!e.s.options.secondaryOnlyConnectionAllowed)&&e.s.replicaSetState.hasPrimary()||stateTransition(e,DISCONNECTED),addServerToList(e.s.connectingServers,this)))}}function shouldTriggerConnect(e){var t=e.state===CONNECTING,r=e.s.replicaSetState.hasPrimary(),n=e.s.replicaSetState.hasSecondary(),s=e.s.options.secondaryOnlyConnectionAllowed,e=e.s.connectOptions.readPreference&&e.s.connectOptions.readPreference.equals(ReadPreference.secondary);return t&&(e&&n||!e&&r)||n&&s}function handleInitialConnectEvent(n,s){return function(){var t=this;if(n.s.logger.isDebug()&&n.s.logger.debug(f("handleInitialConnectEvent %s from server %s in replset with id %s",s,this.name,n.id)),n.state===DESTROYED||n.state===UNREFERENCED)return this.destroy({force:!0});if("connect"===s){var e=n.s.replicaSetState.update(t);if(!0===e){t.lastIsMaster()&&t.lastIsMaster().ismaster&&(n.ismaster=t.lastIsMaster()),n.s.logger.isDebug()&&n.s.logger.debug(f("handleInitialConnectEvent %s from server %s in replset with id %s has state [%s]",s,t.name,n.id,JSON.stringify(n.s.replicaSetState.set)));for(let e=0;e<handlers.length;e++)t.removeAllListeners(handlers[e]);t.on("error",handleEvent(n,"error")),t.on("close",handleEvent(n,"close")),t.on("timeout",handleEvent(n,"timeout")),t.on("parseError",handleEvent(n,"parseError")),shouldTriggerConnect(n)&&(stateTransition(n,CONNECTED),n.initialConnectState.connect=!0,process.nextTick(function(){n.emit("connect",n)}),topologyMonitor(n,{}))}else{if(e instanceof MongoError)return t.destroy({force:!0}),n.destroy({force:!0}),n.emit("error",e);t.destroy({force:!0})}}else n.emit("failed",this),addServerToList(n.s.connectingServers,this),n.s.replicaSetState.remove(this);n.initialConnectState.connect&&!n.initialConnectState.fullsetup&&n.s.replicaSetState.hasPrimaryAndSecondary()&&(n.initialConnectState.fullsetup=!0,n.initialConnectState.all=!0,process.nextTick(function(){n.emit("fullsetup",n),n.emit("all",n)}));for(var r=0;r<n.s.connectingServers.length;r++)n.s.connectingServers[r].equals(this)&&n.s.connectingServers.splice(r,1);0===n.s.connectingServers.length&&n.state===CONNECTING&&topologyMonitor(n,{haInterval:1})}}function connectServers(r,e){r.s.connectingServers=r.s.connectingServers.concat(e);var t=0;for(;0<e.length;)!function(e,t){setTimeout(function(){r.s.replicaSetState.update(e)&&e.lastIsMaster()&&e.lastIsMaster().ismaster&&(r.ismaster=e.lastIsMaster()),e.once("close",handleInitialConnectEvent(r,"close")),e.once("timeout",handleInitialConnectEvent(r,"timeout")),e.once("parseError",handleInitialConnectEvent(r,"parseError")),e.once("error",handleInitialConnectEvent(r,"error")),e.once("connect",handleInitialConnectEvent(r,"connect")),e.on("serverOpening",e=>r.emit("serverOpening",e)),e.on("serverDescriptionChanged",e=>r.emit("serverDescriptionChanged",e)),e.on("serverClosed",e=>r.emit("serverClosed",e)),relayEvents(e,r,["commandStarted","commandSucceeded","commandFailed"]),e.connect(r.s.connectOptions)},t)}(e.shift(),t++)}function emitSDAMEvent(e,t,r){0<e.listeners(t).length&&e.emit(t,r)}ReplSet.prototype.connect=function(t){var r=this;this.s.connectOptions=t||{},stateTransition(this,CONNECTING);var e=this.s.seedlist.map(function(e){return new Server(Object.assign({},r.s.options,e,t,{reconnect:!1,monitoring:!1,parent:r}))});if(0<this.s.options.socketTimeout&&this.s.options.socketTimeout<=this.s.options.haInterval)return r.emit("error",new MongoError(f("haInterval [%s] MS must be set to less than socketTimeout [%s] MS",this.s.options.haInterval,this.s.options.socketTimeout)));emitSDAMEvent(this,"topologyOpening",{topologyId:this.id}),connectServers(r,e)},ReplSet.prototype.auth=function(e,t){"function"==typeof t&&t(null,null)},ReplSet.prototype.destroy=function(t,e){"function"==typeof t&&(e=t,t={}),t=t||{};let r=this.s.connectingServers.length+1;const n=()=>{r--,0<r||(emitSDAMEvent(this,"topologyClosed",{topologyId:this.id}),"function"==typeof e&&e(null,null))};if(this.state!==DESTROYED){stateTransition(this,DESTROYED),this.haTimeoutId&&clearTimeout(this.haTimeoutId);for(var s=0;s<this.intervalIds.length;s++)this.intervalIds[s].stop();this.intervalIds=[],0!==r?(this.s.replicaSetState.destroy(t,n),this.s.connectingServers.forEach(function(e){e.destroy(t,n)})):n()}else"function"==typeof e&&e(null,null)},ReplSet.prototype.unref=function(){stateTransition(this,UNREFERENCED),this.s.replicaSetState.allServers().forEach(function(e){e.unref()}),clearTimeout(this.haTimeoutId)},ReplSet.prototype.lastIsMaster=function(){return this.s.options.secondaryOnlyConnectionAllowed&&!this.s.replicaSetState.hasPrimary()&&this.s.replicaSetState.hasSecondary()?this.s.replicaSetState.secondaries[0].lastIsMaster():this.s.replicaSetState.primary?this.s.replicaSetState.primary.lastIsMaster():this.ismaster},ReplSet.prototype.connections=function(){for(var e=this.s.replicaSetState.allServers(),t=[],r=0;r<e.length;r++)t=t.concat(e[r].connections());return t},ReplSet.prototype.isConnected=function(e){return(e=e||{}).readPreference&&e.readPreference.equals(ReadPreference.secondary)?this.s.replicaSetState.hasSecondary():e.readPreference&&e.readPreference.equals(ReadPreference.primary)?this.s.replicaSetState.hasPrimary():e.readPreference&&e.readPreference.equals(ReadPreference.primaryPreferred)||e.readPreference&&e.readPreference.equals(ReadPreference.secondaryPreferred)?this.s.replicaSetState.hasSecondary()||this.s.replicaSetState.hasPrimary():!(!this.s.options.secondaryOnlyConnectionAllowed||!this.s.replicaSetState.hasSecondary())||this.s.replicaSetState.hasPrimary()},ReplSet.prototype.isDestroyed=function(){return this.state===DESTROYED};const SERVER_SELECTION_TIMEOUT_MS=1e4,SERVER_SELECTION_INTERVAL_MS=1e3;function executeWriteOperation(r,n,s){"function"==typeof n&&(s=n,n={}),n=n||{};const i=r.self;var e=r.op,t=r.ns,o=r.ops;if(i.state===DESTROYED)return s(new MongoError(f("topology was destroyed")));const a=!r.retrying&&!!n.retryWrites&&n.session&&isRetryableWritesSupported(i)&&!n.session.inTransaction()&&void 0===n.explain;if(!i.s.replicaSetState.hasPrimary()){if(i.s.disconnectHandler)return i.s.disconnectHandler.add(e,t,o,n,s);if(!a)return s(new MongoError("no primary server found"))}var c=(e,t)=>{return e?legacyIsRetryableWriteError(e,i)?a?executeWriteOperation(Object.assign({},r,{retrying:!0}),n,s):(i.s.replicaSetState.primary&&(i.s.replicaSetState.primary.destroy(),i.s.replicaSetState.remove(i.s.replicaSetState.primary,{force:!0})),s(e)):(e=getMMAPError(e),s(e)):s(null,t)};s.operationId&&(c.operationId=s.operationId),a&&(n.session.incrementTransactionNumber(),n.willRetryWrite=a),i.s.replicaSetState.primary[e](t,o,n,c)}ReplSet.prototype.selectServer=function(e,t,r){"function"==typeof e&&void 0===r&&(r=e,e=void 0,t={}),"function"==typeof t&&(r=t,t=e),t=t||{};let n;n=e instanceof ReadPreference?e:t.readPreference||ReadPreference.primary;let s;const i=now(),o=()=>{if(calculateDurationInMs(i)>=SERVER_SELECTION_TIMEOUT_MS)null!=s?r(s,null):r(new MongoError("Server selection timed out"));else{var e=this.s.replicaSetState.pickServer(n);if(null!=e){if(!(e instanceof Server))return s=e,void setTimeout(o,SERVER_SELECTION_INTERVAL_MS);this.s.debug&&this.emit("pickedServer",t.readPreference,e),r(null,e)}else setTimeout(o,SERVER_SELECTION_INTERVAL_MS)}};o()},ReplSet.prototype.getServers=function(){return this.s.replicaSetState.allServers()},ReplSet.prototype.insert=function(e,t,r,n){executeWriteOperation({self:this,op:"insert",ns:e,ops:t},r,n)},ReplSet.prototype.update=function(e,t,r,n){executeWriteOperation({self:this,op:"update",ns:e,ops:t},r,n)},ReplSet.prototype.remove=function(e,t,r,n){executeWriteOperation({self:this,op:"remove",ns:e,ops:t},r,n)};const RETRYABLE_WRITE_OPERATIONS=["findAndModify","insert","update","delete"];function isWriteCommand(t){return RETRYABLE_WRITE_OPERATIONS.some(e=>t[e])}ReplSet.prototype.command=function(r,n,s,i){if("function"==typeof s&&(i=s,s=(s={})||{}),this.state===DESTROYED)return i(new MongoError(f("topology was destroyed")));var o=this,e=s.readPreference||ReadPreference.primary;if("primary"===e.preference&&!this.s.replicaSetState.hasPrimary()&&null!=this.s.disconnectHandler)return this.s.disconnectHandler.add("command",r,n,s,i);if("secondary"===e.preference&&!this.s.replicaSetState.hasSecondary()&&null!=this.s.disconnectHandler)return this.s.disconnectHandler.add("command",r,n,s,i);if("primary"!==e.preference&&!this.s.replicaSetState.hasSecondary()&&!this.s.replicaSetState.hasPrimary()&&null!=this.s.disconnectHandler)return this.s.disconnectHandler.add("command",r,n,s,i);var t=this.s.replicaSetState.pickServer(e);if(!(t instanceof Server))return i(t);if(o.s.debug&&o.emit("pickedServer",ReadPreference.primary,t),null==t)return i(new MongoError(f("no server found that matches the provided readPreference %s",e)));const a=!s.retrying&&!!s.retryWrites&&s.session&&isRetryableWritesSupported(o)&&!s.session.inTransaction()&&isWriteCommand(n);a&&(s.session.incrementTransactionNumber(),s.willRetryWrite=a),t.command(r,n,s,(e,t)=>{if(!e)return i(null,t);if(!legacyIsRetryableWriteError(e,o))return i(e);if(a){t=Object.assign({},s,{retrying:!0});return this.command(r,n,t,i)}return this.s.replicaSetState.primary&&(this.s.replicaSetState.primary.destroy(),this.s.replicaSetState.remove(this.s.replicaSetState.primary,{force:!0})),i(e)})},ReplSet.prototype.cursor=function(e,t,r){var n=(r=r||{}).topology||this;return new(r.cursorFactory||this.s.Cursor)(n,e,t,r)},module.exports=ReplSet;