"use strict";const inherits=require("util").inherits,f=require("util").format,EventEmitter=require("events").EventEmitter,CoreCursor=require("../cursor").CoreCursor,Logger=require("../connection/logger"),retrieveBSON=require("../connection/utils").retrieveBSON,MongoError=require("../error").MongoError,Server=require("./server"),diff=require("./shared").diff,cloneOptions=require("./shared").cloneOptions,SessionMixins=require("./shared").SessionMixins,isRetryableWritesSupported=require("./shared").isRetryableWritesSupported,relayEvents=require("../utils").relayEvents,BSON=retrieveBSON(),getMMAPError=require("./shared").getMMAPError,makeClientMetadata=require("../utils").makeClientMetadata,legacyIsRetryableWriteError=require("./shared").legacyIsRetryableWriteError;var DISCONNECTED="disconnected",CONNECTING="connecting",CONNECTED="connected",UNREFERENCED="unreferenced",DESTROYING="destroying",DESTROYED="destroyed";function stateTransition(e,t){var o={disconnected:[CONNECTING,DESTROYING,DESTROYED,DISCONNECTED],connecting:[CONNECTING,DESTROYING,DESTROYED,CONNECTED,DISCONNECTED],connected:[CONNECTED,DISCONNECTED,DESTROYING,DESTROYED,UNREFERENCED],unreferenced:[UNREFERENCED,DESTROYING,DESTROYED],destroyed:[DESTROYED]}[e.state];o&&-1!==o.indexOf(t)?e.state=t:e.s.logger.error(f("Mongos with id [%s] failed attempted illegal state transition from [%s] to [%s] only following state allowed [%s]",e.id,e.state,t,o))}var id=1,handlers=["connect","close","error","timeout","parseError"],Mongos=function(e,t){t=t||{},this.id=id++,Array.isArray(e)&&(e=e.reduce((e,t)=>(e.find(e=>e.host===t.host&&e.port===t.port)||e.push(t),e),[])),this.s={options:Object.assign({metadata:makeClientMetadata(t)},t),bson:t.bson||new BSON([BSON.Binary,BSON.Code,BSON.DBRef,BSON.Decimal128,BSON.Double,BSON.Int32,BSON.Long,BSON.Map,BSON.MaxKey,BSON.MinKey,BSON.ObjectId,BSON.BSONRegExp,BSON.Symbol,BSON.Timestamp]),Cursor:t.cursorFactory||CoreCursor,logger:Logger("Mongos",t),seedlist:e,haInterval:t.haInterval||1e4,disconnectHandler:t.disconnectHandler,index:0,connectOptions:{},debug:"boolean"==typeof t.debug&&t.debug,localThresholdMS:t.localThresholdMS||15},this.s.logger.isWarn()&&0!==this.s.options.socketTimeout&&this.s.options.socketTimeout<this.s.haInterval&&this.s.logger.warn(f("warning socketTimeout %s is less than haInterval %s. This might cause unnecessary server reconnections due to socket timeouts",this.s.options.socketTimeout,this.s.haInterval)),this.state=DISCONNECTED,this.connectingProxies=[],this.connectedProxies=[],this.disconnectedProxies=[],this.index=0,this.haTimeoutId=null,this.ismaster=null,this.topologyDescription={topologyType:"Unknown",servers:[]},this.clusterTime=null,EventEmitter.call(this)};function emitSDAMEvent(e,t,o){0<e.listeners(t).length&&e.emit(t,o)}inherits(Mongos,EventEmitter),Object.assign(Mongos.prototype,SessionMixins),Object.defineProperty(Mongos.prototype,"type",{enumerable:!0,get:function(){return"mongos"}}),Object.defineProperty(Mongos.prototype,"parserType",{enumerable:!0,get:function(){return BSON.native?"c++":"js"}}),Object.defineProperty(Mongos.prototype,"logicalSessionTimeoutMinutes",{enumerable:!0,get:function(){return this.ismaster&&this.ismaster.logicalSessionTimeoutMinutes||null}});const SERVER_EVENTS=["serverDescriptionChanged","error","close","timeout","parseError"];function destroyServer(t,e,o){e=e||{},SERVER_EVENTS.forEach(e=>t.removeAllListeners(e)),t.destroy(e,o)}function handleEvent(e){return function(){e.state!==DESTROYED&&e.state!==DESTROYING&&(moveServerFrom(e.connectedProxies,e.disconnectedProxies,this),emitTopologyDescriptionChanged(e),e.emit("left","mongos",this),e.emit("serverClosed",{topologyId:e.id,address:this.name}))}}function handleInitialConnectEvent(o,n){return function(){var e,t=this;if(o.state===DESTROYED)return emitTopologyDescriptionChanged(o),moveServerFrom(o.connectingProxies,o.disconnectedProxies,this),this.destroy();if("connect"===n)if(o.ismaster=t.lastIsMaster(),"isdbgrid"===o.ismaster.msg){for(let e=0;e<o.connectedProxies.length;e++)if(o.connectedProxies[e].name===t.name)return moveServerFrom(o.connectingProxies,o.disconnectedProxies,t),emitTopologyDescriptionChanged(o),t.destroy(),o.emit("failed",t);for(let e=0;e<handlers.length;e++)t.removeAllListeners(handlers[e]);t.on("error",handleEvent(o,"error")),t.on("close",handleEvent(o,"close")),t.on("timeout",handleEvent(o,"timeout")),t.on("parseError",handleEvent(o,"parseError")),moveServerFrom(o.connectingProxies,o.connectedProxies,t),o.emit("joined","mongos",t)}else o.s.logger.isWarn()&&(e="expected mongos proxy, but found replicaset member mongod for server %s",o.ismaster.hosts||(e="expected mongos proxy, but found standalone mongod for server %s"),o.s.logger.warn(f(e,t.name))),t.destroy(!0),removeProxyFrom(o.connectingProxies,t),o.emit("left","server",t),o.emit("failed",t);else moveServerFrom(o.connectingProxies,o.disconnectedProxies,this),o.emit("left","mongos",this),o.emit("failed",this);if(emitTopologyDescriptionChanged(o),0===o.connectingProxies.length){if(0<o.connectedProxies.length&&o.state===CONNECTING)stateTransition(o,CONNECTED),o.emit("connect",o),o.emit("fullsetup",o),o.emit("all",o);else if(0===o.disconnectedProxies.length)return o.s.logger.isWarn()&&o.s.logger.warn(f("no mongos proxies found in seed list, did you mean to connect to a replicaset")),o.emit("error",new MongoError("no mongos proxies found in seed list"));topologyMonitor(o,{firstConnect:!0})}}}function connectProxies(o,e){o.connectingProxies=o.connectingProxies.concat(e);var t=0;e.forEach(e=>function(e,t){setTimeout(function(){o.emit("serverOpening",{topologyId:o.id,address:e.name}),emitTopologyDescriptionChanged(o),e.once("close",handleInitialConnectEvent(o,"close")),e.once("timeout",handleInitialConnectEvent(o,"timeout")),e.once("parseError",handleInitialConnectEvent(o,"parseError")),e.once("error",handleInitialConnectEvent(o,"error")),e.once("connect",handleInitialConnectEvent(o,"connect")),relayEvents(e,o,["commandStarted","commandSucceeded","commandFailed"]),e.connect(o.s.connectOptions)},t)}(e,t++))}function pickProxy(t,e){const o=e&&e.transaction;if(o&&o.server){if(o.server.isConnected())return o.server;o.unpinServer()}for(var n=t.connectedProxies.slice(0),r=Number.MAX_VALUE,s=0;s<n.length;s++)n[s].lastIsMasterMS<r&&(r=n[s].lastIsMasterMS);let i;return 0===(n=n.filter(function(e){if(e.lastIsMasterMS<=r+t.s.localThresholdMS&&e.isConnected())return!0})).length?i=t.connectedProxies[0]:(i=n[t.index%n.length],t.index=(t.index+1)%n.length),o&&o.isActive&&i&&i.isConnected()&&o.pinServer(i),i}function moveServerFrom(e,t,o){for(var n=0;n<e.length;n++)e[n].name===o.name&&e.splice(n,1);for(n=0;n<t.length;n++)t[n].name===o.name&&t.splice(n,1);t.push(o)}function removeProxyFrom(e,t){for(var o=0;o<e.length;o++)e[o].name===t.name&&e.splice(o,1)}function reconnectProxies(o,e,r){function n(o,n){return function(){var e=this;if(s-=1,o.state===DESTROYED||o.state===DESTROYING||o.state===UNREFERENCED)return moveServerFrom(o.connectingProxies,o.disconnectedProxies,e),this.destroy();if("connect"===n){if(o.state===DESTROYED||o.state===DESTROYING||o.state===UNREFERENCED)return moveServerFrom(o.connectingProxies,o.disconnectedProxies,e),e.destroy();for(var t=0;t<handlers.length;t++)e.removeAllListeners(handlers[t]);e.on("error",handleEvent(o,"error")),e.on("close",handleEvent(o,"close")),e.on("timeout",handleEvent(o,"timeout")),e.on("parseError",handleEvent(o,"parseError")),moveServerFrom(o.connectingProxies,o.connectedProxies,e),emitTopologyDescriptionChanged(o),o.emit("joined","mongos",e)}else moveServerFrom(o.connectingProxies,o.disconnectedProxies,e),this.destroy();0===s&&r()}}var s=e.length;if(0===s)return r();for(var t=0;t<e.length;t++)!function(t,e){setTimeout(function(){var e;o.state!==DESTROYED&&o.state!==DESTROYING&&o.state!==UNREFERENCED&&(e=new Server(Object.assign({},o.s.options,{host:t.name.split(":")[0],port:parseInt(t.name.split(":")[1],10),reconnect:!1,monitoring:!1,parent:o})),destroyServer(t,{force:!0}),removeProxyFrom(o.disconnectedProxies,t),relayEvents(e,o,["serverDescriptionChanged"]),o.emit("serverOpening",{topologyId:-1!==e.s.topologyId?e.s.topologyId:o.id,address:e.name}),e.once("connect",n(o,"connect")),e.once("close",n(o,"close")),e.once("timeout",n(o,"timeout")),e.once("error",n(o,"error")),e.once("parseError",n(o,"parseError")),relayEvents(e,o,["commandStarted","commandSucceeded","commandFailed"]),o.connectingProxies.push(e),e.connect(o.s.connectOptions))},e)}(e[t],t)}function topologyMonitor(i,n){n=n||{},i.state!==DESTROYED&&i.state!==DESTROYING&&i.state!==UNREFERENCED&&(i.haTimeoutId=setTimeout(function(){if(i.state!==DESTROYED&&i.state!==DESTROYING&&i.state!==UNREFERENCED){i.isConnected()&&i.s.disconnectHandler&&i.s.disconnectHandler.execute();var e=i.connectedProxies.slice(0),t=e.length;if(0===e.length)return 0<i.listeners("close").length&&i.state===CONNECTING?i.emit("error",new MongoError("no mongos proxy available")):i.emit("close",i),reconnectProxies(i,i.disconnectedProxies,function(){i.state!==DESTROYED&&i.state!==DESTROYING&&i.state!==UNREFERENCED&&(i.state===CONNECTING&&n.firstConnect?(i.emit("connect",i),i.emit("fullsetup",i),i.emit("all",i)):i.isConnected()?i.emit("reconnect",i):!i.isConnected()&&0<i.listeners("close").length&&i.emit("close",i),topologyMonitor(i))});for(var o=0;o<e.length;o++)!function(n,r){var s=(new Date).getTime();emitSDAMEvent(i,"serverHeartbeatStarted",{connectionId:n.name}),n.command("admin.$cmd",{ismaster:!0},{monitoring:!0,socketTimeout:i.s.options.connectionTimeout||2e3},function(e,t){if(i.state===DESTROYED||i.state===DESTROYING||i.state===UNREFERENCED)return moveServerFrom(i.connectedProxies,i.disconnectedProxies,n),n.destroy(),r(e,t);var o=(new Date).getTime()-s;e?(emitSDAMEvent(i,"serverHeartbeatFailed",{durationMS:o,failure:e,connectionId:n.name}),moveServerFrom(i.connectedProxies,i.disconnectedProxies,n)):(n.ismaster=t.result,n.lastIsMasterMS=o,emitSDAMEvent(i,"serverHeartbeatSucceeded",{durationMS:o,reply:t.result,connectionId:n.name})),r(e,t)})}(e[o],function(){0===(t-=1)&&i.state!==DESTROYED&&i.state!==DESTROYING&&i.state!==UNREFERENCED&&reconnectProxies(i,i.disconnectedProxies,function(){i.state!==DESTROYED&&i.state!==DESTROYING&&i.state!==UNREFERENCED&&topologyMonitor(i)})})}},i.s.haInterval))}function executeWriteOperation(o,n,r){"function"==typeof n&&(r=n,n={}),n=n||{};const s=o.self;var e=o.op,t=o.ns,i=o.ops;let c=pickProxy(s,n.session);if(!c)return r(new MongoError("no mongos proxy available"));const a=!o.retrying&&!!n.retryWrites&&n.session&&isRetryableWritesSupported(s)&&!n.session.inTransaction()&&void 0===n.explain;var l=(e,t)=>{return e?legacyIsRetryableWriteError(e,s)&&a?(c=pickProxy(s,n.session),c?executeWriteOperation(Object.assign({},o,{retrying:!0}),n,r):r(e)):(e=getMMAPError(e),r(e)):r(null,t)};r.operationId&&(l.operationId=r.operationId),a&&(n.session.incrementTransactionNumber(),n.willRetryWrite=a),c[e](t,i,n,l)}Mongos.prototype.connect=function(t){var o=this;this.s.connectOptions=t||{},stateTransition(this,CONNECTING);var e=this.s.seedlist.map(function(e){e=new Server(Object.assign({},o.s.options,e,t,{reconnect:!1,monitoring:!1,parent:o}));return relayEvents(e,o,["serverDescriptionChanged"]),e});emitSDAMEvent(this,"topologyOpening",{topologyId:this.id}),connectProxies(o,e)},Mongos.prototype.auth=function(e,t){"function"==typeof t&&t(null,null)},Mongos.prototype.lastIsMaster=function(){return this.ismaster},Mongos.prototype.unref=function(){stateTransition(this,UNREFERENCED),this.connectedProxies.concat(this.connectingProxies).forEach(function(e){e.unref()}),clearTimeout(this.haTimeoutId)},Mongos.prototype.destroy=function(t,e){"function"==typeof t&&(e=t,t={}),t=t||{},stateTransition(this,DESTROYING),this.haTimeoutId&&clearTimeout(this.haTimeoutId);const o=this.connectedProxies.concat(this.connectingProxies);let n=o.length;const r=()=>{n--,0<n||(emitTopologyDescriptionChanged(this),emitSDAMEvent(this,"topologyClosed",{topologyId:this.id}),stateTransition(this,DESTROYED),"function"==typeof e&&e(null,null))};0!==n?o.forEach(e=>{this.emit("serverClosed",{topologyId:this.id,address:e.name}),destroyServer(e,t,r),moveServerFrom(this.connectedProxies,this.disconnectedProxies,e)}):r()},Mongos.prototype.isConnected=function(){return 0<this.connectedProxies.length},Mongos.prototype.isDestroyed=function(){return this.state===DESTROYED},Mongos.prototype.insert=function(e,t,o,n){return"function"==typeof o&&(n=o,o=(o={})||{}),this.state===DESTROYED?n(new MongoError(f("topology was destroyed"))):this.isConnected()||null==this.s.disconnectHandler?this.isConnected()?void executeWriteOperation({self:this,op:"insert",ns:e,ops:t},o,n):n(new MongoError("no mongos proxy available")):this.s.disconnectHandler.add("insert",e,t,o,n)},Mongos.prototype.update=function(e,t,o,n){return"function"==typeof o&&(n=o,o=(o={})||{}),this.state===DESTROYED?n(new MongoError(f("topology was destroyed"))):this.isConnected()||null==this.s.disconnectHandler?this.isConnected()?void executeWriteOperation({self:this,op:"update",ns:e,ops:t},o,n):n(new MongoError("no mongos proxy available")):this.s.disconnectHandler.add("update",e,t,o,n)},Mongos.prototype.remove=function(e,t,o,n){return"function"==typeof o&&(n=o,o=(o={})||{}),this.state===DESTROYED?n(new MongoError(f("topology was destroyed"))):this.isConnected()||null==this.s.disconnectHandler?this.isConnected()?void executeWriteOperation({self:this,op:"remove",ns:e,ops:t},o,n):n(new MongoError("no mongos proxy available")):this.s.disconnectHandler.add("remove",e,t,o,n)};const RETRYABLE_WRITE_OPERATIONS=["findAndModify","insert","update","delete"];function isWriteCommand(t){return RETRYABLE_WRITE_OPERATIONS.some(e=>t[e])}function emitTopologyDescriptionChanged(e){var t,o,n;0<e.listeners("topologyDescriptionChanged").length&&(o="Unknown",t={topologyType:o=0<e.connectedProxies.length?"Sharded":o,servers:[]},n=e.disconnectedProxies.concat(e.connectingProxies),t.servers=t.servers.concat(n.map(function(e){e=e.getDescription();return e.type="Unknown",e})),t.servers=t.servers.concat(e.connectedProxies.map(function(e){e=e.getDescription();return e.type="Mongos",e})),o=diff(e.topologyDescription,t),n={topologyId:e.id,previousDescription:e.topologyDescription,newDescription:t,diff:o},0<o.servers.length&&e.emit("topologyDescriptionChanged",n),e.topologyDescription=t)}Mongos.prototype.command=function(o,n,e,r){if("function"==typeof e&&(r=e,e=(e={})||{}),this.state===DESTROYED)return r(new MongoError(f("topology was destroyed")));var s=this,t=pickProxy(s,e.session);if((null==t||!t.isConnected())&&null!=this.s.disconnectHandler)return this.s.disconnectHandler.add("command",o,n,e,r);if(null==t)return r(new MongoError("no mongos proxy available"));var i=cloneOptions(e);i.topology=s;const c=!e.retrying&&e.retryWrites&&e.session&&isRetryableWritesSupported(s)&&!e.session.inTransaction()&&isWriteCommand(n);c&&(i.session.incrementTransactionNumber(),i.willRetryWrite=c),t.command(o,n,i,(e,t)=>{if(!e)return r(null,t);if(!legacyIsRetryableWriteError(e,s))return r(e);if(c){t=Object.assign({},i,{retrying:!0});return this.command(o,n,t,r)}return r(e)})},Mongos.prototype.cursor=function(e,t,o){var n=(o=o||{}).topology||this;return new(o.cursorFactory||this.s.Cursor)(n,e,t,o)},Mongos.prototype.selectServer=function(e,t,o){"function"==typeof e&&void 0===o&&(o=e,e=void 0,t={}),"function"==typeof t&&(o=t,t=e,e=void 0);t=pickProxy(this,(t=t||{}).session);null!=t?(this.s.debug&&this.emit("pickedServer",null,t),o(null,t)):o(new MongoError("server selection failed"))},Mongos.prototype.connections=function(){for(var e=[],t=0;t<this.connectedProxies.length;t++)e=e.concat(this.connectedProxies[t].connections());return e},module.exports=Mongos;