"use strict";const retrieveBSON=require("./connection/utils").retrieveBSON,EventEmitter=require("events"),BSON=retrieveBSON(),Binary=BSON.Binary,uuidV4=require("./utils").uuidV4,MongoError=require("./error").MongoError,isRetryableError=require("././error").isRetryableError,MongoNetworkError=require("./error").MongoNetworkError,MongoWriteConcernError=require("./error").MongoWriteConcernError,Transaction=require("./transactions").Transaction,TxnState=require("./transactions").TxnState,isPromiseLike=require("./utils").isPromiseLike,ReadPreference=require("./topologies/read_preference"),maybePromise=require("../utils").maybePromise,isTransactionCommand=require("./transactions").isTransactionCommand,resolveClusterTime=require("./topologies/shared").resolveClusterTime,isSharded=require("./wireprotocol/shared").isSharded,maxWireVersion=require("./utils").maxWireVersion,now=require("./../utils").now,calculateDurationInMs=require("./../utils").calculateDurationInMs,minWireVersionForShardedTransactions=8;function assertAlive(n,e){if(null!=n.serverSession)return!0;n=new MongoError("Cannot use a session that has ended");if("function"==typeof e)return e(n,null),!1;throw n}const kServerSession=Symbol("serverSession");class ClientSession extends EventEmitter{constructor(n,e,r,t){if(super(),null==n)throw new Error("ClientSession requires a topology");if(null==e||!(e instanceof ServerSessionPool))throw new Error("ClientSession requires a ServerSessionPool");r=r||{},t=t||{},this.topology=n,this.sessionPool=e,this.hasEnded=!1,this.clientOptions=t,this[kServerSession]=void 0,this.supports={causalConsistency:void 0===r.causalConsistency||r.causalConsistency},this.clusterTime=r.initialClusterTime,this.operationTime=null,this.explicit=!!r.explicit,this.owner=r.owner,this.defaultTransactionOptions=Object.assign({},r.defaultTransactionOptions),this.transaction=new Transaction}get id(){return this.serverSession.id}get serverSession(){return null==this[kServerSession]&&(this[kServerSession]=this.sessionPool.acquire()),this[kServerSession]}endSession(n,e){"function"==typeof n&&(e=n,n={}),n=n||{};const t=this;return maybePromise(this,e,e=>{return t.hasEnded?e():void(t.serverSession&&t.inTransaction()?t.abortTransaction(n=>n?e(n):void r()):r());function r(){t.sessionPool.release(t.serverSession),t[kServerSession]=void 0,t.hasEnded=!0,t.emit("ended",t),e()}})}advanceOperationTime(n){(null==this.operationTime||n.greaterThan(this.operationTime))&&(this.operationTime=n)}equals(n){return n instanceof ClientSession&&this.id.id.buffer.equals(n.id.id.buffer)}incrementTransactionNumber(){this.serverSession.txnNumber++}inTransaction(){return this.transaction.isActive}startTransaction(n){if(assertAlive(this),this.inTransaction())throw new MongoError("Transaction already in progress");var e=maxWireVersion(this.topology);if(isSharded(this.topology)&&null!=e&&e<minWireVersionForShardedTransactions)throw new MongoError("Transactions are not supported on sharded clusters in MongoDB < 4.2.");this.incrementTransactionNumber(),this.transaction=new Transaction(Object.assign({},this.clientOptions,n||this.defaultTransactionOptions)),this.transaction.transition(TxnState.STARTING_TRANSACTION)}commitTransaction(n){return maybePromise(this,n,n=>endTransaction(this,"commitTransaction",n))}abortTransaction(n){return maybePromise(this,n,n=>endTransaction(this,"abortTransaction",n))}toBSON(){throw new Error("ClientSession cannot be serialized to BSON.")}withTransaction(n,e){return attemptTransaction(this,now(),n,e)}}const MAX_WITH_TRANSACTION_TIMEOUT=12e4,UNSATISFIABLE_WRITE_CONCERN_CODE=100,UNKNOWN_REPL_WRITE_CONCERN_CODE=79,MAX_TIME_MS_EXPIRED_CODE=50,NON_DETERMINISTIC_WRITE_CONCERN_ERRORS=new Set(["CannotSatisfyWriteConcern","UnknownReplWriteConcern","UnsatisfiableWriteConcern"]);function hasNotTimedOut(n,e){return calculateDurationInMs(n)<e}function isUnknownTransactionCommitResult(n){return isMaxTimeMSExpiredError(n)||!NON_DETERMINISTIC_WRITE_CONCERN_ERRORS.has(n.codeName)&&n.code!==UNSATISFIABLE_WRITE_CONCERN_CODE&&n.code!==UNKNOWN_REPL_WRITE_CONCERN_CODE}function isMaxTimeMSExpiredError(n){return null!=n&&(n.code===MAX_TIME_MS_EXPIRED_CODE||n.writeConcernError&&n.writeConcernError.code===MAX_TIME_MS_EXPIRED_CODE)}function attemptTransactionCommit(e,r,t,o){return e.commitTransaction().catch(n=>{if(n instanceof MongoError&&hasNotTimedOut(r,MAX_WITH_TRANSACTION_TIMEOUT)&&!isMaxTimeMSExpiredError(n)){if(n.hasErrorLabel("UnknownTransactionCommitResult"))return attemptTransactionCommit(e,r,t,o);if(n.hasErrorLabel("TransientTransactionError"))return attemptTransaction(e,r,t,o)}throw n})}const USER_EXPLICIT_TXN_END_STATES=new Set([TxnState.NO_TRANSACTION,TxnState.TRANSACTION_COMMITTED,TxnState.TRANSACTION_ABORTED]);function userExplicitlyEndedTransaction(n){return USER_EXPLICIT_TXN_END_STATES.has(n.transaction.state)}function attemptTransaction(r,t,o,i){r.startTransaction(i);let e;try{e=o(r)}catch(n){e=Promise.reject(n)}if(!isPromiseLike(e))throw r.abortTransaction(),new TypeError("Function provided to `withTransaction` must return a Promise");return e.then(()=>{if(!userExplicitlyEndedTransaction(r))return attemptTransactionCommit(r,t,o,i)}).catch(n=>{function e(n){if(n instanceof MongoError&&n.hasErrorLabel("TransientTransactionError")&&hasNotTimedOut(t,MAX_WITH_TRANSACTION_TIMEOUT))return attemptTransaction(r,t,o,i);throw isMaxTimeMSExpiredError(n)&&n.addErrorLabel("UnknownTransactionCommitResult"),n}return r.transaction.isActive?r.abortTransaction().then(()=>e(n)):e(n)})}function endTransaction(r,t,o){if(assertAlive(r,o)){var e=r.transaction.state;if(e!==TxnState.NO_TRANSACTION){if("commitTransaction"===t){if(e===TxnState.STARTING_TRANSACTION||e===TxnState.TRANSACTION_COMMITTED_EMPTY)return r.transaction.transition(TxnState.TRANSACTION_COMMITTED_EMPTY),void o(null,null);if(e===TxnState.TRANSACTION_ABORTED)return void o(new MongoError("Cannot call commitTransaction after calling abortTransaction"))}else{if(e===TxnState.STARTING_TRANSACTION)return r.transaction.transition(TxnState.TRANSACTION_ABORTED),void o(null,null);if(e===TxnState.TRANSACTION_ABORTED)return void o(new MongoError("Cannot call abortTransaction twice"));if(e===TxnState.TRANSACTION_COMMITTED||e===TxnState.TRANSACTION_COMMITTED_EMPTY)return void o(new MongoError("Cannot call abortTransaction after calling commitTransaction"))}const a={[t]:1};let n;function i(n,e){"commitTransaction"===t?(r.transaction.transition(TxnState.TRANSACTION_COMMITTED),n&&(n instanceof MongoNetworkError||n instanceof MongoWriteConcernError||isRetryableError(n)||isMaxTimeMSExpiredError(n)?isUnknownTransactionCommitResult(n)&&(n.addErrorLabel("UnknownTransactionCommitResult"),r.transaction.unpinServer()):n.hasErrorLabel("TransientTransactionError")&&r.transaction.unpinServer())):r.transaction.transition(TxnState.TRANSACTION_ABORTED),o(n,e)}function s(n){return"commitTransaction"===t?n:null}r.transaction.options.writeConcern?n=Object.assign({},r.transaction.options.writeConcern):r.clientOptions&&r.clientOptions.w&&(n={w:r.clientOptions.w}),e===TxnState.TRANSACTION_COMMITTED&&(n=Object.assign({wtimeout:1e4},n,{w:"majority"})),n&&Object.assign(a,{writeConcern:n}),"commitTransaction"===t&&r.transaction.options.maxTimeMS&&Object.assign(a,{maxTimeMS:r.transaction.options.maxTimeMS}),r.transaction.recoveryToken&&supportsRecoveryToken(r)&&(a.recoveryToken=r.transaction.recoveryToken),r.topology.command("admin.$cmd",a,{session:r},(n,e)=>n&&isRetryableError(n)?(a.commitTransaction&&(r.transaction.unpinServer(),a.writeConcern=Object.assign({wtimeout:1e4},a.writeConcern,{w:"majority"})),r.topology.command("admin.$cmd",a,{session:r},(n,e)=>i(s(n),e))):void i(s(n),e))}else o(new MongoError("No transaction started"))}}function supportsRecoveryToken(n){return!!n.topology.s.options.useRecoveryToken}class ServerSession{constructor(){this.id={id:new Binary(uuidV4(),Binary.SUBTYPE_UUID)},this.lastUse=now(),this.txnNumber=0,this.isDirty=!1}hasTimedOut(n){return n-1<Math.round(calculateDurationInMs(this.lastUse)%864e5%36e5/6e4)}}class ServerSessionPool{constructor(n){if(null==n)throw new Error("ServerSessionPool requires a topology");this.topology=n,this.sessions=[]}endAllPooledSessions(n){this.sessions.length?this.topology.endSessions(this.sessions.map(n=>n.id),()=>{this.sessions=[],"function"==typeof n&&n()}):"function"==typeof n&&n()}acquire(){for(var n=this.topology.logicalSessionTimeoutMinutes;this.sessions.length;){const e=this.sessions.shift();if(!e.hasTimedOut(n))return e}return new ServerSession}release(n){for(var e=this.topology.logicalSessionTimeoutMinutes;this.sessions.length;){const r=this.sessions[this.sessions.length-1];if(!r.hasTimedOut(e))break;this.sessions.pop()}n.hasTimedOut(e)||n.isDirty||this.sessions.unshift(n)}}function commandSupportsReadConcern(n,e){return!!(n.aggregate||n.count||n.distinct||n.find||n.parallelCollectionScan||n.geoNear||n.geoSearch)||!(!(n.mapReduce&&e&&e.out)||1!==e.out.inline&&"inline"!==e.out)}function applySession(n,e,r){if(n.hasEnded)return new MongoError("Cannot use a session that has ended");if(!r||!r.writeConcern||0!==r.writeConcern.w){const s=n.serverSession;s.lastUse=now(),e.lsid=s.id;var t=n.inTransaction()||isTransactionCommand(e),o=r.willRetryWrite,i=commandSupportsReadConcern(e,r);return(s.txnNumber&&(o||t)&&(e.txnNumber=BSON.Long.fromNumber(s.txnNumber)),t)?r.readPreference&&!r.readPreference.equals(ReadPreference.primary)?new MongoError(`Read preference in a transaction must be primary, not: ${r.readPreference.mode}`):(e.autocommit=!1,void(n.transaction.state===TxnState.STARTING_TRANSACTION&&(n.transaction.transition(TxnState.TRANSACTION_IN_PROGRESS),e.startTransaction=!0,(r=n.transaction.options.readConcern||n.clientOptions.readConcern)&&(e.readConcern=r),n.supports.causalConsistency&&n.operationTime&&(e.readConcern=e.readConcern||{},Object.assign(e.readConcern,{afterClusterTime:n.operationTime}))))):(n.transaction.state!==TxnState.NO_TRANSACTION&&n.transaction.transition(TxnState.NO_TRANSACTION),void(n.supports.causalConsistency&&n.operationTime&&i&&(e.readConcern=e.readConcern||{},Object.assign(e.readConcern,{afterClusterTime:n.operationTime}))))}}function updateSessionFromResponse(n,e){e.$clusterTime&&resolveClusterTime(n,e.$clusterTime),e.operationTime&&n&&n.supports.causalConsistency&&n.advanceOperationTime(e.operationTime),e.recoveryToken&&n&&n.inTransaction()&&(n.transaction._recoveryToken=e.recoveryToken)}module.exports={ClientSession:ClientSession,ServerSession:ServerSession,ServerSessionPool:ServerSessionPool,TxnState:TxnState,applySession:applySession,updateSessionFromResponse:updateSessionFromResponse,commandSupportsReadConcern:commandSupportsReadConcern};