"use strict";const ServerType=require("./common").ServerType,ServerDescription=require("./server_description").ServerDescription,WIRE_CONSTANTS=require("../wireprotocol/constants"),TopologyType=require("./common").TopologyType,MIN_SUPPORTED_SERVER_VERSION=WIRE_CONSTANTS.MIN_SUPPORTED_SERVER_VERSION,MAX_SUPPORTED_SERVER_VERSION=WIRE_CONSTANTS.MAX_SUPPORTED_SERVER_VERSION,MIN_SUPPORTED_WIRE_VERSION=WIRE_CONSTANTS.MIN_SUPPORTED_WIRE_VERSION,MAX_SUPPORTED_WIRE_VERSION=WIRE_CONSTANTS.MAX_SUPPORTED_WIRE_VERSION;class TopologyDescription{constructor(e,r,o,i,s,t,n){n=n||{},this.type=e||TopologyType.Unknown,this.setName=o||null,this.maxSetVersion=i||null,this.maxElectionId=s||null,this.servers=r||new Map,this.stale=!1,this.compatible=!0,this.compatibilityError=null,this.logicalSessionTimeoutMinutes=null,this.heartbeatFrequencyMS=n.heartbeatFrequencyMS||0,this.localThresholdMS=n.localThresholdMS||0,this.commonWireVersion=t||null,Object.defineProperty(this,"options",{value:n,enumberable:!1});for(const l of this.servers.values())if(l.type!==ServerType.Unknown&&(l.minWireVersion>MAX_SUPPORTED_WIRE_VERSION&&(this.compatible=!1,this.compatibilityError=`Server at ${l.address} requires wire version ${l.minWireVersion}, but this version of the driver only supports up to ${MAX_SUPPORTED_WIRE_VERSION} (MongoDB ${MAX_SUPPORTED_SERVER_VERSION})`),l.maxWireVersion<MIN_SUPPORTED_WIRE_VERSION)){this.compatible=!1,this.compatibilityError=`Server at ${l.address} reports wire version ${l.maxWireVersion}, but this version of the driver requires at least ${MIN_SUPPORTED_WIRE_VERSION} (MongoDB ${MIN_SUPPORTED_SERVER_VERSION}).`;break}this.logicalSessionTimeoutMinutes=null;for(const p of this.servers){var a=p[1];if(a.isReadable){if(null==a.logicalSessionTimeoutMinutes){this.logicalSessionTimeoutMinutes=null;break}null!=this.logicalSessionTimeoutMinutes?this.logicalSessionTimeoutMinutes=Math.min(this.logicalSessionTimeoutMinutes,a.logicalSessionTimeoutMinutes):this.logicalSessionTimeoutMinutes=a.logicalSessionTimeoutMinutes}}}updateFromSrvPollingEvent(e){const r=e.addresses(),o=new Map(this.servers);for(const i of this.servers)(r.has(i[0])?r:o).delete(i[0]);if(o.size===this.servers.size&&0===r.size)return this;for(const s of r)o.set(s,new ServerDescription(s));return new TopologyDescription(this.type,o,this.setName,this.maxSetVersion,this.maxElectionId,this.commonWireVersion,this.options,null)}update(e){var r=e.address;let o=this.type,i=this.setName,s=this.maxSetVersion,t=this.maxElectionId,n=this.commonWireVersion;var a,l=(e=e.setName&&i&&e.setName!==i?new ServerDescription(r,null):e).type;let p=new Map(this.servers);return 0!==e.maxWireVersion&&(n=null==n?e.maxWireVersion:Math.min(n,e.maxWireVersion)),p.set(r,e),o===TopologyType.Single?new TopologyDescription(TopologyType.Single,p,i,s,t,n,this.options):(o===TopologyType.Unknown&&(l===ServerType.Standalone&&1!==this.servers.size?p.delete(r):o=topologyTypeForServerType(l)),o===TopologyType.Sharded&&-1===[ServerType.Mongos,ServerType.Unknown].indexOf(l)&&p.delete(r),o===TopologyType.ReplicaSetNoPrimary&&(0<=[ServerType.Standalone,ServerType.Mongos].indexOf(l)&&p.delete(r),l===ServerType.RSPrimary?(a=updateRsFromPrimary(p,i,e,s,t),o=a[0],i=a[1],s=a[2],t=a[3]):0<=[ServerType.RSSecondary,ServerType.RSArbiter,ServerType.RSOther].indexOf(l)&&(a=updateRsNoPrimaryFromMember(p,i,e),o=a[0],i=a[1])),o===TopologyType.ReplicaSetWithPrimary&&(0<=[ServerType.Standalone,ServerType.Mongos].indexOf(l)?(p.delete(r),o=checkHasPrimary(p)):l===ServerType.RSPrimary?(r=updateRsFromPrimary(p,i,e,s,t),o=r[0],i=r[1],s=r[2],t=r[3]):o=0<=[ServerType.RSSecondary,ServerType.RSArbiter,ServerType.RSOther].indexOf(l)?updateRsWithPrimaryFromMember(p,i,e):checkHasPrimary(p)),new TopologyDescription(o,p,i,s,t,n,this.options))}get error(){var e=Array.from(this.servers.values()).filter(e=>e.error);if(0<e.length)return e[0].error}get hasKnownServers(){return Array.from(this.servers.values()).some(e=>e.type!==ServerType.Unknown)}get hasDataBearingServers(){return Array.from(this.servers.values()).some(e=>e.isDataBearing)}hasServer(e){return this.servers.has(e)}}function topologyTypeForServerType(e){return e===ServerType.Standalone?TopologyType.Single:e===ServerType.Mongos?TopologyType.Sharded:e===ServerType.RSPrimary?TopologyType.ReplicaSetWithPrimary:e===ServerType.RSGhost||e===ServerType.Unknown?TopologyType.Unknown:TopologyType.ReplicaSetNoPrimary}function compareObjectId(e,r){if(null==e)return-1;if(null==r)return 1;if(e.id instanceof Buffer&&r.id instanceof Buffer){const s=e.id;var o=r.id;return s.compare(o)}const i=e.toString();r=r.toString();return i.localeCompare(r)}function updateRsFromPrimary(r,e,o,i,s){if((e=e||o.setName)!==o.setName)return r.delete(o.address),[checkHasPrimary(r),e,i,s];var t=o.electionId||null;if(o.setVersion&&t){if(i&&s&&(i>o.setVersion||0<compareObjectId(s,t)))return r.set(o.address,new ServerDescription(o.address)),[checkHasPrimary(r),e,i,s];s=o.electionId}null!=o.setVersion&&(null==i||o.setVersion>i)&&(i=o.setVersion);for(const p of r.keys()){var n=r.get(p);if(n.type===ServerType.RSPrimary&&n.address!==o.address){r.set(p,new ServerDescription(n.address));break}}o.allHosts.forEach(e=>{r.has(e)||r.set(e,new ServerDescription(e))});const a=Array.from(r.keys()),l=o.allHosts;return a.filter(e=>-1===l.indexOf(e)).forEach(e=>{r.delete(e)}),[checkHasPrimary(r),e,i,s]}function updateRsWithPrimaryFromMember(e,r,o){if(null==r)throw new TypeError("setName is required");return(r!==o.setName||o.me&&o.address!==o.me)&&e.delete(o.address),checkHasPrimary(e)}function updateRsNoPrimaryFromMember(r,e,o){var i=TopologyType.ReplicaSetNoPrimary;return(e=e||o.setName)!==o.setName?r.delete(o.address):(o.allHosts.forEach(e=>{r.has(e)||r.set(e,new ServerDescription(e))}),o.me&&o.address!==o.me&&r.delete(o.address)),[i,e]}function checkHasPrimary(e){for(const r of e.keys())if(e.get(r).type===ServerType.RSPrimary)return TopologyType.ReplicaSetWithPrimary;return TopologyType.ReplicaSetNoPrimary}module.exports={TopologyDescription:TopologyDescription};