"use strict";const Denque=require("denque"),EventEmitter=require("events"),ServerDescription=require("./server_description").ServerDescription,ServerType=require("./common").ServerType,TopologyDescription=require("./topology_description").TopologyDescription,TopologyType=require("./common").TopologyType,events=require("./events"),Server=require("./server").Server,relayEvents=require("../utils").relayEvents,ReadPreference=require("../topologies/read_preference"),CoreCursor=require("../cursor").CoreCursor,deprecate=require("util").deprecate,BSON=require("../connection/utils").retrieveBSON(),createCompressionInfo=require("../topologies/shared").createCompressionInfo,ClientSession=require("../sessions").ClientSession,MongoError=require("../error").MongoError,MongoServerSelectionError=require("../error").MongoServerSelectionError,resolveClusterTime=require("../topologies/shared").resolveClusterTime,SrvPoller=require("./srv_polling").SrvPoller,getMMAPError=require("../topologies/shared").getMMAPError,makeStateMachine=require("../utils").makeStateMachine,eachAsync=require("../utils").eachAsync,emitDeprecationWarning=require("../../utils").emitDeprecationWarning,ServerSessionPool=require("../sessions").ServerSessionPool,makeClientMetadata=require("../utils").makeClientMetadata,CMAP_EVENT_NAMES=require("../../cmap/events").CMAP_EVENT_NAMES,compareTopologyVersion=require("./server_description").compareTopologyVersion,emitWarning=require("../../utils").emitWarning,common=require("./common"),drainTimerQueue=common.drainTimerQueue,clearAndRemoveTimerFrom=common.clearAndRemoveTimerFrom,serverSelection=require("./server_selection"),readPreferenceServerSelector=serverSelection.readPreferenceServerSelector,writableServerSelector=serverSelection.writableServerSelector;let globalTopologyCounter=0;const SERVER_RELAY_EVENTS=["serverHeartbeatStarted","serverHeartbeatSucceeded","serverHeartbeatFailed","commandStarted","commandSucceeded","commandFailed","monitoring"].concat(CMAP_EVENT_NAMES),LOCAL_SERVER_EVENTS=["connect","descriptionReceived","close","ended"],STATE_CLOSING=common.STATE_CLOSING,STATE_CLOSED=common.STATE_CLOSED,STATE_CONNECTING=common.STATE_CONNECTING,STATE_CONNECTED=common.STATE_CONNECTED,stateTransition=makeStateMachine({[STATE_CLOSED]:[STATE_CLOSED,STATE_CONNECTING],[STATE_CONNECTING]:[STATE_CONNECTING,STATE_CLOSING,STATE_CONNECTED,STATE_CLOSED],[STATE_CONNECTED]:[STATE_CONNECTED,STATE_CLOSING,STATE_CLOSED],[STATE_CLOSING]:[STATE_CLOSING,STATE_CLOSED]}),DEPRECATED_OPTIONS=new Set(["autoReconnect","reconnectTries","reconnectInterval","bufferMaxEntries"]),kCancelled=Symbol("cancelled"),kWaitQueue=Symbol("waitQueue");class Topology extends EventEmitter{constructor(e,r){super(),void 0===r&&"string"!=typeof e&&(r=e,e=[],r.host&&e.push({host:r.host,port:r.port})),"string"==typeof(e=e||[])&&(e=parseStringSeedlist(e)),r=Object.assign({},common.TOPOLOGY_DEFAULTS,r),r=Object.freeze(Object.assign(r,{metadata:makeClientMetadata(r),compression:{compressors:createCompressionInfo(r)}})),DEPRECATED_OPTIONS.forEach(e=>{r[e]&&emitDeprecationWarning(`The option \`${e}\` is incompatible with the unified topology, please read more by visiting http://bit.ly/2D8WfT6`,"DeprecationWarning")});var t=topologyTypeFromSeedlist(e,r),o=globalTopologyCounter++,s=e.reduce((e,r)=>{r.domain_socket&&(r.host=r.domain_socket);r=r.port?`${r.host}:${r.port}`:`${r.host}:27017`;return e.set(r,new ServerDescription(r)),e},new Map);this[kWaitQueue]=new Denque,this.s={id:o,options:r,seedlist:e,state:STATE_CLOSED,description:new TopologyDescription(t,s,r.replicaSet,null,null,null,r),serverSelectionTimeoutMS:r.serverSelectionTimeoutMS,heartbeatFrequencyMS:r.heartbeatFrequencyMS,minHeartbeatFrequencyMS:r.minHeartbeatFrequencyMS,Cursor:r.cursorFactory||CoreCursor,bson:r.bson||new BSON([BSON.Binary,BSON.Code,BSON.DBRef,BSON.Decimal128,BSON.Double,BSON.Int32,BSON.Long,BSON.Map,BSON.MaxKey,BSON.MinKey,BSON.ObjectId,BSON.BSONRegExp,BSON.Symbol,BSON.Timestamp]),servers:new Map,sessionPool:new ServerSessionPool(this),sessions:new Set,promiseLibrary:r.promiseLibrary||Promise,credentials:r.credentials,clusterTime:null,connectionTimers:new Set},this.serverApi=r.serverApi,r.srvHost&&(this.s.srvPoller=r.srvPoller||new SrvPoller({heartbeatFrequencyMS:this.s.heartbeatFrequencyMS,srvHost:r.srvHost,logger:r.logger,loggerLevel:r.loggerLevel}),this.s.detectTopologyDescriptionChange=e=>{var r=e.previousDescription.type,e=e.newDescription.type;r!==TopologyType.Sharded&&e===TopologyType.Sharded&&(this.s.handleSrvPolling=srvPollingHandler(this),this.s.srvPoller.on("srvRecordDiscovery",this.s.handleSrvPolling),this.s.srvPoller.start())},this.on("topologyDescriptionChanged",this.s.detectTopologyDescriptionChange)),this.setMaxListeners(1/0)}get description(){return this.s.description}get parserType(){return BSON.native?"c++":"js"}connect(e,r){var t,o;"function"==typeof e&&(r=e,e={}),e=e||{},this.s.state!==STATE_CONNECTED?(stateTransition(this,STATE_CONNECTING),this.emit("topologyOpening",new events.TopologyOpeningEvent(this.s.id)),this.emit("topologyDescriptionChanged",new events.TopologyDescriptionChangedEvent(this.s.id,new TopologyDescription(TopologyType.Unknown),this.s.description)),connectServers(this,Array.from(this.s.description.servers.values())),ReadPreference.translate(e),t=e.readPreference||ReadPreference.primary,o=e=>{if(e)return this.close(),void("function"==typeof r?r(e):this.emit("error",e));stateTransition(this,STATE_CONNECTED),this.emit("open",e,this),this.emit("connect",this),"function"==typeof r&&r(e,this)},this.s.credentials?this.command("admin.$cmd",{ping:1},{readPreference:t},o):this.selectServer(readPreferenceServerSelector(t),e,o)):"function"==typeof r&&r()}close(t,r){"function"==typeof t&&(r=t,t={}),t=(t="boolean"==typeof t?{force:t}:t)||{},this.s.state!==STATE_CLOSED&&this.s.state!==STATE_CLOSING?(stateTransition(this,STATE_CLOSING),drainWaitQueue(this[kWaitQueue],new MongoError("Topology closed")),drainTimerQueue(this.s.connectionTimers),this.s.srvPoller&&(this.s.srvPoller.stop(),this.s.handleSrvPolling&&(this.s.srvPoller.removeListener("srvRecordDiscovery",this.s.handleSrvPolling),delete this.s.handleSrvPolling)),this.s.detectTopologyDescriptionChange&&(this.removeListener("topologyDescriptionChanged",this.s.detectTopologyDescriptionChange),delete this.s.detectTopologyDescriptionChange),this.s.sessions.forEach(e=>e.endSession()),this.s.sessionPool.endAllPooledSessions(()=>{eachAsync(Array.from(this.s.servers.values()),(e,r)=>destroyServer(e,this,t,r),e=>{this.s.servers.clear(),this.emit("topologyClosed",new events.TopologyClosedEvent(this.s.id)),stateTransition(this,STATE_CLOSED),"function"==typeof r&&r(e)})})):"function"==typeof r&&r()}selectServer(r,t,o){if("function"==typeof t)if(o=t,"function"!=typeof r){t=r;let e;e=r instanceof ReadPreference?r:"string"==typeof r?new ReadPreference(r):(ReadPreference.translate(t),t.readPreference||ReadPreference.primary),r=readPreferenceServerSelector(e)}else t={};t=Object.assign({},{serverSelectionTimeoutMS:this.s.serverSelectionTimeoutMS},t);var e=this.description.type===TopologyType.Sharded,s=t.session,s=s&&s.transaction;if(e&&s&&s.server)o(void 0,s.server);else{let e=r;"object"==typeof r&&(r=r.readPreference||ReadPreference.primary,e=readPreferenceServerSelector(r));const i={serverSelector:e,transaction:s,callback:o},n=t.serverSelectionTimeoutMS;n&&(i.timer=setTimeout(()=>{i[kCancelled]=!0,i.timer=void 0;var e=new MongoServerSelectionError(`Server selection timed out after ${n} ms`,this.description);i.callback(e)},n)),this[kWaitQueue].push(i),processWaitQueue(this)}}shouldCheckForSessionSupport(){return this.description.type===TopologyType.Single?!this.description.hasKnownServers:!this.description.hasDataBearingServers}hasSessionSupport(){return null!=this.description.logicalSessionTimeoutMinutes}startSession(e,r){const t=new ClientSession(this,this.s.sessionPool,e,r);return t.once("ended",()=>{this.s.sessions.delete(t)}),this.s.sessions.add(t),t}endSessions(e,r){Array.isArray(e)||(e=[e]),this.command("admin.$cmd",{endSessions:e},{readPreference:ReadPreference.primaryPreferred,noResponse:!0,serverApi:this.serverApi},()=>{"function"==typeof r&&r()})}serverUpdateHandler(e){if(this.s.description.hasServer(e.address)&&!isStaleServerDescription(this.s.description,e)){var r=this.s.description;const o=this.s.description.servers.get(e.address);var t=e.$clusterTime;t&&resolveClusterTime(this,t);t=o&&o.equals(e);this.s.description=this.s.description.update(e),this.s.description.compatibilityError?this.emit("error",new MongoError(this.s.description.compatibilityError)):(t||this.emit("serverDescriptionChanged",new events.ServerDescriptionChangedEvent(this.s.id,e.address,o,this.s.description.servers.get(e.address))),updateServers(this,e),0<this[kWaitQueue].length&&processWaitQueue(this),t||this.emit("topologyDescriptionChanged",new events.TopologyDescriptionChangedEvent(this.s.id,r,this.s.description)))}}auth(e,r){"function"==typeof e&&(r=e,e=null),"function"==typeof r&&r(null,!0)}logout(e){"function"==typeof e&&e(null,!0)}insert(e,r,t,o){executeWriteOperation({topology:this,op:"insert",ns:e,ops:r},t,o)}update(e,r,t,o){executeWriteOperation({topology:this,op:"update",ns:e,ops:r},t,o)}remove(e,r,t,o){executeWriteOperation({topology:this,op:"remove",ns:e,ops:r},t,o)}command(a,c,l,p){"function"==typeof l&&(p=l,l=(l={})||{}),ReadPreference.translate(l);var e=l.readPreference||ReadPreference.primary;this.selectServer(readPreferenceServerSelector(e),l,(e,r)=>{if(e)p(e);else{var t=!l.retrying,o=!!l.retryWrites,s=!!l.session,i=r.supportsRetryableWrites,e=!s||!l.session.inTransaction();const n=t&&o&&s&&i&&e&&isWriteCommand(c);n&&(l.session.incrementTransactionNumber(),l.willRetryWrite=n),r.command(a,c,l,(e,r)=>{if(!e)return p(null,r);if(!shouldRetryOperation(e))return p(e);if(n){r=Object.assign({},l,{retrying:!0});return this.command(a,c,r,p)}return p(e)})}})}cursor(e,r,t){var o=(t=t||{}).topology||this;const s=t.cursorFactory||this.s.Cursor;return ReadPreference.translate(t),new s(o,e,r,t)}get clientMetadata(){return this.s.options.metadata}isConnected(){return this.s.state===STATE_CONNECTED}isDestroyed(){return this.s.state===STATE_CLOSED}unref(){emitWarning("`unref` is a noop and will be removed in the next major version")}lastIsMaster(){const e=Array.from(this.description.servers.values());return 0===e.length?{}:e.filter(e=>e.type!==ServerType.Unknown)[0]||{maxWireVersion:this.description.commonWireVersion}}get logicalSessionTimeoutMinutes(){return this.description.logicalSessionTimeoutMinutes}get bson(){return this.s.bson}}Object.defineProperty(Topology.prototype,"clusterTime",{enumerable:!0,get:function(){return this.s.clusterTime},set:function(e){this.s.clusterTime=e}}),Topology.prototype.destroy=deprecate(Topology.prototype.close,"destroy() is deprecated, please use close() instead");const RETRYABLE_WRITE_OPERATIONS=["findAndModify","insert","update","delete"];function isWriteCommand(r){return RETRYABLE_WRITE_OPERATIONS.some(e=>r[e])}function isStaleServerDescription(e,r){e=e.servers.get(r.address).topologyVersion;return 0<compareTopologyVersion(e,r.topologyVersion)}function destroyServer(r,e,t,o){t=t||{},LOCAL_SERVER_EVENTS.forEach(e=>r.removeAllListeners(e)),r.destroy(t,()=>{e.emit("serverClosed",new events.ServerClosedEvent(e.s.id,r.description.address)),SERVER_RELAY_EVENTS.forEach(e=>r.removeAllListeners(e)),"function"==typeof o&&o()})}function parseStringSeedlist(e){return e.split(",").map(e=>({host:e.split(":")[0],port:e.split(":")[1]||27017}))}function topologyTypeFromSeedlist(e,r){return r.directConnection?TopologyType.Single:null==(r.replicaSet||r.setName||r.rs_name)?TopologyType.Unknown:TopologyType.ReplicaSetNoPrimary}function randomSelection(e){return e[Math.floor(Math.random()*e.length)]}function createAndConnectServer(e,r,t){e.emit("serverOpening",new events.ServerOpeningEvent(e.s.id,r.address));const o=new Server(r,e.s.options,e);if(relayEvents(o,e,SERVER_RELAY_EVENTS),o.on("descriptionReceived",e.serverUpdateHandler.bind(e)),t){const s=setTimeout(()=>{clearAndRemoveTimerFrom(s,e.s.connectionTimers),o.connect()},t);return e.s.connectionTimers.add(s),o}return o.connect(),o}function connectServers(o,e){o.s.servers=e.reduce((e,r)=>{var t=createAndConnectServer(o,r);return e.set(r.address,t),e},new Map)}function updateServers(e,r){if(r&&e.s.servers.has(r.address)){const i=e.s.servers.get(r.address);i.s.description=r}for(const n of e.description.servers.values()){var t;e.s.servers.has(n.address)||(t=createAndConnectServer(e,n),e.s.servers.set(n.address,t))}for(const a of e.s.servers){var o,s=a[0];e.description.hasServer(s)||(o=e.s.servers.get(s),e.s.servers.delete(s),destroyServer(o,e))}}function executeWriteOperation(c,l,p){"function"==typeof l&&(p=l,l={}),l=l||{};const e=c.topology,d=c.op,u=c.ns,S=c.ops;e.selectServer(writableServerSelector(),l,(e,r)=>{if(e)p(e,null);else{var t=!c.retrying,o=!!l.retryWrites,s=!!l.session,i=r.supportsRetryableWrites,n=!s||!l.session.inTransaction(),e=void 0===l.explain;const a=t&&o&&s&&i&&n&&e;e=(e,r)=>{return e?shouldRetryOperation(e)?a?executeWriteOperation(Object.assign({},c,{retrying:!0}),l,p):p(e):(e=getMMAPError(e),p(e)):p(null,r)};p.operationId&&(e.operationId=p.operationId),a&&(l.session.incrementTransactionNumber(),l.willRetryWrite=a),r[d](u,S,l,e)}})}function shouldRetryOperation(e){return e instanceof MongoError&&e.hasErrorLabel("RetryableWriteError")}function srvPollingHandler(t){return function(e){var r=t.s.description;t.s.description=t.s.description.updateFromSrvPollingEvent(e),t.s.description!==r&&(updateServers(t),t.emit("topologyDescriptionChanged",new events.TopologyDescriptionChangedEvent(t.s.id,r,t.s.description)))}}function drainWaitQueue(e,r){for(;e.length;){const t=e.shift();clearTimeout(t.timer),t[kCancelled]||t.callback(r)}}function processWaitQueue(r){if(r.s.state!==STATE_CLOSED){var t=Array.from(r.description.servers.values()),o=r[kWaitQueue].length;for(let e=0;e<o&&r[kWaitQueue].length;++e){const i=r[kWaitQueue].shift();if(!i[kCancelled]){let e;try{const n=i.serverSelector;e=n?n(r.description,t):t}catch(e){clearTimeout(i.timer),i.callback(e);continue}if(0!==e.length){var s=randomSelection(e),s=r.s.servers.get(s.address);const a=i.transaction;r.description.type===TopologyType.Sharded&&a&&a.isActive&&a.pinServer(s),clearTimeout(i.timer),i.callback(void 0,s)}else r[kWaitQueue].push(i)}}0<r[kWaitQueue].length&&r.s.servers.forEach(e=>process.nextTick(()=>e.requestCheck()))}else drainWaitQueue(r[kWaitQueue],new MongoError("Topology is closed, please connect"))}module.exports={Topology:Topology};