"use strict";const Logger=require("../connection/logger"),EventEmitter=require("events").EventEmitter,dns=require("dns");function matchesParentDomain(e,t){var s=/^.*?\./;const r=`.${e.replace(s,"")}`;s=`.${t.replace(s,"")}`;return r.endsWith(s)}class SrvPollingEvent{constructor(e){this.srvRecords=e}addresses(){return new Set(this.srvRecords.map(e=>`${e.name}:${e.port}`))}}class SrvPoller extends EventEmitter{constructor(e){if(super(),!e||!e.srvHost)throw new TypeError("options for SrvPoller must exist and include srvHost");this.srvHost=e.srvHost,this.rescanSrvIntervalMS=6e4,this.heartbeatFrequencyMS=e.heartbeatFrequencyMS||1e4,this.logger=Logger("srvPoller",e),this.haMode=!1,this.generation=0,this._timeout=null}get srvAddress(){return`_mongodb._tcp.${this.srvHost}`}get intervalMS(){return this.haMode?this.heartbeatFrequencyMS:this.rescanSrvIntervalMS}start(){this._timeout||this.schedule()}stop(){this._timeout&&(clearTimeout(this._timeout),this.generation+=1,this._timeout=null)}schedule(){clearTimeout(this._timeout),this._timeout=setTimeout(()=>this._poll(),this.intervalMS)}success(e){this.haMode=!1,this.schedule(),this.emit("srvRecordDiscovery",new SrvPollingEvent(e))}failure(e,t){this.logger.warn(e,t),this.haMode=!0,this.schedule()}parentDomainMismatch(e){this.logger.warn(`parent domain mismatch on SRV record (${e.name}:${e.port})`,e)}_poll(){const r=this.generation;dns.resolveSrv(this.srvAddress,(e,t)=>{if(r===this.generation)if(e)this.failure("DNS error",e);else{const s=[];t.forEach(e=>{matchesParentDomain(e.name,this.srvHost)?s.push(e):this.parentDomainMismatch(e)}),s.length?this.success(s):this.failure("No valid addresses found at host")}})}}module.exports.SrvPollingEvent=SrvPollingEvent,module.exports.SrvPoller=SrvPoller;