"use strict";const ServerType=require("./common").ServerType,TopologyType=require("./common").TopologyType,ReadPreference=require("../topologies/read_preference"),MongoError=require("../error").MongoError,IDLE_WRITE_PERIOD=1e4,SMALLEST_MAX_STALENESS_SECONDS=90;function writableServerSelector(){return function(e,r){return latencyWindowReducer(e,r.filter(e=>e.isWritable))}}function maxStalenessReducer(t,n,e){if(null==t.maxStalenessSeconds||t.maxStalenessSeconds<0)return e;var r=t.maxStalenessSeconds,o=(n.heartbeatFrequencyMS+IDLE_WRITE_PERIOD)/1e3;if(r<o)throw new MongoError(`maxStalenessSeconds must be at least ${o} seconds`);if(r<SMALLEST_MAX_STALENESS_SECONDS)throw new MongoError(`maxStalenessSeconds must be at least ${SMALLEST_MAX_STALENESS_SECONDS} seconds`);if(n.type===TopologyType.ReplicaSetWithPrimary){const i=Array.from(n.servers.values()).filter(primaryFilter)[0];return e.reduce((e,r)=>{return(r.lastUpdateTime-r.lastWriteDate-(i.lastUpdateTime-i.lastWriteDate)+n.heartbeatFrequencyMS)/1e3<=t.maxStalenessSeconds&&e.push(r),e},[])}if(n.type!==TopologyType.ReplicaSetNoPrimary)return e;{if(0===e.length)return e;const a=e.reduce((e,r)=>r.lastWriteDate>e.lastWriteDate?r:e);return e.reduce((e,r)=>{return(a.lastWriteDate-r.lastWriteDate+n.heartbeatFrequencyMS)/1e3<=t.maxStalenessSeconds&&e.push(r),e},[])}}function tagSetMatch(r,t){var n=Object.keys(r);const o=Object.keys(t);for(let e=0;e<n.length;++e){var i=n[e];if(-1===o.indexOf(i)||t[i]!==r[i])return!1}return!0}function tagSetReducer(r,t){if(null==r.tags||Array.isArray(r.tags)&&0===r.tags.length)return t;for(let e=0;e<r.tags.length;++e){const o=r.tags[e];var n=t.reduce((e,r)=>(tagSetMatch(o,r.tags)&&e.push(r),e),[]);if(n.length)return n}return[]}function latencyWindowReducer(e,r){const t=r.reduce((e,r)=>-1===e?r.roundTripTime:Math.min(r.roundTripTime,e),-1),n=t+e.localThresholdMS;return r.reduce((e,r)=>(r.roundTripTime<=n&&r.roundTripTime>=t&&e.push(r),e),[])}function primaryFilter(e){return e.type===ServerType.RSPrimary}function secondaryFilter(e){return e.type===ServerType.RSSecondary}function nearestFilter(e){return e.type===ServerType.RSSecondary||e.type===ServerType.RSPrimary}function knownFilter(e){return e.type!==ServerType.Unknown}function readPreferenceServerSelector(o){if(!o.isValid())throw new TypeError("Invalid read preference specified");return function(e,r){var t=e.commonWireVersion;if(t&&o.minWireVersion&&o.minWireVersion>t)throw new MongoError(`Minimum wire version '${o.minWireVersion}' required, but found '${t}'`);if(e.type===TopologyType.Unknown)return[];if(e.type===TopologyType.Single||e.type===TopologyType.Sharded)return latencyWindowReducer(e,r.filter(knownFilter));t=o.mode;if(t===ReadPreference.PRIMARY)return r.filter(primaryFilter);if(t===ReadPreference.PRIMARY_PREFERRED){var n=r.filter(primaryFilter);if(n.length)return n}n=t===ReadPreference.NEAREST?nearestFilter:secondaryFilter,n=latencyWindowReducer(e,tagSetReducer(o,maxStalenessReducer(o,e,r.filter(n))));return t===ReadPreference.SECONDARY_PREFERRED&&0===n.length?r.filter(primaryFilter):n}}module.exports={writableServerSelector:writableServerSelector,readPreferenceServerSelector:readPreferenceServerSelector};