"use strict";const arrayStrictEqual=require("../utils").arrayStrictEqual,tagsStrictEqual=require("../utils").tagsStrictEqual,errorStrictEqual=require("../utils").errorStrictEqual,ServerType=require("./common").ServerType,now=require("../../utils").now,WRITABLE_SERVER_TYPES=new Set([ServerType.RSPrimary,ServerType.Standalone,ServerType.Mongos]),DATA_BEARING_SERVER_TYPES=new Set([ServerType.RSPrimary,ServerType.RSSecondary,ServerType.Mongos,ServerType.Standalone]),ISMASTER_FIELDS=["minWireVersion","maxWireVersion","maxBsonObjectSize","maxMessageSizeBytes","maxWriteBatchSize","compression","me","hosts","passives","arbiters","tags","setName","setVersion","electionId","primary","logicalSessionTimeoutMinutes","saslSupportedMechs","__nodejs_mock_server__","$clusterTime"];class ServerDescription{constructor(e,r,s){s=s||{},null!=(r=Object.assign({minWireVersion:0,maxWireVersion:0,hosts:[],passives:[],arbiters:[],tags:[]},r)).isWritablePrimary&&(r.ismaster=r.isWritablePrimary),this.address=e,this.error=s.error,this.roundTripTime=s.roundTripTime||-1,this.lastUpdateTime=now(),this.lastWriteDate=r.lastWrite?r.lastWrite.lastWriteDate:null,this.opTime=r.lastWrite?r.lastWrite.opTime:null,this.type=parseServerType(r),this.topologyVersion=s.topologyVersion||r.topologyVersion,ISMASTER_FIELDS.forEach(e=>{void 0!==r[e]&&(this[e]=r[e])}),this.me&&(this.me=this.me.toLowerCase()),this.hosts=this.hosts.map(e=>e.toLowerCase()),this.passives=this.passives.map(e=>e.toLowerCase()),this.arbiters=this.arbiters.map(e=>e.toLowerCase())}get allHosts(){return this.hosts.concat(this.arbiters).concat(this.passives)}get isReadable(){return this.type===ServerType.RSSecondary||this.isWritable}get isDataBearing(){return DATA_BEARING_SERVER_TYPES.has(this.type)}get isWritable(){return WRITABLE_SERVER_TYPES.has(this.type)}get host(){var e=`:${this.port}`.length;return this.address.slice(0,-e)}get port(){var e=this.address.split(":").pop();return e&&Number.parseInt(e,10)}equals(e){var r=this.topologyVersion===e.topologyVersion||0===compareTopologyVersion(this.topologyVersion,e.topologyVersion);return null!=e&&errorStrictEqual(this.error,e.error)&&this.type===e.type&&this.minWireVersion===e.minWireVersion&&this.me===e.me&&arrayStrictEqual(this.hosts,e.hosts)&&tagsStrictEqual(this.tags,e.tags)&&this.setName===e.setName&&this.setVersion===e.setVersion&&(this.electionId?e.electionId&&this.electionId.equals(e.electionId):this.electionId===e.electionId)&&this.primary===e.primary&&this.logicalSessionTimeoutMinutes===e.logicalSessionTimeoutMinutes&&r}}function parseServerType(e){return e&&e.ok?e.isreplicaset?ServerType.RSGhost:e.msg&&"isdbgrid"===e.msg?ServerType.Mongos:e.setName?e.hidden?ServerType.RSOther:e.ismaster?ServerType.RSPrimary:e.secondary?ServerType.RSSecondary:e.arbiterOnly?ServerType.RSArbiter:ServerType.RSOther:ServerType.Standalone:ServerType.Unknown}function compareTopologyVersion(e,r){return null!=e&&null!=r&&e.processId.equals(r.processId)?e.counter===r.counter?0:e.counter<r.counter?-1:1:-1}module.exports={ServerDescription:ServerDescription,parseServerType:parseServerType,compareTopologyVersion:compareTopologyVersion};