"use strict";const EventEmitter=require("events"),ConnectionPool=require("../../cmap/connection_pool").ConnectionPool,CMAP_EVENT_NAMES=require("../../cmap/events").CMAP_EVENT_NAMES,MongoError=require("../error").MongoError,relayEvents=require("../utils").relayEvents,BSON=require("../connection/utils").retrieveBSON(),Logger=require("../connection/logger"),ServerDescription=require("./server_description").ServerDescription,compareTopologyVersion=require("./server_description").compareTopologyVersion,ReadPreference=require("../topologies/read_preference"),Monitor=require("./monitor").Monitor,MongoNetworkError=require("../error").MongoNetworkError,MongoNetworkTimeoutError=require("../error").MongoNetworkTimeoutError,collationNotSupported=require("../utils").collationNotSupported,debugOptions=require("../connection/utils").debugOptions,isSDAMUnrecoverableError=require("../error").isSDAMUnrecoverableError,isRetryableWriteError=require("../error").isRetryableWriteError,isNodeShuttingDownError=require("../error").isNodeShuttingDownError,isNetworkErrorBeforeHandshake=require("../error").isNetworkErrorBeforeHandshake,maxWireVersion=require("../utils").maxWireVersion,makeStateMachine=require("../utils").makeStateMachine,extractCommand=require("../../command_utils").extractCommand,common=require("./common"),ServerType=common.ServerType,isTransactionCommand=require("../transactions").isTransactionCommand,DEBUG_FIELDS=["reconnect","reconnectTries","reconnectInterval","emitError","cursorFactory","host","port","size","keepAlive","keepAliveInitialDelay","noDelay","connectionTimeout","checkServerIdentity","socketTimeout","ssl","ca","crl","cert","key","rejectUnauthorized","promoteLongs","promoteValues","promoteBuffers","bsonRegExp","servername"],STATE_CLOSING=common.STATE_CLOSING,STATE_CLOSED=common.STATE_CLOSED,STATE_CONNECTING=common.STATE_CONNECTING,STATE_CONNECTED=common.STATE_CONNECTED,stateTransition=makeStateMachine({[STATE_CLOSED]:[STATE_CLOSED,STATE_CONNECTING],[STATE_CONNECTING]:[STATE_CONNECTING,STATE_CLOSING,STATE_CONNECTED,STATE_CLOSED],[STATE_CONNECTED]:[STATE_CONNECTED,STATE_CLOSING,STATE_CLOSED],[STATE_CLOSING]:[STATE_CLOSING,STATE_CLOSED]}),kMonitor=Symbol("monitor");class Server extends EventEmitter{constructor(e,r,o){super(),this.s={description:e,options:r,logger:Logger("Server",r),bson:r.bson||new BSON([BSON.Binary,BSON.Code,BSON.DBRef,BSON.Decimal128,BSON.Double,BSON.Int32,BSON.Long,BSON.Map,BSON.MaxKey,BSON.MinKey,BSON.ObjectId,BSON.BSONRegExp,BSON.Symbol,BSON.Timestamp]),state:STATE_CLOSED,credentials:r.credentials,topology:o},this.serverApi=r.serverApi;r=Object.assign({host:this.description.host,port:this.description.port,bson:this.s.bson},r);this.s.pool=new ConnectionPool(r),relayEvents(this.s.pool,this,["commandStarted","commandSucceeded","commandFailed"].concat(CMAP_EVENT_NAMES)),this.s.pool.on("clusterTimeReceived",e=>{this.clusterTime=e}),this[kMonitor]=new Monitor(this,this.s.options),relayEvents(this[kMonitor],this,["serverHeartbeatStarted","serverHeartbeatSucceeded","serverHeartbeatFailed","monitoring"]),this[kMonitor].on("resetConnectionPool",()=>{this.s.pool.clear()}),this[kMonitor].on("resetServer",e=>markServerUnknown(this,e)),this[kMonitor].on("serverHeartbeatSucceeded",e=>{this.emit("descriptionReceived",new ServerDescription(this.description.address,e.reply,{roundTripTime:calculateRoundTripTime(this.description.roundTripTime,e.duration)})),this.s.state===STATE_CONNECTING&&(stateTransition(this,STATE_CONNECTED),this.emit("connect",this))})}get description(){return this.s.description}get supportsRetryableWrites(){return supportsRetryableWrites(this)}get name(){return this.s.description.address}get autoEncrypter(){return this.s.options&&this.s.options.autoEncrypter?this.s.options.autoEncrypter:null}connect(){this.s.state===STATE_CLOSED&&(stateTransition(this,STATE_CONNECTING),this[kMonitor].connect())}destroy(e,r){"function"==typeof e&&(r=e,e={}),e=Object.assign({},{force:!1},e),this.s.state!==STATE_CLOSED?(stateTransition(this,STATE_CLOSING),this[kMonitor].close(),this.s.pool.close(e,e=>{stateTransition(this,STATE_CLOSED),this.emit("closed"),"function"==typeof r&&r(e)})):"function"==typeof r&&r()}requestCheck(){this[kMonitor].requestCheck()}command(t,n,i,e){if("function"==typeof i&&(e=i,i=(i={})||{}),i.serverApi=this.serverApi,this.s.state!==STATE_CLOSING&&this.s.state!==STATE_CLOSED){var r=basicReadValidations(this,i);if(r)return e(r);i=Object.assign({},i,{wireProtocolCommand:!1}),this.s.logger.isDebug()&&(r=extractCommand(n),this.s.logger.debug(`executing command [${JSON.stringify({ns:t,cmd:r.shouldRedact?`${r.name} details REDACTED`:n,options:debugOptions(DEBUG_FIELDS,i)})}] against ${this.name}`)),collationNotSupported(this,n)?e(new MongoError(`server ${this.name} does not support collation`)):this.s.pool.withConnection((e,r,o)=>e?(markServerUnknown(this,e),o(e)):void r.command(t,n,i,makeOperationHandler(this,r,n,i,o)),e)}else e(new MongoError("server is closed"))}query(t,n,i,s,e){this.s.state!==STATE_CLOSING&&this.s.state!==STATE_CLOSED?this.s.pool.withConnection((e,r,o)=>e?(markServerUnknown(this,e),o(e)):void r.query(t,n,i,s,makeOperationHandler(this,r,n,s,o)),e):e(new MongoError("server is closed"))}getMore(t,n,i,s,e){this.s.state!==STATE_CLOSING&&this.s.state!==STATE_CLOSED?this.s.pool.withConnection((e,r,o)=>e?(markServerUnknown(this,e),o(e)):void r.getMore(t,n,i,s,makeOperationHandler(this,r,null,s,o)),e):e(new MongoError("server is closed"))}killCursors(t,n,e){this.s.state!==STATE_CLOSING&&this.s.state!==STATE_CLOSED?this.s.pool.withConnection((e,r,o)=>e?(markServerUnknown(this,e),o(e)):void r.killCursors(t,n,makeOperationHandler(this,r,null,void 0,o)),e):"function"==typeof e&&e(new MongoError("server is closed"))}insert(e,r,o,t){executeWriteOperation({server:this,op:"insert",ns:e,ops:r},o,t)}update(e,r,o,t){executeWriteOperation({server:this,op:"update",ns:e,ops:r},o,t)}remove(e,r,o,t){executeWriteOperation({server:this,op:"remove",ns:e,ops:r},o,t)}}function supportsRetryableWrites(e){return 6<=e.description.maxWireVersion&&e.description.logicalSessionTimeoutMinutes&&e.description.type!==ServerType.Standalone}function calculateRoundTripTime(e,r){if(-1===e)return r;return.2*r+.8*e}function basicReadValidations(e,r){if(r.readPreference&&!(r.readPreference instanceof ReadPreference))return new MongoError("readPreference must be an instance of ReadPreference")}function executeWriteOperation(e,t,r){"function"==typeof t&&(r=t,t={}),t=t||{};const n=e.server,i=e.op,s=e.ns,a=Array.isArray(e.ops)?e.ops:[e.ops];n.s.state!==STATE_CLOSING&&n.s.state!==STATE_CLOSED?collationNotSupported(n,t)?r(new MongoError(`server ${n.name} does not support collation`)):!(t.writeConcern&&0===t.writeConcern.w||maxWireVersion(n)<5)||"update"!==i&&"remove"!==i||!a.find(e=>e.hint)?n.s.pool.withConnection((e,r,o)=>e?(markServerUnknown(n,e),o(e)):void r[i](s,a,t,makeOperationHandler(n,r,a,t,o)),r):r(new MongoError(`servers < 3.4 do not support hint on ${i}`)):r(new MongoError("server is closed"))}function markServerUnknown(e,r){r instanceof MongoNetworkError&&!(r instanceof MongoNetworkTimeoutError)&&e[kMonitor].reset(),e.emit("descriptionReceived",new ServerDescription(e.description.address,null,{error:r,topologyVersion:(r&&r.topologyVersion?r:e.description).topologyVersion}))}function connectionIsStale(e,r){return r.generation!==e.generation}function shouldHandleStateChangeError(e,r){r=r.topologyVersion,e=e.description.topologyVersion;return compareTopologyVersion(e,r)<0}function inActiveTransaction(e,r){return e&&e.inTransaction()&&!isTransactionCommand(r)}function makeOperationHandler(o,t,n,e,i){const s=e&&e.session;return function(e,r){e&&!connectionIsStale(o.s.pool,t)&&(e instanceof MongoNetworkError?(s&&!s.hasEnded&&(s.serverSession.isDirty=!0),supportsRetryableWrites(o)&&!inActiveTransaction(s,n)&&e.addErrorLabel("RetryableWriteError"),e instanceof MongoNetworkTimeoutError&&!isNetworkErrorBeforeHandshake(e)||(markServerUnknown(o,e),o.s.pool.clear())):(maxWireVersion(o)<9&&isRetryableWriteError(e)&&!inActiveTransaction(s,n)&&e.addErrorLabel("RetryableWriteError"),isSDAMUnrecoverableError(e)&&shouldHandleStateChangeError(o,e)&&((maxWireVersion(o)<=7||isNodeShuttingDownError(e))&&o.s.pool.clear(),markServerUnknown(o,e),process.nextTick(()=>o.requestCheck())))),i(e,r)}}Object.defineProperty(Server.prototype,"clusterTime",{get:function(){return this.s.topology.clusterTime},set:function(e){this.s.topology.clusterTime=e}}),module.exports={Server:Server};