"use strict";const ServerType=require("./common").ServerType,EventEmitter=require("events"),connect=require("../connection/connect"),Connection=require("../../cmap/connection").Connection,common=require("./common"),makeStateMachine=require("../utils").makeStateMachine,MongoNetworkError=require("../error").MongoNetworkError,BSON=require("../connection/utils").retrieveBSON(),makeInterruptableAsyncInterval=require("../../utils").makeInterruptableAsyncInterval,calculateDurationInMs=require("../../utils").calculateDurationInMs,now=require("../../utils").now,sdamEvents=require("./events"),ServerHeartbeatStartedEvent=sdamEvents.ServerHeartbeatStartedEvent,ServerHeartbeatSucceededEvent=sdamEvents.ServerHeartbeatSucceededEvent,ServerHeartbeatFailedEvent=sdamEvents.ServerHeartbeatFailedEvent,kServer=Symbol("server"),kMonitorId=Symbol("monitorId"),kConnection=Symbol("connection"),kCancellationToken=Symbol("cancellationToken"),kRTTPinger=Symbol("rttPinger"),kRoundTripTime=Symbol("roundTripTime"),STATE_CLOSED=common.STATE_CLOSED,STATE_CLOSING=common.STATE_CLOSING,STATE_IDLE="idle",STATE_MONITORING="monitoring",stateTransition=makeStateMachine({[STATE_CLOSING]:[STATE_CLOSING,STATE_IDLE,STATE_CLOSED],[STATE_CLOSED]:[STATE_CLOSED,STATE_MONITORING],[STATE_IDLE]:[STATE_IDLE,STATE_MONITORING,STATE_CLOSING],[STATE_MONITORING]:[STATE_MONITORING,STATE_IDLE,STATE_CLOSING]}),INVALID_REQUEST_CHECK_STATES=new Set([STATE_CLOSING,STATE_CLOSED,STATE_MONITORING]);function isInCloseState(e){return e.s.state===STATE_CLOSED||e.s.state===STATE_CLOSING}class Monitor extends EventEmitter{constructor(e,t){super(t),this[kServer]=e,this[kConnection]=void 0,this[kCancellationToken]=new EventEmitter,this[kCancellationToken].setMaxListeners(1/0),this[kMonitorId]=null,this.s={state:STATE_CLOSED},this.address=e.description.address,this.options=Object.freeze({connectTimeoutMS:"number"==typeof t.connectionTimeout?t.connectionTimeout:"number"==typeof t.connectTimeoutMS?t.connectTimeoutMS:1e4,heartbeatFrequencyMS:"number"==typeof t.heartbeatFrequencyMS?t.heartbeatFrequencyMS:1e4,minHeartbeatFrequencyMS:"number"==typeof t.minHeartbeatFrequencyMS?t.minHeartbeatFrequencyMS:500,useUnifiedTopology:t.useUnifiedTopology});const n=Object.assign({id:"<monitor>",host:e.description.host,port:e.description.port,bson:e.s.bson,connectionType:Connection},e.s.options,this.options,{raw:!1,promoteLongs:!0,promoteValues:!0,promoteBuffers:!0,bsonRegExp:!0});delete n.credentials,delete n.autoEncrypter,this.connectOptions=Object.freeze(n)}connect(){var e,t;this.s.state===STATE_CLOSED&&(e=this.options.heartbeatFrequencyMS,t=this.options.minHeartbeatFrequencyMS,this[kMonitorId]=makeInterruptableAsyncInterval(monitorServer(this),{interval:e,minInterval:t,immediate:!0}))}requestCheck(){INVALID_REQUEST_CHECK_STATES.has(this.s.state)||this[kMonitorId].wake()}reset(){var e,t=this[kServer].description.topologyVersion;isInCloseState(this)||null==t||(stateTransition(this,STATE_CLOSING),resetMonitorState(this),stateTransition(this,STATE_IDLE),e=this.options.heartbeatFrequencyMS,t=this.options.minHeartbeatFrequencyMS,this[kMonitorId]=makeInterruptableAsyncInterval(monitorServer(this),{interval:e,minInterval:t}))}close(){isInCloseState(this)||(stateTransition(this,STATE_CLOSING),resetMonitorState(this),this.emit("close"),stateTransition(this,STATE_CLOSED))}}function resetMonitorState(e){e[kMonitorId]&&(e[kMonitorId].stop(),e[kMonitorId]=null),e[kRTTPinger]&&(e[kRTTPinger].close(),e[kRTTPinger]=void 0),e[kCancellationToken].emit("cancel"),e[kMonitorId]&&(clearTimeout(e[kMonitorId]),e[kMonitorId]=void 0),e[kConnection]&&e[kConnection].destroy({force:!0})}function checkServer(o,r){let i=now();function s(e){o[kConnection]&&(o[kConnection].destroy({force:!0}),o[kConnection]=void 0),o.emit("serverHeartbeatFailed",new ServerHeartbeatFailedEvent(calculateDurationInMs(i),e,o.address)),o.emit("resetServer",e),o.emit("resetConnectionPool"),r(e)}if(o.emit("serverHeartbeatStarted",new ServerHeartbeatStartedEvent(o.address)),null!=o[kConnection]&&!o[kConnection].closed){var e=o.options.connectTimeoutMS,t=o.options.heartbeatFrequencyMS,n=o[kServer].description.topologyVersion;const T=null!=n;var a=o[kConnection].serverApi,c=o[kConnection].helloOk;const S={[a||c?"hello":"ismaster"]:!0};c&&(S.helloOk=c);const l={socketTimeout:e};return T&&(S.maxAwaitTimeMS=t,S.topologyVersion=makeTopologyVersion(n),e&&(l.socketTimeout=e+t),l.exhaustAllowed=!0,null==o[kRTTPinger]&&(o[kRTTPinger]=new RTTPinger(o[kCancellationToken],o.connectOptions))),void o[kConnection].command("admin.$cmd",S,l,(e,t)=>{if(e)s(e);else{const n=t.result;t=o[kRTTPinger];"isWritablePrimary"in n&&(n.ismaster=n.isWritablePrimary);t=T&&t?t.roundTripTime:calculateDurationInMs(i);o.emit("serverHeartbeatSucceeded",new ServerHeartbeatSucceededEvent(t,n,o.address)),T&&n.topologyVersion?(o.emit("serverHeartbeatStarted",new ServerHeartbeatStartedEvent(o.address)),i=now()):(o[kRTTPinger]&&(o[kRTTPinger].close(),o[kRTTPinger]=void 0),r(void 0,n))}})}connect(o.connectOptions,o[kCancellationToken],(e,t)=>{if(t&&isInCloseState(o))t.destroy({force:!0});else{if(e)return o[kConnection]=void 0,e instanceof MongoNetworkError||o.emit("resetConnectionPool"),void s(e);o[kConnection]=t,o.emit("serverHeartbeatSucceeded",new ServerHeartbeatSucceededEvent(calculateDurationInMs(i),t.ismaster,o.address)),r(void 0,t.ismaster)}})}function monitorServer(o){return e=>{function n(){isInCloseState(o)||stateTransition(o,STATE_IDLE),e()}stateTransition(o,STATE_MONITORING),process.nextTick(()=>o.emit("monitoring",o[kServer])),checkServer(o,(e,t)=>e&&o[kServer].description.type===ServerType.Unknown?(o.emit("resetServer",e),n()):(t&&t.topologyVersion&&setTimeout(()=>{isInCloseState(o)||o[kMonitorId].wake()}),void n()))}}function makeTopologyVersion(e){return{processId:e.processId,counter:BSON.Long.fromNumber(e.counter)}}class RTTPinger{constructor(e,t){this[kConnection]=null,this[kCancellationToken]=e,this[kRoundTripTime]=0,this.closed=!1;e=t.heartbeatFrequencyMS;this[kMonitorId]=setTimeout(()=>measureRoundTripTime(this,t),e)}get roundTripTime(){return this[kRoundTripTime]}close(){this.closed=!0,clearTimeout(this[kMonitorId]),this[kMonitorId]=void 0,this[kConnection]&&this[kConnection].destroy({force:!0})}}function measureRoundTripTime(n,t){const o=now();var e=n[kCancellationToken];const r=t.heartbeatFrequencyMS;function i(e){n.closed?e.destroy({force:!0}):(null==n[kConnection]&&(n[kConnection]=e),n[kRoundTripTime]=calculateDurationInMs(o),n[kMonitorId]=setTimeout(()=>measureRoundTripTime(n,t),r))}n.closed||(null!=n[kConnection]?n[kConnection].command("admin.$cmd",{ismaster:1},e=>e?(n[kConnection]=void 0,void(n[kRoundTripTime]=0)):void i()):connect(t,e,(e,t)=>e?(n[kConnection]=void 0,void(n[kRoundTripTime]=0)):void i(t)))}module.exports={Monitor:Monitor};