"use strict";const MONGODB_ERROR_CODES=require("../error_codes").MONGODB_ERROR_CODES,kErrorLabels=Symbol("errorLabels");class MongoError extends Error{constructor(r){if(r instanceof Error)super(r.message),this.stack=r.stack;else{if("string"==typeof r)super(r);else for(var e in super(r.message||r.errmsg||r.$err||"n/a"),r.errorLabels&&(this[kErrorLabels]=new Set(r.errorLabels)),r)"errorLabels"!==e&&"errmsg"!==e&&(this[e]=r[e]);Error.captureStackTrace(this,this.constructor)}this.name="MongoError"}get errmsg(){return this.message}static create(r){return new MongoError(r)}hasErrorLabel(r){return null!=this[kErrorLabels]&&this[kErrorLabels].has(r)}addErrorLabel(r){null==this[kErrorLabels]&&(this[kErrorLabels]=new Set),this[kErrorLabels].add(r)}get errorLabels(){return this[kErrorLabels]?Array.from(this[kErrorLabels]):[]}}const kBeforeHandshake=Symbol("beforeHandshake");function isNetworkErrorBeforeHandshake(r){return!0===r[kBeforeHandshake]}class MongoNetworkError extends MongoError{constructor(r,e){super(r),this.name="MongoNetworkError",e&&"boolean"==typeof e.beforeHandshake&&(this[kBeforeHandshake]=e.beforeHandshake)}}class MongoNetworkTimeoutError extends MongoNetworkError{constructor(r,e){super(r,e),this.name="MongoNetworkTimeoutError"}}class MongoParseError extends MongoError{constructor(r){super(r),this.name="MongoParseError"}}class MongoTimeoutError extends MongoError{constructor(r,e){e&&e.error?super(e.error.message||e.error):super(r),this.name="MongoTimeoutError",e&&(this.reason=e)}}class MongoServerSelectionError extends MongoTimeoutError{constructor(r,e){super(r,e),this.name="MongoServerSelectionError"}}function makeWriteConcernResultObject(r){const e=Object.assign({},r);return 0===e.ok&&(e.ok=1,delete e.errmsg,delete e.code,delete e.codeName),e}class MongoWriteConcernError extends MongoError{constructor(r,e){super(r),this.name="MongoWriteConcernError",e&&Array.isArray(e.errorLabels)&&(this[kErrorLabels]=new Set(e.errorLabels)),null!=e&&(this.result=makeWriteConcernResultObject(e))}}const RETRYABLE_ERROR_CODES=new Set([MONGODB_ERROR_CODES.HostUnreachable,MONGODB_ERROR_CODES.HostNotFound,MONGODB_ERROR_CODES.NetworkTimeout,MONGODB_ERROR_CODES.ShutdownInProgress,MONGODB_ERROR_CODES.PrimarySteppedDown,MONGODB_ERROR_CODES.SocketException,MONGODB_ERROR_CODES.NotMaster,MONGODB_ERROR_CODES.InterruptedAtShutdown,MONGODB_ERROR_CODES.InterruptedDueToReplStateChange,MONGODB_ERROR_CODES.NotMasterNoSlaveOk,MONGODB_ERROR_CODES.NotMasterOrSecondary]),RETRYABLE_WRITE_ERROR_CODES=new Set([MONGODB_ERROR_CODES.InterruptedAtShutdown,MONGODB_ERROR_CODES.InterruptedDueToReplStateChange,MONGODB_ERROR_CODES.NotMaster,MONGODB_ERROR_CODES.NotMasterNoSlaveOk,MONGODB_ERROR_CODES.NotMasterOrSecondary,MONGODB_ERROR_CODES.PrimarySteppedDown,MONGODB_ERROR_CODES.ShutdownInProgress,MONGODB_ERROR_CODES.HostNotFound,MONGODB_ERROR_CODES.HostUnreachable,MONGODB_ERROR_CODES.NetworkTimeout,MONGODB_ERROR_CODES.SocketException,MONGODB_ERROR_CODES.ExceededTimeLimit]);function isRetryableWriteError(r){return r instanceof MongoWriteConcernError?RETRYABLE_WRITE_ERROR_CODES.has(r.code)||RETRYABLE_WRITE_ERROR_CODES.has(r.result.code):RETRYABLE_WRITE_ERROR_CODES.has(r.code)}function isRetryableError(r){return RETRYABLE_ERROR_CODES.has(r.code)||r instanceof MongoNetworkError||r.message.match(/not master/)||r.message.match(/node is recovering/)}const SDAM_RECOVERING_CODES=new Set([MONGODB_ERROR_CODES.ShutdownInProgress,MONGODB_ERROR_CODES.PrimarySteppedDown,MONGODB_ERROR_CODES.InterruptedAtShutdown,MONGODB_ERROR_CODES.InterruptedDueToReplStateChange,MONGODB_ERROR_CODES.NotMasterOrSecondary]),SDAM_NOTMASTER_CODES=new Set([MONGODB_ERROR_CODES.NotMaster,MONGODB_ERROR_CODES.NotMasterNoSlaveOk,MONGODB_ERROR_CODES.LegacyNotPrimary]),SDAM_NODE_SHUTTING_DOWN_ERROR_CODES=new Set([MONGODB_ERROR_CODES.InterruptedAtShutdown,MONGODB_ERROR_CODES.ShutdownInProgress]);function isRecoveringError(r){return"number"==typeof r.code?SDAM_RECOVERING_CODES.has(r.code):/not master or secondary/.test(r.message)||/node is recovering/.test(r.message)}function isNotMasterError(r){return"number"==typeof r.code?SDAM_NOTMASTER_CODES.has(r.code):!isRecoveringError(r)&&/not master/.test(r.message)}function isNodeShuttingDownError(r){return r.code&&SDAM_NODE_SHUTTING_DOWN_ERROR_CODES.has(r.code)}function isSDAMUnrecoverableError(r){return r instanceof MongoParseError||null==r||(isRecoveringError(r)||isNotMasterError(r))}module.exports={MongoError:MongoError,MongoNetworkError:MongoNetworkError,MongoNetworkTimeoutError:MongoNetworkTimeoutError,MongoParseError:MongoParseError,MongoTimeoutError:MongoTimeoutError,MongoServerSelectionError:MongoServerSelectionError,MongoWriteConcernError:MongoWriteConcernError,isRetryableError:isRetryableError,isSDAMUnrecoverableError:isSDAMUnrecoverableError,isNodeShuttingDownError:isNodeShuttingDownError,isRetryableWriteError:isRetryableWriteError,isNetworkErrorBeforeHandshake:isNetworkErrorBeforeHandshake};